/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.haos.business.service.staff.helper.StaffEntryTempHelperEnum;
import kd.hr.hbp.common.util.HRStringUtils;

public enum StaffEntryHelperEnum {
    dutyOrgEntry("a", "dutyorg", "haos_adminorgdetail", StaffEntryHelperEnum::getDutyOrgLocaleName),
    useOrgEntry("b", "useorg", "haos_adminorgdetail", StaffEntryHelperEnum::getUseOrgLocaleName),
    positionEntry("c", "dutyworkrole", "hbpm_positionhr", StaffEntryHelperEnum::getPositionLocaleName),
    jobEntry("d", "job", "hbjm_jobhr", StaffEntryHelperEnum::getJobLocaleName),
    laborRelTypeEntry("e", "laborreltype", "hbss_laborreltype", StaffEntryHelperEnum::getLaborRelTypeLocaleName);

    private static List<String> bEntryImportFields;
    private static List<String> cEntryImportFields;
    private static List<String> dEntryImportFields;
    private static List<String> eEntryImportFields;
    private String prefix;
    private String keyField;
    private final Supplier<String> keyFieldLocaleSupplier;
    private String keyFieldEntityName;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public String getKeyFieldEntityName() {
        return this.keyFieldEntityName;
    }

    public void setKeyFieldEntityName(String keyFieldEntityName) {
        this.keyFieldEntityName = keyFieldEntityName;
    }

    private StaffEntryHelperEnum(String prefix, String keyField, String keyFieldEntityName, Supplier<String> keyFieldLocaleSupplier) {
        this.prefix = prefix;
        this.keyField = keyField;
        this.keyFieldEntityName = keyFieldEntityName;
        this.keyFieldLocaleSupplier = keyFieldLocaleSupplier;
    }

    public String getkeyFieldLocale() {
        return this.keyFieldLocaleSupplier.get();
    }

    public static List<String> getEntryFieldsByPrefix(String prefix) {
        if (prefix.equals("b")) {
            return bEntryImportFields;
        }
        if (prefix.equals("c")) {
            return cEntryImportFields;
        }
        if (prefix.equals("d")) {
            return dEntryImportFields;
        }
        if (prefix.equals("e")) {
            return eEntryImportFields;
        }
        return new ArrayList<String>();
    }

    public static String getKeyFieldLocaleByPrefix(String prefix) {
        StaffEntryHelperEnum[] entryEnums;
        for (StaffEntryHelperEnum entryEnum : entryEnums = StaffEntryHelperEnum.values()) {
            if (!HRStringUtils.equals((String)entryEnum.getPrefix(), (String)prefix)) continue;
            return entryEnum.getkeyFieldLocale();
        }
        return "";
    }

    private static String getDutyOrgLocaleName() {
        return ResManager.loadKDString((String)"\u8d23\u4efb\u7ec4\u7ec7", (String)"StaffEntryHelperEnum_00", (String)"hrmp-haos-business", (Object[])new Object[0]);
    }

    private static String getUseOrgLocaleName() {
        return ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7", (String)"StaffEntryHelperEnum_01", (String)"hrmp-haos-business", (Object[])new Object[0]);
    }

    private static String getPositionLocaleName() {
        return ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"StaffEntryHelperEnum_02", (String)"hrmp-haos-business", (Object[])new Object[0]);
    }

    private static String getJobLocaleName() {
        return ResManager.loadKDString((String)"\u804c\u4f4d", (String)"StaffEntryHelperEnum_03", (String)"hrmp-haos-business", (Object[])new Object[0]);
    }

    private static String getLaborRelTypeLocaleName() {
        return ResManager.loadKDString((String)"\u7528\u5de5\u5173\u7cfb\u7c7b\u578b", (String)"StaffEntryHelperEnum_04", (String)"hrmp-haos-business", (Object[])new Object[0]);
    }

    public static String getKeyFieldByPrefix(String prefix) {
        StaffEntryTempHelperEnum[] entryEnums;
        for (StaffEntryTempHelperEnum entryEnum : entryEnums = StaffEntryTempHelperEnum.values()) {
            if (!entryEnum.getPrefix().equals(prefix)) continue;
            return entryEnum.getKeyField();
        }
        return "";
    }

    public static String getKeyFieldEntityNameByPrefix(String prefix) {
        StaffEntryHelperEnum[] entryEnums;
        for (StaffEntryHelperEnum entryEnum : entryEnums = StaffEntryHelperEnum.values()) {
            if (!entryEnum.getPrefix().equals(prefix)) continue;
            return entryEnum.keyFieldEntityName;
        }
        return "";
    }

    public static List<String> getAllPrefix() {
        StaffEntryHelperEnum[] entryEnums = StaffEntryHelperEnum.values();
        return Arrays.stream(entryEnums).map(StaffEntryHelperEnum::getPrefix).collect(Collectors.toList());
    }

    public static List<String> getPrefixListExcludeDutyOrg() {
        StaffEntryHelperEnum[] entryEnums = StaffEntryHelperEnum.values();
        return Arrays.stream(entryEnums).filter(enums -> !HRStringUtils.equals((String)enums.getPrefix(), (String)"a")).map(StaffEntryHelperEnum::getPrefix).collect(Collectors.toList());
    }

    public static List<String> getMultiPrefixList() {
        return Arrays.stream(StaffEntryHelperEnum.values()).filter(enums -> !HRStringUtils.equals((String)enums.getPrefix(), (String)"a") && !HRStringUtils.equals((String)enums.getPrefix(), (String)"b")).map(StaffEntryHelperEnum::getPrefix).collect(Collectors.toList());
    }

    public static List<String> getMultiKeyFieldList() {
        StaffEntryHelperEnum[] entryEnums;
        ArrayList multiKeyFieldList = Lists.newArrayListWithExpectedSize((int)16);
        for (StaffEntryHelperEnum entryEnum : entryEnums = StaffEntryHelperEnum.values()) {
            if (entryEnum.getPrefix().equals("a") || entryEnum.getPrefix().equals("b")) continue;
            multiKeyFieldList.add(entryEnum.getKeyField());
        }
        return multiKeyFieldList;
    }

    static {
        bEntryImportFields = Arrays.asList("staffdimension", "controlstrategy", "elasticcontrol", "elasticcount", "yearstaffnumwithsub", "yearstaff", "monthstaff1", "monthstaff2", "monthstaff3", "monthstaff4", "monthstaff5", "monthstaff6", "monthstaff7", "monthstaff8", "monthstaff9", "monthstaff10", "monthstaff11", "monthstaff12");
        cEntryImportFields = Arrays.asList("controlstrategy", "elasticcontrol", "elasticcount", "yearstaff", "monthstaff1", "monthstaff2", "monthstaff3", "monthstaff4", "monthstaff5", "monthstaff6", "monthstaff7", "monthstaff8", "monthstaff9", "monthstaff10", "monthstaff11", "monthstaff12");
        dEntryImportFields = Arrays.asList("controlstrategy", "elasticcontrol", "elasticcount", "yearstaff", "monthstaff1", "monthstaff2", "monthstaff3", "monthstaff4", "monthstaff5", "monthstaff6", "monthstaff7", "monthstaff8", "monthstaff9", "monthstaff10", "monthstaff11", "monthstaff12");
        eEntryImportFields = Arrays.asList("controlstrategy", "elasticcontrol", "elasticcount", "yearstaff", "monthstaff1", "monthstaff2", "monthstaff3", "monthstaff4", "monthstaff5", "monthstaff6", "monthstaff7", "monthstaff8", "monthstaff9", "monthstaff10", "monthstaff11", "monthstaff12");
    }
}

