/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.hr.haos.business.domain.repository.staff.StaffDimensionRepository;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public enum StaffEntryTempHelperEnum {
    dutyOrgEntry("a", "dutyorg", false),
    useOrgEntry("b", "useorg", false),
    positionEntry("c", "dutyworkrole", false),
    jobEntry("d", "job", false),
    laborRelTypeEntry("e", "laborreltype", false),
    basicdata1("f", "basicdata1", true),
    basicdata2("g", "basicdata2", true),
    basicdata3("h", "basicdata3", true),
    basicdata4("i", "basicdata4", true),
    basicdata5("j", "basicdata5", true);

    private String prefix;
    private String keyField;
    private boolean isDynamic;
    private String keyFieldEntityName;
    private static Set<String> needAppendInSqlSet;
    public static Predicate<StaffEntryTempHelperEnum> filter;
    private static List<String> bEntryImportFields;
    private static List<String> entryImportFields;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public String getKeyFieldEntityName() {
        return this.keyFieldEntityName;
    }

    public void setKeyFieldEntityName(String keyFieldEntityName) {
        this.keyFieldEntityName = keyFieldEntityName;
    }

    private StaffEntryTempHelperEnum(String prefix, String keyField, boolean isDynamic) {
        this.prefix = prefix;
        this.keyField = keyField;
        this.isDynamic = isDynamic;
    }

    public static List<String> getAllPrefix() {
        StaffEntryTempHelperEnum[] entryEnums = StaffEntryTempHelperEnum.values();
        return Arrays.stream(entryEnums).filter(temp -> filter.test((StaffEntryTempHelperEnum)((Object)temp))).map(StaffEntryTempHelperEnum::getPrefix).collect(Collectors.toList());
    }

    public static List<String> getMultiPrefixList() {
        return Arrays.stream(StaffEntryTempHelperEnum.values()).filter(enums -> !HRStringUtils.equals((String)enums.getPrefix(), (String)"a") && !HRStringUtils.equals((String)enums.getPrefix(), (String)"b") && filter.test((StaffEntryTempHelperEnum)((Object)enums))).map(StaffEntryTempHelperEnum::getPrefix).collect(Collectors.toList());
    }

    public static List<String> getMultiKeyFieldList() {
        StaffEntryTempHelperEnum[] entryEnums;
        ArrayList multiKeyFieldList = Lists.newArrayListWithExpectedSize((int)16);
        for (StaffEntryTempHelperEnum entryEnum : entryEnums = StaffEntryTempHelperEnum.values()) {
            if (entryEnum.getPrefix().equals("a") || entryEnum.getPrefix().equals("b") || !filter.test(entryEnum)) continue;
            multiKeyFieldList.add(entryEnum.getKeyField());
        }
        return multiKeyFieldList;
    }

    public static List<String> getPrefixListExcludeDutyOrg() {
        StaffEntryTempHelperEnum[] entryEnums = StaffEntryTempHelperEnum.values();
        return Arrays.stream(entryEnums).filter(enums -> !HRStringUtils.equals((String)enums.getPrefix(), (String)"a") && filter.test((StaffEntryTempHelperEnum)((Object)enums))).map(StaffEntryTempHelperEnum::getPrefix).collect(Collectors.toList());
    }

    public static String getPrefixByFieldKey(String fieldKey) {
        StaffEntryTempHelperEnum[] entryEnums;
        for (StaffEntryTempHelperEnum entryEnum : entryEnums = StaffEntryTempHelperEnum.values()) {
            if (!fieldKey.equals(entryEnum.getKeyField())) continue;
            return entryEnum.getPrefix();
        }
        return "";
    }

    public static String getKeyFieldByPrefix(String prefix) {
        StaffEntryTempHelperEnum[] entryEnums;
        for (StaffEntryTempHelperEnum entryEnum : entryEnums = StaffEntryTempHelperEnum.values()) {
            if (!entryEnum.getPrefix().equals(prefix)) continue;
            return entryEnum.getKeyField();
        }
        return "";
    }

    public static List<String> getEntryFieldsByPrefix(String prefix) {
        if (prefix.equals("b")) {
            return bEntryImportFields;
        }
        return entryImportFields;
    }

    public static Set<String> getFilter() {
        HashSet needAppendInSqlStrs;
        if (needAppendInSqlSet != null) {
            return needAppendInSqlSet;
        }
        DynamicObject[] dynamicObjects = StaffDimensionRepository.getInstance().listAllDimension();
        Set staffimension = Arrays.stream(dynamicObjects).map(temp -> temp.getString("staffdimension")).collect(Collectors.toSet());
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("haos_muldimendetail");
        DynamicObject mulitStaffdimension = hrBaseServiceHelper.generateEmptyDynamicObject();
        DataEntityPropertyCollection properties = mulitStaffdimension.getDataEntityType().getProperties();
        Set propertyName = properties.stream().map(temp -> temp.getName()).collect(Collectors.toSet());
        needAppendInSqlSet = needAppendInSqlStrs = (HashSet)Sets.intersection(staffimension, propertyName).copyInto(new HashSet(16));
        return needAppendInSqlStrs;
    }

    public static Set<String> getFilterContainsDefualtDimension() {
        DynamicObject[] dynamicObjects = StaffDimensionRepository.getInstance().listDimension();
        Set staffimension = Arrays.stream(dynamicObjects).map(temp -> temp.getString("staffdimension")).collect(Collectors.toSet());
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("haos_muldimendetail");
        DynamicObject mulitStaffdimension = hrBaseServiceHelper.generateEmptyDynamicObject();
        DataEntityPropertyCollection properties = mulitStaffdimension.getDataEntityType().getProperties();
        Set propertyName = properties.stream().map(temp -> temp.getName()).collect(Collectors.toSet());
        HashSet needAppendInSqlStrs = (HashSet)Sets.intersection(staffimension, propertyName).copyInto(new HashSet(16));
        return needAppendInSqlStrs;
    }

    static {
        filter = temp -> !temp.isDynamic || StaffEntryTempHelperEnum.getFilter().contains(temp.getKeyField());
        bEntryImportFields = Arrays.asList("staffdimension", "controlstrategy", "elasticcontrol", "elasticcount", "yearstaffnumwithsub", "yearstaff", "monthstaff1", "monthstaff2", "monthstaff3", "monthstaff4", "monthstaff5", "monthstaff6", "monthstaff7", "monthstaff8", "monthstaff9", "monthstaff10", "monthstaff11", "monthstaff12");
        entryImportFields = Arrays.asList("controlstrategy", "elasticcontrol", "elasticcount", "yearstaff", "monthstaff1", "monthstaff2", "monthstaff3", "monthstaff4", "monthstaff5", "monthstaff6", "monthstaff7", "monthstaff8", "monthstaff9", "monthstaff10", "monthstaff11", "monthstaff12");
    }
}

