/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.occupy.core;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.staff.occupy.IStaffOccupyService;
import kd.hr.haos.business.service.staff.occupy.bean.StaffDetailBO;
import kd.hr.haos.business.service.staff.occupy.impl.StaffOccupyServiceImpl;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.common.model.org.staff.StaffQueryInParam;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParam;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public abstract class AbstractStaffOccupyService
implements OrgStaffConstants {
    protected static final Log logger = LogFactory.getLog(AbstractStaffOccupyService.class);
    protected static Map<Integer, Function<StaffDetailBO, Integer>> staffCycleFunctionMap = Maps.newHashMapWithExpectedSize((int)16);
    protected AbstractStaffOccupyService nextOccupyService;
    protected IStaffOccupyService staffOccupyService;
    protected Map<String, List<StaffQueryInParam>> queryParamGroupMap = Maps.newHashMapWithExpectedSize((int)16);
    protected Map<String, List<DynamicObject>> beforeDynGroupMap = Maps.newHashMapWithExpectedSize((int)16);
    protected Map<String, List<DynamicObject>> beforeDynDateGroupMap = Maps.newHashMapWithExpectedSize((int)16);
    protected Map<String, List<DynamicObject>> effDynDateGroupMap = Maps.newHashMapWithExpectedSize((int)16);
    protected Map<String, StaffDetailBO> staffOccupyResultMap = Maps.newHashMapWithExpectedSize((int)16);
    protected Map<String, Map<String, Object>> systemParam = Maps.newHashMapWithExpectedSize((int)16);
    protected Map<Long, String> useOrgBoIdOrDutyOrgIdVsBoNameMap = Maps.newHashMapWithExpectedSize((int)16);
    protected List<DynamicObject> allStaffCaseDynList = Lists.newArrayListWithExpectedSize((int)16);

    public AbstractStaffOccupyService(List<StaffQueryInParam> staffQueryInParams) {
        this.staffOccupyService = new StaffOccupyServiceImpl(staffQueryInParams);
    }

    public void setBeforeDynGroupMap(Map<String, List<DynamicObject>> beforeDynGroupMap) {
        this.beforeDynGroupMap = beforeDynGroupMap;
    }

    public void setQueryParamGroupMap(Map<String, List<StaffQueryInParam>> queryParamGroupMap) {
        this.queryParamGroupMap = queryParamGroupMap;
    }

    public void setNextOccupyService(AbstractStaffOccupyService occupyService) {
        this.nextOccupyService = occupyService;
    }

    public void setSystemParam(Map<String, Map<String, Object>> systemParam) {
        this.systemParam = systemParam;
    }

    public void setAllStaffCaseDynList(List<DynamicObject> allStaffCaseDynList) {
        this.allStaffCaseDynList = allStaffCaseDynList;
    }

    public void invokeStaffOccupyCalc(StaffQueryInParam staffQueryInParam, StaffQueryOutParam staffQueryOutParam) {
        boolean isContinue = this.occupyCalc(staffQueryInParam, staffQueryOutParam);
        if (this.nextOccupyService != null && isContinue) {
            this.nextOccupyService.invokeStaffOccupyCalc(staffQueryInParam, staffQueryOutParam);
        }
    }

    protected abstract boolean occupyCalc(StaffQueryInParam var1, StaffQueryOutParam var2);

    protected abstract String getOccupyKey(StaffQueryInParam var1);

    protected abstract String getDimensionCombKey(StaffQueryInParam var1);

    protected abstract String getKeyFieldName(StaffDetailBO var1);

    protected abstract String buildReasonMessage(int var1, String var2);

    protected void rebuildOccupyResultMap() {
    }

    protected Set<Long> getOrgIds() {
        return this.staffOccupyResultMap.values().stream().map(StaffDetailBO::getOrgId).collect(Collectors.toSet());
    }

    protected List<DynamicObject> buildBeforeUseStaffByEffDate(Date effDate, String occupyKey, List<DynamicObject> useStaffList) {
        if (effDate == null || CollectionUtils.isEmpty(useStaffList)) {
            return null;
        }
        String groupKey = effDate + "-" + occupyKey;
        return this.beforeDynDateGroupMap.computeIfAbsent(groupKey, function -> useStaffList.stream().filter(dyn -> !dyn.getDate("effdt").after(effDate) && !dyn.getDate("leffdt").before(effDate)).collect(Collectors.toList()));
    }

    protected List<DynamicObject> buildUseStaffByEffDate(Date effDate, String occupyKey, List<DynamicObject> useStaffList) {
        if (effDate == null || CollectionUtils.isEmpty(useStaffList)) {
            return null;
        }
        Set personIdSet = this.allStaffCaseDynList.stream().filter(dyn -> this.containsDateRange((DynamicObject)dyn, effDate)).map(dyn -> dyn.getLong("person.id")).collect(Collectors.toSet());
        logger.info("AbstractStaffOccupyService.buildUseStaffByEffDate.personIdSet:{}", personIdSet);
        String groupKey = effDate + "-" + occupyKey;
        return this.effDynDateGroupMap.computeIfAbsent(groupKey, function -> useStaffList.stream().filter(dyn -> {
            long personIdFromDB = dyn.getLong("personstaffinfo.person.id");
            return !dyn.getDate("effdt").after(effDate) && !dyn.getDate("leffdt").before(effDate) && !personIdSet.contains(personIdFromDB);
        }).collect(Collectors.toList()));
    }

    private boolean containsDateRange(DynamicObject staffCaseDyn, Date effDate) {
        Date bsed = HRDateTimeUtils.truncateDate((Date)staffCaseDyn.getDate("bsed"));
        Date bsled = staffCaseDyn.getDate("bsled");
        Date date = bsled = bsled == null ? HisEffDateCommonService.getInstance().getDate2999(null) : HRDateTimeUtils.truncateDate((Date)bsled);
        return !bsed.after(effDate) && !bsled.before(effDate);
    }

    protected boolean commonStaffNumValid(StaffQueryInParam staffQueryInParam, StaffQueryOutParam staffQueryOutParam, StaffDetailBO staffDetailBO) {
        String occupyKey = this.getOccupyKey(staffQueryInParam);
        String dimensionCombKey = this.getDimensionCombKey(staffQueryInParam);
        Date effDate = staffQueryInParam.getEffDate();
        List<DynamicObject> beforeUseStaffList = this.beforeDynGroupMap.get(dimensionCombKey);
        List<DynamicObject> beforeEffUseStaffList = this.buildBeforeUseStaffByEffDate(effDate, occupyKey, beforeUseStaffList);
        logger.info("AbstractStaffOccupyService.commonStaffNumValid.beforeUseStaffList:{},beforeEffUseStaffList.size:{}", (Object)(CollectionUtils.isEmpty(beforeUseStaffList) ? 0 : beforeUseStaffList.size()), (Object)(CollectionUtils.isEmpty(beforeEffUseStaffList) ? 0 : beforeEffUseStaffList.size()));
        List<DynamicObject> useStaffList = staffDetailBO.getUseStaffList();
        List<DynamicObject> effUseStaffList = this.buildUseStaffByEffDate(effDate, occupyKey, useStaffList);
        logger.info("AbstractStaffOccupyService.commonStaffNumValid.useStaffList.size:{},effUseStaffList.size:{}", (Object)(CollectionUtils.isEmpty(useStaffList) ? 0 : useStaffList.size()), (Object)(CollectionUtils.isEmpty(effUseStaffList) ? 0 : effUseStaffList.size()));
        int month = HRDateTimeUtils.getMonth((Date)effDate);
        Integer cycleKey = STAFF_CYCLE_MONTH.longValue() == staffDetailBO.getStaffCycleId() ? month : 0;
        Integer staffNum = staffCycleFunctionMap.get(cycleKey).apply(staffDetailBO);
        if (staffNum == null) {
            return true;
        }
        staffQueryOutParam.setControl(true);
        String roundType = ((Map)this.systemParam.getOrDefault(String.valueOf(staffDetailBO.getOrgId()), new HashMap())).getOrDefault("elasticcountgroup", "1");
        staffDetailBO.buildStrategySpringValue(staffNum, roundType);
        int remainStaffNum = staffDetailBO.getStaffNum();
        logger.info("AbstractStaffOccupyService.commonStaffNumValid.staffQueryInParam:{},remainStaffNum.size:{},beforeEffUseStaffList.size:{},effUseStaffList.size:{}", new Object[]{JSONObject.toJSONString((Object)staffQueryInParam), remainStaffNum, CollectionUtils.isEmpty(beforeUseStaffList) ? 0 : beforeUseStaffList.size(), CollectionUtils.isEmpty(effUseStaffList) ? 0 : effUseStaffList.size()});
        if (!CollectionUtils.isEmpty(effUseStaffList)) {
            remainStaffNum -= effUseStaffList.size();
        }
        if (!CollectionUtils.isEmpty(beforeEffUseStaffList)) {
            remainStaffNum += beforeEffUseStaffList.size();
        }
        List<Object> paramGroups = this.queryParamGroupMap.get(dimensionCombKey);
        if (!CollectionUtils.isEmpty(paramGroups = paramGroups.stream().filter(paramGroup -> !this.isMatch(paramGroup.getPersonId(), paramGroup.getEffDate())).collect(Collectors.toList())) && remainStaffNum < paramGroups.size()) {
            staffQueryOutParam.setOverStaffing(true);
            if (!"1".equals(staffDetailBO.getControlStrategy())) {
                staffQueryOutParam.setAllow(false);
                String name = this.getKeyFieldName(staffDetailBO);
                staffQueryOutParam.getReasonList().add(this.buildReasonMessage(remainStaffNum, name));
            }
        }
        return true;
    }

    private boolean isMatch(Long personId, Date effDate) {
        Set personIdSet = this.allStaffCaseDynList.stream().filter(dyn -> this.containsDateRange((DynamicObject)dyn, effDate)).map(dyn -> dyn.getLong("person.id")).collect(Collectors.toSet());
        return personIdSet.contains(personId);
    }

    static {
        staffCycleFunctionMap.put(0, StaffDetailBO::getYearStaff);
        staffCycleFunctionMap.put(1, StaffDetailBO::getMonth1);
        staffCycleFunctionMap.put(2, StaffDetailBO::getMonth2);
        staffCycleFunctionMap.put(3, StaffDetailBO::getMonth3);
        staffCycleFunctionMap.put(4, StaffDetailBO::getMonth4);
        staffCycleFunctionMap.put(5, StaffDetailBO::getMonth5);
        staffCycleFunctionMap.put(6, StaffDetailBO::getMonth6);
        staffCycleFunctionMap.put(7, StaffDetailBO::getMonth7);
        staffCycleFunctionMap.put(8, StaffDetailBO::getMonth8);
        staffCycleFunctionMap.put(9, StaffDetailBO::getMonth9);
        staffCycleFunctionMap.put(10, StaffDetailBO::getMonth10);
        staffCycleFunctionMap.put(11, StaffDetailBO::getMonth11);
        staffCycleFunctionMap.put(12, StaffDetailBO::getMonth12);
    }
}

