/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.occupy.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.staff.DutyOrgDetailRepository;
import kd.hr.haos.business.domain.repository.staff.OrgUseStaffDetailRepository;
import kd.hr.haos.business.domain.repository.staff.PersonChangeEventRepository;
import kd.hr.haos.business.domain.repository.staff.PersonStaffInfoRepository;
import kd.hr.haos.business.domain.repository.staff.UseOrgDetailRepository;
import kd.hr.haos.business.service.staff.occupy.bean.StaffDetailBO;
import kd.hr.haos.business.service.staff.occupy.core.AbstractStaffOccupyService;
import kd.hr.hbp.common.model.org.staff.StaffQueryInParam;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParam;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class DutyOrgOccupyChain
extends AbstractStaffOccupyService {
    private AbstractStaffOccupyService preOccupyService;
    private DutyOrgDetailRepository dutyOrgDetailRepository = DutyOrgDetailRepository.getInstance();
    private UseOrgDetailRepository useOrgDetailRepository = UseOrgDetailRepository.getInstance();
    private OrgUseStaffDetailRepository useStaffInfoRepository = OrgUseStaffDetailRepository.getInstance();
    private Map<Long, Long> useOrgBODutyOrgIdMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, Long> dutyOrgIdVsDutyOrgBoIdMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, Set<Long>> dutyOrgSubOrgIdMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, List<DynamicObject>> useStaffGroupMap;
    private PersonStaffInfoRepository personStaffInfoRepository = PersonStaffInfoRepository.getInstance();
    Map<Long, String> occupyStaffInfoIdVsChangeEventNumMap = Maps.newHashMapWithExpectedSize((int)16);

    public DutyOrgOccupyChain(AbstractStaffOccupyService preOccupyService, List<StaffQueryInParam> staffQueryInParams) {
        super(staffQueryInParams);
        logger.info("DutyOrgOccupyChain.init.begin!");
        this.preOccupyService = preOccupyService;
        Collection<StaffDetailBO> staffDetailBOs = preOccupyService.staffOccupyResultMap.values();
        HashSet staffIds = Sets.newHashSetWithExpectedSize((int)staffDetailBOs.size());
        HashSet useOrgOrDutyOrgIdSet = Sets.newHashSetWithExpectedSize((int)staffDetailBOs.size());
        ArrayList dutyOrgIdList = Lists.newArrayListWithExpectedSize((int)staffDetailBOs.size());
        for (StaffDetailBO staffDetailBO : staffDetailBOs) {
            staffIds.add(staffDetailBO.getStaffId());
            useOrgOrDutyOrgIdSet.add(staffDetailBO.getUseOrgBOId());
            useOrgOrDutyOrgIdSet.add(staffDetailBO.getDutyOrgId());
            this.useOrgBODutyOrgIdMap.put(staffDetailBO.getUseOrgBOId(), staffDetailBO.getDutyOrgId());
            dutyOrgIdList.add(staffDetailBO.getDutyOrgId());
        }
        this.initUseOrgBODutyOrgIdMap(dutyOrgIdList);
        this.initKeyFieldIdVsNameMap(useOrgOrDutyOrgIdSet);
        this.initDutyOrgDetailInfo(staffIds);
        this.initDutyOrgOccupyInfo(staffIds);
        logger.info("DutyOrgOccupyChain.init.end, dutyOrgInfoMap:{}", (Object)this.staffOccupyResultMap.toString());
    }

    private void initUseOrgBODutyOrgIdMap(List<Long> dutyOrgIdList) {
        DynamicObject[] adminOrgDynArr = AdOrgRepository.getInstance().queryBaseFieldAdminOrgByIdList(dutyOrgIdList);
        this.dutyOrgIdVsDutyOrgBoIdMap = Arrays.stream(adminOrgDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("boid"), (o1, o2) -> o1));
    }

    private void initKeyFieldIdVsNameMap(Set<Long> useOrgOrDutyOrgId) {
        QFilter idFilter = new QFilter("id", "in", useOrgOrDutyOrgId);
        DynamicObject[] adminOrgDyns = AdOrgRepository.getInstance().queryOriginalArray("id, boid", new QFilter[]{idFilter});
        Map<Long, Long> orgIdVsBoIdMap = Arrays.stream(adminOrgDyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("boid")));
        Collection<Long> orgBoIdCol = orgIdVsBoIdMap.values();
        QFilter boIdFilter = new QFilter("boid", "in", orgBoIdCol);
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] adminOrgDynsForName = AdOrgRepository.getInstance().queryOriginalArray("id, boid, name", new QFilter[]{boIdFilter, isCurrentVersionFilter});
        Map<Long, String> orgBoIdVsNameMap = Arrays.stream(adminOrgDynsForName).collect(Collectors.toMap(dyn -> dyn.getLong("boid"), dyn -> dyn.getString("name")));
        for (Long orgId : useOrgOrDutyOrgId) {
            Long orgBoId = orgIdVsBoIdMap.get(orgId);
            String name = orgBoIdVsNameMap.get(orgBoId);
            this.useOrgBoIdOrDutyOrgIdVsBoNameMap.put(orgId, name);
        }
    }

    private void initDutyOrgDetailInfo(Set<Long> staffIds) {
        DynamicObject[] dutyOrgInfoArr;
        QFilter filter = new QFilter("staff", "in", staffIds);
        filter.and("dutyorg.id", "in", this.useOrgBODutyOrgIdMap.values());
        for (DynamicObject dutyOrgInfo : dutyOrgInfoArr = this.dutyOrgDetailRepository.loadDutyOrgDetailByFilter(filter)) {
            String occupyKey = HRDateTimeUtils.getYear((Date)dutyOrgInfo.getDate("staff.year")) + "-" + dutyOrgInfo.getLong("dutyorg.id");
            StaffDetailBO staffDetailBO = new StaffDetailBO();
            staffDetailBO.setYear(dutyOrgInfo.getDate("staff.year"));
            staffDetailBO.setId(dutyOrgInfo.getLong("id"));
            staffDetailBO.setDimensionBOId(dutyOrgInfo.getLong("dutyorg.boid"));
            staffDetailBO.setDutyOrgId(dutyOrgInfo.getLong("dutyorg.id"));
            staffDetailBO.setControlStrategy(dutyOrgInfo.getString("controlstrategy"));
            staffDetailBO.setElasticControl(dutyOrgInfo.getString("elasticcontrol"));
            staffDetailBO.setElasticCount(dutyOrgInfo.getInt("elasticcount"));
            staffDetailBO.setOrgId(dutyOrgInfo.getLong("staff.org.id"));
            staffDetailBO.buildStrategySpringValue(dutyOrgInfo.getInt("staffcount"));
            this.staffOccupyResultMap.put(occupyKey, staffDetailBO);
        }
    }

    private void initDutyOrgOccupyInfo(Set<Long> staffIds) {
        QFilter filter = new QFilter("staff", "in", staffIds);
        filter.and("dutyorg.id", "in", new ArrayList<Long>(this.useOrgBODutyOrgIdMap.values()));
        DynamicObject[] useOrgDetailArr = this.useOrgDetailRepository.queryUseOrgDetailByFilter("staff, dutyorg, useorgbo, bo", filter);
        HashSet boIdSet = Sets.newHashSetWithExpectedSize((int)useOrgDetailArr.length);
        for (DynamicObject useOrgDetailInfo : useOrgDetailArr) {
            boIdSet.add(useOrgDetailInfo.getLong("bo"));
            long dutyOrgId = useOrgDetailInfo.getLong("dutyorg.id");
            Date staffYear = useOrgDetailInfo.getDate("staff.year");
            long useOrgBOId = useOrgDetailInfo.getLong("useorgbo");
            String dutyOrgMapKey = HRDateTimeUtils.getYear((Date)staffYear) + "-" + dutyOrgId;
            Set<Long> subUseOrgIds = this.dutyOrgSubOrgIdMap.getOrDefault(dutyOrgMapKey, Sets.newHashSetWithExpectedSize((int)16));
            subUseOrgIds.add(useOrgBOId);
            this.dutyOrgSubOrgIdMap.put(dutyOrgMapKey, subUseOrgIds);
        }
        String selectFields = "bo, useorg, effdt, leffdt, stafftype, personstaffinfo";
        DynamicObject[] useStaffInfoArr = this.useStaffInfoRepository.queryOccupyUseStaffInfoByBOId(selectFields, null, boIdSet);
        this.useStaffGroupMap = Arrays.stream(useStaffInfoArr).collect(Collectors.groupingBy(useStaffInfo -> useStaffInfo.getLong("useorg.id")));
        List<Long> personStaffInfoId = Arrays.stream(useStaffInfoArr).map(occupyStaffInfo -> occupyStaffInfo.getLong("personstaffinfo.id")).collect(Collectors.toList());
        DynamicObject[] personStaffInfoDyns = this.personStaffInfoRepository.queryById(personStaffInfoId);
        Map<Long, DynamicObject> personStaffInfoIdVsPersonIdMap = Arrays.stream(personStaffInfoDyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        for (DynamicObject useStaffInfo2 : useStaffInfoArr) {
            long personstaffinfoId = useStaffInfo2.getLong("personstaffinfo.id");
            useStaffInfo2.set("personstaffinfo", (Object)personStaffInfoIdVsPersonIdMap.get(personstaffinfoId));
        }
        List<Long> orgUseInfoIdList = Arrays.stream(useStaffInfoArr).map(info -> info.getLong("id")).collect(Collectors.toList());
        DynamicObject[] changeEventDynArr = PersonChangeEventRepository.getInstance().queryByUId(orgUseInfoIdList);
        this.occupyStaffInfoIdVsChangeEventNumMap = Arrays.stream(changeEventDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("orgusestaffdetail.id"), dyn -> dyn.getString("changeevent.number")));
    }

    @Override
    protected boolean occupyCalc(StaffQueryInParam staffQueryInParam, StaffQueryOutParam staffQueryOutParam) {
        Long orgTeamId = staffQueryInParam.getOrgTeamId();
        Date effDate = staffQueryInParam.getEffDate();
        Long dutyOrgId = this.useOrgBODutyOrgIdMap.get(orgTeamId);
        if (dutyOrgId == null) {
            return true;
        }
        String occupyKey = this.getOccupyKey(staffQueryInParam);
        StaffDetailBO staffDetailBO = (StaffDetailBO)this.staffOccupyResultMap.get(occupyKey);
        Set<Long> subUseOrgIds = this.dutyOrgSubOrgIdMap.get(occupyKey);
        if (staffDetailBO == null || CollectionUtils.isEmpty(subUseOrgIds)) {
            return true;
        }
        if ("4".equals(staffDetailBO.getControlStrategy())) {
            return true;
        }
        staffQueryOutParam.setControl(true);
        Integer staffNum = staffDetailBO.getStaffNum();
        int queryCount = 0;
        for (Long subUseOrgId : subUseOrgIds) {
            List<StaffQueryInParam> useOrgGroups;
            String useOrgOccupyKey = HRDateTimeUtils.getYear((Date)effDate) + "-" + subUseOrgId;
            List<DynamicObject> beforeUseStaffList = this.preOccupyService.beforeDynGroupMap.get(String.valueOf(subUseOrgId));
            List<DynamicObject> beforeEffUseStaffList = this.preOccupyService.buildBeforeUseStaffByEffDate(effDate, useOrgOccupyKey, beforeUseStaffList);
            List<DynamicObject> useStaffList = this.useStaffGroupMap.get(subUseOrgId);
            this.staffOccupyService.filterUsestaff(useStaffList, staffDetailBO.getOrgId(), this.occupyStaffInfoIdVsChangeEventNumMap);
            List<DynamicObject> effUseStaffList = this.preOccupyService.buildUseStaffByEffDate(effDate, useOrgOccupyKey, useStaffList);
            if (!CollectionUtils.isEmpty(beforeEffUseStaffList)) {
                staffNum = staffNum + beforeEffUseStaffList.size();
            }
            if (!CollectionUtils.isEmpty(effUseStaffList)) {
                staffNum = staffNum - effUseStaffList.size();
            }
            if (CollectionUtils.isEmpty(useOrgGroups = this.preOccupyService.queryParamGroupMap.get(String.valueOf(subUseOrgId)))) continue;
            queryCount += useOrgGroups.size();
        }
        if (staffNum < queryCount && !"1".equals(staffDetailBO.getControlStrategy())) {
            staffQueryOutParam.setAllow(false);
            if (orgTeamId.equals(this.dutyOrgIdVsDutyOrgBoIdMap.get(dutyOrgId))) {
                staffQueryOutParam.getReasonList().add(0, this.buildReasonMessage(staffNum, (String)this.useOrgBoIdOrDutyOrgIdVsBoNameMap.get(dutyOrgId)));
            } else {
                staffQueryOutParam.getReasonList().add(0, this.buildReasonMessage(staffNum, (String)this.useOrgBoIdOrDutyOrgIdVsBoNameMap.get(orgTeamId), (String)this.useOrgBoIdOrDutyOrgIdVsBoNameMap.get(dutyOrgId)));
            }
        }
        return true;
    }

    @Override
    protected String getOccupyKey(StaffQueryInParam staffQueryInParam) {
        Long orgTeamId = staffQueryInParam.getOrgTeamId();
        Date effDate = staffQueryInParam.getEffDate();
        return HRDateTimeUtils.getYear((Date)effDate) + "-" + this.useOrgBODutyOrgIdMap.get(orgTeamId);
    }

    @Override
    protected String getDimensionCombKey(StaffQueryInParam staffQueryInParam) {
        return null;
    }

    @Override
    protected String getKeyFieldName(StaffDetailBO staffDetailBO) {
        return (String)this.useOrgBoIdOrDutyOrgIdVsBoNameMap.get(staffDetailBO.getDutyOrgId());
    }

    @Override
    protected String buildReasonMessage(int remainStaffNum, String name) {
        return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7f16\u5236\u603b\u989d\u4e0d\u8db3\uff08\u7a7a\u4f59\u7f16\u5236\uff1a%2$s\uff09\u3002", (String)"DutyOrgOccupyChain_1", (String)"hrmp-haos-business", (Object[])new Object[0]), name, remainStaffNum);
    }

    private String buildReasonMessage(int remainStaffNum, String useOrgName, String dutyOrgName) {
        return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0a\u7ea7\u201c%2$s\u201d\u7f16\u5236\u603b\u989d\u4e0d\u8db3\uff08\u7a7a\u4f59\u7f16\u5236\uff1a%3$s\uff09\u3002", (String)"DutyOrgOccupyChain_0", (String)"hrmp-haos-business", (Object[])new Object[0]), useOrgName, dutyOrgName, remainStaffNum);
    }
}

