/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.occupy.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.staff.DutyOrgDetailRepository;
import kd.hr.haos.business.domain.repository.staff.MuldimDetailRepository;
import kd.hr.haos.business.domain.repository.staff.MuldimUseStaffRepository;
import kd.hr.haos.business.domain.repository.staff.OrgUseStaffDetailRepository;
import kd.hr.haos.business.domain.repository.staff.PersonChangeEventRepository;
import kd.hr.haos.business.domain.repository.staff.PersonStaffInfoRepository;
import kd.hr.haos.business.domain.repository.staff.StaffCaseRepository;
import kd.hr.haos.business.domain.repository.staff.StaffDimensionRepository;
import kd.hr.haos.business.domain.repository.staff.StaffRepository;
import kd.hr.haos.business.domain.repository.staff.UseOrgDetailRepository;
import kd.hr.haos.business.service.staff.bean.DutyOrgTreeDataBo;
import kd.hr.haos.business.service.staff.bean.OccupyStaffResult;
import kd.hr.haos.business.service.staff.occupy.IStaffOccupyService;
import kd.hr.haos.business.service.staff.occupy.bean.QueryStaffDetailParam;
import kd.hr.haos.business.service.staff.occupy.bean.StaffDetailBO;
import kd.hr.haos.business.service.staff.occupy.bean.StaffDimenPropertyBO;
import kd.hr.haos.business.service.staff.occupy.bean.StaffDimensionConfig;
import kd.hr.haos.business.service.staff.occupy.core.AbstractStaffOccupyService;
import kd.hr.haos.business.service.staff.occupy.core.StaffOccupyServiceCreator;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.business.util.TimeConvertUtil;
import kd.hr.haos.business.util.TimeLogger;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.haos.common.util.tree.FindSubNode;
import kd.hr.haos.common.util.tree.FindSubTree;
import kd.hr.haos.common.util.tree.Node;
import kd.hr.hbp.common.model.org.staff.StaffQueryInParam;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParam;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParamMap;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class StaffOccupyServiceImpl
implements IStaffOccupyService,
OrgStaffConstants {
    private static final Log logger = LogFactory.getLog(StaffOccupyServiceImpl.class);
    private static final String QUERY_SQL = "querySql";
    private static final String QUERY_PARAM = "queryParam";
    private Map<String, StaffDimensionConfig> dimensionConfigMap = Maps.newHashMapWithExpectedSize((int)16);
    private List<StaffQueryInParam> staffQueryInParams;
    Map<String, Function<QueryStaffDetailParam, Map<String, Object>>> commonFunctionMap = Maps.newHashMapWithExpectedSize((int)16);
    Map<String, Function<QueryStaffDetailParam, DynamicObject[]>> functionMap = Maps.newHashMapWithExpectedSize((int)16);
    private PersonStaffInfoRepository personStaffInfoRepository = PersonStaffInfoRepository.getInstance();
    private UseOrgDetailRepository useOrgDetailRepository = UseOrgDetailRepository.getInstance();
    private MuldimDetailRepository muldimDetailRepository = MuldimDetailRepository.getInstance();
    private OrgUseStaffDetailRepository useStaffDetailRepository = OrgUseStaffDetailRepository.getInstance();
    private MuldimUseStaffRepository muldimUseStaffRepository = MuldimUseStaffRepository.getInstance();

    private void dimensionConfigMapInit() {
        StaffDimenPropertyBO useOrgPropertyBO = new StaffDimenPropertyBO("useorg.boid", StaffQueryInParam::getOrgTeamId);
        StaffDimenPropertyBO positionPropertyBO = new StaffDimenPropertyBO("dutyworkrole", StaffQueryInParam::getDutyWorkRoleId);
        StaffDimenPropertyBO jobPropertyBO = new StaffDimenPropertyBO("job", StaffQueryInParam::getJobId);
        StaffDimenPropertyBO laborPropertyBO = new StaffDimenPropertyBO("laborreltype", StaffQueryInParam::getLaborRelTypeId);
        StaffDimensionConfig useOrgConfig = new StaffDimensionConfig("haos_useorgdetail", "useorg.boid", Collections.singletonList(useOrgPropertyBO), 0L);
        ArrayList positionPropertyBOs = Lists.newArrayListWithExpectedSize((int)16);
        positionPropertyBOs.add(useOrgPropertyBO);
        positionPropertyBOs.add(positionPropertyBO);
        StaffDimensionConfig positionConfig = new StaffDimensionConfig("haos_muldimendetail", "dutyworkrole.id", "dutyworkrole.name", positionPropertyBOs, 1010L);
        ArrayList jobPropertyBOs = Lists.newArrayListWithExpectedSize((int)16);
        jobPropertyBOs.add(useOrgPropertyBO);
        jobPropertyBOs.add(jobPropertyBO);
        StaffDimensionConfig jobConfig = new StaffDimensionConfig("haos_muldimendetail2", "job.id", "job.name", jobPropertyBOs, 1020L);
        ArrayList laborPropertyBOs = Lists.newArrayListWithExpectedSize((int)16);
        laborPropertyBOs.add(useOrgPropertyBO);
        laborPropertyBOs.add(laborPropertyBO);
        StaffDimensionConfig laborRelTypeConfig = new StaffDimensionConfig("haos_muldimendetail3", "laborreltype.id", "laborreltype.name", laborPropertyBOs, 1050L);
        this.dimensionConfigMap.put("haos_useorgdetail", useOrgConfig);
        this.dimensionConfigMap.put("haos_muldimendetail", positionConfig);
        this.dimensionConfigMap.put("haos_muldimendetail2", jobConfig);
        this.dimensionConfigMap.put("haos_muldimendetail3", laborRelTypeConfig);
        this.dynamicDimensionConfigMapInit(useOrgPropertyBO);
    }

    public StaffOccupyServiceImpl(List<StaffQueryInParam> staffQueryInParams) {
        this.staffQueryInParams = staffQueryInParams;
        this.init();
        this.dimensionConfigMapInit();
    }

    public StaffOccupyServiceImpl() {
        this.init();
    }

    private void init() {
        this.commonFunctionMap.put("haos_useorgdetail", this::getSingleDimensionSqlAndParam);
        this.commonFunctionMap.put("haos_muldimendetail", this::getSingleDimensionSqlAndParam);
        this.functionMap.put("haos_useorgdetail", this::getUseOrgDetailArr);
        this.functionMap.put("haos_muldimendetail", this::getDimensionDetailArr);
        this.functionMap.put("haos_muldimendetail2", this::getDimensionDetailArr);
        this.functionMap.put("haos_muldimendetail3", this::getDimensionDetailArr);
    }

    @Override
    public StaffQueryOutParamMap queryStaffOccupyInfo() {
        logger.info("StaffOccupyService.queryStaffOccupyInfo.staffQueryInParams:{}", (Object)JSONObject.toJSONString(this.staffQueryInParams));
        StaffQueryOutParamMap resultMap = new StaffQueryOutParamMap();
        AbstractStaffOccupyService occupyService = StaffOccupyServiceCreator.getInstance(this.staffQueryInParams).getOccupyService();
        logger.info("StaffOccupyService.queryStaffOccupyInfo.begin!");
        for (StaffQueryInParam staffQueryInParam : this.staffQueryInParams) {
            Object isOccupyStaff;
            StaffQueryOutParam staffQueryOutParam = new StaffQueryOutParam();
            Long candidateId = staffQueryInParam.getCandidateId();
            Long personId = staffQueryInParam.getPersonId();
            Long depEmpId = staffQueryInParam.getDepEmpId();
            staffQueryOutParam.setCandidateId(candidateId);
            staffQueryOutParam.setDepEmpId(depEmpId);
            staffQueryOutParam.setPersonId(personId);
            staffQueryOutParam.setOrgTeamId(staffQueryInParam.getOrgTeamId());
            staffQueryOutParam.setControl(false);
            staffQueryOutParam.setOverStaffing(false);
            staffQueryOutParam.setAllow(true);
            String occupyKey = depEmpId == null ? "C" + candidateId : "D" + depEmpId;
            Map otherParamMap = staffQueryInParam.getOther();
            Object v0 = isOccupyStaff = otherParamMap == null ? null : otherParamMap.get("isOccupyStaff");
            if (isOccupyStaff != null && (isOccupyStaff instanceof String && ("false".equals(isOccupyStaff) || "0".equals(isOccupyStaff)) || isOccupyStaff instanceof Boolean && !((Boolean)isOccupyStaff).booleanValue())) {
                resultMap.put((Object)occupyKey, (Object)staffQueryOutParam);
                continue;
            }
            occupyService.invokeStaffOccupyCalc(staffQueryInParam, staffQueryOutParam);
            resultMap.put((Object)occupyKey, (Object)staffQueryOutParam);
        }
        logger.info("StaffOccupyService.queryStaffOccupyInfo.StaffQueryOutParamMap:{}", (Object)JSONObject.toJSONString((Object)resultMap));
        return resultMap;
    }

    @Override
    public Map<String, StaffDetailBO> queryUseStaffInfo() {
        List<StaffDetailBO> staffDetailBOs = this.checkAndGetDetail("haos_useorgdetail");
        return this.queryStaffInfo("haos_useorgdetail", staffDetailBOs, 0L);
    }

    @Override
    public Map<String, Map<String, Object>> queryUseStaffInfo(Date queryDate, List<Long> useOrgIds) {
        if (CollectionUtils.isEmpty(useOrgIds)) {
            return null;
        }
        if (queryDate == null) {
            queryDate = new Date();
        }
        QueryStaffDetailParam queryStaffDetailParam = new QueryStaffDetailParam();
        queryStaffDetailParam.setEntityName("haos_useorgdetail");
        queryStaffDetailParam.setRelDate(queryDate);
        queryStaffDetailParam.setStaffYear(queryDate);
        queryStaffDetailParam.setEntryBoList(useOrgIds);
        List<StaffDetailBO> staffDetailBOs = this.getStaffDetailById(queryStaffDetailParam);
        return this.queryStaffInfo("haos_useorgdetail", queryDate, staffDetailBOs, 0L);
    }

    @Override
    public Map<String, Map<String, Object>> queryUseStaffInfo(Date queryDate, List<Long> useOrgIds, Date staffDate) {
        if (CollectionUtils.isEmpty(useOrgIds)) {
            return Maps.newHashMap();
        }
        if (queryDate == null) {
            queryDate = new Date();
        }
        QueryStaffDetailParam queryStaffDetailParam = new QueryStaffDetailParam();
        queryStaffDetailParam.setEntityName("haos_useorgdetail");
        queryStaffDetailParam.setRelDate(queryDate);
        queryStaffDetailParam.setStaffYear(staffDate);
        queryStaffDetailParam.setEntryBoList(useOrgIds);
        List<StaffDetailBO> staffDetailBOs = this.getStaffDetailById(queryStaffDetailParam);
        return this.queryStaffInfo("haos_useorgdetail", OrgDateTimeUtil.getLastDayOfMonth((Date)new Date()), staffDetailBOs, 0L);
    }

    @Override
    @Deprecated
    public Map<String, Map<String, Object>> queryUseStaffInfo(long staffId, Date queryDate) {
        DynamicObject staffDy = StaffRepository.getInstance().queryStaffById("year", staffId);
        Date staffYear = staffDy.getDate("year");
        DynamicObject[] useOrgDetails = UseOrgDetailRepository.getInstance().queryUseOrgDetailByStaffId("useorgbo", staffId);
        List<Long> useOrgBoList = Arrays.stream(useOrgDetails).map(dy -> dy.getLong("useorgbo")).collect(Collectors.toList());
        QueryStaffDetailParam queryStaffDetailParam = new QueryStaffDetailParam();
        queryStaffDetailParam.setEntityName("haos_useorgdetail");
        queryStaffDetailParam.setRelDate(queryDate);
        queryStaffDetailParam.setEntryBoList(useOrgBoList);
        queryStaffDetailParam.setStaffYear(staffYear);
        TimeLogger timeLogger = TimeLogger.create();
        timeLogger.start();
        List<StaffDetailBO> staffDetailBOs = this.getStaffDetailById(queryStaffDetailParam);
        timeLogger.check("getStaffDetailById");
        Map<String, Map<String, Object>> stringMapMap = this.queryStaffInfo("haos_useorgdetail", queryDate, staffDetailBOs, 0L);
        timeLogger.check("queryStaffInfo");
        return stringMapMap;
    }

    @Override
    public OccupyStaffResult queryUseAndDutyStaffInfo(Date queryDate, long staffId, Date year) {
        DynamicObject[] useOrgDetails = UseOrgDetailRepository.getInstance().queryUseOrgDetailByStaffId("id, useorg.boid, pid", staffId);
        DynamicObject[] dutyOrgDetails = DutyOrgDetailRepository.getInstance().queryOriginalByStaff("staff.org.id, staffcount, elasticcount, elasticcontrol, controlstrategy, dutyorg.boid", staffId);
        Set dutyOrgBoSet = Arrays.stream(dutyOrgDetails).map(dy -> dy.getLong("dutyorg.boid")).collect(Collectors.toSet());
        Map<Long, Long> useOrgBoVsEntryId = Arrays.stream(useOrgDetails).collect(Collectors.toMap(dy -> dy.getLong("useorg.boid"), dy -> dy.getLong("id"), (o1, o2) -> o2));
        Map<Long, Long> entryIdVsParentEntryId = Arrays.stream(useOrgDetails).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("pid")));
        Map<String, Map<String, Object>> useOrgVsStaffNumMap = this.queryUseStaffInfo(queryDate, Lists.newArrayList(useOrgBoVsEntryId.keySet()), year);
        HashMap<String, Integer> zeroMap = new HashMap<String, Integer>();
        zeroMap.put("staffNum", 0);
        zeroMap.put("holdStaff", 0);
        zeroMap.put("inTranHoldStaff", 0);
        zeroMap.put("inTranReleaseStaff", 0);
        zeroMap.put("entryInTransit", 0);
        zeroMap.put("transferInTransit", 0);
        zeroMap.put("transferOutTransit", 0);
        zeroMap.put("departInTransit", 0);
        zeroMap.put("remainStaffNum", 0);
        Map<Long, DutyOrgTreeDataBo> useOrgBoVsUseOrgDetail = Arrays.stream(useOrgDetails).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> {
            Map stringObjectMap = useOrgVsStaffNumMap.getOrDefault(dy.getString("useorg.boid"), zeroMap);
            DutyOrgTreeDataBo dutyOrgTreeDataBo = new DutyOrgTreeDataBo();
            dutyOrgTreeDataBo.setStaff(stringObjectMap.getOrDefault("staffNum", 0));
            dutyOrgTreeDataBo.setHoldStaff(stringObjectMap.getOrDefault("holdStaff", 0));
            dutyOrgTreeDataBo.setInTranHoldStaff(stringObjectMap.getOrDefault("inTranHoldStaff", 0));
            dutyOrgTreeDataBo.setInTranReleaseStaff(stringObjectMap.getOrDefault("inTranReleaseStaff", 0));
            dutyOrgTreeDataBo.setRemainStaff(stringObjectMap.getOrDefault("remainStaffNum", 0));
            dutyOrgTreeDataBo.setEntryInTransit(stringObjectMap.getOrDefault("entryInTransit", 0));
            dutyOrgTreeDataBo.setTransferInTransit(stringObjectMap.getOrDefault("transferInTransit", 0));
            dutyOrgTreeDataBo.setTransferOutTransit(stringObjectMap.getOrDefault("transferOutTransit", 0));
            dutyOrgTreeDataBo.setDepartInTransit(stringObjectMap.getOrDefault("departInTransit", 0));
            return dutyOrgTreeDataBo;
        }));
        FindSubTree findSubTree = FindSubTree.create(entryIdVsParentEntryId, useOrgBoVsUseOrgDetail);
        Consumer<FindSubNode> visitor = findSubNode -> findSubNode.getChildList().stream().map(Node::getData).forEach(((DutyOrgTreeDataBo)findSubNode.getData())::add);
        findSubTree.setFindSubVisitor(visitor);
        findSubTree.initSub();
        Map<String, Integer> dutyOrgBoVsStaffNum = Arrays.stream(dutyOrgDetails).map(this::buildStaffDetailBo).collect(Collectors.toMap(staffDetailBO -> String.valueOf(staffDetailBO.getDutyOrgId()), StaffDetailBO::getStaffNum));
        Map<String, Map<String, Object>> dutyOrgBoVsStaffNumMap = dutyOrgBoSet.stream().collect(Collectors.toMap(String::valueOf, bo -> {
            DutyOrgTreeDataBo dutyOrgTreeDataBo = (DutyOrgTreeDataBo)findSubTree.get(((Long)useOrgBoVsEntryId.get(bo)).longValue());
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            int dutyOrgStaff = (Integer)dutyOrgBoVsStaffNum.get(String.valueOf(bo));
            result.put("staffNum", dutyOrgStaff);
            result.put("holdStaff", dutyOrgTreeDataBo.getHoldStaff());
            result.put("inTranHoldStaff", dutyOrgTreeDataBo.getInTranHoldStaff());
            result.put("inTranReleaseStaff", dutyOrgTreeDataBo.getInTranReleaseStaff());
            result.put("entryInTransit", dutyOrgTreeDataBo.getEntryInTransit());
            result.put("transferInTransit", dutyOrgTreeDataBo.getTransferInTransit());
            result.put("transferOutTransit", dutyOrgTreeDataBo.getTransferOutTransit());
            result.put("departInTransit", dutyOrgTreeDataBo.getDepartInTransit());
            result.put("remainStaffNum", dutyOrgStaff - dutyOrgTreeDataBo.getHoldStaff() - dutyOrgTreeDataBo.getInTranHoldStaff() - dutyOrgTreeDataBo.getInTranReleaseStaff());
            return result;
        }));
        OccupyStaffResult occupyStaffResult = new OccupyStaffResult();
        occupyStaffResult.setDutyOrgMap(dutyOrgBoVsStaffNumMap);
        occupyStaffResult.setUseOrgMap(useOrgVsStaffNumMap);
        return occupyStaffResult;
    }

    private StaffDetailBO buildStaffDetailBo(DynamicObject dy) {
        StaffDetailBO staffDetailBO = new StaffDetailBO();
        staffDetailBO.setOrgId(dy.getLong("staff.org.id"));
        staffDetailBO.setElasticControl(dy.getString("elasticcontrol"));
        staffDetailBO.setElasticCount(dy.getInt("elasticcount"));
        staffDetailBO.setControlStrategy(dy.getString("controlstrategy"));
        staffDetailBO.buildStrategySpringValue(dy.getInt("staffcount"));
        staffDetailBO.setDutyOrgId(dy.getLong("dutyorg.boid"));
        return staffDetailBO;
    }

    private List<StaffDetailBO> getStaffDetailById(QueryStaffDetailParam queryStaffDetailParam) {
        return this.getStaffDetailByOrgId(queryStaffDetailParam);
    }

    @Override
    public Map<String, StaffDetailBO> queryPositionStaffInfo() {
        List<StaffDetailBO> staffDetailBOs = this.checkAndGetDetail("haos_muldimendetail");
        return this.queryStaffInfo("haos_muldimendetail", staffDetailBOs, 1010L);
    }

    private List<StaffDetailBO> checkAndGetDetail(String entityName) {
        if (CollectionUtils.isEmpty(this.staffQueryInParams)) {
            return null;
        }
        StaffDimensionConfig staffDimensionConfig = this.dimensionConfigMap.get(entityName);
        List<StaffDimenPropertyBO> staffDimenPropertyBOs = staffDimensionConfig.getStaffDimenPropertyBOs();
        ArrayList staffDetailParams = Lists.newArrayListWithExpectedSize((int)16);
        for (StaffQueryInParam staffQueryInParam : this.staffQueryInParams) {
            boolean addFlag = true;
            for (StaffDimenPropertyBO propertyBO : staffDimenPropertyBOs) {
                Long propertyValue = propertyBO.getPropertyValueFunction().apply(staffQueryInParam);
                if (propertyValue != null && propertyValue != 0L) continue;
                addFlag = false;
                break;
            }
            if (!addFlag) continue;
            this.buildStaffDetailParam(staffQueryInParam, staffDetailParams, staffDimensionConfig);
        }
        if (CollectionUtils.isEmpty((Collection)staffDetailParams)) {
            return null;
        }
        return this.getStaffDetailById(entityName, staffDetailParams);
    }

    @Override
    public Map<String, Map<String, Object>> queryPositionStaffInfo(Date queryDate, List<Long> positionIds) {
        if (CollectionUtils.isEmpty(positionIds)) {
            return null;
        }
        if (queryDate == null) {
            queryDate = new Date();
        }
        QueryStaffDetailParam queryStaffDetailParam = new QueryStaffDetailParam();
        queryStaffDetailParam.setEntityName("haos_muldimendetail");
        queryStaffDetailParam.setRelDate(queryDate);
        queryStaffDetailParam.setStaffYear(queryDate);
        queryStaffDetailParam.setEntryBoList(positionIds);
        List<StaffDetailBO> staffDetailBOs = this.getStaffDetailById(queryStaffDetailParam);
        return this.queryStaffInfo("haos_muldimendetail1", queryDate, staffDetailBOs, 1010L);
    }

    @Override
    public Map<String, StaffDetailBO> queryJobStaffInfo() {
        List<StaffDetailBO> staffDetailBOs = this.checkAndGetDetail("haos_muldimendetail2");
        return this.queryStaffInfo("haos_muldimendetail2", staffDetailBOs, 1020L);
    }

    @Override
    public Map<String, StaffDetailBO> queryLaborRelTypeStaffInfo() {
        List<StaffDetailBO> staffDetailBOs = this.checkAndGetDetail("haos_muldimendetail3");
        return this.queryStaffInfo("haos_muldimendetail3", staffDetailBOs, 1050L);
    }

    @Override
    public Map<String, StaffDetailBO> queryLaborFirstDimensionStaffInfo() {
        List<StaffDetailBO> staffDetailBOs = this.checkAndGetDetail("haos_muldimendetail4");
        DynamicObject basicdata1 = StaffDimensionRepository.getInstance().getDimensionByIdentify("basicdata1");
        return this.queryStaffInfo("haos_muldimendetail4", staffDetailBOs, basicdata1.getLong("id"));
    }

    @Override
    public Map<String, StaffDetailBO> queryLaborSecondDimensionStaffInfo() {
        List<StaffDetailBO> staffDetailBOs = this.checkAndGetDetail("haos_muldimendetail5");
        DynamicObject basicdata1 = StaffDimensionRepository.getInstance().getDimensionByIdentify("basicdata2");
        return this.queryStaffInfo("haos_muldimendetail5", staffDetailBOs, basicdata1.getLong("id"));
    }

    @Override
    public Map<String, StaffDetailBO> queryLaborThirdDimensionStaffInfo() {
        List<StaffDetailBO> staffDetailBOs = this.checkAndGetDetail("haos_muldimendetail6");
        DynamicObject basicdata1 = StaffDimensionRepository.getInstance().getDimensionByIdentify("basicdata3");
        return this.queryStaffInfo("haos_muldimendetail6", staffDetailBOs, basicdata1.getLong("id"));
    }

    @Override
    public Map<String, StaffDetailBO> queryLaborFourthDimensionStaffInfo() {
        List<StaffDetailBO> staffDetailBOs = this.checkAndGetDetail("haos_muldimendetail7");
        DynamicObject basicdata1 = StaffDimensionRepository.getInstance().getDimensionByIdentify("basicdata4");
        return this.queryStaffInfo("haos_muldimendetail7", staffDetailBOs, basicdata1.getLong("id"));
    }

    @Override
    public Map<String, StaffDetailBO> queryLaborFifthDimensionStaffInfo() {
        List<StaffDetailBO> staffDetailBOs = this.checkAndGetDetail("haos_muldimendetail8");
        DynamicObject basicdata1 = StaffDimensionRepository.getInstance().getDimensionByIdentify("basicdata5");
        return this.queryStaffInfo("haos_muldimendetail8", staffDetailBOs, basicdata1.getLong("id"));
    }

    private void buildStaffDetailParam(StaffQueryInParam staffQueryInParam, List<QueryStaffDetailParam> staffDetailParams, StaffDimensionConfig staffDimensionConfig) {
        List<StaffDimenPropertyBO> propertyBOS = staffDimensionConfig.getStaffDimenPropertyBOs();
        Date queryDate = staffQueryInParam.getEffDate();
        boolean addFlag = true;
        for (QueryStaffDetailParam queryStaffDetailParam : staffDetailParams) {
            if (!queryDate.after(queryStaffDetailParam.getMinDate()) || !queryDate.before(queryStaffDetailParam.getMaxDate())) continue;
            List<StaffDimenPropertyBO> dimenPropertyBOCopy = queryStaffDetailParam.getStaffDimenPropertyBOs();
            for (StaffDimenPropertyBO staffDimenPropertyBO : dimenPropertyBOCopy) {
                staffDimenPropertyBO.addKeyFieldId(staffDimenPropertyBO.getPropertyValueFunction().apply(staffQueryInParam));
            }
            addFlag = false;
            break;
        }
        if (staffDetailParams.size() == 0 || addFlag) {
            ArrayList dimenPropertyBOCopy = Lists.newArrayListWithExpectedSize((int)propertyBOS.size());
            propertyBOS.forEach(propertyBOs -> dimenPropertyBOCopy.add(new StaffDimenPropertyBO(propertyBOs.getPropertyName(), propertyBOs.getPropertyValueFunction())));
            for (StaffDimenPropertyBO staffDimenPropertyBO : dimenPropertyBOCopy) {
                staffDimenPropertyBO.addKeyFieldId(staffDimenPropertyBO.getPropertyValueFunction().apply(staffQueryInParam));
            }
            QueryStaffDetailParam queryStaffDetailParam = new QueryStaffDetailParam(queryDate);
            queryStaffDetailParam.setEntityName(staffDimensionConfig.getEntityName());
            queryStaffDetailParam.setStaffDimenPropertyBOs(dimenPropertyBOCopy);
            queryStaffDetailParam.setKeyFieldIdPropName(staffDimensionConfig.getKeyFieldIdPropName());
            queryStaffDetailParam.setKeyFieldNamePropName(staffDimensionConfig.getKeyFieldNamePropName());
            staffDetailParams.add(queryStaffDetailParam);
        }
    }

    private Map<String, Map<String, Object>> queryStaffInfo(String entityName, Date queryDate, List<StaffDetailBO> staffDetailBOs, long dimensionId) {
        DynamicObject[] changeEventDynArr;
        List<Long> orgUseInfoIdList;
        DynamicObject[] occupyStaffInfoArr;
        if (CollectionUtils.isEmpty(staffDetailBOs)) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        Set<Long> boIdSet = staffDetailBOs.stream().map(StaffDetailBO::getBoId).collect(Collectors.toSet());
        String selectFields = "bo, stafftype, orgusestaffdetail, personstaffinfo, effdt, leffdt";
        Map<Object, Object> occupyStaffInfoIdVsChangeEventNumMap = Maps.newHashMapWithExpectedSize((int)16);
        if ("haos_useorgdetail".equals(entityName)) {
            occupyStaffInfoArr = this.useStaffDetailRepository.queryOccupyUseStaffInfoByBOId(selectFields, queryDate, boIdSet);
            orgUseInfoIdList = Arrays.stream(occupyStaffInfoArr).map(info -> info.getLong("id")).collect(Collectors.toList());
            changeEventDynArr = PersonChangeEventRepository.getInstance().queryByUId(orgUseInfoIdList);
            occupyStaffInfoIdVsChangeEventNumMap = Arrays.stream(changeEventDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("orgusestaffdetail.id"), dyn -> dyn.getString("changeevent.number")));
        } else {
            occupyStaffInfoArr = this.muldimUseStaffRepository.queryOccupyDimenInfoByBOId(selectFields, queryDate, boIdSet);
            orgUseInfoIdList = Arrays.stream(occupyStaffInfoArr).map(info -> info.getLong("orgusestaffdetail.id")).collect(Collectors.toList());
            changeEventDynArr = PersonChangeEventRepository.getInstance().queryByUId(orgUseInfoIdList);
            Map<Long, String> orgUseInfoIdVsChangeEventIdMap = Arrays.stream(changeEventDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("orgusestaffdetail.id"), dyn -> dyn.getString("changeevent.number")));
            for (DynamicObject occupyStaffInfo : occupyStaffInfoArr) {
                long orgUseInfoId = occupyStaffInfo.getLong("orgusestaffdetail.id");
                String changeEventNum = orgUseInfoIdVsChangeEventIdMap.get(orgUseInfoId);
                occupyStaffInfoIdVsChangeEventNumMap.put(occupyStaffInfo.getLong("id"), changeEventNum);
            }
        }
        List<DynamicObject> occupyStaffInfoList = this.filterStaffCase(queryDate, occupyStaffInfoArr);
        Map<Long, List<DynamicObject>> useStaffInfoMap = occupyStaffInfoList.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("bo")));
        return this.buildStaffOccupyResultMap(staffDetailBOs, useStaffInfoMap, dimensionId, (Map<Long, String>)occupyStaffInfoIdVsChangeEventNumMap);
    }

    private List<DynamicObject> filterStaffCase(Date queryDate, DynamicObject[] occupyStaffInfoArr) {
        if (Objects.isNull(queryDate)) {
            return Arrays.stream(occupyStaffInfoArr).collect(Collectors.toList());
        }
        DynamicObject[] staffCaseDyns = StaffCaseRepository.getInstance().queryAllEnableAndAuditDynsByDate(queryDate);
        List staffCaseDynList = Arrays.stream(staffCaseDyns).filter(dyn -> dyn.getDate("bsled") == null || this.isContainsDate(queryDate, dyn.getDate("bsed"), dyn.getDate("bsled"))).collect(Collectors.toList());
        List personIdList = staffCaseDynList.stream().map(dyn -> dyn.getLong("person.id")).collect(Collectors.toList());
        List<Long> personStaffInfoId = Arrays.stream(occupyStaffInfoArr).map(occupyStaffInfo -> occupyStaffInfo.getLong("personstaffinfo.id")).collect(Collectors.toList());
        DynamicObject[] personStaffInfoDyns = this.personStaffInfoRepository.queryById(personStaffInfoId);
        Map<Long, Long> personStaffInfoIdVsPersonIdMap = Arrays.stream(personStaffInfoDyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("person.id")));
        List<DynamicObject> occupyStaffInfoList = Arrays.stream(occupyStaffInfoArr).filter(occupyStaffInfo -> {
            Long personId = (Long)personStaffInfoIdVsPersonIdMap.get(occupyStaffInfo.getLong("personstaffinfo.id"));
            return !personIdList.contains(personId);
        }).collect(Collectors.toList());
        return occupyStaffInfoList;
    }

    private boolean isContainsDate(Date targetDate, Date startDate, Date endDate) {
        return !HRDateTimeUtils.dayAfter((Date)targetDate, (Date)endDate) && !HRDateTimeUtils.dayBefore((Date)targetDate, (Date)startDate);
    }

    private Map<String, StaffDetailBO> queryStaffInfo(String entityName, List<StaffDetailBO> staffDetailBOList, long dimensionId) {
        DynamicObject[] changeEventDynArr;
        List<Long> orgUseInfoIdList;
        DynamicObject[] occupyStaffInfoArr;
        if (staffDetailBOList == null || staffDetailBOList.size() == 0) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        Set<Long> boIdSet = staffDetailBOList.stream().map(StaffDetailBO::getBoId).collect(Collectors.toSet());
        Set queryDateSet = this.staffQueryInParams.stream().map(StaffQueryInParam::getEffDate).collect(Collectors.toSet());
        Date queryDate = null;
        if (queryDateSet.size() == 1) {
            queryDate = (Date)queryDateSet.iterator().next();
        }
        Map<Object, Object> occupyStaffInfoIdVsChangeEventNumMap = Maps.newHashMapWithExpectedSize((int)16);
        if ("haos_useorgdetail".equals(entityName)) {
            occupyStaffInfoArr = this.useStaffDetailRepository.queryOccupyUseStaffInfoByBOId("bo, stafftype, personstaffinfo, effdt, leffdt", queryDate, boIdSet);
            orgUseInfoIdList = Arrays.stream(occupyStaffInfoArr).map(info -> info.getLong("id")).collect(Collectors.toList());
            changeEventDynArr = PersonChangeEventRepository.getInstance().queryByUId(orgUseInfoIdList);
            occupyStaffInfoIdVsChangeEventNumMap = Arrays.stream(changeEventDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("orgusestaffdetail.id"), dyn -> dyn.getString("changeevent.number")));
        } else {
            occupyStaffInfoArr = this.muldimUseStaffRepository.queryOccupyDimenInfoByBOId("bo, stafftype, personstaffinfo, effdt, leffdt,orgusestaffdetail", queryDate, boIdSet);
            orgUseInfoIdList = Arrays.stream(occupyStaffInfoArr).map(info -> info.getLong("orgusestaffdetail.id")).collect(Collectors.toList());
            changeEventDynArr = PersonChangeEventRepository.getInstance().queryByUId(orgUseInfoIdList);
            Map<Long, String> orgUseInfoIdVsChangeEventIdMap = Arrays.stream(changeEventDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("orgusestaffdetail.id"), dyn -> dyn.getString("changeevent.number")));
            for (DynamicObject occupyStaffInfo : occupyStaffInfoArr) {
                long orgUseInfoId = occupyStaffInfo.getLong("orgusestaffdetail.id");
                String changeEventNum = orgUseInfoIdVsChangeEventIdMap.get(orgUseInfoId);
                occupyStaffInfoIdVsChangeEventNumMap.put(occupyStaffInfo.getLong("id"), changeEventNum);
            }
        }
        List<DynamicObject> occupyStaffInfoList = this.filterStaffCase(queryDate, occupyStaffInfoArr);
        Map<Long, List<DynamicObject>> useStaffInfoMap = occupyStaffInfoList.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("bo")));
        return this.buildStaffDetailMap(staffDetailBOList, useStaffInfoMap, dimensionId, (Map<Long, String>)occupyStaffInfoIdVsChangeEventNumMap);
    }

    private Map<String, Map<String, Object>> buildStaffOccupyResultMap(List<StaffDetailBO> staffDetailBOs, Map<Long, List<DynamicObject>> staffOccupyInfoMap, long dimensionId, Map<Long, String> occupyStaffInfoIdVsChangeEventNumMap) {
        HashMap staffOccupyResultMap = Maps.newHashMapWithExpectedSize((int)16);
        staffDetailBOs.forEach(staffDetailBO -> {
            long boId = staffDetailBO.getBoId();
            boolean effectOccupation = (Boolean)StaffCommonService.getSystemParamBooleanValue(staffDetailBO.getOrgId(), "effectoccupation", Boolean.TRUE);
            boolean effectRelease = (Boolean)StaffCommonService.getSystemParamBooleanValue(staffDetailBO.getOrgId(), "effectrelease", Boolean.TRUE);
            boolean mobilizeOccuOrRelease = (Boolean)StaffCommonService.getSystemParamBooleanValue(staffDetailBO.getOrgId(), "mobilizeoccuorrelease", Boolean.TRUE);
            HashMap staffPropertyInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            if (staffDetailBO.getStaffNum() == null) {
                staffDetailBO.setStaffNum(0);
            }
            staffDetailBO.buildStrategySpringValue(staffDetailBO.getStaffNum());
            int result = staffDetailBO.getStaffNum();
            staffPropertyInfoMap.put("remainStaffNum", result);
            staffPropertyInfoMap.put("staffNum", result);
            int entryInTransit = 0;
            int transferInTransit = 0;
            int transferOutTransit = 0;
            int departInTransit = 0;
            int inTransitRelease = 0;
            int inTransitOccupy = 0;
            staffPropertyInfoMap.put("entryInTransit", entryInTransit);
            staffPropertyInfoMap.put("transferInTransit", transferInTransit);
            staffPropertyInfoMap.put("transferOutTransit", transferOutTransit);
            staffPropertyInfoMap.put("departInTransit", departInTransit);
            List useStaffInfos = (List)staffOccupyInfoMap.get(boId);
            if (!CollectionUtils.isEmpty((Collection)useStaffInfos)) {
                List<DynamicObject> inTransitFree;
                List<DynamicObject> inTransitHold;
                Map<String, List<DynamicObject>> staffOccupyTypeMap = useStaffInfos.stream().collect(Collectors.groupingBy(dyn -> dyn.getString("stafftype")));
                List<DynamicObject> holdStaffList = staffOccupyTypeMap.get("1");
                staffPropertyInfoMap.put("holdStaff", CollectionUtils.isEmpty(holdStaffList) ? 0 : holdStaffList.size());
                if (!CollectionUtils.isEmpty(holdStaffList)) {
                    result -= holdStaffList.size();
                }
                if (!CollectionUtils.isEmpty(inTransitHold = staffOccupyTypeMap.get("2"))) {
                    List inTransitHoldForEntry = inTransitHold.stream().filter(in -> HRStringUtils.equals((String)"1010_S", (String)((String)occupyStaffInfoIdVsChangeEventNumMap.get(in.getLong("id"))))).collect(Collectors.toList());
                    if (effectOccupation && !CollectionUtils.isEmpty(inTransitHoldForEntry)) {
                        result -= inTransitHoldForEntry.size();
                        inTransitOccupy += inTransitHoldForEntry.size();
                        staffPropertyInfoMap.put("entryInTransit", inTransitHoldForEntry.size());
                    }
                    List inTransitHoldForIn = inTransitHold.stream().filter(in -> HRStringUtils.equals((String)"1050_S", (String)((String)occupyStaffInfoIdVsChangeEventNumMap.get(in.getLong("id"))))).collect(Collectors.toList());
                    if (mobilizeOccuOrRelease && !CollectionUtils.isEmpty(inTransitHoldForIn)) {
                        result -= inTransitHoldForIn.size();
                        inTransitOccupy += inTransitHoldForIn.size();
                        staffPropertyInfoMap.put("transferInTransit", inTransitHoldForIn.size());
                    }
                }
                if (!CollectionUtils.isEmpty(inTransitFree = staffOccupyTypeMap.get("4"))) {
                    List inTransitFreeForDepart;
                    List inTransitFreeForOut;
                    if (!mobilizeOccuOrRelease && !CollectionUtils.isEmpty(inTransitFreeForOut = inTransitFree.stream().filter(in -> HRStringUtils.equals((String)"1070_S", (String)((String)occupyStaffInfoIdVsChangeEventNumMap.get(in.getLong("id"))))).collect(Collectors.toList()))) {
                        result -= inTransitFreeForOut.size();
                        inTransitRelease += inTransitFreeForOut.size();
                        staffPropertyInfoMap.put("transferOutTransit", inTransitFreeForOut.size());
                    }
                    if (!effectRelease && !CollectionUtils.isEmpty(inTransitFreeForDepart = inTransitFree.stream().filter(in -> HRStringUtils.equals((String)"1030_S", (String)((String)occupyStaffInfoIdVsChangeEventNumMap.get(in.getLong("id"))))).collect(Collectors.toList()))) {
                        result -= inTransitFreeForDepart.size();
                        inTransitRelease += inTransitFreeForDepart.size();
                        staffPropertyInfoMap.put("departInTransit", inTransitFreeForDepart.size());
                    }
                }
                staffPropertyInfoMap.put("inTranHoldStaff", inTransitOccupy);
                staffPropertyInfoMap.put("inTranReleaseStaff", inTransitRelease);
                staffPropertyInfoMap.put("remainStaffNum", result);
            }
            String key = this.getOccupyKey(dimensionId, (StaffDetailBO)staffDetailBO);
            staffOccupyResultMap.put(key, staffPropertyInfoMap);
        });
        return staffOccupyResultMap;
    }

    private Map<String, StaffDetailBO> buildStaffDetailMap(List<StaffDetailBO> staffDetailBOList, Map<Long, List<DynamicObject>> staffOccupyInfoMap, long dimensionId, Map<Long, String> occupyStaffInfoIdVsChangeEventNumMap) {
        HashMap staffOccupyResultMap = Maps.newHashMapWithExpectedSize((int)staffDetailBOList.size());
        for (StaffDetailBO staffDetailBO : staffDetailBOList) {
            long boId = staffDetailBO.getBoId();
            int year = TimeConvertUtil.getYear(staffDetailBO.getYear());
            String occupyKey = this.getOccupyKey(dimensionId, staffDetailBO);
            staffOccupyResultMap.put(year + "-" + occupyKey, staffDetailBO);
            List<DynamicObject> useStaffList = staffOccupyInfoMap.get(boId);
            if (useStaffList == null) continue;
            this.filterUsestaff(useStaffList, staffDetailBO.getOrgId(), occupyStaffInfoIdVsChangeEventNumMap);
            staffDetailBO.setUseStaffList(useStaffList);
        }
        return staffOccupyResultMap;
    }

    @Override
    public void filterUsestaff(List<DynamicObject> useStaffList, long buId, Map<Long, String> occupyStaffInfoIdVsChangeEventNumMap) {
        if (CollectionUtils.isEmpty(useStaffList)) {
            return;
        }
        boolean effectOccupation = (Boolean)StaffCommonService.getSystemParamBooleanValue(buId, "effectoccupation", Boolean.TRUE);
        boolean effectRelease = (Boolean)StaffCommonService.getSystemParamBooleanValue(buId, "effectrelease", Boolean.TRUE);
        boolean mobilizeOccuOrRelease = (Boolean)StaffCommonService.getSystemParamBooleanValue(buId, "mobilizeoccuorrelease", Boolean.TRUE);
        ArrayList<DynamicObject> invalidList = new ArrayList<DynamicObject>();
        for (DynamicObject usestaff : useStaffList) {
            long id = usestaff.getLong("id");
            String changeeventnumber = occupyStaffInfoIdVsChangeEventNumMap.get(id);
            if (HRStringUtils.equals((String)changeeventnumber, (String)"1010_S") && !effectOccupation) {
                invalidList.add(usestaff);
                continue;
            }
            if (HRStringUtils.equals((String)changeeventnumber, (String)"1030_S") && effectRelease) {
                invalidList.add(usestaff);
                continue;
            }
            if (HRStringUtils.equals((String)changeeventnumber, (String)"1050_S") && !mobilizeOccuOrRelease) {
                invalidList.add(usestaff);
                continue;
            }
            if (!HRStringUtils.equals((String)changeeventnumber, (String)"1070_S") || !mobilizeOccuOrRelease) continue;
            invalidList.add(usestaff);
        }
        useStaffList.removeAll(invalidList);
    }

    private String getOccupyKey(long dimensionId, StaffDetailBO staffDetailBO) {
        String key;
        Long dimensionBoId = staffDetailBO.getDimensionBOId();
        if (dimensionId == 0L || 1010L == dimensionId) {
            key = String.valueOf(dimensionBoId);
        } else {
            Long useOrgBoId = staffDetailBO.getUseOrgBOId();
            key = useOrgBoId + "-" + dimensionBoId;
        }
        return key;
    }

    private List<StaffDetailBO> getStaffDetailByOrgId(QueryStaffDetailParam queryStaffDetailParam) {
        String entityName = queryStaffDetailParam.getEntityName();
        ArrayList staffDetailList = Lists.newArrayListWithExpectedSize((int)16);
        Map<String, Object> result = this.commonFunctionMap.get(entityName).apply(queryStaffDetailParam);
        try (DataSet dataSet = HRDBUtil.queryDataSet((String)"haos_useStaffSearch", (DBRoute)new DBRoute("haos"), (String)result.get(QUERY_SQL).toString(), (Object[])((Object[])result.get(QUERY_PARAM)));){
            for (Row row : dataSet) {
                StaffDetailBO staffDetailBO = new StaffDetailBO();
                staffDetailBO.setStaffNum(row.getInteger("staffNum"));
                staffDetailBO.setControlStrategy(row.getString("controlstrategy"));
                staffDetailBO.setElasticControl(row.getString("elasticcontrol"));
                staffDetailBO.setElasticCount(row.getInteger("elasticcount"));
                staffDetailBO.setDimensionBOId(row.getLong("diemsionboid"));
                staffDetailBO.setOrgId(row.getLong("org"));
                staffDetailBO.setStaffProjectId(row.getLong("staffproject"));
                staffDetailBO.setEffdt(row.getDate("effdt"));
                staffDetailBO.setLeffdt(row.getDate("leffdt"));
                staffDetailBO.setBoId(row.getLong("bo"));
                staffDetailBO.setId(row.getLong("id"));
                staffDetailList.add(staffDetailBO);
            }
        }
        return staffDetailList;
    }

    private List<StaffDetailBO> getStaffDetailById(String entityName, List<QueryStaffDetailParam> staffDetailParams) {
        ArrayList staffDetailBOList = Lists.newArrayListWithExpectedSize((int)16);
        for (QueryStaffDetailParam staffDetailParam : staffDetailParams) {
            DynamicObject[] staffDetailArr;
            for (DynamicObject staffDetail : staffDetailArr = this.functionMap.get(entityName).apply(staffDetailParam)) {
                StaffDetailBO staffDetailBO = new StaffDetailBO();
                staffDetailBO.setYear(staffDetail.getDate("staff.year"));
                staffDetailBO.setId(staffDetail.getLong("id"));
                staffDetailBO.setDimensionBOId(staffDetail.getLong(staffDetailParam.getKeyFieldIdPropName()));
                if (!"haos_useorgdetail".equals(entityName)) {
                    staffDetailBO.setDimensionName(staffDetail.getString(staffDetailParam.getKeyFieldNamePropName()));
                }
                staffDetailBO.setBoId(staffDetail.getLong("bo"));
                staffDetailBO.setOrgId(staffDetail.getLong("staff.org.id"));
                staffDetailBO.setUseOrgBOId(staffDetail.getLong("useorg.boid"));
                if ("haos_useorgdetail".equals(entityName)) {
                    staffDetailBO.setDutyOrgId(staffDetail.getLong("dutyorg.id"));
                }
                staffDetailBO.setStaffId(staffDetail.getLong("staff.id"));
                staffDetailBO.setStaffProjectId(staffDetail.getLong("staff.staffproject.id"));
                staffDetailBO.setStaffCycleId(staffDetail.getLong("staff.staffcycle.id"));
                staffDetailBO.setEffdt(staffDetail.getDate("effdt"));
                staffDetailBO.setLeffdt(staffDetail.getDate("leffdt"));
                staffDetailBO.setControlStrategy(staffDetail.getString("controlstrategy"));
                staffDetailBO.setElasticControl(staffDetail.getString("elasticcontrol"));
                staffDetailBO.setElasticCount(staffDetail.getInt("elasticcount"));
                staffDetailBO.setYearStaff(staffDetailBO.box(staffDetail.get("yearstaff")));
                staffDetailBO.setMonth1(staffDetailBO.box(staffDetail.get("monthstaff1")));
                staffDetailBO.setMonth2(staffDetailBO.box(staffDetail.get("monthstaff2")));
                staffDetailBO.setMonth3(staffDetailBO.box(staffDetail.get("monthstaff3")));
                staffDetailBO.setMonth4(staffDetailBO.box(staffDetail.get("monthstaff4")));
                staffDetailBO.setMonth5(staffDetailBO.box(staffDetail.get("monthstaff5")));
                staffDetailBO.setMonth6(staffDetailBO.box(staffDetail.get("monthstaff6")));
                staffDetailBO.setMonth7(staffDetailBO.box(staffDetail.get("monthstaff7")));
                staffDetailBO.setMonth8(staffDetailBO.box(staffDetail.get("monthstaff8")));
                staffDetailBO.setMonth9(staffDetailBO.box(staffDetail.get("monthstaff9")));
                staffDetailBO.setMonth10(staffDetailBO.box(staffDetail.get("monthstaff10")));
                staffDetailBO.setMonth11(staffDetailBO.box(staffDetail.get("monthstaff11")));
                staffDetailBO.setMonth12(staffDetailBO.box(staffDetail.get("monthstaff12")));
                staffDetailBOList.add(staffDetailBO);
            }
        }
        return staffDetailBOList;
    }

    private Map<String, Object> getSingleDimensionSqlAndParam(QueryStaffDetailParam queryStaffDetailParam) {
        Date searchDate = queryStaffDetailParam.getRelDate();
        String entityName = queryStaffDetailParam.getEntityName();
        List<Long> useOrgIds = queryStaffDetailParam.getEntryBoList();
        Object[] param = new Object[]{TimeConvertUtil.getMinDate(queryStaffDetailParam.getStaffYear()), TimeConvertUtil.getMaxDate(queryStaffDetailParam.getStaffYear())};
        StringBuilder sql = "haos_useorgdetail".equals(entityName) ? this.getUseOrgSql(searchDate) : this.getPositionSql(searchDate);
        int size = useOrgIds.size();
        Object[] paramFinal = Arrays.copyOf(param, param.length + size);
        for (int i = 0; i < size; ++i) {
            sql.append("?,");
            paramFinal[param.length + i] = useOrgIds.get(i);
        }
        sql.deleteCharAt(sql.length() - 1).append(")");
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        result.put(QUERY_SQL, sql);
        result.put(QUERY_PARAM, paramFinal);
        return result;
    }

    private StringBuilder getUseOrgSql(Date searchDate) {
        int month = HRDateTimeUtils.getMonth((Date)searchDate);
        return new StringBuilder("SELECT t.fentryid as id, s.forgid as org, t.fuseorgboid as diemsionboid, CASE WHEN s.fstaffcycleid = 1010 THEN t.fmonthstaff").append(month).append(" ELSE fyearstaff END AS staffNum, t.fcontrolstrategy as controlstrategy, t.felasticcontrol as elasticcontrol,").append(" t.felasticcount as elasticcount, s.fstaffprojectid as staffproject, t.feffdt as effdt, t.fleffdt as leffdt, t.fboid as bo").append(" FROM t_haos_useorgdetail t LEFT JOIN t_haos_staff s ON t.fid = s.fid").append(" WHERE t.fdatastatus in ('1') AND t.fenable = '1'").append(" AND s.fenable = '1' AND s.fyear >= ? AND s.fyear <= ? AND ").append("t.fuseorgboid in(");
    }

    private StringBuilder getPositionSql(Date searchDate) {
        int month = HRDateTimeUtils.getMonth((Date)searchDate);
        return new StringBuilder("SELECT t.fentryid as id, s.forgid as org, t.fdutyworkroleid as diemsionboid,").append(" t.fuseorgid as useorgboid, CASE WHEN s.fstaffcycleid = 1010 THEN t.fmonthstaff").append(month).append(" ELSE fyearstaff END AS staffNum, t.fcontrolstrategy as controlstrategy, t.felasticcontrol as elasticcontrol,").append(" t.felasticcount as elasticcount, s.fstaffprojectid as staffproject, t.feffdt as effdt, t.fleffdt as leffdt,").append(" t.fboid as bo").append(" FROM t_haos_muldimendetail t LEFT JOIN t_haos_staff s ON t.fid = s.fid").append(" WHERE t.fdatastatus in ('1') AND t.fenable = '1'").append(" AND s.fenable = '1' AND s.fyear >= ? AND s.fyear <= ? AND ").append("t.fdutyworkroleid in(");
    }

    private DynamicObject[] getUseOrgDetailArr(QueryStaffDetailParam staffDetailParam) {
        List<StaffDimenPropertyBO> staffDimenPropertyBOs = staffDetailParam.getStaffDimenPropertyBOs();
        QFilter filter = this.getCommonFilter(staffDetailParam);
        staffDimenPropertyBOs.forEach(propertyBO -> filter.and(propertyBO.getPropertyName(), "in", propertyBO.getPropertyIds()));
        return this.useOrgDetailRepository.loadUseOrgDetailByFilter(filter);
    }

    private DynamicObject[] getDimensionDetailArr(QueryStaffDetailParam staffDetailParam) {
        List<StaffDimenPropertyBO> staffDimenPropertyBOs = staffDetailParam.getStaffDimenPropertyBOs();
        QFilter filter = this.getCommonFilter(staffDetailParam);
        staffDimenPropertyBOs.forEach(propertyBO -> filter.and(propertyBO.getPropertyName(), "in", propertyBO.getPropertyIds()));
        return this.muldimDetailRepository.loadDimensionDetailByFilter(filter);
    }

    private QFilter getCommonFilter(QueryStaffDetailParam staffDetailParam) {
        Date currentDate = new Date();
        QFilter filter = new QFilter("staff.year", ">=", (Object)staffDetailParam.getMinDate());
        filter.and("staff.year", "<=", (Object)staffDetailParam.getMaxDate());
        filter.and("staff.enable", "=", (Object)"1");
        filter.and("effdt", "<=", (Object)currentDate);
        filter.and("leffdt", ">=", (Object)currentDate);
        return filter;
    }

    private List<DynamicObject> getDynamicDimensionDbFieldName() {
        DynamicObject[] dynamicObjects = StaffDimensionRepository.getInstance().listAllDimension();
        return Arrays.asList(dynamicObjects);
    }

    private void setDynamicDimensionDetailArr(String dimensionIdentify) {
        this.functionMap.put(this.getDimensionPageIdByMark(dimensionIdentify), this::getDimensionDetailArr);
    }

    private void dynamicDimensionConfigMapInit(StaffDimenPropertyBO useOrgPropertyBO) {
        List<DynamicObject> dynamicDimensionDbFieldName = this.getDynamicDimensionDbFieldName();
        for (DynamicObject dynamicDimension : dynamicDimensionDbFieldName) {
            String staffdimensionIdentify = dynamicDimension.getString("staffdimension");
            long dimensionId = dynamicDimension.getLong("id");
            ArrayList dimensionList = Lists.newArrayListWithExpectedSize((int)16);
            StaffDimenPropertyBO dimensionBO = new StaffDimenPropertyBO(staffdimensionIdentify, this.getStaffQueryInParamOtherField(staffdimensionIdentify));
            dimensionList.add(useOrgPropertyBO);
            dimensionList.add(dimensionBO);
            StaffDimensionConfig dimensionConfig = new StaffDimensionConfig(this.getDimensionPageIdByMark(staffdimensionIdentify), this.appendIdSuffix(staffdimensionIdentify), this.appendNameSuffix(staffdimensionIdentify), dimensionList, dimensionId);
            this.dimensionConfigMap.put(this.getDimensionPageIdByMark(staffdimensionIdentify), dimensionConfig);
            this.setDynamicDimensionDetailArr(staffdimensionIdentify);
        }
    }

    private Function<StaffQueryInParam, Long> getStaffQueryInParamOtherField(String mark) {
        return temp -> {
            Map other = temp.getOther();
            if (other == null || other.isEmpty()) {
                logger.info("getStaffQueryInParamOtherField is null StaffQueryInParam:{}", (Object)temp.toString());
                return 0L;
            }
            Long dimensionValue = other.getOrDefault(mark, 0L);
            return dimensionValue;
        };
    }

    private String getDimensionPageIdByMark(String mark) {
        switch (mark) {
            case "basicdata1": {
                return "haos_muldimendetail4";
            }
            case "basicdata2": {
                return "haos_muldimendetail5";
            }
            case "basicdata3": {
                return "haos_muldimendetail6";
            }
            case "basicdata4": {
                return "haos_muldimendetail7";
            }
            case "basicdata5": {
                return "haos_muldimendetail8";
            }
        }
        throw new KDBizException("DynamicDimension match error");
    }

    private String appendIdSuffix(String dimensionIdentify) {
        return dimensionIdentify + ".id";
    }

    private String appendNameSuffix(String dimensionIdentify) {
        return dimensionIdentify + ".name";
    }
}

