/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.staff.bean.StaffHisParamBO;
import kd.hr.haos.business.service.staff.service.AbstractStaffHistoryService;
import kd.hr.haos.business.service.staff.service.IOpService;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.business.service.staff.service.StaffDimensionHisService;
import kd.hr.haos.business.service.staff.service.StaffDutyOrgHisService;
import kd.hr.haos.business.service.staff.service.StaffUseOrgHisService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.util.HRStringUtils;

public class OrgStaffBaseService
implements IOpService {
    private static Map<String, AbstractStaffHistoryService> staffHisAttachMap = Maps.newHashMapWithExpectedSize((int)16);

    @Override
    public void saveTemp(List<StaffHisParamBO> staffDyns) {
        staffDyns.forEach(staffHisParamBO -> {
            AbstractStaffHistoryService attach;
            if (!CollectionUtils.isEmpty(staffHisParamBO.getDyns()) && (attach = staffHisAttachMap.get(staffHisParamBO.getEntityName())) != null) {
                attach.batchSaveTempBoDataHis(staffHisParamBO.getDyns());
            }
        });
    }

    @Override
    public void enable(List<StaffHisParamBO> staffDyns) {
        staffDyns.forEach(staffHisParamBO -> {
            if (!CollectionUtils.isEmpty(staffHisParamBO.getDyns())) {
                staffHisParamBO.getDyns().stream().forEach(dyn -> dyn.set("enable", (Object)"1"));
                AbstractStaffHistoryService attach = staffHisAttachMap.get(staffHisParamBO.getEntityName());
                if (attach != null) {
                    attach.batchModifyAndEffectBoData(staffHisParamBO.getDyns());
                }
            }
        });
    }

    @Override
    public void change(List<StaffHisParamBO> boList) {
        boList.stream().forEach(staffHisParamBO -> {
            ArrayList changeDynList = Lists.newArrayListWithExpectedSize((int)boList.size());
            ArrayList modifyDynList = Lists.newArrayListWithExpectedSize((int)boList.size());
            ArrayList newDynList = Lists.newArrayListWithExpectedSize((int)boList.size());
            ArrayList deleteDynList = Lists.newArrayListWithExpectedSize((int)boList.size());
            DynamicObject[] dynsFromDB = this.getDynsFromDB((StaffHisParamBO)staffHisParamBO);
            List<DynamicObject> needToBeOpDynList = staffHisParamBO.getDyns();
            List<Long> onlyOrgVersionChangeEntryIdList = staffHisParamBO.getOnlyOrgVersionChangeList();
            if (!CollectionUtils.isEmpty(needToBeOpDynList)) {
                List idFromDBList = Arrays.stream(dynsFromDB).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
                needToBeOpDynList.stream().forEach(dyn -> {
                    long id = dyn.getLong("id");
                    if (onlyOrgVersionChangeEntryIdList.contains(id)) {
                        modifyDynList.add(dyn);
                    } else if (idFromDBList.contains(id)) {
                        changeDynList.add(dyn);
                    } else {
                        newDynList.add(dyn);
                    }
                });
            }
            List idNeedToOpList = needToBeOpDynList.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
            List<Long> noChangeIdList = staffHisParamBO.getNoChangeIdList();
            Arrays.stream(dynsFromDB).forEach(dyn -> {
                long id = dyn.getLong("id");
                if (!idNeedToOpList.contains(id) && !noChangeIdList.contains(id)) {
                    deleteDynList.add(dyn);
                }
            });
            AbstractStaffHistoryService attach = staffHisAttachMap.get(staffHisParamBO.getEntityName());
            if (attach != null) {
                if (!CollectionUtils.isEmpty((Collection)newDynList)) {
                    attach.batchSaveAndEnableBoDataHis(newDynList);
                }
                if (!CollectionUtils.isEmpty((Collection)changeDynList)) {
                    attach.batchModifyAndEffectBoData(changeDynList);
                }
                if (!CollectionUtils.isEmpty((Collection)deleteDynList)) {
                    attach.batchDeleteBoDataHis(deleteDynList);
                }
                if (!CollectionUtils.isEmpty((Collection)modifyDynList)) {
                    attach.batchModifyBoDataHis(modifyDynList);
                }
            }
        });
    }

    private DynamicObject[] getDynsFromDB(StaffHisParamBO staffHisParamBO) {
        String entityName = staffHisParamBO.getEntityName();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        long staffId = staffHisParamBO.getStaffId();
        QFilter staffIdFilter = new QFilter("staff", "=", (Object)staffId);
        QFilter orgPermQFilter = HRStringUtils.equals((String)entityName, (String)"bentryentity") ? StaffCommonService.getOrgPermQFilterForUseOrgEntry() : new QFilter("1", "=", (Object)1);
        QFilter effectingFilter = new QFilter("datastatus", "in", (Object)new String[]{EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue()});
        return helper.loadDynamicObjectArray(new QFilter[]{staffIdFilter, effectingFilter, orgPermQFilter});
    }

    @Override
    public void disable(List<StaffHisParamBO> staffDyns) {
        staffDyns.forEach(staffHisParamBO -> {
            if (!CollectionUtils.isEmpty(staffHisParamBO.getDyns())) {
                staffHisParamBO.getDyns().stream().forEach(dyn -> dyn.set("enable", (Object)"0"));
                AbstractStaffHistoryService attach = staffHisAttachMap.get(staffHisParamBO.getEntityName());
                if (attach != null) {
                    attach.batchModifyAndEffectBoData(staffHisParamBO.getDyns());
                }
            }
        });
    }

    @Override
    public void deleteTemp(List<StaffHisParamBO> staffDyns) {
        staffDyns.forEach(staffHisParamBO -> {
            AbstractStaffHistoryService attach;
            List<DynamicObject> dyns = staffHisParamBO.getDyns();
            if (!CollectionUtils.isEmpty(dyns) && (attach = staffHisAttachMap.get(staffHisParamBO.getEntityName())) != null) {
                attach.batchDeleteTempData(dyns.stream().map(dyn -> dyn.getLong("id")).distinct().toArray());
            }
        });
    }

    static {
        staffHisAttachMap.put("haos_dutyorgdetail", new StaffDutyOrgHisService());
        staffHisAttachMap.put("haos_useorgdetail", new StaffUseOrgHisService());
        staffHisAttachMap.put("haos_muldimendetail", new StaffDimensionHisService());
    }
}

