/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.form.IFormView;
import kd.bos.id.ID;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.domain.repository.staff.StaffOrgEmpCountRepository;
import kd.hr.haos.business.domain.repository.staff.StaffRuleConfigEntryRepository;
import kd.hr.haos.business.service.staff.bean.StaffEntryParamBO;
import kd.hr.haos.business.service.staff.bean.UseOrgEntryParamBO;
import kd.hr.haos.business.service.staff.service.StaffExtEntryHelper;
import kd.hr.haos.business.servicehelper.OrgBatchBillHelper;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.haos.business.util.TimeConvertUtil;
import kd.hr.haos.business.util.TimeLogger;
import kd.hr.haos.common.constants.PosTypeEnum;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class StaffCommonService {
    private static final Log logger = LogFactory.getLog(StaffCommonService.class);
    private static TimeLogger timeLogger = TimeLogger.create();
    public static final ThreadLocal<Long> STAFF_INTERFACE_STAFF_ID = new ThreadLocal();
    private static final String ADMIN_ORG_SELECT_SQL = "SELECT a.fid AS id, a.fboid AS boid, A.fparentid as parentorg, t.flevel as level1,  t.fstructlongnumber as structlongnumber FROM T_HAOS_ADMINORG A LEFT JOIN T_HAOS_ADMINSTRUCT T ON A.fboid = T.fadminorgid AND T.fiscurrentversion = '0' AND T.fdatastatus = '1' AND T.fstructprojectid = 1010 AND T.finitstatus = '2' AND T.fbsed <= ? AND T.fbsled >= ? AND T.fenable = '1' LEFT JOIN T_HAOS_ORGSORTCODE S ON S.FADMINORGID = A.fboid AND S.fiscurrentversion = '0' AND S.fdatastatus = '1' AND S.finitstatus = '2' AND S.fbsed <= ? AND S.fbsled >= ? AND S.fenable = '1' WHERE A.fiscurrentversion = '0' AND A.fdatastatus = '1' AND A.finitstatus = '2' AND A.fbsed <= ? AND A.fbsled >= ? AND A.fenable = '1' AND (A.forgid = ? OR A.fboid = ?)";
    public static final String[] PREFIX_ARR = new String[]{"a", "b", "c", "d", "e"};
    public static final String[] PREFIX_ARR2 = new String[]{"b", "c", "d", "e"};
    public static final String[] MUTIL_DIM_PREFIX_ARR2 = new String[]{"c", "d", "e"};

    public static List<String> getYearStaff(String prefix, String suffix) {
        ArrayList yearStaffs = Lists.newArrayListWithExpectedSize((int)16);
        if (!HRStringUtils.isEmpty((String)prefix)) {
            yearStaffs.add(prefix + "yearstaff");
            if (!HRStringUtils.isEmpty((String)suffix)) {
                yearStaffs.add(prefix + "yearstaff" + suffix);
            }
            return yearStaffs;
        }
        StaffExtEntryHelper staffExtEntryHelper = new StaffExtEntryHelper();
        for (String prefixX : staffExtEntryHelper.getAllPrefixWithoutA()) {
            yearStaffs.add(prefixX + "yearstaff");
            if (HRStringUtils.isEmpty((String)suffix)) continue;
            yearStaffs.add(prefixX + "yearstaff" + suffix);
        }
        return yearStaffs;
    }

    public static List<String> getHalfYearStaff(String prefix, String suffix) {
        ArrayList halfYearStaffs = Lists.newArrayListWithExpectedSize((int)16);
        if (!HRStringUtils.isEmpty((String)prefix)) {
            halfYearStaffs.add(prefix + "halfyearstaff1");
            halfYearStaffs.add(prefix + "halfyearstaff2");
            if (!HRStringUtils.isEmpty((String)suffix)) {
                halfYearStaffs.add(prefix + "halfyearstaff1" + suffix);
                halfYearStaffs.add(prefix + "halfyearstaff2" + suffix);
            }
            return halfYearStaffs;
        }
        StaffExtEntryHelper staffExtEntryHelper = new StaffExtEntryHelper();
        for (String prefixX : staffExtEntryHelper.getAllPrefixWithoutA()) {
            halfYearStaffs.add(prefixX + "halfyearstaff1");
            halfYearStaffs.add(prefixX + "halfyearstaff2");
            if (HRStringUtils.isEmpty((String)suffix)) continue;
            halfYearStaffs.add(prefixX + "halfyearstaff1" + suffix);
            halfYearStaffs.add(prefixX + "halfyearstaff2" + suffix);
        }
        return halfYearStaffs;
    }

    public static List<String> getMonthStaff(String prefix, String suffix, boolean onlyOnce) {
        String[] prefixArr;
        String[] stringArray;
        ArrayList monthStaffList = Lists.newArrayListWithExpectedSize((int)16);
        StaffExtEntryHelper staffExtEntryHelper = new StaffExtEntryHelper();
        if (!HRStringUtils.isEmpty((String)prefix)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = prefix;
        } else {
            stringArray = staffExtEntryHelper.getAllPrefixWithoutA().toArray(new String[0]);
        }
        for (String prefixX : prefixArr = stringArray) {
            for (int i = 1; i <= 12; ++i) {
                if (onlyOnce && !HRStringUtils.isEmpty((String)suffix)) {
                    monthStaffList.add(prefixX + "monthstaff" + i + suffix);
                    continue;
                }
                monthStaffList.add(prefixX + "monthstaff" + i);
                if (HRStringUtils.isEmpty((String)suffix)) continue;
                monthStaffList.add(prefixX + "monthstaff" + i + suffix);
            }
        }
        return monthStaffList;
    }

    public static List<String> getMonthStaff(String prefix, String suffix) {
        return StaffCommonService.getMonthStaff(prefix, suffix, false);
    }

    public static List<String> getQuarterStaff(String prefix, String suffix) {
        ArrayList monthStaffList = Lists.newArrayListWithExpectedSize((int)16);
        if (!HRStringUtils.isEmpty((String)prefix)) {
            for (int i = 1; i <= 4; ++i) {
                monthStaffList.add(prefix + "quarterstaff" + i);
                if (HRStringUtils.isEmpty((String)suffix)) continue;
                monthStaffList.add(prefix + "quarterstaff" + i + suffix);
            }
            return monthStaffList;
        }
        StaffExtEntryHelper staffExtEntryHelper = new StaffExtEntryHelper();
        for (String prefixX : staffExtEntryHelper.getAllPrefix()) {
            for (int i = 1; i <= 4; ++i) {
                monthStaffList.add(prefixX + "quarterstaff" + i);
                if (HRStringUtils.isEmpty((String)suffix)) continue;
                monthStaffList.add(prefixX + "quarterstaff" + i + suffix);
            }
        }
        return monthStaffList;
    }

    public static List<String> getStaffProjectField(String prefix) {
        ArrayList staffProjectFields = Lists.newArrayListWithExpectedSize((int)16);
        if (!HRStringUtils.isEmpty((String)prefix)) {
            staffProjectFields.add(prefix + "controlstrategy");
            staffProjectFields.add(prefix + "elasticcontrol");
            staffProjectFields.add(prefix + "elasticcount");
            return staffProjectFields;
        }
        StaffExtEntryHelper staffExtEntryHelper = new StaffExtEntryHelper();
        for (String prefixX : staffExtEntryHelper.getAllPrefix()) {
            staffProjectFields.add(prefixX + "controlstrategy");
            staffProjectFields.add(prefixX + "elasticcontrol");
            staffProjectFields.add(prefixX + "elasticcount");
        }
        return staffProjectFields;
    }

    public static String addPrefix(String prefix, String field) {
        return prefix + field;
    }

    public static String addPrefixAndPostfix(String prefix, String field) {
        return prefix + field + "_import";
    }

    public static DynamicObjectCollection removePrefix(DynamicObjectCollection data, String entityName) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        DynamicObjectCollection result = new DynamicObjectCollection();
        if (CollectionUtils.isEmpty((Collection)data)) {
            return result;
        }
        String prefix = data.getDynamicObjectType().getName().substring(0, 1);
        int size = data.size();
        long[] ids = ORM.create().genLongIds(entityName, size);
        for (int i = 0; i < size; ++i) {
            DynamicObject dyn = (DynamicObject)data.get(i);
            DataEntityPropertyCollection sourceProperties = dyn.getDataEntityType().getProperties();
            LinkedHashMap propVsValueMap = Maps.newLinkedHashMapWithExpectedSize((int)sourceProperties.size());
            DynamicObject dynamicObject = helper.generateEmptyDynamicObject();
            DataEntityPropertyCollection targetProperties = dynamicObject.getDataEntityType().getProperties();
            for (IDataEntityProperty sourceProp : sourceProperties) {
                String fieldName = sourceProp.getName();
                propVsValueMap.put(fieldName, dyn.get(fieldName));
            }
            for (IDataEntityProperty target : targetProperties) {
                String targetFieldName = target.getName();
                if (HRStringUtils.equals((String)targetFieldName, (String)"pid") || HRStringUtils.equals((String)targetFieldName, (String)"id")) {
                    dynamicObject.set(targetFieldName, propVsValueMap.get(targetFieldName));
                    continue;
                }
                dynamicObject.set(targetFieldName, propVsValueMap.get(prefix + targetFieldName));
            }
            if (dyn.getLong("id") == 0L) {
                dynamicObject.set("id", (Object)ids[i]);
            } else {
                dynamicObject.set("id", dyn.get("id"));
            }
            dynamicObject.set("sequence", (Object)i);
            result.add((Object)dynamicObject);
        }
        return result;
    }

    public static void fieldCopy(DynamicObject fromObj, DynamicObject toObj, Object[] fields) {
        if (fields == null || fields.length == 0) {
            return;
        }
        for (Object field : fields) {
            if (field instanceof Map) {
                Map fieldMap = (Map)field;
                fieldMap.forEach((key, value) -> toObj.set(value, fromObj.get(key)));
                continue;
            }
            if ("entryentity".equals(field)) {
                toObj.set("entryentity", fromObj.get("entryentity"));
                continue;
            }
            toObj.set((String)field, fromObj.get((String)field));
        }
    }

    public static Object getSystemParam(long orgId, String param) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)"homs");
        String appId = appInfo != null ? appInfo.getId() : null;
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)param);
    }

    public static Object getSystemParamBooleanValue(long orgId, String param, boolean defaultValue) {
        Object value = StaffCommonService.getSystemParam(orgId, param);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static Map<String, Map<String, Object>> batchLoadSystemParam(List<Long> orgIds) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)"homs");
        String appId = appInfo != null ? appInfo.getId() : null;
        AppParam appParam = new AppParam();
        appParam.setAppId(appId);
        return SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)appParam, orgIds);
    }

    public static Map<Long, HashSet<Long>[]> getPositionAndJobIds(List<Long> adminOrgIds) {
        if (CollectionUtils.isEmpty(adminOrgIds)) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        Map positionMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IPositionService", (String)"queryPositionByOrgIds", (Object[])new Object[]{adminOrgIds});
        List positionAndJobList = (List)positionMap.get("data");
        HashMap positionAndJobMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map positionInfo : positionAndJobList) {
            Long adminOrgId = (Long)positionInfo.get("adminorg");
            long positionId = (Long)positionInfo.get("id");
            long jobId = (Long)positionInfo.get("job");
            HashSet[] positionAndJobIds = (HashSet[])positionAndJobMap.get(adminOrgId);
            if (positionAndJobIds == null) {
                HashSet positionIds = Sets.newHashSetWithExpectedSize((int)16);
                HashSet jobIds = Sets.newHashSetWithExpectedSize((int)16);
                positionAndJobIds = new HashSet[]{positionIds, jobIds};
            }
            if (positionId != 0L) {
                positionAndJobIds[0].add(positionId);
            }
            if (jobId != 0L) {
                positionAndJobIds[1].add(jobId);
            }
            positionAndJobMap.put(adminOrgId, positionAndJobIds);
        }
        return positionAndJobMap;
    }

    public static AuthorizedOrgResult getOrgAuth() {
        Long userId = RequestContext.get().getCurrUserId();
        String permItemId = "47150e89000000ac";
        AuthorizedOrgResult permResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgsF7", (Object[])new Object[]{userId, "homs", "haos_staff", permItemId, "adminorgboid", Boolean.FALSE});
        return permResult;
    }

    public static AuthorizedOrgResultWithSub getOrgAuthWithSub() {
        Long userId = RequestContext.get().getCurrUserId();
        String permItemId = "47150e89000000ac";
        AuthorizedOrgResultWithSub permResult = (AuthorizedOrgResultWithSub)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgsWithSub", (Object[])new Object[]{userId, "homs", "haos_staff", permItemId, "useorg"});
        return permResult;
    }

    public static QFilter getBaseDataAuthByOrg(DynamicObject org, String baseDataEntityName) {
        QFilter filter = org == null ? new QFilter("1", "!=", (Object)1) : BaseDataHelper.getBaseDataFilter(baseDataEntityName, org.getLong("id"));
        return filter;
    }

    public static Map<Long, Integer> getOrgDirectPersonCount(List<Long> orgIds, Date queryDate) {
        HashMap orgPersonCountMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList<Long> postTypes = new ArrayList<Long>();
        postTypes.add(PosTypeEnum.FULL_TIME.getId());
        boolean isIncludeSubOrg = false;
        Map personResult = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIDepempService", (String)"listMainEmpOrgRelByAdminOrg", (Object[])new Object[]{orgIds, isIncludeSubOrg, queryDate, postTypes});
        logger.info("listMainEmpOrgRelByAdminOrg: {}, orgIds: {}, queryDate: {}", new Object[]{JSONObject.toJSONString((Object)personResult), JSONObject.toJSONString(orgIds), JSONObject.toJSONString((Object)queryDate)});
        if (((Boolean)personResult.get("success")).booleanValue()) {
            Map orgIdPersonInfoMap = (Map)personResult.get("data");
            Set entries = orgIdPersonInfoMap.entrySet();
            for (Map.Entry entry : entries) {
                Long orgId = (Long)entry.getKey();
                Map personInfoMap = (Map)entry.getValue();
                int count = personInfoMap.get("count") == null ? 0 : (Integer)personInfoMap.get("count");
                orgPersonCountMap.put(orgId, count);
            }
        }
        return orgPersonCountMap;
    }

    public static Map<Long, String> getOrgNameMap(Set<Long> adminOrgIds, Date queryDate) {
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter idFilter = new QFilter("id", "in", adminOrgIds);
        DynamicObject[] adminOrgInfoArr = adminOrgHelper.queryOriginalArray("id, parentorg", new QFilter[]{idFilter});
        Map<Long, Long> parentOrgIdMap = Arrays.stream(adminOrgInfoArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("parentorg")));
        Map<Long, String> parentOrgLongName = OrgBatchBillHelper.getOrgLongNameByFid(new HashSet<Long>(parentOrgIdMap.values()), queryDate, null);
        HashMap orgLongNameMap = Maps.newHashMapWithExpectedSize((int)16);
        parentOrgIdMap.forEach((adminOrgId, parentOrgId) -> {
            String cfr_ignored_0 = (String)orgLongNameMap.put(adminOrgId, parentOrgLongName.get(parentOrgId));
        });
        return orgLongNameMap;
    }

    public static List<UseOrgEntryParamBO> getStaffEntryInfo(IFormView formView, long orgId, List<UseOrgEntryParamBO> useOrgEntryDataFromDB, boolean queryPerm) {
        Map<Object, Object> useOrgFromDBMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!CollectionUtils.isEmpty(useOrgEntryDataFromDB)) {
            useOrgFromDBMap = useOrgEntryDataFromDB.stream().collect(Collectors.toMap(StaffEntryParamBO::getBoId, dyn -> dyn, (v1, v2) -> v1));
        }
        Date date = new Date();
        ArrayList entryInfos = Lists.newArrayListWithExpectedSize((int)16);
        HashMap entryInfoMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet adminOrgIds = Sets.newHashSetWithExpectedSize((int)16);
        StringBuilder sql = StaffCommonService.buildSqlWithPerm(formView, queryPerm);
        logger.info("StaffCommonService#getStaffEntryInfo sql={}", (Object)sql);
        Object[] param = new Object[]{date, date, date, date, date, date, orgId, orgId};
        ORM orm = ORM.create();
        try (DataSet dataSet = HRDBUtil.queryDataSet((String)"haos_adminOrgHisSearch", (DBRoute)new DBRoute("hr"), (String)sql.toString(), (Object[])param);){
            DynamicObjectCollection retDynCol = orm.toPlainDynamicObjectCollection(dataSet);
            int size = retDynCol.size();
            long[] ids = ID.genLongIds((int)size);
            for (int i = 0; i < size; ++i) {
                DynamicObject row = (DynamicObject)retDynCol.get(i);
                long adminOrgId = row.getLong("id");
                long boId = row.getLong("boid");
                long parentOrgId = row.getLong("parentorg");
                String structLongNumber = row.getString("structlongnumber");
                UseOrgEntryParamBO staffEntryParamBO = new UseOrgEntryParamBO("bentryentity", "buseorg", adminOrgId);
                UseOrgEntryParamBO useOrgFromDB = (UseOrgEntryParamBO)useOrgFromDBMap.get(boId);
                if (useOrgFromDB != null) {
                    staffEntryParamBO.setId(useOrgFromDB.getId());
                    staffEntryParamBO.setParentEntryId(useOrgFromDB.getParentEntryId());
                } else {
                    staffEntryParamBO.setId(ids[i]);
                }
                staffEntryParamBO.setBoId(boId);
                staffEntryParamBO.setLevel(row.getInt("level1"));
                staffEntryParamBO.setParentOrgId(parentOrgId);
                staffEntryParamBO.setStructLongNumber(structLongNumber);
                entryInfoMap.put(boId, staffEntryParamBO);
                adminOrgIds.add(boId);
                entryInfos.add(staffEntryParamBO);
            }
        }
        StaffCommonService.buildStaffStructInfo(entryInfos, entryInfoMap, adminOrgIds);
        return entryInfos;
    }

    public static StringBuilder buildSqlWithPerm(IFormView formView, boolean queryPerm) {
        AuthorizedOrgResultWithSub permResult;
        StringBuilder sql = new StringBuilder(ADMIN_ORG_SELECT_SQL);
        if (queryPerm && !(permResult = StaffCommonService.getOrgAuthWithSub()).isHasAllOrgPerm()) {
            List<String> subStructLongNumbers = permResult.getHasPermOrgsWithSub().stream().filter(OrgSubInfo::isContainsSub).map(OrgSubInfo::getLongStructNumber).sorted().collect(Collectors.toList());
            List<Long> orgBoIdList = permResult.getHasPermOrgsWithSub().stream().filter(permOrg -> !permOrg.isContainsSub()).map(OrgSubInfo::getOrgId).sorted().collect(Collectors.toList());
            List<String> commonStructLongNumber = StaffCommonService.findCommonStructLongNumber(subStructLongNumbers);
            if (!CollectionUtils.isEmpty(commonStructLongNumber) || !CollectionUtils.isEmpty(orgBoIdList)) {
                sql.append(" AND (");
                if (!CollectionUtils.isEmpty(commonStructLongNumber)) {
                    commonStructLongNumber.forEach(structLongNumber -> sql.append(" T.fstructlongnumber LIKE '").append((String)structLongNumber).append("%' OR"));
                    if (CollectionUtils.isEmpty(orgBoIdList)) {
                        sql.delete(sql.length() - 2, sql.length());
                    }
                }
                if (!CollectionUtils.isEmpty(orgBoIdList)) {
                    sql.append(" A.fboid in (");
                    orgBoIdList.forEach(orgBoId -> sql.append(orgBoId).append(","));
                    sql.delete(sql.length() - 1, sql.length());
                    sql.append(")");
                }
                sql.append(")");
            }
        }
        long staffId = formView != null ? formView.getModel().getDataEntity().getLong("id") : STAFF_INTERFACE_STAFF_ID.get().longValue();
        QFilter staffIdFilter = new QFilter("refstaff", "=", (Object)staffId);
        DynamicObject ruleConfigEntryDyn = StaffRuleConfigEntryRepository.getInstance().loadDynamicObject(staffIdFilter);
        if (Objects.nonNull(ruleConfigEntryDyn)) {
            StaffCommonService.filterRuleConfigCurEntryRow(sql, ruleConfigEntryDyn);
            StaffCommonService.filterRuleConfigOtherEntryRow(sql, ruleConfigEntryDyn);
        }
        sql.append(" ORDER BY S.fsortcode");
        return sql;
    }

    private static void filterRuleConfigOtherEntryRow(StringBuilder sql, DynamicObject ruleConfigEntryDyn) {
        long staffRuleConfigId = ruleConfigEntryDyn.getLong("staffruleconfig.id");
        DynamicObjectCollection staffRuleOrgDynCol = ruleConfigEntryDyn.getDynamicObjectCollection("staffruleorg");
        Set orgIdSet = staffRuleOrgDynCol.stream().map(orgDyn -> orgDyn.getLong("fbasedataid.id")).collect(Collectors.toSet());
        long staffRuleConfigEntryId = ruleConfigEntryDyn.getLong("id");
        QFilter staffRuleConfigFilter = new QFilter("staffruleconfig", "=", (Object)staffRuleConfigId);
        staffRuleConfigFilter.and("id", "!=", (Object)staffRuleConfigEntryId);
        DynamicObject[] ruleConfigEntryAllDyns = StaffRuleConfigEntryRepository.getInstance().loadDynamicObjectArray(staffRuleConfigFilter);
        HashSet otherEntryAdminOrgIdSet = Sets.newHashSetWithExpectedSize((int)ruleConfigEntryAllDyns.length);
        Arrays.stream(ruleConfigEntryAllDyns).forEach(dyn -> {
            DynamicObjectCollection staffRuleOrgDynOtherCol = dyn.getDynamicObjectCollection("staffruleorg");
            otherEntryAdminOrgIdSet.addAll(staffRuleOrgDynOtherCol.stream().map(orgDyn -> orgDyn.getLong("fbasedataid.id")).collect(Collectors.toSet()));
        });
        otherEntryAdminOrgIdSet.removeAll(orgIdSet);
        QFilter adminOrgIdFilter = new QFilter("adminorg", "in", (Object)otherEntryAdminOrgIdSet);
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] orgStructDyns = AdminOrgStructRepository.getInstance().queryArray("id, adminorg, structlongnumber", new QFilter[]{adminOrgIdFilter, isCurrentVersionFilter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
        List<String> otherEntryOrgStructLongNumberList = Arrays.stream(orgStructDyns).map(dyn -> dyn.getString("structlongnumber")).collect(Collectors.toList());
        Set<String> structLongNumberSet = StaffCommonService.filterSubOrgStructLongNumber(ruleConfigEntryDyn, otherEntryOrgStructLongNumberList);
        if (!CollectionUtils.isEmpty(structLongNumberSet)) {
            sql.append(" and (");
            structLongNumberSet.forEach(structLongNumber -> sql.append(" T.fstructlongnumber NOT LIKE '").append((String)structLongNumber).append("%' AND"));
            sql.delete(sql.length() - 3, sql.length());
            sql.append(" )");
        }
    }

    private static Set<String> filterSubOrgStructLongNumber(DynamicObject ruleConfigEntryDyn, List<String> otherEntryOrgStructLongNumberList) {
        DynamicObjectCollection ruleConfigAdminOrgDynCol = ruleConfigEntryDyn.getDynamicObjectCollection("staffruleorg");
        List curStructNumberList = ruleConfigAdminOrgDynCol.stream().map(dyn -> dyn.getString("fbasedataid.structnumber")).collect(Collectors.toList());
        HashSet structLongNumberSet = Sets.newHashSetWithExpectedSize((int)16);
        block0: for (String structLongNumber : otherEntryOrgStructLongNumberList) {
            for (String structNumber : curStructNumberList) {
                if (!structLongNumber.contains(structNumber)) continue;
                structLongNumberSet.add(structLongNumber);
                continue block0;
            }
        }
        return structLongNumberSet;
    }

    private static void filterRuleConfigCurEntryRow(StringBuilder sql, DynamicObject ruleConfigEntryDyn) {
        boolean includeSub = ruleConfigEntryDyn.getBoolean("includesub");
        DynamicObjectCollection staffRuleOrgDynCol = ruleConfigEntryDyn.getDynamicObjectCollection("staffruleorg");
        Set<Long> orgIdSet = staffRuleOrgDynCol.stream().map(orgDyn -> orgDyn.getLong("fbasedataid.id")).collect(Collectors.toSet());
        if (includeSub) {
            QFilter adminOrgFilter = new QFilter("adminorg", "in", orgIdSet);
            QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            DynamicObject[] orgStructDyns = AdminOrgStructRepository.getInstance().queryArray("id, adminorg, structlongnumber", new QFilter[]{adminOrgFilter, isCurrentVersionFilter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
            List<String> structLongNumberList = Arrays.stream(orgStructDyns).map(dyn -> dyn.getString("structlongnumber")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(structLongNumberList)) {
                return;
            }
            sql.append(" and (");
            structLongNumberList.forEach(structLongNumber -> sql.append(" T.fstructlongnumber LIKE '").append((String)structLongNumber).append("%' OR"));
            sql.delete(sql.length() - 2, sql.length());
            sql.append(" )");
        } else {
            sql.append(" and A.fboid in (");
            orgIdSet.forEach(orgBoId -> sql.append(orgBoId).append(","));
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
    }

    public static QFilter getOrgPermQFilterForUseOrgEntry() {
        AuthorizedOrgResultWithSub permResult = StaffCommonService.getOrgAuthWithSub();
        if (permResult.isHasAllOrgPerm()) {
            return new QFilter("1", "=", (Object)1);
        }
        Set<Long> hasPermOrgIdSet = StaffCommonService.getHasPermOrgIdSet(permResult);
        return new QFilter("useorgbo", "in", hasPermOrgIdSet);
    }

    public static QFilter getOrgPermQFilterForMultiEntry() {
        AuthorizedOrgResultWithSub permResult = StaffCommonService.getOrgAuthWithSub();
        if (permResult.isHasAllOrgPerm()) {
            return new QFilter("1", "=", (Object)1);
        }
        Set<Long> hasPermOrgIdSet = StaffCommonService.getHasPermOrgIdSet(permResult);
        return new QFilter("useorg.boid", "in", hasPermOrgIdSet);
    }

    public static Set<Long> getHasPermOrgIdSet(AuthorizedOrgResultWithSub permResult) {
        Set<Long> hasPermOrgIdSet = permResult.getHasPermOrgsWithSub().stream().filter(permOrg -> !permOrg.isContainsSub()).map(OrgSubInfo::getOrgId).collect(Collectors.toSet());
        List<String> subStructLongNumbers = permResult.getHasPermOrgsWithSub().stream().filter(OrgSubInfo::isContainsSub).map(OrgSubInfo::getLongStructNumber).sorted().collect(Collectors.toList());
        List<String> commonStructLongNumberList = StaffCommonService.findCommonStructLongNumber(subStructLongNumbers);
        QFilter structLongNumberFilter = null;
        for (String commonStructLongNumber : commonStructLongNumberList) {
            if (structLongNumberFilter == null) {
                structLongNumberFilter = new QFilter("structlongnumber", "like", (Object)(commonStructLongNumber + "%"));
                continue;
            }
            structLongNumberFilter.or(new QFilter("structlongnumber", "like", (Object)(commonStructLongNumber + "%")));
        }
        if (structLongNumberFilter != null) {
            DynamicObject[] adminOrgStructDyns = AdminOrgStructRepository.getInstance().queryOriginal("id, adminorg.id", new QFilter[]{structLongNumberFilter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
            Set orgBoIdSet = Arrays.stream(adminOrgStructDyns).map(dyn -> dyn.getLong("adminorg.id")).collect(Collectors.toSet());
            hasPermOrgIdSet.addAll(orgBoIdSet);
        }
        return hasPermOrgIdSet;
    }

    private static List<String> findCommonStructLongNumber(List<String> subStructLongNumbers) {
        ArrayList<String> structLongNumberResult = new ArrayList<String>(subStructLongNumbers.size());
        if (CollectionUtils.isEmpty(subStructLongNumbers)) {
            return structLongNumberResult;
        }
        structLongNumberResult.add(subStructLongNumbers.get(0));
        String structlongnumber = subStructLongNumbers.get(0);
        for (int i = 0; i < subStructLongNumbers.size() - 1; ++i) {
            if (subStructLongNumbers.get(i + 1).startsWith(structlongnumber)) continue;
            structLongNumberResult.add(subStructLongNumbers.get(i + 1));
            structlongnumber = subStructLongNumbers.get(i + 1);
        }
        return structLongNumberResult;
    }

    public static void buildStaffStructInfo(List<UseOrgEntryParamBO> entryInfos, Map<Long, UseOrgEntryParamBO> entryInfoMap, Set<Long> adminOrgBOIds) {
        Map<Object, Object> orgLongNameMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<Object, Object> staffOrgEmpCountInfoMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!CollectionUtils.isEmpty(adminOrgBOIds)) {
            orgLongNameMap = StaffCommonService.getOrgNameMap(adminOrgBOIds, new Date());
            DynamicObject[] staffOrgEmpCountInfoArr = StaffOrgEmpCountRepository.getInstance().queryStaffEmpCountByOrgId(new ArrayList<Long>(adminOrgBOIds));
            staffOrgEmpCountInfoMap = Arrays.stream(staffOrgEmpCountInfoArr).collect(Collectors.toMap(dyn -> dyn.getLong("useorgbo.id"), dyn -> dyn, (v1, v2) -> v1));
        }
        int size = entryInfos.size();
        for (int i = size - 1; i >= 0; --i) {
            long parentOrgId;
            UseOrgEntryParamBO parentStaffEntry;
            DynamicObject staffOrgEmpInfo;
            UseOrgEntryParamBO staffEntryParamBO = entryInfos.get(i);
            if (!CollectionUtils.isEmpty((Map)orgLongNameMap)) {
                String orgLongName = (String)orgLongNameMap.get(staffEntryParamBO.getBoId());
                staffEntryParamBO.setLongName(orgLongName);
            }
            if ((staffOrgEmpInfo = (DynamicObject)staffOrgEmpCountInfoMap.get(staffEntryParamBO.getBoId())) != null) {
                staffEntryParamBO.setDirectNum(staffOrgEmpInfo.getInt("count"));
            }
            if ((parentStaffEntry = entryInfoMap.get(parentOrgId = staffEntryParamBO.getParentOrgId())) == null) continue;
            List<Object> childStaffEntry = parentStaffEntry.getChildEntryInfos() == null ? Lists.newArrayListWithExpectedSize((int)16) : parentStaffEntry.getChildEntryInfos();
            childStaffEntry.add(staffEntryParamBO);
            parentStaffEntry.setChildEntryInfos(childStaffEntry);
            staffEntryParamBO.setParentEntryId(parentStaffEntry.getId());
        }
    }

    public static DynamicObject getOrgStaffRuleConfig(DynamicObject org, Date ruleYear) {
        if (org != null) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_staffruleconfig");
            QFilter filter = new QFilter("org", "=", (Object)org.getLong("id"));
            filter.and("enable", "=", (Object)"1");
            filter.and("year", ">=", (Object)TimeConvertUtil.getMinDate(ruleYear));
            filter.and("year", "<=", (Object)TimeConvertUtil.getMaxDate(ruleYear));
            return serviceHelper.queryOne("id, year, org, staffcycle, staffproject", new QFilter[]{filter});
        }
        return null;
    }

    public static DynamicObject[] loadStaffTempAndEffectData(String entryEntityName, Long staffId, QFilter otherFilter) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entryEntityName);
        QFilter staffIdFilter = new QFilter("staff", "=", (Object)staffId);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue()});
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{staffIdFilter, dataStatusFilter, otherFilter});
    }

    public static DynamicObject[] queryStaffTempAndEffectData(String entryEntityName, Long staffId, String selectFields) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entryEntityName);
        QFilter staffIdFilter = new QFilter("staff", "=", (Object)staffId);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue()});
        return serviceHelper.query(selectFields, new QFilter[]{staffIdFilter, dataStatusFilter});
    }

    public static DynamicObject[] queryOriginStaffTempAndEffectData(String entryEntityName, Long staffId, String selectFields) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entryEntityName);
        QFilter staffIdFilter = new QFilter("staff", "=", (Object)staffId);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue()});
        return serviceHelper.queryOriginalArray(selectFields, new QFilter[]{staffIdFilter, dataStatusFilter});
    }

    public static DynamicObject[] queryStaffTempAndEffectDataWithFilter(String entryEntityName, Long staffId, QFilter otherFilter, String selectFields) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entryEntityName);
        QFilter staffIdFilter = new QFilter("staff", "=", (Object)staffId);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue()});
        return serviceHelper.query(selectFields, new QFilter[]{staffIdFilter, dataStatusFilter, otherFilter}, "sequence asc");
    }

    public static DynamicObject[] queryStaffTempAndEffectDisableData(String entryEntityName, Long staffId, String selectFields) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entryEntityName);
        QFilter staffIdFilter = new QFilter("staff", "=", (Object)staffId);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_INVALIDED.getValue()});
        QFilter permFilter = StaffCommonService.getOrgPermQFilterForUseOrgEntry();
        return serviceHelper.query(selectFields, new QFilter[]{staffIdFilter, dataStatusFilter, permFilter});
    }

    public static DynamicObjectCollection removeMultiDataId(DynamicObjectCollection staffDimensions) {
        DynamicObjectCollection useOrgStaffDimensions = new DynamicObjectCollection();
        if (!CollectionUtils.isEmpty((Collection)staffDimensions)) {
            staffDimensions.forEach(item -> {
                DynamicObject dyn = new DynamicObject(item.getDynamicObjectType());
                dyn.set("fbasedataid", item.get("fbasedataid"));
                useOrgStaffDimensions.add((Object)dyn);
            });
        }
        return useOrgStaffDimensions;
    }

    public static String[] buildStructLongNumberArr(String structLongNumber) {
        if (HRStringUtils.isEmpty((String)structLongNumber)) {
            return new String[0];
        }
        String[] structNumbers = structLongNumber.split("!");
        int length = structNumbers.length;
        String[] structLongNumbers = new String[length];
        StringBuilder longNumber = new StringBuilder(structNumbers[0]);
        structLongNumbers[0] = longNumber.toString();
        for (int i = 1; i < length; ++i) {
            longNumber.append("!").append(structNumbers[i]);
            structLongNumbers[i] = longNumber.toString();
        }
        return structLongNumbers;
    }

    public static Integer elasticValueCalc(String roundType, String elasticControl, int elasticCount, Integer staffNum) {
        if (HRStringUtils.isEmpty((String)elasticControl) || staffNum == null) {
            return null;
        }
        int result = "1".equals(elasticControl) ? staffNum + elasticCount : ("1".equals(roundType) ? (int)Math.floor((double)staffNum.intValue() * (1.0 + (double)elasticCount / 100.0)) : (int)Math.ceil((double)staffNum.intValue() * (1.0 + (double)elasticCount / 100.0)));
        return result;
    }

    public static boolean compareDynamicObject(DynamicObject dynFromPage, DynamicObject dynFromDB, List<String> ignoreProp) {
        DataEntityPropertyCollection pageDynPropCol = dynFromPage.getDynamicObjectType().getProperties();
        for (IDataEntityProperty pageDynProp : pageDynPropCol) {
            if (ignoreProp.contains(pageDynProp.getName())) continue;
            Object newVal = dynFromPage.get(pageDynProp);
            Object oldVal = HRStringUtils.equals((String)pageDynProp.getName(), (String)"pid") ? dynFromDB.get(pageDynProp.getName()) : dynFromDB.get(pageDynProp.getName().substring(1));
            if (Objects.isNull(newVal) && Objects.isNull(oldVal)) continue;
            if (Objects.isNull(newVal) || Objects.isNull(oldVal)) {
                return false;
            }
            if (StaffCommonService.compareValues(newVal, oldVal)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareDynamicObjectByContainsProp(DynamicObject dynFromPage, DynamicObject dynFromDB, List<String> containsProp) {
        DataEntityPropertyCollection pageDynPropCol = dynFromPage.getDynamicObjectType().getProperties();
        for (IDataEntityProperty pageDynProp : pageDynPropCol) {
            if (!containsProp.contains(pageDynProp.getName())) continue;
            Object newVal = dynFromPage.get(pageDynProp);
            Object oldVal = dynFromDB.get(pageDynProp.getName());
            if (Objects.isNull(newVal) && Objects.isNull(oldVal)) continue;
            if (Objects.isNull(newVal) || Objects.isNull(oldVal)) {
                return false;
            }
            if (StaffCommonService.compareValues(newVal, oldVal)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareValues(Object newVal, Object oldVal) {
        boolean result = true;
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        List enabledLangList = service.getEnabledLang();
        if (newVal instanceof OrmLocaleValue) {
            if (!CollectionUtils.isEmpty((Collection)enabledLangList)) {
                for (EnabledLang enabledLang : enabledLangList) {
                    String oldItem;
                    String number = enabledLang.getNumber();
                    String newItem = ((OrmLocaleValue)newVal).getItem(number);
                    if (HRStringUtils.equals((String)newItem, (String)(oldItem = ((OrmLocaleValue)oldVal).getItem(number)))) continue;
                    result = false;
                }
            }
        } else if (newVal instanceof LocaleString) {
            if (!CollectionUtils.isEmpty((Collection)enabledLangList)) {
                for (EnabledLang enabledLang : enabledLangList) {
                    String oldItem;
                    String number = enabledLang.getNumber();
                    String newItem = (String)((LocaleString)newVal).getItem(number);
                    if (HRStringUtils.equals((String)newItem, (String)(oldItem = (String)((LocaleString)oldVal).getItem(number)))) continue;
                    result = false;
                }
            }
        } else if (newVal instanceof DynamicObject) {
            Long oldId;
            Long newId = ((DynamicObject)newVal).getLong("id");
            if (!newId.equals(oldId = Long.valueOf(((DynamicObject)oldVal).getLong("id")))) {
                result = false;
            }
        } else if (newVal instanceof Long && oldVal instanceof DynamicObject) {
            Long newId;
            Long oldId = ((DynamicObject)oldVal).getLong("id");
            if (!oldId.equals(newId = (Long)newVal)) {
                result = false;
            }
        } else if (newVal instanceof DynamicObjectCollection) {
            result = StaffCommonService.compareDynamicObjectCollection((DynamicObjectCollection)newVal, (DynamicObjectCollection)oldVal);
        } else if (!newVal.equals(oldVal)) {
            result = false;
        }
        return result;
    }

    private static boolean compareDynamicObjectCollection(DynamicObjectCollection newColl, DynamicObjectCollection oldColl) {
        List baseDataIdListFromNew = newColl.stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toList());
        List baseDataIdListFromOld = oldColl.stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toList());
        if (baseDataIdListFromNew.size() != baseDataIdListFromOld.size()) {
            return false;
        }
        return baseDataIdListFromNew.containsAll(baseDataIdListFromOld);
    }

    public static Map<Long, DynamicObject> getStructInfoByOrgId(Set<Long> adminOrgIds, Date queryDate) {
        if (CollectionUtils.isEmpty(adminOrgIds) || queryDate == null) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        HRBaseServiceHelper structServiceHelper = new HRBaseServiceHelper("haos_adminorgstruct");
        QFilter filter = new QFilter("adminorg", "in", adminOrgIds);
        filter.and("iscurrentversion", "=", (Object)"0");
        filter.and((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get());
        filter.and("enable", "=", (Object)"1");
        filter.and("datastatus", "=", (Object)"1");
        filter.and("initstatus", "=", (Object)"2");
        filter.and("bsed", "<=", (Object)queryDate);
        filter.and("bsled", ">=", (Object)queryDate);
        DynamicObject[] structInfos = structServiceHelper.queryOriginalArray("adminorg, structlongnumber, level", new QFilter[]{filter});
        return Arrays.stream(structInfos).collect(Collectors.toMap(dyn -> dyn.getLong("adminorg"), dyn -> dyn));
    }
}

