/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.staff.MuldimDetailRepository;
import kd.hr.haos.business.domain.repository.staff.OrgPersonStaffInfoRepository;
import kd.hr.haos.business.domain.repository.staff.PersonStaffInfoRepository;
import kd.hr.haos.business.domain.repository.staff.StaffDimensionRepository;
import kd.hr.haos.business.domain.repository.staff.UseOrgDetailRepository;
import kd.hr.haos.business.domain.service.impl.staff.MuldimUseStaffServiceImpl;
import kd.hr.haos.business.domain.service.impl.staff.OrgPersonStaffInfoServiceImpl;
import kd.hr.haos.business.domain.service.impl.staff.OrgUseStaffDetailServiceImpl;
import kd.hr.haos.business.domain.service.impl.staff.PersonChangeEventServiceImpl;
import kd.hr.haos.business.domain.service.impl.staff.PersonStaffInfoServiceImpl;
import kd.hr.haos.business.domain.service.staff.IMuldimUseStaffService;
import kd.hr.haos.business.domain.service.staff.IOrgPersonStaffInfoService;
import kd.hr.haos.business.domain.service.staff.IOrgUseStaffDetailService;
import kd.hr.haos.business.domain.service.staff.IPersonChangeEventService;
import kd.hr.haos.business.domain.service.staff.IPersonStaffInfoService;
import kd.hr.haos.business.service.staff.bean.StaffBillDataBO;
import kd.hr.haos.business.service.staff.service.IPersonStaffService;
import kd.hr.haos.business.util.StaffActivityHelper;
import kd.hr.haos.common.constants.staff.DynamicDimensionEnum;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.common.model.org.staff.StaffUseInParam;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class PersonStaffServiceImpl
implements IPersonStaffService,
OrgStaffConstants {
    private static final Log logger = LogFactory.getLog(PersonStaffServiceImpl.class);
    private IPersonStaffInfoService personStaffInfoService = new PersonStaffInfoServiceImpl();
    private IOrgPersonStaffInfoService orgPersonStaffInfoService = new OrgPersonStaffInfoServiceImpl();
    private IMuldimUseStaffService muldimUseStaffService = new MuldimUseStaffServiceImpl();
    private IOrgUseStaffDetailService orgUseStaffDetailService = new OrgUseStaffDetailServiceImpl();
    private IPersonChangeEventService personChangeEventService = new PersonChangeEventServiceImpl();
    private MainEntityType personStaffInfoEntityType = MetadataServiceHelper.getDataEntityType((String)"haos_personstaffinfo");
    private MainEntityType orgPersonStaffInfoEntityType = MetadataServiceHelper.getDataEntityType((String)"haos_orgpersonstaffinfo");
    private MainEntityType orgUseStaffDetailEntityType = MetadataServiceHelper.getDataEntityType((String)"haos_orgusestaffdetail");
    private MainEntityType muldimUseStaffEntityType = MetadataServiceHelper.getDataEntityType((String)"haos_muldimusestaff");
    private MainEntityType personChangeEventEntityType = MetadataServiceHelper.getDataEntityType((String)"haos_personchangeevent");
    private static List<String> dimensionKeys = new ArrayList<String>(16);
    private Map<String, Method> dimensionMethodMap = new HashMap<String, Method>(16);
    Map<Long, DynamicObject> userOrgDetailMap = new HashMap<Long, DynamicObject>(16);
    Map<String, Map<Long, Map<Long, DynamicObject>>> orgToMuldimUseStaffMap = new HashMap<String, Map<Long, Map<Long, DynamicObject>>>(16);
    Map<String, DynamicObject> staffActivityMap = new HashMap<String, DynamicObject>(16);
    private static Map<String, String> dimensionToParamKeyMap = new HashMap<String, String>(16);
    private List<DynamicObject> personStaffInfoList;
    private Map<Long, Long> personStaffInfoMap;
    private List<DynamicObject> orgPersonStaffInfoList;
    private List<DynamicObject> orgUseStaffDetailList;
    private List<DynamicObject> muldimUseStaffList;
    private List<DynamicObject> personChangeEventList;
    private List<Long> needDelStaffPerson;
    private Map<Long, String> orgUseStaffDetailIdToEventActNumberMap;
    private Map<Long, Map<String, DynamicObject>> depEmpIdToReleasingDataMap;
    private Map<Long, DynamicObject> depEmpIdToOldOrgUseStaffDetailMap;
    private Map<Long, List<DynamicObject>> depEmpIdToOldMuldimUseStaffMap;

    private void init(List<StaffUseInParam> staffUseInParamList) {
        this.personStaffInfoList = new ArrayList<DynamicObject>(staffUseInParamList.size());
        this.orgPersonStaffInfoList = new ArrayList<DynamicObject>(staffUseInParamList.size());
        this.orgUseStaffDetailList = new ArrayList<DynamicObject>(staffUseInParamList.size());
        this.muldimUseStaffList = new ArrayList<DynamicObject>(staffUseInParamList.size());
        this.personChangeEventList = new ArrayList<DynamicObject>(staffUseInParamList.size());
        this.personStaffInfoMap = Maps.newHashMapWithExpectedSize((int)staffUseInParamList.size());
        this.needDelStaffPerson = new ArrayList<Long>(staffUseInParamList.size());
        this.orgUseStaffDetailIdToEventActNumberMap = Maps.newHashMapWithExpectedSize((int)staffUseInParamList.size());
        this.depEmpIdToReleasingDataMap = Maps.newHashMapWithExpectedSize((int)staffUseInParamList.size());
        this.depEmpIdToOldOrgUseStaffDetailMap = Maps.newHashMapWithExpectedSize((int)staffUseInParamList.size());
        this.depEmpIdToOldMuldimUseStaffMap = Maps.newHashMapWithExpectedSize((int)staffUseInParamList.size());
        ArrayList<Long> orgIds = new ArrayList<Long>(staffUseInParamList.size());
        ArrayList<String> changeEventNumbers = new ArrayList<String>(staffUseInParamList.size());
        HashMap<String, List<Long>> dimensionMap = new HashMap<String, List<Long>>(16);
        for (StaffUseInParam staffUseInParam : staffUseInParamList) {
            orgIds.add(staffUseInParam.getOrgTeamId());
            changeEventNumbers.add(staffUseInParam.getChangeEventNumber());
            this.buildDimensionMethodMap(dimensionMap, staffUseInParam);
        }
        this.userOrgDetailMap = this.getUserOrgDetailMap(orgIds);
        ArrayList<StaffUseInParam> needRemoveParams = new ArrayList<StaffUseInParam>(10);
        for (StaffUseInParam staffUseInParam : staffUseInParamList) {
            if (this.userOrgDetailMap.get(staffUseInParam.getOrgTeamId()) != null) continue;
            needRemoveParams.add(staffUseInParam);
        }
        staffUseInParamList.removeAll(needRemoveParams);
        this.orgToMuldimUseStaffMap = this.getOrgToMuldimUseStaffMap(orgIds, dimensionMap);
        this.staffActivityMap = this.getStaffActivityMap(changeEventNumbers);
        this.getOldUseStaffMap(staffUseInParamList);
    }

    private void buildDimensionMethodMap(Map<String, List<Long>> dimensionMap, StaffUseInParam staffUseInParam) {
        for (String dimensionKey : dimensionKeys) {
            if (!dimensionMap.containsKey(dimensionKey)) {
                dimensionMap.put(dimensionKey, new ArrayList(16));
            }
            if (!this.dimensionMethodMap.containsKey(dimensionKey)) {
                try {
                    PropertyDescriptor pd = new PropertyDescriptor(dimensionToParamKeyMap.get(dimensionKey), StaffUseInParam.class);
                    Method method = pd.getReadMethod();
                    this.dimensionMethodMap.put(dimensionKey, method);
                }
                catch (IntrospectionException e) {
                    throw new KDBizException(new ErrorCode("hrmp.haos.intenerError", e.getMessage()), new Object[0]);
                }
            }
            try {
                Long dimensionValue = (Long)this.dimensionMethodMap.get(dimensionKey).invoke((Object)staffUseInParam, new Object[0]);
                if (this.isEmptyOfLong(dimensionValue)) continue;
                dimensionMap.get(dimensionKey).add((Long)this.dimensionMethodMap.get(dimensionKey).invoke((Object)staffUseInParam, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new KDBizException(new ErrorCode("hrmp.haos.intenerError", e.getMessage()), new Object[0]);
            }
        }
        this.executeDynamicDimension(dimensionMap, staffUseInParam);
    }

    private List<String> getAllDynamicDimenSion() {
        DynamicObject[] dynamicObjects = StaffDimensionRepository.getInstance().listAllDimension();
        List<String> staffdimension = Arrays.stream(dynamicObjects).map(temp -> temp.getString("staffdimension")).collect(Collectors.toList());
        return staffdimension;
    }

    private void executeDynamicDimension(Map<String, List<Long>> dimensionMap, StaffUseInParam staffUseInParam) {
        List<String> allDynamicDimenSion = this.getAllDynamicDimenSion();
        for (String dimension : allDynamicDimenSion) {
            Map other = staffUseInParam.getOther();
            Long dimensionValue = (Long)other.get(dimension);
            if (dimensionValue == null || dimensionValue == 0L) continue;
            List<Long> dimensionValueList = dimensionMap.get(dimension);
            if (dimensionValueList == null) {
                dimensionValueList = new ArrayList<Long>(16);
            }
            dimensionValueList.add(dimensionValue);
            dimensionMap.put(dimension, dimensionValueList);
        }
    }

    @Override
    public void staffTry(List<StaffUseInParam> staffUseInParamList) throws Exception {
        if (CollectionUtils.isEmpty(staffUseInParamList)) {
            return;
        }
        this.init(staffUseInParamList);
        this.buildAndSaveData(staffUseInParamList, "0");
    }

    @Override
    public void staffConfirm(List<StaffUseInParam> staffUseInParamList) {
        List<Long> billIdList = staffUseInParamList.stream().map(StaffUseInParam::getBizBillId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(billIdList)) {
            return;
        }
        StaffBillDataBO staffBillDataBO = new StaffBillDataBO(billIdList, new ArrayList<Long>(), true, true, false);
        staffBillDataBO.getNeedUpdateOldData();
        this.orgUseStaffDetailService.update(staffBillDataBO.getHisOrgUseStaffDetailList());
        this.muldimUseStaffService.update(staffBillDataBO.getHisMuldimUseStaffList());
        String status = "1";
        this.personStaffInfoService.update(this.setStatus(staffBillDataBO.getSchedulEffectPersonStaffList(), status));
        this.orgUseStaffDetailService.update(this.setStatus(staffBillDataBO.getSchedulEffectOrgUseStaffDetailList(), status));
        this.muldimUseStaffService.update(this.setStatus(staffBillDataBO.getSchedulEffectMuldimUseStaffList(), status));
        List<Long> candidateIdList = staffUseInParamList.stream().filter(staffUseInParam -> HRStringUtils.equals((String)staffUseInParam.getChangeEventNumber(), (String)"1010_S")).map(StaffUseInParam::getCandidateId).collect(Collectors.toList());
        staffBillDataBO.getOfferDataByStaffPersonId(candidateIdList);
        this.delData(staffBillDataBO, true, false, false);
    }

    @Override
    public void staffRollback(List<Long> billIdList) {
        if (CollectionUtils.isEmpty(billIdList)) {
            return;
        }
        StaffBillDataBO staffBillDataBO = new StaffBillDataBO(billIdList, new ArrayList<Long>(), false, true, false);
        this.delData(staffBillDataBO, false, true, false);
    }

    @Override
    public void msgEffect(List<StaffUseInParam> staffUseInParamList) throws Exception {
        if (CollectionUtils.isEmpty(staffUseInParamList)) {
            return;
        }
        this.init(staffUseInParamList);
        List<Long> billIdList = staffUseInParamList.stream().map(StaffUseInParam::getBizBillId).collect(Collectors.toList());
        List<Long> depEmpIdList = staffUseInParamList.stream().filter(param -> !this.isEmptyOfLong(param.getDepEmpId())).map(StaffUseInParam::getDepEmpId).collect(Collectors.toList());
        StaffBillDataBO staffBillDataBO = new StaffBillDataBO(billIdList, depEmpIdList, true, false, false);
        this.depEmpIdToReleasingDataMap = staffBillDataBO.getDepEmpIdToReleasingDataMap();
        this.buildAndSaveData(staffUseInParamList, "1");
        staffBillDataBO.getNeedUpdateOldData(this.orgUseStaffDetailList, this.orgUseStaffDetailIdToEventActNumberMap);
        this.orgUseStaffDetailService.update(staffBillDataBO.getHisOrgUseStaffDetailList());
        this.muldimUseStaffService.update(staffBillDataBO.getHisMuldimUseStaffList());
        this.delData(staffBillDataBO, true, true, false);
    }

    @Override
    public void msgAbortProcess(List<StaffUseInParam> staffUseInParamList) {
        ArrayList staffInAddTerminateList = Lists.newArrayListWithExpectedSize((int)staffUseInParamList.size());
        ArrayList staffMoveChangeTerminateList = Lists.newArrayListWithExpectedSize((int)staffUseInParamList.size());
        for (StaffUseInParam staffUseInParam : staffUseInParamList) {
            if (!this.isEmptyOfLong(staffUseInParam.getCandidateId())) {
                staffInAddTerminateList.add(staffUseInParam);
                continue;
            }
            if (this.isEmptyOfLong(staffUseInParam.getDepEmpId())) continue;
            staffMoveChangeTerminateList.add(staffUseInParam);
        }
        this.abortInAddProcess(staffInAddTerminateList);
        this.abortMoveChangeProcess(staffMoveChangeTerminateList);
    }

    @Override
    public void syncAdd(List<StaffUseInParam> staffUseInParamList) throws Exception {
        if (CollectionUtils.isEmpty(staffUseInParamList)) {
            return;
        }
        this.init(staffUseInParamList);
        this.buildAndSaveData(staffUseInParamList, "1");
    }

    private void abortInAddProcess(List<StaffUseInParam> staffUseInParamList) {
        if (CollectionUtils.isEmpty(staffUseInParamList)) {
            return;
        }
        List<Long> billIdList = staffUseInParamList.stream().map(StaffUseInParam::getBizBillId).collect(Collectors.toList());
        StaffBillDataBO staffBillDataBO = new StaffBillDataBO(billIdList, new ArrayList<Long>(), false, false, true);
        this.delData(staffBillDataBO, true, true, true);
    }

    private void abortMoveChangeProcess(List<StaffUseInParam> staffUseInParamList) {
        if (CollectionUtils.isEmpty(staffUseInParamList)) {
            return;
        }
        List<Long> depEmpIdList = staffUseInParamList.stream().map(StaffUseInParam::getDepEmpId).collect(Collectors.toList());
        List<Long> billIdList = staffUseInParamList.stream().map(StaffUseInParam::getBizBillId).collect(Collectors.toList());
        StaffBillDataBO staffBillDataBO = new StaffBillDataBO(billIdList, depEmpIdList, true, false, true);
        staffBillDataBO.getNeedUpdateOldData();
        this.orgUseStaffDetailService.update(staffBillDataBO.getHisOrgUseStaffDetailList());
        this.muldimUseStaffService.update(staffBillDataBO.getHisMuldimUseStaffList());
        this.orgPersonStaffInfoService.update(staffBillDataBO.getHisPersonDimList());
        this.delData(staffBillDataBO, true, true, false);
    }

    private void buildAndSaveData(List<StaffUseInParam> staffUseInParamList, String status) throws Exception {
        Map<Long, Long> billToPersonIdMap = this.getBillToPersonIdMap(staffUseInParamList);
        ArrayList<Long> depEmpIdList = new ArrayList<Long>();
        DynamicObject[] staffPersons = PersonStaffInfoRepository.getInstance().queryById(new ArrayList<Long>(billToPersonIdMap.values()));
        Map<Long, DynamicObject> staffPersonsMap = Arrays.stream(staffPersons).collect(Collectors.toMap(staffPerson -> staffPerson.getLong("id"), staffPerson -> staffPerson));
        ArrayList<DynamicObject> staffPersonList = new ArrayList<DynamicObject>();
        ArrayList<StaffUseInParam> moveInEffectParam = new ArrayList<StaffUseInParam>();
        List<Long> existOrgPersonStaffInfoList = this.getExistOrgPersonStaffInfoByDepempId(staffUseInParamList);
        HashMap depEmpIdToLeffdt = Maps.newHashMapWithExpectedSize((int)staffUseInParamList.size());
        for (StaffUseInParam staffUseInParam : staffUseInParamList) {
            if (this.isReleaseStaffScene(staffUseInParam) && this.depEmpIdToOldOrgUseStaffDetailMap.get(staffUseInParam.getDepEmpId()) == null) continue;
            this.getMoveOutDepEmpIdList(staffUseInParam, depEmpIdList, depEmpIdToLeffdt);
            this.getMoveInStaffUseInParam(staffUseInParam, moveInEffectParam);
            if (staffUseInParam.getOther().containsKey("haos_noWriteStaffData")) {
                logger.info("match special rule");
                continue;
            }
            Long personStaffInfoId = this.getPersonStaffInfoId(staffUseInParam, billToPersonIdMap, status);
            this.getUpdatePersonStaffInfo(staffUseInParam, personStaffInfoId, staffPersonsMap, staffPersonList);
            DynamicObject orgUseStaffDetail = this.buildOrgUseStaffDetail(staffUseInParam, personStaffInfoId, status);
            Long orgUseStaffDetailId = orgUseStaffDetail.getLong("id");
            this.buildMuldimUseStaff(staffUseInParam, personStaffInfoId, orgUseStaffDetail);
            this.buildPersonChangeEvent(staffUseInParam, personStaffInfoId, orgUseStaffDetailId);
            this.buildMoveInOrgPersonStaffInfo(staffUseInParam, personStaffInfoId, existOrgPersonStaffInfoList);
            this.orgUseStaffDetailIdToEventActNumberMap.put(orgUseStaffDetailId, staffUseInParam.getChangeEventNumber());
        }
        if (depEmpIdList.size() > 0) {
            List<DynamicObject> schedulInvalidOrgPersonStaffInfoList = this.getSchedulInvalidOrgPersonStaffInfo(depEmpIdList, depEmpIdToLeffdt);
            this.orgPersonStaffInfoService.update(schedulInvalidOrgPersonStaffInfoList);
        }
        if (staffPersonList.size() > 0) {
            this.personStaffInfoService.update(staffPersonList);
        }
        if (this.needDelStaffPerson.size() > 0) {
            this.personStaffInfoService.deleteByIds(this.needDelStaffPerson);
        }
        this.addData();
        if (moveInEffectParam.size() > 0) {
            this.updateMoveOutOrgDetail(moveInEffectParam);
        }
    }

    private List<Long> getExistOrgPersonStaffInfoByDepempId(List<StaffUseInParam> staffUseInParamList) {
        List<Long> depEmpIdList = staffUseInParamList.stream().filter(param -> !this.isEmptyOfLong(param.getDepEmpId())).map(StaffUseInParam::getDepEmpId).collect(Collectors.toList());
        return this.orgPersonStaffInfoService.queryEffectingDepempId(depEmpIdList);
    }

    private void getMoveOutDepEmpIdList(StaffUseInParam staffUseInParam, List<Long> depEmpIdList, Map<Long, Date> depEmpIdToLeffdt) {
        if (HRStringUtils.equals((String)staffUseInParam.getChangeEventNumber(), (String)"1040_S") || HRStringUtils.equals((String)staffUseInParam.getChangeEventNumber(), (String)"1080_S")) {
            if (staffUseInParam.getOther().containsKey("haos_nodeEffect") || staffUseInParam.isUpdate()) {
                return;
            }
            Long depEmpId = staffUseInParam.getDepEmpId();
            Date date = HRDateTimeUtils.truncateDate((Date)staffUseInParam.getEffDate());
            depEmpIdList.add(depEmpId);
            depEmpIdToLeffdt.put(depEmpId, HRDateTimeUtils.addDay((Date)date, (long)-1L));
        }
    }

    private Long getPersonStaffInfoId(StaffUseInParam staffUseInParam, Map<Long, Long> billToPersonIdMap, String status) {
        Long bizBillId;
        Long personStaffInfoId = this.getPersonStaffInfoIdFromMap(staffUseInParam);
        if (this.isEmptyOfLong(personStaffInfoId) && this.isEmptyOfLong(personStaffInfoId = billToPersonIdMap.get(bizBillId = staffUseInParam.getBizBillId()))) {
            personStaffInfoId = this.buildPersonStaffInfo(staffUseInParam, status);
        }
        return personStaffInfoId;
    }

    private Long getPersonStaffInfoIdFromMap(StaffUseInParam staffUseInParam) {
        Long personKey = this.getPersonKey(staffUseInParam);
        return this.personStaffInfoMap.get(personKey);
    }

    private void getUpdatePersonStaffInfo(StaffUseInParam staffUseInParam, Long personStaffInfoId, Map<Long, DynamicObject> staffPersonsMap, List<DynamicObject> staffPersonList) {
        DynamicObject personDyn;
        if (HRStringUtils.equals((String)staffUseInParam.getChangeEventNumber(), (String)"1020_S") && (personDyn = staffPersonsMap.get(personStaffInfoId)) != null) {
            personDyn.set("person", (Object)staffUseInParam.getPersonId());
            personDyn.set("status", (Object)"1");
            staffPersonList.add(personDyn);
        }
    }

    private void buildMoveInOrgPersonStaffInfo(StaffUseInParam staffUseInParam, Long personStaffInfoId, List<Long> existOrgPersonStaffInfoList) {
        if (HRStringUtils.equals((String)staffUseInParam.getChangeEventNumber(), (String)"1020_S") || HRStringUtils.equals((String)staffUseInParam.getChangeEventNumber(), (String)"1060_S")) {
            if (staffUseInParam.getOther().containsKey("haos_nodeEffect")) {
                return;
            }
            Long personId = staffUseInParam.getPersonId();
            if (!this.isEmptyOfLong(personId) && !existOrgPersonStaffInfoList.contains(personId)) {
                this.buildOrgPersonStaffInfo(personStaffInfoId, staffUseInParam, "1");
            }
        }
    }

    private void getMoveInStaffUseInParam(StaffUseInParam staffUseInParam, List<StaffUseInParam> moveInEffectParam) {
        if (HRStringUtils.equals((String)staffUseInParam.getChangeEventNumber(), (String)"1060_S")) {
            moveInEffectParam.add(staffUseInParam);
        }
    }

    private void updateMoveOutOrgDetail(List<StaffUseInParam> moveInEffectParam) throws Exception {
        List<Long> depEmpIdList = moveInEffectParam.stream().map(param -> (Long)param.getOther().get("oldDepEmpId")).collect(Collectors.toList());
        Map<Long, Map<String, DynamicObject>> depEmpIdToReleasingDataMap = this.personChangeEventService.getDepEmpIdToReleasingDataMap(depEmpIdList);
        ArrayList moveOutParamList = Lists.newArrayListWithExpectedSize((int)16);
        for (StaffUseInParam param2 : moveInEffectParam) {
            JSONObject paramJson = (JSONObject)JSONObject.toJSON((Object)param2);
            Long depEmpId = (Long)param2.getOther().get("oldDepEmpId");
            DynamicObject event = (DynamicObject)((Map)depEmpIdToReleasingDataMap.getOrDefault(depEmpId, new HashMap())).get("1030_S");
            if (event == null) {
                event = (DynamicObject)((Map)depEmpIdToReleasingDataMap.getOrDefault(depEmpId, new HashMap())).get("1040_S");
            }
            if (event == null) continue;
            StaffUseInParam leaveParam = (StaffUseInParam)JSONObject.toJavaObject((JSON)paramJson, StaffUseInParam.class);
            leaveParam.setChangeEventNumber(event.getDynamicObject("changeevent").getString("number"));
            leaveParam.setEffDate(event.getDate("effdt"));
            leaveParam.setBizBillId(Long.valueOf(event.getLong("perevent")));
            leaveParam.setBeforeChange(Boolean.FALSE);
            leaveParam.setUpdate(true);
            moveOutParamList.add(leaveParam);
        }
        this.staffTry(moveOutParamList);
        this.staffConfirm(moveOutParamList);
    }

    private void addData() {
        this.personStaffInfoService.save(this.personStaffInfoList);
        this.orgUseStaffDetailService.save(this.orgUseStaffDetailList);
        this.muldimUseStaffService.save(this.muldimUseStaffList);
        this.personChangeEventService.save(this.personChangeEventList);
        this.orgPersonStaffInfoService.save(this.orgPersonStaffInfoList);
    }

    private void delData(StaffBillDataBO staffBillDataBO, boolean delEffect, boolean delSchedul, boolean delPerson) {
        if (delEffect) {
            this.orgUseStaffDetailService.deleteByIds(this.getListDynId(staffBillDataBO.getEffectOrgUseStaffDetailList()));
            this.muldimUseStaffService.deleteByIds(this.getListDynId(staffBillDataBO.getEffectMuldimUseStaffList()));
            this.personChangeEventService.deleteByIds(staffBillDataBO.getEffectChangeEventIdList());
            this.orgUseStaffDetailService.deleteByIds(this.getListDynId(staffBillDataBO.getOfferOrgUseStaffList()));
            this.muldimUseStaffService.deleteByIds(this.getListDynId(staffBillDataBO.getOfferMuldimUseStaffList()));
            this.personChangeEventService.deleteByIds(staffBillDataBO.getOfferEventIdList());
        }
        if (delSchedul) {
            this.personStaffInfoService.deleteByIds(this.getListDynId(staffBillDataBO.getSchedulEffectPersonStaffList()));
            this.orgUseStaffDetailService.deleteByIds(this.getListDynId(staffBillDataBO.getSchedulEffectOrgUseStaffDetailList()));
            this.muldimUseStaffService.deleteByIds(this.getListDynId(staffBillDataBO.getSchedulEffectMuldimUseStaffList()));
            this.personChangeEventService.deleteByIds(staffBillDataBO.getSchedulEffectChangeEventIdList());
        }
        if (delPerson) {
            this.personStaffInfoService.deleteByIds(staffBillDataBO.getPersonStaffIdList());
        }
    }

    private List<DynamicObject> getSchedulInvalidOrgPersonStaffInfo(List<Long> depEmpIdList, Map<Long, Date> depEmpIdToLeffdt) {
        ArrayList schedulInvalidData = Lists.newArrayListWithExpectedSize((int)depEmpIdList.size());
        if (depEmpIdList.size() == 0) {
            return schedulInvalidData;
        }
        DynamicObject[] schedulInvalidOrgPersonStaffInfos = OrgPersonStaffInfoRepository.getInstance().queryEffectDataByDepempId(depEmpIdList);
        if (schedulInvalidOrgPersonStaffInfos == null || schedulInvalidOrgPersonStaffInfos.length == 0) {
            return schedulInvalidData;
        }
        for (DynamicObject dyn : schedulInvalidOrgPersonStaffInfos) {
            dyn.set("status", (Object)"2");
            dyn.set("leffdt", (Object)depEmpIdToLeffdt.get(dyn.getLong("orgperson_id")));
        }
        return Arrays.asList(schedulInvalidOrgPersonStaffInfos);
    }

    private void buildPersonChangeEvent(StaffUseInParam staffUseInParam, Long personStaffInfoId, Long orgUseStaffDetailId) {
        DynamicObject personChangeEvent = new DynamicObject((DynamicObjectType)this.personChangeEventEntityType);
        if (this.staffActivityMap.containsKey(staffUseInParam.getChangeEventNumber())) {
            personChangeEvent.set("changeevent", this.staffActivityMap.get(staffUseInParam.getChangeEventNumber()).get("id"));
            personChangeEvent.set("eventtype", this.staffActivityMap.get(staffUseInParam.getChangeEventNumber()).get("staffactivitytype"));
            Long personChangeEventId = ID.genLongId();
            personChangeEvent.set("id", (Object)personChangeEventId);
            personChangeEvent.set("staffperson", (Object)personStaffInfoId);
            personChangeEvent.set("orgusestaffdetail", (Object)orgUseStaffDetailId);
            personChangeEvent.set("perevent", (Object)staffUseInParam.getBizBillId());
            personChangeEvent.set("effdt", (Object)HRDateTimeUtils.truncateDate((Date)staffUseInParam.getEffDate()));
            personChangeEvent.set("creator", (Object)RequestContext.get().getCurrUserId());
            personChangeEvent.set("createtime", (Object)new Date());
            this.personChangeEventList.add(personChangeEvent);
        }
    }

    private void buildMuldimUseStaff(StaffUseInParam staffUseInParam, Long personStaffInfoId, DynamicObject orgUseStaffDetail) throws Exception {
        if (this.isReleaseStaffScene(staffUseInParam)) {
            this.buildReleaseMuldimUseStaff(staffUseInParam, personStaffInfoId, orgUseStaffDetail);
            return;
        }
        for (Map.Entry<String, Map<Long, Map<Long, DynamicObject>>> orgToMuldimUseStaff : this.orgToMuldimUseStaffMap.entrySet()) {
            Map<Long, DynamicObject> sameOrgMuldimUseStaff = orgToMuldimUseStaff.getValue().get(staffUseInParam.getOrgTeamId());
            String dimensionKey = orgToMuldimUseStaff.getKey();
            Method method = this.dimensionMethodMap.get(dimensionKey);
            if (sameOrgMuldimUseStaff == null || sameOrgMuldimUseStaff.isEmpty()) continue;
            DynamicObject muldimUseStaff = new DynamicObject((DynamicObjectType)this.muldimUseStaffEntityType);
            Long muldimUseStaffId = ID.genLongId();
            muldimUseStaff.set("id", (Object)muldimUseStaffId);
            muldimUseStaff.set("personstaffinfo", (Object)personStaffInfoId);
            muldimUseStaff.set("orgusestaffdetail", (Object)orgUseStaffDetail.getLong("id"));
            if (method != null) {
                if (sameOrgMuldimUseStaff.get(method.invoke((Object)staffUseInParam, new Object[0])) == null) continue;
                muldimUseStaff.set("muldimendetail", (Object)sameOrgMuldimUseStaff.get(method.invoke((Object)staffUseInParam, new Object[0])).getLong("id"));
                muldimUseStaff.set("bo", (Object)sameOrgMuldimUseStaff.get(method.invoke((Object)staffUseInParam, new Object[0])).getLong("bo"));
            } else {
                muldimUseStaff.set("muldimendetail", (Object)sameOrgMuldimUseStaff.get(this.getStaffUseInParamOtherDimension(staffUseInParam, dimensionKey)).getLong("id"));
                muldimUseStaff.set("bo", (Object)sameOrgMuldimUseStaff.get(this.getStaffUseInParamOtherDimension(staffUseInParam, dimensionKey)).getLong("bo"));
            }
            if (this.staffActivityMap.containsKey(staffUseInParam.getChangeEventNumber())) {
                muldimUseStaff.set("stafftype", this.staffActivityMap.get(staffUseInParam.getChangeEventNumber()).get("controltype"));
            } else {
                muldimUseStaff.set("stafftype", (Object)"1");
            }
            muldimUseStaff.set("status", (Object)orgUseStaffDetail.getString("status"));
            this.setEffdtAndCreator(muldimUseStaff, staffUseInParam);
            muldimUseStaff.set("effdt", (Object)orgUseStaffDetail.getDate("effdt"));
            muldimUseStaff.set("leffdt", (Object)orgUseStaffDetail.getDate("leffdt"));
            this.muldimUseStaffList.add(muldimUseStaff);
        }
    }

    private DynamicObject buildOrgUseStaffDetail(StaffUseInParam staffUseInParam, Long personStaffInfoId, String status) {
        DynamicObject orgUseStaffDetail = new DynamicObject((DynamicObjectType)this.orgUseStaffDetailEntityType);
        Long orgUseStaffDetailId = ID.genLongId();
        orgUseStaffDetail.set("id", (Object)orgUseStaffDetailId);
        orgUseStaffDetail.set("useorg", (Object)staffUseInParam.getOrgTeamId());
        orgUseStaffDetail.set("useorgdetail", (Object)this.userOrgDetailMap.get(staffUseInParam.getOrgTeamId()).getLong("id"));
        orgUseStaffDetail.set("bo", (Object)this.userOrgDetailMap.get(staffUseInParam.getOrgTeamId()).getLong("bo"));
        orgUseStaffDetail.set("personstaffinfo", (Object)personStaffInfoId);
        if (Objects.nonNull(staffUseInParam.getDepEmpId())) {
            orgUseStaffDetail.set("orgperson", (Object)staffUseInParam.getDepEmpId());
        }
        if (this.staffActivityMap.containsKey(staffUseInParam.getChangeEventNumber())) {
            orgUseStaffDetail.set("stafftype", this.staffActivityMap.get(staffUseInParam.getChangeEventNumber()).get("controltype"));
        } else {
            orgUseStaffDetail.set("stafftype", (Object)"1");
        }
        orgUseStaffDetail.set("status", (Object)status);
        this.setEffdtAndCreator(orgUseStaffDetail, staffUseInParam);
        if (HRStringUtils.equals((String)staffUseInParam.getChangeEventNumber(), (String)"1020_S") || HRStringUtils.equals((String)staffUseInParam.getChangeEventNumber(), (String)"1060_S")) {
            this.setStatusAndEffctDateByReleasingData(staffUseInParam.getDepEmpId(), orgUseStaffDetail);
        }
        this.orgUseStaffDetailList.add(orgUseStaffDetail);
        return orgUseStaffDetail;
    }

    private void setStatusAndEffctDateByReleasingData(Long depEmpId, DynamicObject orgUseStaffDetail) {
        if (this.isEmptyOfLong(depEmpId)) {
            return;
        }
        Map<String, DynamicObject> releasingData = this.depEmpIdToReleasingDataMap.get(depEmpId);
        if (releasingData == null) {
            return;
        }
        DynamicObject event = (DynamicObject)((Map)this.depEmpIdToReleasingDataMap.getOrDefault(depEmpId, new HashMap())).get("1070_S");
        if (event == null) {
            event = (DynamicObject)((Map)this.depEmpIdToReleasingDataMap.getOrDefault(depEmpId, new HashMap())).get("1080_S");
        }
        if (event == null) {
            event = (DynamicObject)((Map)this.depEmpIdToReleasingDataMap.getOrDefault(depEmpId, new HashMap())).get("1030_S");
        }
        if (event == null) {
            event = (DynamicObject)((Map)this.depEmpIdToReleasingDataMap.getOrDefault(depEmpId, new HashMap())).get("1040_S");
        }
        if (event == null) {
            return;
        }
        Date effdt = event.getDate("effdt");
        Date leffdt = HRDateTimeUtils.addDay((Date)effdt, (long)-1L);
        orgUseStaffDetail.set("leffdt", (Object)leffdt);
        if (HRDateTimeUtils.dayBefore((Date)leffdt, (Date)orgUseStaffDetail.getDate("effdt"))) {
            orgUseStaffDetail.set("status", (Object)"-1");
        } else {
            orgUseStaffDetail.set("status", (Object)"2");
        }
    }

    private void buildOrgPersonStaffInfo(Long personStaffInfoId, StaffUseInParam staffUseInParam, String status) {
        DynamicObject orgPersonStaffInfo = new DynamicObject((DynamicObjectType)this.orgPersonStaffInfoEntityType);
        Long orgPersonStaffInfoId = ID.genLongId();
        orgPersonStaffInfo.set("id", (Object)orgPersonStaffInfoId);
        orgPersonStaffInfo.set("personstaffinfo", (Object)personStaffInfoId);
        orgPersonStaffInfo.set("candidate", (Object)staffUseInParam.getCandidateId());
        orgPersonStaffInfo.set("person", (Object)staffUseInParam.getPersonId());
        orgPersonStaffInfo.set("orgperson", (Object)staffUseInParam.getDepEmpId());
        orgPersonStaffInfo.set("orgteam", (Object)staffUseInParam.getOrgTeamId());
        orgPersonStaffInfo.set("dutyworkrole", (Object)staffUseInParam.getDutyWorkRoleId());
        orgPersonStaffInfo.set("job", (Object)staffUseInParam.getJobId());
        orgPersonStaffInfo.set("laborrelType", (Object)staffUseInParam.getLaborRelTypeId());
        orgPersonStaffInfo.set("status", (Object)status);
        this.setEffdtAndCreator(orgPersonStaffInfo, staffUseInParam);
        Map other = staffUseInParam.getOther();
        other.forEach((basicdata, value) -> {
            DynamicDimensionEnum match = DynamicDimensionEnum.match((String)basicdata);
            if (match != null) {
                orgPersonStaffInfo.set(basicdata, value);
            }
        });
        this.orgPersonStaffInfoList.add(orgPersonStaffInfo);
    }

    private Long buildPersonStaffInfo(StaffUseInParam staffUseInParam, String status) {
        DynamicObject personStaffInfo = new DynamicObject((DynamicObjectType)this.personStaffInfoEntityType);
        Long personStaffInfoId = ID.genLongId();
        personStaffInfo.set("id", (Object)personStaffInfoId);
        personStaffInfo.set("person", (Object)staffUseInParam.getPersonId());
        personStaffInfo.set("candidate", (Object)staffUseInParam.getCandidateId());
        personStaffInfo.set("status", (Object)status);
        this.setEffdtAndCreator(personStaffInfo, staffUseInParam);
        this.personStaffInfoList.add(personStaffInfo);
        Long personKey = this.getPersonKey(staffUseInParam);
        this.personStaffInfoMap.put(personKey, personStaffInfoId);
        return personStaffInfoId;
    }

    private Map<String, Map<Long, Map<Long, DynamicObject>>> getOrgToMuldimUseStaffMap(List<Long> orgIds, Map<String, List<Long>> dimensionMap) {
        HashMap<String, Map<Long, Map<Long, DynamicObject>>> result = new HashMap<String, Map<Long, Map<Long, DynamicObject>>>(16);
        for (Map.Entry<String, List<Long>> dimension : dimensionMap.entrySet()) {
            DynamicObject[] muldimUseStaffs = MuldimDetailRepository.getInstance().queryMuldimDetailData(orgIds, dimension.getValue(), dimension.getKey());
            Map<Long, Map<Long, DynamicObject>> orgToMuldimUseStaff = Arrays.stream(muldimUseStaffs).filter(dyn -> dyn.getDynamicObject((String)dimension.getKey()) != null).filter(dyn -> dyn.getLong("useorg.boid") != 0L).collect(Collectors.groupingBy(muldimUseStaff -> muldimUseStaff.getLong("useorg.boid"), Collectors.toMap(muldimUseStaff -> muldimUseStaff.getDynamicObject((String)dimension.getKey()).getLong("id"), muldimUseStaff -> muldimUseStaff, (v1, v2) -> v1)));
            result.put(dimension.getKey(), orgToMuldimUseStaff);
        }
        return result;
    }

    private Map<String, DynamicObject> getStaffActivityMap(List<String> changeEventNumbers) {
        Map<String, DynamicObject> staffActivityMap = StaffActivityHelper.getStaffActivityMap();
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(16);
        for (String changeEventNumber : changeEventNumbers) {
            DynamicObject changeEvent = staffActivityMap.get(changeEventNumber);
            if (changeEvent == null) continue;
            result.put(changeEventNumber, changeEvent);
        }
        return result;
    }

    private Map<Long, DynamicObject> getUserOrgDetailMap(List<Long> orgIds) {
        DynamicObject[] useOrgDetails = UseOrgDetailRepository.getInstance().queryUseOrgDetailSimpleData(orgIds);
        return Arrays.asList(useOrgDetails).stream().collect(Collectors.toMap(useOrgDetail -> useOrgDetail.getLong("useorg.boid"), useOrgDetail -> useOrgDetail, (v1, v2) -> v1));
    }

    private void setEffdtAndCreator(DynamicObject basedata, StaffUseInParam staffUseInParam) {
        basedata.set("effdt", (Object)HRDateTimeUtils.truncateDate((Date)staffUseInParam.getEffDate()));
        basedata.set("leffdt", (Object)OrgDateTimeUtil.BSLED);
        basedata.set("creator", (Object)RequestContext.get().getCurrUserId());
        basedata.set("createtime", (Object)new Date());
    }

    private List<Long> getListDynId(List<DynamicObject> list) {
        return list.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    private List<DynamicObject> setStatus(List<DynamicObject> list, String status) {
        for (DynamicObject dynamicObject : list) {
            dynamicObject.set("status", (Object)status);
        }
        return list;
    }

    private boolean isEmptyOfLong(Long value) {
        return value == null || value == 0L;
    }

    private Map<Long, Long> getBillToPersonIdMap(List<StaffUseInParam> staffUseInParamList) {
        List<Long> bizBillIdList = staffUseInParamList.stream().map(StaffUseInParam::getBizBillId).collect(Collectors.toList());
        DynamicObject[] events = this.personChangeEventService.queryByBizBillIds(bizBillIdList);
        HashMap billToPersonIdMap = Maps.newHashMapWithExpectedSize((int)staffUseInParamList.size());
        for (DynamicObject event : events) {
            long bizBillId = event.getLong("perevent");
            long staffPerson = event.getLong("staffperson.id");
            billToPersonIdMap.put(bizBillId, staffPerson);
        }
        List<Long> personIdList = staffUseInParamList.stream().filter(staffUseInParam -> !this.isEmptyOfLong(staffUseInParam.getPersonId())).map(StaffUseInParam::getPersonId).collect(Collectors.toList());
        List<Long> candidateIdList = staffUseInParamList.stream().filter(staffUseInParam -> !this.isEmptyOfLong(staffUseInParam.getCandidateId())).map(StaffUseInParam::getCandidateId).collect(Collectors.toList());
        DynamicObject[] staffPersons = PersonStaffInfoRepository.getInstance().queryBaseInfoByPersonIdsOrCandidateId(personIdList, candidateIdList);
        HashMap personIdToStaffPersonIdMap = Maps.newHashMapWithExpectedSize((int)staffPersons.length);
        for (DynamicObject person : staffPersons) {
            Long id = person.getLong("id");
            Long personKey = this.getPersonKey(person);
            personIdToStaffPersonIdMap.put(personKey, id);
        }
        for (StaffUseInParam staffUseInParam2 : staffUseInParamList) {
            Long bizBillId = staffUseInParam2.getBizBillId();
            Long personKey = this.getPersonKey(staffUseInParam2);
            Long staffPersonFromEvent = (Long)billToPersonIdMap.get(bizBillId);
            Long staffPersonFromPersonId = (Long)personIdToStaffPersonIdMap.get(personKey);
            Long staffPerson = this.isEmptyOfLong(staffPersonFromPersonId) ? staffPersonFromEvent : staffPersonFromPersonId;
            billToPersonIdMap.put(bizBillId, staffPerson);
            if (this.isEmptyOfLong(staffPersonFromEvent) || this.isEmptyOfLong(staffPersonFromPersonId) || staffPersonFromEvent.equals(staffPersonFromPersonId)) continue;
            this.needDelStaffPerson.add(staffPersonFromEvent);
        }
        return billToPersonIdMap;
    }

    private Long getPersonKey(StaffUseInParam staffUseInParam) {
        Long personId = staffUseInParam.getPersonId();
        Long candidateId = staffUseInParam.getCandidateId();
        return this.isEmptyOfLong(personId) ? candidateId : personId;
    }

    private Long getPersonKey(DynamicObject person) {
        long personId = person.getLong("person_id");
        long candidateId = person.getLong("candidate_id");
        return this.isEmptyOfLong(personId) ? candidateId : personId;
    }

    private long getStaffUseInParamOtherDimension(StaffUseInParam staffUseInParam, String dimensionKey) {
        Map other = staffUseInParam.getOther();
        return (Long)other.get(dimensionKey);
    }

    private void buildReleaseMuldimUseStaff(StaffUseInParam staffUseInParam, Long personStaffInfoId, DynamicObject orgUseStaffDetail) {
        long depEmpId = staffUseInParam.getDepEmpId();
        List<DynamicObject> muldimUseStaffListOld = this.depEmpIdToOldMuldimUseStaffMap.get(depEmpId);
        if (CollectionUtils.isEmpty(muldimUseStaffListOld)) {
            return;
        }
        for (DynamicObject muldimUseStaffOld : muldimUseStaffListOld) {
            DynamicObject muldimUseStaff = new DynamicObject((DynamicObjectType)this.muldimUseStaffEntityType);
            HRDynamicObjectUtils.copy((DynamicObject)muldimUseStaffOld, (DynamicObject)muldimUseStaff);
            Long muldimUseStaffId = ID.genLongId();
            muldimUseStaff.set("id", (Object)muldimUseStaffId);
            muldimUseStaff.set("personstaffinfo", (Object)personStaffInfoId);
            muldimUseStaff.set("orgusestaffdetail", (Object)orgUseStaffDetail);
            if (this.staffActivityMap.containsKey(staffUseInParam.getChangeEventNumber())) {
                muldimUseStaff.set("stafftype", this.staffActivityMap.get(staffUseInParam.getChangeEventNumber()).get("controltype"));
            } else {
                muldimUseStaff.set("stafftype", (Object)"1");
            }
            muldimUseStaff.set("status", (Object)orgUseStaffDetail.getString("status"));
            this.setEffdtAndCreator(muldimUseStaff, staffUseInParam);
            muldimUseStaff.set("effdt", (Object)orgUseStaffDetail.getDate("effdt"));
            muldimUseStaff.set("leffdt", (Object)orgUseStaffDetail.getDate("leffdt"));
            this.muldimUseStaffList.add(muldimUseStaff);
        }
    }

    private boolean isReleaseStaffScene(StaffUseInParam staffUseInParam) {
        return HRStringUtils.equals((String)staffUseInParam.getChangeEventNumber(), (String)"1030_S") || HRStringUtils.equals((String)staffUseInParam.getChangeEventNumber(), (String)"1040_S") || HRStringUtils.equals((String)staffUseInParam.getChangeEventNumber(), (String)"1070_S") || HRStringUtils.equals((String)staffUseInParam.getChangeEventNumber(), (String)"1080_S");
    }

    private void getOldUseStaffMap(List<StaffUseInParam> staffUseInParamList) {
        ArrayList<Long> depEmpIdList = new ArrayList<Long>();
        for (StaffUseInParam staffUseInParam : staffUseInParamList) {
            Long depEmpId2 = staffUseInParam.getDepEmpId();
            if (depEmpId2 == null || depEmpId2 == 0L) continue;
            depEmpIdList.add(depEmpId2);
        }
        StaffBillDataBO staffBillDataBO = new StaffBillDataBO();
        List<DynamicObject> orgUseStaffDetailList = staffBillDataBO.getOccupyData(depEmpIdList);
        List<DynamicObject> muldimUseStaffs = staffBillDataBO.getMuldimUseStaff(orgUseStaffDetailList);
        this.depEmpIdToOldOrgUseStaffDetailMap = orgUseStaffDetailList.stream().collect(Collectors.toMap(dyn -> dyn.getLong("orgperson_id"), dyn -> dyn));
        Map<Long, List<DynamicObject>> orgUseStaffDetailToMulDimUseStaffDetailListMap = muldimUseStaffs.stream().collect(Collectors.groupingBy(muldimUseStaff -> muldimUseStaff.getLong("orgusestaffdetail.id")));
        this.depEmpIdToOldOrgUseStaffDetailMap.forEach((depEmpId, orgUseStaffDetail) -> {
            List orgUseStaffMuldimUseStaffs = (List)orgUseStaffDetailToMulDimUseStaffDetailListMap.get(orgUseStaffDetail.getLong("id"));
            this.depEmpIdToOldMuldimUseStaffMap.put((Long)depEmpId, orgUseStaffMuldimUseStaffs);
        });
    }

    static {
        dimensionKeys.add("dutyworkrole");
        dimensionKeys.add("job");
        dimensionKeys.add("laborreltype");
        dimensionToParamKeyMap.put("dutyworkrole", "dutyWorkRoleId");
        dimensionToParamKeyMap.put("job", "jobId");
        dimensionToParamKeyMap.put("laborreltype", "laborRelTypeId");
    }
}

