/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.staff.bean.RemainStaffQueryBO;
import kd.hr.haos.business.service.staff.service.IRemainStaffQueryService;
import kd.hr.haos.business.util.DataSetManager;
import kd.hr.haos.business.util.TimeLogger;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class RemainStaffQueryDataService
implements IRemainStaffQueryService {
    private RemainStaffQueryBO queryModel;
    private SQLFields sqlFields;
    private static final String SORTCODE_SELECTFIELDS = "adminorg.id as adminorg.boid, sortcode ";
    private static final String STRUCT_SELECTFIELDS = "adminorg.id as adminorg.boid, structlongnumber ";
    private static final String RIGHT_LEFT_JOIN_SELECTFIELDS = "sortcode";
    private DataSetManager dataSetManager = new DataSetManager();
    private TimeLogger timeLogger = TimeLogger.create();
    private static final Log LOGGER = LogFactory.getLog(RemainStaffQueryDataService.class);

    @Override
    public DataSet query() {
        DataSet remainStaffDataSet;
        this.init();
        this.timeLogger.start();
        try {
            remainStaffDataSet = this.doQuery();
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
            throw ex;
        }
        finally {
            this.dataSetManager.closeAll();
        }
        this.timeLogger.end();
        return remainStaffDataSet;
    }

    private void init() {
        this.sqlFields = new NormalSQLFields();
    }

    private DataSet doQuery() {
        this.timeLogger.check("before query");
        QFilter[] queryUseOrgFilter = QFilterHelper.convert2Array(this.queryModel.getUseOrgFilter());
        QFilter[] queryDutyOrgFilter = QFilterHelper.convert2Array(this.queryModel.getDutyOrgFilter());
        QFilter[] querySortCodeFilter = QFilterHelper.convert2Array(this.queryModel.getSortCodeFilter());
        String[] orderBys = this.getOrderBys();
        DataSet useOrgDataSet = this.registerAndReturn(HRBaseServiceHelper.create((String)"haos_useorgdetailquery").queryDataSet("remainstaff.queryuseorg", this.sqlFields.getUseOrgSelectFields(), queryUseOrgFilter));
        this.timeLogger.check("useOrgDataSet");
        DataSet dutyOrgDataSet = this.registerAndReturn(HRBaseServiceHelper.create((String)"haos_dutyorgdetailquery").queryDataSet("remainstaff.querydutyorg", this.sqlFields.getDutyOrgSelectFields(), queryDutyOrgFilter));
        this.timeLogger.check("dutyOrgDataSet");
        DataSet sortCodeDataSet = this.registerAndReturn(HRBaseServiceHelper.create((String)AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey()).queryDataSet("remainstaff.querysortcode", SORTCODE_SELECTFIELDS, querySortCodeFilter));
        this.timeLogger.check("sortCodeDataSet");
        return dutyOrgDataSet.addField("1", "stafftype").union(useOrgDataSet.addField("2", "stafftype")).leftJoin(sortCodeDataSet).on("adminorg.boid", "adminorg.boid").select(this.splitString2Array(this.sqlFields.getOrgJoinSelectFields()), this.splitString2Array(RIGHT_LEFT_JOIN_SELECTFIELDS)).finish().orderBy(orderBys).limit(this.queryModel.getStart(), this.queryModel.getLimit());
    }

    private String[] getOrderBys() {
        ArrayList orderByList = Lists.newArrayList((Object[])new String[]{"sortcode asc", "stafftype asc"});
        if (!HRStringUtils.isEmpty((String)this.queryModel.getOrderBys())) {
            String[] split = this.queryModel.getOrderBys().split(",");
            List<String> result = Arrays.stream(split).map(String::trim).collect(Collectors.toList());
            result.addAll(orderByList);
            return result.toArray(new String[0]);
        }
        return orderByList.toArray(new String[0]);
    }

    private String[] splitString2Array(String str) {
        return this.getSplitString2ArrayFunction(",").apply(str);
    }

    private Function<String, String[]> getSplitString2ArrayFunction(String separator) {
        return selectFields -> {
            if (selectFields != null) {
                String[] split = selectFields.split(separator);
                for (int i = 0; i < split.length; ++i) {
                    split[i] = split[i].trim();
                }
                return split;
            }
            return null;
        };
    }

    @Override
    public int count() {
        throw new RuntimeException("no support");
    }

    private DataSet registerAndReturn(DataSet dataSet) {
        this.dataSetManager.register(dataSet);
        return dataSet;
    }

    public void setQueryModel(RemainStaffQueryBO queryModel) {
        this.queryModel = queryModel;
    }

    static class NormalSQLFields
    extends SQLFields {
        NormalSQLFields() {
        }
    }

    static abstract class SQLFields {
        SQLFields() {
        }

        protected String getDutyOrgSelectFields() {
            return "id, adminorg.id, adminorg.boid, adminorg.name, adminorg.number, adminorg.parentorg.id as adminorg.parentorg.boid, adminorg.adminorgtype.name, adminorg.adminorglayer.name";
        }

        protected String getUseOrgSelectFields() {
            return "id, adminorg.id, adminorg.boid, adminorg.name, adminorg.number, adminorg.parentorg.id as adminorg.parentorg.boid, adminorg.adminorgtype.name, adminorg.adminorglayer.name";
        }

        protected String getOrgJoinSelectFields() {
            return "id, adminorg.id, adminorg.boid, adminorg.name, adminorg.number, adminorg.parentorg.boid, adminorg.adminorglayer.name, adminorg.adminorgtype.name, stafftype";
        }
    }
}

