/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.hr.haos.business.service.staff.bean.OrgStaffBo;
import kd.hr.haos.business.service.staff.bean.StaffIncludeSubCountContext;
import kd.hr.haos.business.service.staff.service.IStaffIncludeSubStaffQueryService;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;

public class StaffIncludeSubStaffQueryService
implements IStaffIncludeSubStaffQueryService,
OrgStaffConstants {
    @Override
    public Map<Long, Integer> queryIncludeSubStaffQueryByAdminOrg(Date queryDate, List<Long> adminOrgIds) {
        StaffIncludeSubCountContext staffIncludeSubCountContext = new StaffIncludeSubCountContext(queryDate, adminOrgIds);
        List<OrgStaffBo> orgStaffBoList = this.orgStaffBoListCreator(staffIncludeSubCountContext);
        Map<Long, OrgStaffBo> adminOrgBoIdVsBoMap = orgStaffBoList.stream().collect(Collectors.toMap(bo -> bo.getAdminOrgBoId(), dyn -> dyn));
        List<OrgStaffBo> sortedBoList = orgStaffBoList.stream().sorted(Comparator.comparingInt(bo -> bo.getLongStructNumber().length())).collect(Collectors.toList());
        this.calculateCountAndSummarize(adminOrgBoIdVsBoMap, sortedBoList);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)adminOrgIds.size());
        for (Long adminOrgId : adminOrgIds) {
            OrgStaffBo orgStaffBo = adminOrgBoIdVsBoMap.get(adminOrgId);
            if (Objects.nonNull(orgStaffBo)) {
                resultMap.put(adminOrgId, orgStaffBo.getStatisticalStaffCount());
                continue;
            }
            resultMap.put(adminOrgId, null);
        }
        return resultMap;
    }

    private void calculateCountAndSummarize(Map<Long, OrgStaffBo> adminOrgBoIdVsBoMap, List<OrgStaffBo> sortedBoList) {
        for (int i = sortedBoList.size() - 1; i >= 0; --i) {
            Integer statisticalStaffCount;
            OrgStaffBo orgStaffBo = sortedBoList.get(i);
            Long adminOrgId = orgStaffBo.getAdminOrgId();
            Long dutyOrgId = orgStaffBo.getDutyOrgId();
            Long parentOrgBoId = orgStaffBo.getParentOrgBoId();
            OrgStaffBo parentOrgStaffBo = adminOrgBoIdVsBoMap.get(parentOrgBoId);
            if (Objects.nonNull(adminOrgId) && adminOrgId.equals(dutyOrgId)) {
                Integer includeSubStaffCount = orgStaffBo.getIncludeSubStaffCount();
                orgStaffBo.setStatisticalStaffCount(includeSubStaffCount);
                this.setParentStaffCount(parentOrgStaffBo, includeSubStaffCount);
                continue;
            }
            Integer staffCount = orgStaffBo.getStaffCount();
            Integer resultCount = staffCount == null ? orgStaffBo.getStatisticalStaffCount() : (Objects.isNull(statisticalStaffCount = orgStaffBo.getStatisticalStaffCount()) ? staffCount : Integer.valueOf(staffCount + statisticalStaffCount));
            orgStaffBo.setStatisticalStaffCount(resultCount);
            this.setParentStaffCount(parentOrgStaffBo, resultCount);
        }
    }

    private void setParentStaffCount(OrgStaffBo parentOrgStaffBo, Integer includeSubStaffCount) {
        if (Objects.nonNull(parentOrgStaffBo)) {
            Integer statisticalStaffCount = parentOrgStaffBo.getStatisticalStaffCount();
            if (Objects.isNull(includeSubStaffCount)) {
                return;
            }
            if (Objects.isNull(statisticalStaffCount)) {
                parentOrgStaffBo.setStatisticalStaffCount(includeSubStaffCount);
            } else {
                parentOrgStaffBo.setStatisticalStaffCount(statisticalStaffCount + includeSubStaffCount);
            }
        }
    }

    private List<OrgStaffBo> orgStaffBoListCreator(StaffIncludeSubCountContext staffIncludeSubCountContext) {
        List<Long> curAndSubAdminOrgBoIdList = staffIncludeSubCountContext.getCurAndSubAdminOrgBoIdList();
        ArrayList orgStaffBoList = Lists.newArrayListWithExpectedSize((int)curAndSubAdminOrgBoIdList.size());
        for (Long adminOrgBoId : curAndSubAdminOrgBoIdList) {
            orgStaffBoList.add(new OrgStaffBo(adminOrgBoId, staffIncludeSubCountContext));
        }
        return orgStaffBoList;
    }
}

