/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.servicehelper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgParam;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.adminorg.bean.Pair;
import kd.hr.haos.business.service.adminorg.bean.TeamCoopRelBO;
import kd.hr.haos.business.service.orgteam.OrgTeamSynService;
import kd.hr.haos.business.servicehelper.model.upgrade.InitDataHolder;
import kd.hr.haos.business.servicehelper.model.upgrade.InitHisData;
import kd.hr.haos.business.servicehelper.model.upgrade.InitTreeNode;
import kd.hr.haos.business.util.IdCreator;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class AdminOrgInitServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(AdminOrgInitServiceHelper.class);
    public static ThreadLocal<List<HisVersionParamBo>> INVALID_HIS_DATA = ThreadLocal.withInitial(() -> new ArrayList());

    public static Map<Long, DynamicObject> toAdminOrgDynamicObject(List<DynamicObject> result, List<Map<String, Object>> result2, Long batchNumber) {
        return AdminOrgInitServiceHelper.toAdminOrgDynamicObjectWithParent(result, result2, batchNumber).getInitKeyAdminOrgMap();
    }

    public static InitDataHolder toAdminOrgDynamicObjectWithParent(List<DynamicObject> result, List<Map<String, Object>> result2, Long batchNumber) {
        HashMap<Long, DynamicObject> initKeyAdminOrgMap = new HashMap<Long, DynamicObject>();
        if (CollectionUtils.isEmpty(result) || CollectionUtils.isEmpty(result2)) {
            return new InitDataHolder(null, initKeyAdminOrgMap);
        }
        HashMap numberOrgMap = new HashMap();
        HashMap numberParentNumberMap = new HashMap();
        HashMap<Long, String> idNumberMap = new HashMap<Long, String>();
        HashSet<String> adminorgTypeNames = new HashSet<String>();
        result2.forEach(map -> {
            idNumberMap.put(Long.parseLong(map.get("id").toString()), map.get("number").toString());
            if (map.get("parentorg") != null) {
                numberParentNumberMap.put(map.get("number").toString(), map.get("parentorg").toString());
            }
            adminorgTypeNames.add(map.get("adminorgtype").toString());
        });
        result.forEach(dy -> numberOrgMap.put(dy.getString("number"), dy));
        Map<String, DynamicObject> adminorgTypeMap = AdminOrgInitServiceHelper.getAdminorgTypes(adminorgTypeNames);
        Map<String, DynamicObject> parentNumberParentOrgMap = AdminOrgInitServiceHelper.getParentOrgs(numberParentNumberMap.values());
        HashSet<Long> parentOrgBoIds = new HashSet<Long>();
        parentNumberParentOrgMap.values().forEach(dyn -> parentOrgBoIds.add(dyn.getLong("boid")));
        Map<Long, List<DynamicObject>> orgHisDyn = AdminOrgInitServiceHelper.getOrgHisDyn(parentOrgBoIds);
        Map<Long, List<DynamicObject>> orgHisStruct = AdminOrgInitServiceHelper.getOrgHisStruct(parentOrgBoIds);
        Map<Long, List<DynamicObject>> orgHisSortCode = AdminOrgInitServiceHelper.getOrgHisSortCode(parentOrgBoIds);
        Map<Long, List<DynamicObject>> orgHisOrgTeamStruct = AdminOrgInitServiceHelper.getOrgHisOrgTeamStruct(parentOrgBoIds);
        Map<String, DynamicObject> numberInitMidTableParentOrgMap = AdminOrgInitServiceHelper.getInitMidTableParentOrg(numberParentNumberMap.values(), numberOrgMap.keySet(), parentNumberParentOrgMap.keySet(), batchNumber);
        idNumberMap.forEach((id, number) -> {
            DynamicObject dynamicObject = (DynamicObject)numberOrgMap.get(number);
            if (dynamicObject != null) {
                String adminorgtypeName;
                DynamicObject adminorgtype;
                String parentNumber = (String)numberParentNumberMap.get(number);
                if (!StringUtils.isEmpty((CharSequence)parentNumber)) {
                    DynamicObject parentOrg = (DynamicObject)parentNumberParentOrgMap.get(parentNumber);
                    if (parentOrg != null) {
                        dynamicObject.set("parentorg", parentNumberParentOrgMap.get(parentNumber));
                    } else {
                        dynamicObject.set("parentorg", numberOrgMap.getOrDefault(parentNumber, numberInitMidTableParentOrgMap.get(parentNumber)));
                    }
                }
                if ((adminorgtype = (DynamicObject)adminorgTypeMap.get(adminorgtypeName = dynamicObject.getString("adminorgtype.name"))) != null) {
                    dynamicObject.set("adminorgtype", (Object)adminorgtype);
                }
                dynamicObject.set("bsed", dynamicObject.get("establishmentdate"));
                dynamicObject.set("firstbsed", dynamicObject.get("establishmentdate"));
                dynamicObject.set("datastatus", (Object)"1");
                initKeyAdminOrgMap.put((Long)id, dynamicObject);
            }
        });
        return new InitDataHolder(new InitHisData(orgHisDyn, orgHisStruct, orgHisSortCode, orgHisOrgTeamStruct), initKeyAdminOrgMap);
    }

    private static Map<String, DynamicObject> getInitMidTableParentOrg(Collection<String> parentNumbers, Collection<String> currentOrgNumbers, Collection<String> orgNumbers, Long batchNumber) {
        HashMap numberInitMidTableParentOrgMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(parentNumbers)) {
            return numberInitMidTableParentOrgMap;
        }
        ArrayList<String> newParentNumbers = new ArrayList<String>(parentNumbers);
        newParentNumbers.removeAll(currentOrgNumbers);
        newParentNumbers.removeAll(orgNumbers);
        if (CollectionUtils.isEmpty(newParentNumbers)) {
            return numberInitMidTableParentOrgMap;
        }
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("number", newParentNumbers);
        Map InitMidTableParentOrg = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hric", (String)"IInitMidTableService", (String)"getBizDOBySpecifyConditions", (Object[])new Object[]{batchNumber, paramMap});
        List dynamicObjects = (List)InitMidTableParentOrg.get("data");
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return numberInitMidTableParentOrgMap;
        }
        return dynamicObjects.stream().peek(dynamicObject -> {
            dynamicObject.set("bsed", dynamicObject.get("establishmentdate"));
            dynamicObject.set("firstbsed", dynamicObject.get("establishmentdate"));
            dynamicObject.set("datastatus", (Object)"1");
        }).collect(Collectors.toMap(dy -> dy.getString("number"), dt -> dt));
    }

    public static List<String> getPermOrgNumber(List<Long> permOrgIds) {
        ArrayList<String> orgNumbers = new ArrayList<String>();
        if (CollectionUtils.isEmpty(permOrgIds)) {
            return orgNumbers;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_org_structure");
        QFilter viewFilter = new QFilter("view.number", "=", (Object)"21");
        QFilter idFilter = new QFilter("org.id", "in", permOrgIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Object[] orgStructures = helper.query("org.number", new QFilter[]{viewFilter, enableFilter, idFilter});
        if (!ArrayUtils.isEmpty((Object[])orgStructures)) {
            Stream.of(orgStructures).forEach(dy -> orgNumbers.add(dy.getString("org.number")));
        }
        return orgNumbers;
    }

    private static Map<String, DynamicObject> getParentOrgs(Collection<String> parentNumbers) {
        if (CollectionUtils.isEmpty(parentNumbers)) {
            return new HashMap<String, DynamicObject>();
        }
        HRBaseServiceHelper adminorgServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObject[] adminorgs = adminorgServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("number", "in", parentNumbers), new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("datastatus", "in", (Object)new String[]{EnumHisDataVersionStatus.INVALIDED.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus()})});
        return Stream.of(adminorgs).collect(Collectors.toMap(dy -> dy.getString("number"), dt -> dt));
    }

    private static Map<Long, List<DynamicObject>> getOrgHisDyn(Collection<Long> orgBoIds) {
        if (CollectionUtils.isEmpty(orgBoIds)) {
            return new HashMap<Long, List<DynamicObject>>();
        }
        HRBaseServiceHelper adminorgServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObject[] adminorgs = adminorgServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("boid", "in", orgBoIds), new QFilter("iscurrentversion", "=", (Object)"0"), new QFilter("datastatus", "in", (Object)new String[]{EnumHisDataVersionStatus.INVALIDED.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus()})});
        return Arrays.stream(adminorgs).collect(Collectors.groupingBy(dyn -> dyn.getLong("boid")));
    }

    private static Map<Long, List<DynamicObject>> getOrgHisStruct(Collection<Long> orgBoIds) {
        if (CollectionUtils.isEmpty(orgBoIds)) {
            return new HashMap<Long, List<DynamicObject>>();
        }
        HRBaseServiceHelper adminorgServiceHelper = new HRBaseServiceHelper("haos_adminorgstruct");
        DynamicObject[] adminorgs = adminorgServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("adminorg", "in", orgBoIds), (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get(), new QFilter("iscurrentversion", "=", (Object)"0"), new QFilter("datastatus", "in", (Object)new String[]{EnumHisDataVersionStatus.INVALIDED.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus()})});
        return Arrays.stream(adminorgs).collect(Collectors.groupingBy(dyn -> dyn.getLong("adminorg.id")));
    }

    private static Map<Long, List<DynamicObject>> getOrgHisSortCode(Collection<Long> orgBoIds) {
        if (CollectionUtils.isEmpty(orgBoIds)) {
            return new HashMap<Long, List<DynamicObject>>();
        }
        HRBaseServiceHelper adminorgServiceHelper = new HRBaseServiceHelper("haos_orgsortcode");
        DynamicObject[] adminorgs = adminorgServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("adminorg.id", "in", orgBoIds), new QFilter("iscurrentversion", "=", (Object)"0"), new QFilter("datastatus", "in", (Object)new String[]{EnumHisDataVersionStatus.INVALIDED.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus()})});
        return Arrays.stream(adminorgs).collect(Collectors.groupingBy(dyn -> dyn.getLong("adminorg.id")));
    }

    private static Map<Long, List<DynamicObject>> getOrgHisOrgTeamStruct(Collection<Long> orgBoIds) {
        if (CollectionUtils.isEmpty(orgBoIds)) {
            return new HashMap<Long, List<DynamicObject>>();
        }
        HRBaseServiceHelper adminorgServiceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        DynamicObject[] adminorgs = adminorgServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("orgteam.id", "in", orgBoIds), (QFilter)StructProjectConstants.ORG_STRUCTURE_FILTER.get(), new QFilter("iscurrentversion", "=", (Object)"0"), (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get(), new QFilter("datastatus", "in", (Object)new String[]{EnumHisDataVersionStatus.INVALIDED.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus()})});
        return Arrays.stream(adminorgs).collect(Collectors.groupingBy(dyn -> dyn.getLong("orgteam.id")));
    }

    private static Map<String, DynamicObject> getOrgInfoByStructNumber(Collection<String> structNumbers) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObject[] adminorgs = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("structnumber", "in", structNumbers), new QFilter("iscurrentversion", "=", (Object)"1")});
        return Stream.of(adminorgs).collect(Collectors.toMap(dy -> dy.getString("number"), dt -> dt));
    }

    private static Map<String, DynamicObject> getAdminorgTypes(Set<String> adminorgTypeNames) {
        if (CollectionUtils.isEmpty(adminorgTypeNames)) {
            return new HashMap<String, DynamicObject>();
        }
        HRBaseServiceHelper adminorgTypeServiceHelper = new HRBaseServiceHelper("haos_adminorgtype");
        DynamicObject[] adminorgTypes = adminorgTypeServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("name", "in", adminorgTypeNames), new QFilter("enable", "=", (Object)"1")});
        return Stream.of(adminorgTypes).collect(Collectors.toMap(dy -> dy.getString("name"), dt -> dt, (d1, d2) -> d1));
    }

    public static void setInitDefaultValue(DynamicObject[] entityDycList, long initbatch) {
        Stream.of(entityDycList).forEach(dy -> {
            dy.set("initdatasource", (Object)"1");
            dy.set("initbatch", (Object)initbatch);
            dy.set("initstatus", (Object)"0");
        });
    }

    public static List<OrgParam> assembleOrgParamByAdminOrg(DynamicObject[] dynamicObjects) {
        ArrayList<OrgParam> paramList = new ArrayList<OrgParam>(4);
        for (DynamicObject adminOrgDynObj : dynamicObjects) {
            long id = adminOrgDynObj.getLong("id");
            if (id == PlatformRootUtils.getLongRootIdOfPlatform()) continue;
            String adminOrgName = adminOrgDynObj.getString("name");
            String adminOrgNumber = adminOrgDynObj.getString("number");
            DynamicObject adminOrgParentDynObj = (DynamicObject)adminOrgDynObj.get("parentorg");
            long parentId = 0L;
            if (adminOrgParentDynObj != null) {
                parentId = adminOrgParentDynObj.getLong("id");
            }
            OrgParam orgParam = new OrgParam();
            orgParam.setId(id);
            orgParam.setCustomOrgId(id);
            orgParam.setName(adminOrgName);
            orgParam.setNumber(adminOrgNumber);
            orgParam.setParentId(parentId);
            orgParam.setDuty("01");
            orgParam.setYzjSync(true);
            orgParam.setDescription(adminOrgDynObj.getString("description"));
            paramList.add(orgParam);
        }
        return paramList;
    }

    public static Map<Long, List<TeamCoopRelBO>> getCurBatchOrgCoopRelBOMap(DynamicObject[] dysArrays) {
        HashMap<Long, List<TeamCoopRelBO>> orgCoopRelBOMap = new HashMap<Long, List<TeamCoopRelBO>>(dysArrays.length);
        for (DynamicObject dynamicObject : dysArrays) {
            long orgTeamId = dynamicObject.getLong("id");
            ArrayList<TeamCoopRelBO> coopRelBOList = new ArrayList<TeamCoopRelBO>(4);
            DynamicObject parentOrg = dynamicObject.getDynamicObject("parentorg");
            if (Objects.nonNull(parentOrg)) {
                TeamCoopRelBO teamCoopRelBO = new TeamCoopRelBO(orgTeamId, 1010L, parentOrg.getLong("id"), 0);
                teamCoopRelBO.setEnable(!HRObjectUtils.isEmpty((Object)dynamicObject.get("enable")) ? dynamicObject.getString("enable") : "1");
                AdminOrgInitServiceHelper.setEstablishmentDateForTeamCoopRel(dynamicObject, teamCoopRelBO);
                coopRelBOList.add(teamCoopRelBO);
            }
            orgCoopRelBOMap.put(orgTeamId, coopRelBOList);
        }
        return orgCoopRelBOMap;
    }

    private static void constructAndAddNewCoopRelDyn(List<DynamicObject> orgTeamCoopRelList, TeamCoopRelBO teamCoopRelBO) {
        DynamicObject dyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_orgteamcooprel"));
        long id = ORM.create().genLongId("haos_orgteamcooprel");
        dyn.set("id", (Object)id);
        dyn.set("enable", (Object)teamCoopRelBO.getEnable());
        dyn.set("status", (Object)"C");
        dyn.set("bsed", (Object)teamCoopRelBO.getEffDate());
        dyn.set("org", (Object)teamCoopRelBO.getOrgTeamId());
        dyn.set("coopreltype", (Object)teamCoopRelBO.getCoopTypeId());
        dyn.set("cooporgteam", (Object)teamCoopRelBO.getCoopTeamId());
        dyn.set("index", (Object)teamCoopRelBO.getIndex());
        dyn.set("initstatus", (Object)"2");
        orgTeamCoopRelList.add(dyn);
    }

    private static void setEstablishmentDateForTeamCoopRel(DynamicObject dynamicObject, TeamCoopRelBO teamCoopRelBO) {
        Date establishmentdate = dynamicObject.getDate("establishmentdate");
        Date parentDate = dynamicObject.getDate("parentorg.establishmentdate");
        if (establishmentdate != null && parentDate != null && HRDateTimeUtils.dayBefore((Date)establishmentdate, (Date)parentDate)) {
            teamCoopRelBO.setEffDate(parentDate);
        } else {
            teamCoopRelBO.setEffDate(establishmentdate);
        }
    }

    public static HisVersionParamBo buildAddNewHisParam(Map<Long, List<TeamCoopRelBO>> orgTeamCoopRelMap) {
        Set<Map.Entry<Long, List<TeamCoopRelBO>>> entrySet = orgTeamCoopRelMap.entrySet();
        Iterator<Map.Entry<Long, List<TeamCoopRelBO>>> iterator = entrySet.iterator();
        ArrayList<DynamicObject> orgTeamCoopRelList = new ArrayList<DynamicObject>();
        while (iterator.hasNext()) {
            Map.Entry<Long, List<TeamCoopRelBO>> orgTeamCoopRelEntry = iterator.next();
            List<TeamCoopRelBO> TeamCoopRelBOList = orgTeamCoopRelEntry.getValue();
            for (TeamCoopRelBO teamCoopRelBO : TeamCoopRelBOList) {
                AdminOrgInitServiceHelper.constructAndAddNewCoopRelDyn(orgTeamCoopRelList, teamCoopRelBO);
            }
        }
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(orgTeamCoopRelList.toArray(new DynamicObject[0]), "haos_orgteamcooprel", false);
    }

    public static HisVersionParamBo buildAddNewHisParam(DynamicObject[] dynamicObjects) {
        if (HRObjectUtils.isEmpty((Object)dynamicObjects)) {
            return null;
        }
        Map<String, List<DynamicObject>> parentNumberOrgsMap = Stream.of(dynamicObjects).filter(dy -> dy.get("parentorg") != null).collect(Collectors.groupingBy(dy -> dy.getString("parentorg.number")));
        Map<String, DynamicObject> numberStructLongNumMap = AdminOrgInitServiceHelper.batchGetOrgParentStructDynObj(parentNumberOrgsMap.keySet());
        ArrayList<DynamicObject> structDynVersionSaveList = new ArrayList<DynamicObject>(16);
        long[] ids = ORM.create().genLongIds(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), dynamicObjects.length);
        Map<String, String> numberOrgStructLongNumberMap = AdminOrgInitServiceHelper.getOrgStructLongNumbers(parentNumberOrgsMap);
        int index = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            String structLongNumber;
            DynamicObject adminStruct = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey()));
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)adminStruct, AdminOrgHisDynamicUtils.getInstance().getMultiLanguageIgnoreKey());
            adminStruct.set("id", (Object)ids[index++]);
            adminStruct.set("structproject", (Object)1010L);
            adminStruct.set("adminorg", (Object)dynamicObject);
            DynamicObject parentDynObj = dynamicObject.getDynamicObject("parentorg");
            if (Objects.nonNull(parentDynObj)) {
                adminStruct.set("parentorg", (Object)parentDynObj);
            }
            if (StringUtils.isEmpty((CharSequence)(structLongNumber = numberOrgStructLongNumberMap.get(dynamicObject.getString("number"))))) {
                structLongNumber = dynamicObject.getString("structnumber");
            }
            adminStruct.set("structlongnumber", (Object)structLongNumber);
            if (PlatformRootUtils.getLongRootIdOfPlatform() == dynamicObject.getLong("id")) {
                adminStruct.set("isroot", (Object)"1");
                adminStruct.set("isleaf", (Object)"0");
            } else {
                adminStruct.set("isleaf", (Object)"1");
            }
            adminStruct.set("level", (Object)structLongNumber.split("!").length);
            AdminOrgInitServiceHelper.setEstablishmentDate(dynamicObject, adminStruct);
            structDynVersionSaveList.add(adminStruct);
            numberStructLongNumMap.put(dynamicObject.getString("number"), adminStruct);
        }
        LOGGER.info(String.format(Locale.ROOT, "111111AdminOrgStructService.buildAddNewHisParam() structDynVersionSaveList size = %s", structDynVersionSaveList.size()));
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(structDynVersionSaveList.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), false);
    }

    private static void setEstablishmentDate(DynamicObject dynamicObject, DynamicObject adminStruct) {
        Date establishmentdate = dynamicObject.getDate("establishmentdate");
        Date parentDate = dynamicObject.getDate("parentorg.establishmentdate");
        if (establishmentdate != null && parentDate != null && HRDateTimeUtils.dayBefore((Date)establishmentdate, (Date)parentDate)) {
            adminStruct.set("bsed", (Object)parentDate);
            adminStruct.set("firstbsed", (Object)parentDate);
        } else {
            adminStruct.set("bsed", (Object)establishmentdate);
            adminStruct.set("firstbsed", (Object)establishmentdate);
        }
    }

    public static HisVersionParamBo buildSortCodeAddNewHisParam(DynamicObject[] dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        Map<String, List<DynamicObject>> parentNumberOrgsMap = Stream.of(dynamicObjects).filter(dy -> dy.get("parentorg") != null).collect(Collectors.groupingBy(dy -> dy.getString("parentorg.number")));
        DynamicObject[] orgSortCodeDynArr = new DynamicObject[dynamicObjects.length];
        long[] ids = ORM.create().genLongIds(AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey(), dynamicObjects.length);
        AdminOrgInitServiceHelper.setSortIndex(dynamicObjects);
        Map<String, String> numberOrgSortCodeNumberMap = AdminOrgInitServiceHelper.getOrgSortCodeNumbers(parentNumberOrgsMap);
        int index = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject dyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey()));
            DynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)dyn, AdminOrgHisDynamicUtils.getInstance().getMultiLanguageIgnoreKey());
            long id = ids[index];
            dyn.set("id", (Object)id);
            dyn.set("adminorg", (Object)dynamicObject);
            String sortCodeNumber = numberOrgSortCodeNumberMap.get(dynamicObject.getString("number"));
            if (StringUtils.isEmpty((CharSequence)sortCodeNumber)) {
                sortCodeNumber = AdminOrgInitServiceHelper.fillIndexWithZero(dynamicObject.getString("index"));
            }
            dyn.set("sortcode", (Object)sortCodeNumber);
            orgSortCodeDynArr[index] = dyn;
            ++index;
        }
        LOGGER.info(String.format(Locale.ROOT, "kd.hr.haos.business.servicehelper.AdminOrgInitServiceHelper.buildSortCodeAddNewHisParam() orgSortCodeDynArr size = %s", orgSortCodeDynArr.length));
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(orgSortCodeDynArr, AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey(), false);
    }

    private static void setSortIndex(DynamicObject[] dynamicObjects) {
        HashSet<Long> parentOrgIds = new HashSet<Long>();
        Stream.of(dynamicObjects).forEach(dy -> {
            long parentOrgId = dy.getLong("parentorg.id");
            if (parentOrgId > 0L) {
                parentOrgIds.add(parentOrgId);
            }
        });
        if (!CollectionUtils.isEmpty(parentOrgIds)) {
            Map<Long, Integer> maxIndexUnderOrg = AdminOrgHisServiceHelper.batchGetMaxIndexUnderOrg(parentOrgIds);
            HashMap<String, Integer> maxIndexUnderOrgMap = new HashMap<String, Integer>();
            for (DynamicObject org : dynamicObjects) {
                DynamicObject parentOrg;
                if (org.get("index") != null && org.getLong("index") != 0L || (parentOrg = org.getDynamicObject("parentorg")) == null) continue;
                long parentOrgId = parentOrg.getLong("id");
                String parentOrgNumber = parentOrg.getString("number");
                Integer index = 1;
                if (maxIndexUnderOrgMap.containsKey(parentOrgNumber)) {
                    index = (Integer)maxIndexUnderOrgMap.get(parentOrgNumber);
                } else if (maxIndexUnderOrg.containsKey(parentOrgId)) {
                    index = maxIndexUnderOrg.get(parentOrgId);
                }
                if (index > AdminOrgConstants.MAX_INDEX) {
                    index = AdminOrgConstants.MAX_INDEX;
                }
                org.set("index", (Object)index);
                maxIndexUnderOrgMap.put(parentOrgNumber, index + 1);
            }
        }
    }

    private static Map<String, DynamicObject> batchGetOrgParentSortCode(Collection<String> parentNumbers) {
        if (CollectionUtils.isEmpty(parentNumbers)) {
            return new HashMap<String, DynamicObject>();
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey());
        QFilter filter = new QFilter("adminorg.number", "in", parentNumbers);
        filter.and("iscurrentversion", "=", (Object)"1");
        DynamicObject[] dynamicObjectArray = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        return Stream.of(dynamicObjectArray).collect(Collectors.toMap(dyn -> dyn.getString("adminorg.number"), dyn -> dyn));
    }

    public static String fillIndexWithZero(String index) {
        int length = index.length();
        StringBuilder indexBuilder = new StringBuilder(index);
        for (int i = 0; i < 5 - length; ++i) {
            indexBuilder.insert(0, "0");
        }
        return indexBuilder.toString();
    }

    private static Map<String, String> getOrgStructLongNumbers(Map<String, List<DynamicObject>> parentNumberOrgsMap) {
        Map<String, DynamicObject> numerStructLongNumMap = AdminOrgInitServiceHelper.batchGetOrgParentStructDynObj(parentNumberOrgsMap.keySet());
        HashMap<String, String> numberOrgStructLongNumberMap = new HashMap<String, String>();
        numerStructLongNumMap.forEach((number, orgStruct) -> AdminOrgInitServiceHelper.getParentOrgStructLongNumber(numberOrgStructLongNumberMap, parentNumberOrgsMap, number, orgStruct.getString("structlongnumber")));
        return numberOrgStructLongNumberMap;
    }

    private static Map<String, String> getOrgSortCodeNumbers(Map<String, List<DynamicObject>> parentNumberOrgsMap) {
        Map<String, DynamicObject> numerStructLongNumMap = AdminOrgInitServiceHelper.batchGetOrgParentSortCode(parentNumberOrgsMap.keySet());
        HashMap<String, String> numberOrgSortCodeNumberMap = new HashMap<String, String>();
        numerStructLongNumMap.forEach((number, orgStruct) -> AdminOrgInitServiceHelper.getParentOrgSortCodeNumber(numberOrgSortCodeNumberMap, parentNumberOrgsMap, number, orgStruct.getString("sortcode")));
        return numberOrgSortCodeNumberMap;
    }

    private static void getParentOrgSortCodeNumber(Map<String, String> numberOrgSortCodeNumberMap, Map<String, List<DynamicObject>> parentNumberOrgsMap, String number, String sortCode) {
        List<DynamicObject> childOrgs = parentNumberOrgsMap.get(number);
        if (!CollectionUtils.isEmpty(childOrgs)) {
            childOrgs.forEach(childOrg -> {
                String currentSortCodeNumber = sortCode + "!" + AdminOrgInitServiceHelper.fillIndexWithZero(childOrg.getString("index"));
                numberOrgSortCodeNumberMap.put(childOrg.getString("number"), currentSortCodeNumber);
                AdminOrgInitServiceHelper.getParentOrgSortCodeNumber(numberOrgSortCodeNumberMap, parentNumberOrgsMap, childOrg.getString("number"), currentSortCodeNumber);
            });
        }
    }

    private static void getParentOrgStructLongNumber(Map<String, String> numberOrgStructLongNumberMap, Map<String, List<DynamicObject>> parentNumberOrgsMap, String number, String structLongNumber) {
        List<DynamicObject> childOrgs = parentNumberOrgsMap.get(number);
        if (!CollectionUtils.isEmpty(childOrgs)) {
            childOrgs.forEach(childOrg -> {
                String currentOrgstructLongNumber = structLongNumber + "!" + childOrg.getString("structnumber");
                numberOrgStructLongNumberMap.put(childOrg.getString("number"), currentOrgstructLongNumber);
                AdminOrgInitServiceHelper.getParentOrgStructLongNumber(numberOrgStructLongNumberMap, parentNumberOrgsMap, childOrg.getString("number"), currentOrgstructLongNumber);
            });
        }
    }

    public static Map<String, DynamicObject> batchGetOrgParentStructDynObj(Collection<String> parentOrgNumbers) {
        if (CollectionUtils.isEmpty(parentOrgNumbers)) {
            return new HashMap<String, DynamicObject>();
        }
        QFilter filter = new QFilter("adminorg.number", "in", parentOrgNumbers);
        filter.and("iscurrentversion", "=", (Object)"1");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey());
        DynamicObject[] dynamicObjectArray = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
        return Stream.of(dynamicObjectArray).collect(Collectors.toMap(dyn -> dyn.getString("adminorg.number"), dyn -> dyn));
    }

    public static Map<String, DynamicObject> getAllParentOrgs(DynamicObject[] dysArrays) {
        HashSet parentNumbers = new HashSet();
        HashMap numberOrgMap = new HashMap();
        Stream.of(dysArrays).forEach(org -> {
            numberOrgMap.put(org.getString("number"), org);
            DynamicObject parentOrg = org.getDynamicObject("parentorg");
            if (parentOrg != null) {
                parentNumbers.add(parentOrg.getString("number"));
            }
        });
        HRBaseServiceHelper adminorgTypeServiceHelper = new HRBaseServiceHelper("haos_adminorgstruct");
        Object[] adminorgStructs = adminorgTypeServiceHelper.query("structlongnumber", new QFilter[]{new QFilter("adminorg.number", "in", parentNumbers), new QFilter("iscurrentversion", "=", (Object)"1"), (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get(), new QFilter("datastatus", "in", (Object)new String[]{EnumHisDataVersionStatus.INVALIDED.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus()})});
        HashSet<String> allStrucNumbers = new HashSet<String>();
        if (!ArrayUtils.isEmpty((Object[])adminorgStructs)) {
            Stream.of(adminorgStructs).forEach(adminorgStruct -> allStrucNumbers.addAll(Arrays.asList(adminorgStruct.getString("structlongnumber").split("!"))));
        }
        Map<String, DynamicObject> parentOrgs = AdminOrgInitServiceHelper.getOrgInfoByStructNumber(allStrucNumbers);
        parentOrgs.putAll(numberOrgMap);
        return parentOrgs;
    }

    public static List<HisVersionParamBo> buildAddNewHisVersionParam(DynamicObject[] dysArrays) {
        ArrayList<DynamicObject> groupDynList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> companyDynList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> departmentDynList = new ArrayList<DynamicObject>();
        HashMap boIdToFirstVid = Maps.newHashMapWithExpectedSize((int)dysArrays.length);
        HashMap boIdToVidPair = Maps.newHashMapWithExpectedSize((int)dysArrays.length);
        long[] ids = ORM.create().genLongIds("haos_adminorgdetail", dysArrays.length);
        IdCreator idCreator = new IdCreator();
        String[] structNumbers = ORM.create().genStringIds("haos_adminorgdetail", dysArrays.length);
        Map<String, DynamicObject> allParentOrgMap = AdminOrgInitServiceHelper.getAllParentOrgs(dysArrays);
        for (int i = 0; i < dysArrays.length; ++i) {
            DynamicObject dynamicObject = dysArrays[i];
            long id = dynamicObject.getLong("id");
            if (id == 0L) {
                id = ids[i];
            }
            long vid = idCreator.getId();
            dynamicObject.set("id", (Object)id);
            boIdToFirstVid.put(id, vid);
            boIdToVidPair.put(id, new Pair<Integer, Long>(i, vid));
            dynamicObject.set("enable", !HRObjectUtils.isEmpty((Object)dynamicObject.get("enable")) ? dynamicObject.get("enable") : "1");
            dynamicObject.set("status", (Object)"C");
            dynamicObject.set("bsled", (Object)AdminOrgHisDynamicUtils.getDefaultBsled());
            String structNumber = structNumbers[i];
            dynamicObject.set("structnumber", (Object)structNumber);
            String index = dynamicObject.getString("index");
            if (HRStringUtils.isEmpty((String)index) || "0".equals(index)) {
                index = AdminOrgHisServiceHelper.getCurOrgIndex(dynamicObject);
                dynamicObject.set("index", (Object)index);
            }
            AdminOrgInitServiceHelper.addGroupCompDepDynByOrgType(dynamicObject, groupDynList, companyDynList, departmentDynList, allParentOrgMap);
        }
        if (boIdToVidPair.size() != 0) {
            long[] firstVersionIds = new long[dysArrays.length];
            for (Map.Entry entry : boIdToVidPair.entrySet()) {
                Long key = (Long)entry.getKey();
                Pair value = (Pair)entry.getValue();
                for (int idx = 0; idx < dysArrays.length; ++idx) {
                    if (!key.equals(dysArrays[idx].getLong("id"))) continue;
                    firstVersionIds[((Integer)value.getKey()).intValue()] = (Long)value.getValue();
                }
            }
            AdminOrgHisDynamicUtils.FIRST_VERSION_IDS.set(firstVersionIds);
        }
        AdminOrgHisDynamicUtils.FIRST_VERSION_IDS_MAP.set(boIdToFirstVid);
        LOGGER.info(String.format(Locale.ROOT, "kd.hr.haos.business.servicehelper.AdminOrgInitServiceHelper.buildAddNewHisVersionParam() groupDynList size = %s", groupDynList.size()));
        LOGGER.info(String.format(Locale.ROOT, "kd.hr.haos.business.servicehelper.AdminOrgInitServiceHelper.buildAddNewHisVersionParam() companyDynList size = %s", companyDynList.size()));
        LOGGER.info(String.format(Locale.ROOT, "kd.hr.haos.business.servicehelper.AdminOrgInitServiceHelper.buildAddNewHisVersionParam() departmentDynList size = %s", departmentDynList.size()));
        return AdminOrgInitServiceHelper.constructOrgBasicInfoHisParam(dysArrays, groupDynList, companyDynList, departmentDynList);
    }

    public static List<HisVersionParamBo> buildAddNewHisVersionParamWithInvalidHis(DynamicObject[] dysArrays, InitHisData initHisData) {
        Map<Long, List<DynamicObject>> orgHisDyn = initHisData.getOrgHisDyn();
        HashMap<Long, Integer> parentBoIdToIndex = new HashMap<Long, Integer>(16);
        HashMap<Long, Integer> parentInDbBoIdToIndex = new HashMap<Long, Integer>(16);
        ArrayList<DynamicObject> groupDynList = new ArrayList<DynamicObject>(dysArrays.length);
        ArrayList<DynamicObject> companyDynList = new ArrayList<DynamicObject>(dysArrays.length);
        ArrayList<DynamicObject> departmentDynList = new ArrayList<DynamicObject>(dysArrays.length);
        HashMap boIdToFirstVid = Maps.newHashMapWithExpectedSize((int)dysArrays.length);
        HashMap boIdToVidPair = Maps.newHashMapWithExpectedSize((int)dysArrays.length);
        IdCreator idCreator = new IdCreator();
        String[] structNumbers = ORM.create().genStringIds("haos_adminorgdetail", dysArrays.length);
        Map<String, DynamicObject> allParentOrgMap = AdminOrgInitServiceHelper.getAllParentOrgs(dysArrays);
        for (int i = 0; i < dysArrays.length; ++i) {
            DynamicObject dynamicObject = dysArrays[i];
            long id = dynamicObject.getLong("id");
            if (id == 0L) {
                id = idCreator.getId();
            }
            long vid = idCreator.getId();
            dynamicObject.set("id", (Object)id);
            boIdToFirstVid.put(id, vid);
            dynamicObject.set("enable", !HRObjectUtils.isEmpty((Object)dynamicObject.get("enable")) ? dynamicObject.get("enable") : "1");
            dynamicObject.set("status", (Object)"C");
            dynamicObject.set("bsled", (Object)AdminOrgHisDynamicUtils.getDefaultBsled());
            String structNumber = structNumbers[i];
            dynamicObject.set("structnumber", (Object)structNumber);
            AdminOrgInitServiceHelper.setIndex(orgHisDyn, parentBoIdToIndex, parentInDbBoIdToIndex, dynamicObject);
            AdminOrgInitServiceHelper.addGroupCompDepDynByOrgType(dynamicObject, groupDynList, companyDynList, departmentDynList, allParentOrgMap);
        }
        Map<String, List<DynamicObject>> dynamicObjects = AdminOrgInitServiceHelper.getAllVersionList(dysArrays, boIdToFirstVid, initHisData, idCreator);
        List<DynamicObject> effectingAdminorg = dynamicObjects.get("adminorg").stream().filter(dyn -> dyn.getDate("bsled").compareTo(HisEffDateCommonService.getInstance().getDate2999(null)) == 0).collect(Collectors.toList());
        DynamicObject[] effectingAdminArray = effectingAdminorg.toArray(new DynamicObject[0]);
        for (int i = 0; i < effectingAdminArray.length; ++i) {
            boIdToVidPair.put(effectingAdminArray[i].getLong("id"), new Pair(i, boIdToFirstVid.get(effectingAdminArray[i].getLong("id"))));
        }
        long[] firstVersionIds = null;
        if (boIdToVidPair.size() != 0) {
            firstVersionIds = new long[effectingAdminArray.length];
            for (Map.Entry entry : boIdToVidPair.entrySet()) {
                Long key = (Long)entry.getKey();
                Pair value = (Pair)entry.getValue();
                for (int idx = 0; idx < effectingAdminArray.length; ++idx) {
                    if (!key.equals(effectingAdminArray[idx].getLong("id"))) continue;
                    firstVersionIds[((Integer)value.getKey()).intValue()] = (Long)value.getValue();
                }
            }
            AdminOrgHisDynamicUtils.FIRST_VERSION_IDS.set(firstVersionIds);
        }
        LOGGER.info(String.format(Locale.ROOT, "kd.hr.haos.business.servicehelper.AdminOrgInitServiceHelper.buildAddNewHisVersionParam() groupDynList size = %s", groupDynList.size()));
        LOGGER.info(String.format(Locale.ROOT, "kd.hr.haos.business.servicehelper.AdminOrgInitServiceHelper.buildAddNewHisVersionParam() companyDynList size = %s", companyDynList.size()));
        LOGGER.info(String.format(Locale.ROOT, "kd.hr.haos.business.servicehelper.AdminOrgInitServiceHelper.buildAddNewHisVersionParam() departmentDynList size = %s", departmentDynList.size()));
        ArrayList<HisVersionParamBo> invalidHisVersionParamsBos = new ArrayList<HisVersionParamBo>(16);
        List<HisVersionParamBo> hisVersionParamBos = AdminOrgInitServiceHelper.constructOrgBasicInfoHisParam(effectingAdminArray, groupDynList, companyDynList, departmentDynList);
        AdminOrgInitServiceHelper.effectingVersionGenerate(boIdToFirstVid, dynamicObjects, firstVersionIds, hisVersionParamBos);
        AdminOrgInitServiceHelper.invalidVersionGenerate(dynamicObjects, invalidHisVersionParamsBos);
        INVALID_HIS_DATA.set(invalidHisVersionParamsBos);
        return hisVersionParamBos;
    }

    private static void setIndex(Map<Long, List<DynamicObject>> orgHisDyn, Map<Long, Integer> parentBoIdToIndex, Map<Long, Integer> parentInDbBoIdToIndex, DynamicObject dynamicObject) {
        String index = dynamicObject.getString("index");
        if (HRStringUtils.isEmpty((String)index) || "0".equals(index)) {
            if (orgHisDyn.containsKey(dynamicObject.getLong("parentorg.id"))) {
                Integer integer = parentInDbBoIdToIndex.get(dynamicObject.getLong("parentorg.id"));
                if (integer != null) {
                    integer = integer + 1;
                    index = integer + "";
                } else {
                    index = AdminOrgHisServiceHelper.getCurOrgIndex(dynamicObject);
                }
                parentInDbBoIdToIndex.put(dynamicObject.getLong("parentorg.id"), Integer.valueOf(index));
            } else {
                Integer orDefault = parentBoIdToIndex.getOrDefault(dynamicObject.getLong("parentorg.id"), 1);
                index = orDefault + "";
                orDefault = orDefault + 1;
                parentBoIdToIndex.put(dynamicObject.getLong("parentorg.id"), orDefault);
            }
            dynamicObject.set("index", (Object)index);
        }
    }

    private static void effectingVersionGenerate(Map<Long, Long> boIdToFirstVid, Map<String, List<DynamicObject>> dynamicObjects, long[] firstVersionIds, List<HisVersionParamBo> hisVersionParamBos) {
        List<DynamicObject> effectingorgteam = dynamicObjects.get("orgteam").stream().filter(dyn -> dyn.getDate("bsled").compareTo(HisEffDateCommonService.getInstance().getDate2999(null)) == 0).collect(Collectors.toList());
        List<DynamicObject> effectingAdminorgstruct = dynamicObjects.get("adminorgstruct").stream().filter(dyn -> dyn.getDate("bsled").compareTo(HisEffDateCommonService.getInstance().getDate2999(null)) == 0).collect(Collectors.toList());
        List<DynamicObject> effectingAdminorgsortcode = dynamicObjects.get("adminorgsortcode").stream().filter(dyn -> dyn.getDate("bsled").compareTo(HisEffDateCommonService.getInstance().getDate2999(null)) == 0).collect(Collectors.toList());
        List<DynamicObject> effectingorgteamstruct = dynamicObjects.get("orgteamstruct").stream().filter(dyn -> dyn.getDate("bsled").compareTo(HisEffDateCommonService.getInstance().getDate2999(null)) == 0).collect(Collectors.toList());
        HisVersionParamBo hisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(effectingAdminorgsortcode.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey(), false);
        hisVersionParamBos.add(hisVersionParam);
        HisVersionParamBo hisVersionParam1 = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(effectingAdminorgstruct.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), false);
        hisVersionParamBos.add(hisVersionParam1);
        AdminOrgHisDynamicUtils.FIRST_VERSION_IDS.set(firstVersionIds);
        HisVersionParamBo hisVersionParam2 = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(effectingorgteam.toArray(new DynamicObject[0]), "haos_adminorgteam", false);
        hisVersionParamBos.add(hisVersionParam2);
        List<Map<String, Object>> customizedFiledValue = null;
        DynamicObject[] effectingOrgTeamStructArray = effectingorgteamstruct.toArray(new DynamicObject[0]);
        Map[] customizedFiledValueArray = new Map[effectingOrgTeamStructArray.length];
        for (Map.Entry<Long, Long> entry : boIdToFirstVid.entrySet()) {
            Long key = entry.getKey();
            Long value = entry.getValue();
            for (int idx = 0; idx < effectingOrgTeamStructArray.length; ++idx) {
                if (!key.equals(effectingOrgTeamStructArray[idx].getLong("orgteam.id"))) continue;
                HashMap<String, Long> map = new HashMap<String, Long>();
                map.put("orgteamhisid", value);
                effectingOrgTeamStructArray[idx].set("orgteamhisid", (Object)key);
                customizedFiledValueArray[idx] = map;
            }
        }
        customizedFiledValue = Arrays.stream(customizedFiledValueArray).collect(Collectors.toList());
        HisVersionParamBo hisVersionParam3 = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(effectingOrgTeamStructArray, "haos_adminorgstructure", false, customizedFiledValue);
        hisVersionParamBos.add(hisVersionParam3);
    }

    private static void invalidVersionGenerate(Map<String, List<DynamicObject>> dynamicObjects, List<HisVersionParamBo> invalidHisVersionParamsBos) {
        List<DynamicObject> invalidAdminorg = dynamicObjects.get("adminorg").stream().filter(dyn -> dyn.getDate("bsled").compareTo(HisEffDateCommonService.getInstance().getDate2999(null)) != 0).collect(Collectors.toList());
        List<DynamicObject> invalidOrgteam = dynamicObjects.get("orgteam").stream().filter(dyn -> dyn.getDate("bsled").compareTo(HisEffDateCommonService.getInstance().getDate2999(null)) != 0).collect(Collectors.toList());
        List<DynamicObject> invalidAdminorgstruct = dynamicObjects.get("adminorgstruct").stream().filter(dyn -> dyn.getDate("bsled").compareTo(HisEffDateCommonService.getInstance().getDate2999(null)) != 0).collect(Collectors.toList());
        List<DynamicObject> invalidAdminorgsortcode = dynamicObjects.get("adminorgsortcode").stream().filter(dyn -> dyn.getDate("bsled").compareTo(HisEffDateCommonService.getInstance().getDate2999(null)) != 0).collect(Collectors.toList());
        List<DynamicObject> invalidorgteamstruct = dynamicObjects.get("orgteamstruct").stream().filter(dyn -> dyn.getDate("bsled").compareTo(HisEffDateCommonService.getInstance().getDate2999(null)) != 0).collect(Collectors.toList());
        if (invalidAdminorg.size() != 0) {
            HisVersionParamBo invalidAdminOrg = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(invalidAdminorg.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), false);
            invalidHisVersionParamsBos.add(invalidAdminOrg);
        }
        if (invalidAdminorgsortcode.size() != 0) {
            HisVersionParamBo invalidAdminOrgSortCode = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(invalidAdminorgsortcode.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey(), false);
            invalidHisVersionParamsBos.add(invalidAdminOrgSortCode);
        }
        if (invalidAdminorgstruct.size() != 0) {
            HisVersionParamBo invalidAdminOrgStruct = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(invalidAdminorgstruct.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), false);
            invalidHisVersionParamsBos.add(invalidAdminOrgStruct);
        }
        if (invalidOrgteam.size() != 0) {
            HisVersionParamBo invalidOrgTeam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(invalidOrgteam.toArray(new DynamicObject[0]), "haos_adminorgteam", false);
            invalidHisVersionParamsBos.add(invalidOrgTeam);
        }
        if (invalidorgteamstruct.size() != 0) {
            HisVersionParamBo invalidOrgTeamStruct = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(invalidorgteamstruct.toArray(new DynamicObject[0]), "haos_adminorgstructure", false);
            invalidHisVersionParamsBos.add(invalidOrgTeamStruct);
        }
    }

    private static Map<String, List<DynamicObject>> getAllVersionList(DynamicObject[] dysArrays, Map<Long, Long> boIdToFirstVid, InitHisData initHisData, IdCreator idCreator) {
        HashMap<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        HRBaseServiceHelper adminStructServiceHelper = new HRBaseServiceHelper("haos_adminorgstruct");
        HRBaseServiceHelper orgServiceHelper = new HRBaseServiceHelper("haos_adminorgteam");
        HRBaseServiceHelper orgTeamStructServiceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        Map<Long, List<DynamicObject>> parentVsChildrenMap = Arrays.stream(dysArrays).collect(Collectors.groupingBy(dyn -> dyn.getLong("parentorg.id")));
        Map<Long, List<DynamicObject>> orgHisDyn = initHisData.getOrgHisDyn();
        Map<Long, List<DynamicObject>> orgHisStruct = initHisData.getOrgHisStruct();
        Map<Long, List<DynamicObject>> orgHisSortCode = initHisData.getOrgHisSortCode();
        Map<Long, List<DynamicObject>> orgTeamHisStruct = initHisData.getOrgTeamHisStruct();
        InitTreeNode virtualRoot = new InitTreeNode();
        virtualRoot.setId(0L);
        orgHisDyn.forEach((key, value) -> {
            InitTreeNode initTreeNode = new InitTreeNode();
            initTreeNode.setId((Long)key);
            Collections.sort(value, Comparator.comparing(dyn -> dyn.getDate("bsed")));
            initTreeNode.setHisList((List<DynamicObject>)value);
            List orgStruct = (List)orgHisStruct.get(key);
            Collections.sort(orgStruct, Comparator.comparing(dyn -> dyn.getDate("bsed")));
            initTreeNode.setAdminStructHisList(orgStruct);
            List orgSortCode = (List)orgHisSortCode.get(key);
            Collections.sort(orgSortCode, Comparator.comparing(dyn -> dyn.getDate("bsed")));
            initTreeNode.setAdminSortCodeHisList(orgSortCode);
            List orgTeamStruct = (List)orgTeamHisStruct.get(key);
            Collections.sort(orgTeamStruct, Comparator.comparing(dyn -> dyn.getDate("bsed")));
            initTreeNode.setOrgTeamStructHisList(orgTeamStruct);
            virtualRoot.getChildren().add(initTreeNode);
        });
        LinkedList<InitTreeNode> queue = new LinkedList<InitTreeNode>();
        HashSet<Long> set = new HashSet<Long>();
        set.add(1030L);
        set.add(1040L);
        virtualRoot.getChildren().forEach(node -> queue.offer((InitTreeNode)node));
        while (!queue.isEmpty()) {
            InitTreeNode poll = (InitTreeNode)queue.poll();
            List<DynamicObject> parentHisList = poll.getHisList();
            List<DynamicObject> adminStructHisList = poll.getAdminStructHisList();
            List<DynamicObject> adminSortCodeHisList = poll.getAdminSortCodeHisList();
            List<DynamicObject> orgTeamStructHisList = poll.getOrgTeamStructHisList();
            Long parentId = poll.getId();
            List<DynamicObject> childrenDyn = parentVsChildrenMap.get(parentId);
            if (childrenDyn == null || childrenDyn.size() == 0) continue;
            for (DynamicObject child : childrenDyn) {
                InitTreeNode childNode = new InitTreeNode();
                childNode.setId(child.getLong("id"));
                List<DynamicObject> suitableParentHisList = parentHisList.stream().filter(dyn -> child.getDate("establishmentdate").before(dyn.getDate("bsled"))).collect(Collectors.toList());
                List<DynamicObject> parentStructHisList = adminStructHisList.stream().filter(dyn -> child.getDate("establishmentdate").before(dyn.getDate("bsled"))).collect(Collectors.toList());
                List<DynamicObject> parentSortCodeHisList = adminSortCodeHisList.stream().filter(dyn -> child.getDate("establishmentdate").before(dyn.getDate("bsled"))).collect(Collectors.toList());
                List<DynamicObject> parentOrgTeamStructHisList = orgTeamStructHisList.stream().filter(dyn -> child.getDate("establishmentdate").before(dyn.getDate("bsled"))).collect(Collectors.toList());
                AdminOrgInitServiceHelper.generateChildrenAdminOrgVerionList(idCreator, serviceHelper, set, child, childNode, suitableParentHisList);
                AdminOrgInitServiceHelper.generateChildrenOrgTeamVersionList(orgServiceHelper, childNode);
                AdminOrgInitServiceHelper.generateAdminStructVersionList(idCreator, adminStructServiceHelper, child, childNode, parentStructHisList);
                AdminOrgInitServiceHelper.generateAdminSortCodeVersionList(idCreator, child, childNode, parentSortCodeHisList);
                AdminOrgInitServiceHelper.generateOrgTeamStructVersionList(idCreator, orgTeamStructServiceHelper, child, childNode, parentOrgTeamStructHisList);
                AdminOrgInitServiceHelper.setNoRoot(childNode);
                AdminOrgInitServiceHelper.setTime(childNode);
                AdminOrgInitServiceHelper.setBsedOnylOne(child, childNode);
                AdminOrgInitServiceHelper.setSortCodeAndStructNumberAndLevel(childNode);
                AdminOrgInitServiceHelper.fillOrgTeamHisId(boIdToFirstVid, childNode);
                AdminOrgInitServiceHelper.setResultMap(resultMap, childNode);
                poll.getChildren().add(childNode);
                queue.offer(childNode);
            }
        }
        return resultMap;
    }

    private static void setTime(InitTreeNode childNode) {
        Date now = new Date();
        childNode.getHisList().forEach(dyn -> {
            dyn.set("createtime", (Object)now);
            dyn.set("modifytime", (Object)now);
        });
        childNode.getAdminStructHisList().forEach(dyn -> {
            dyn.set("createtime", (Object)now);
            dyn.set("modifytime", (Object)now);
        });
        childNode.getAdminSortCodeHisList().forEach(dyn -> {
            dyn.set("createtime", (Object)now);
            dyn.set("modifytime", (Object)now);
        });
        childNode.getOtHisList().forEach(dyn -> {
            dyn.set("createtime", (Object)now);
            dyn.set("modifytime", (Object)now);
        });
        childNode.getOrgTeamStructHisList().forEach(dyn -> {
            dyn.set("createtime", (Object)now);
            dyn.set("modifytime", (Object)now);
        });
    }

    private static void setNoRoot(InitTreeNode childNode) {
        if (childNode != null && childNode.getAdminStructHisList() != null && childNode.getOrgTeamStructHisList() != null) {
            childNode.getAdminStructHisList().forEach(struct -> struct.set("isroot", (Object)"0"));
            childNode.getOrgTeamStructHisList().forEach(otStruct -> otStruct.set("isroot", (Object)"0"));
        }
    }

    private static void setSortCodeAndStructNumberAndLevel(InitTreeNode childNode) {
        childNode.getHisList().get(childNode.getHisList().size() - 1).set("sortcode", (Object)childNode.getAdminSortCodeHisList().get(childNode.getAdminSortCodeHisList().size() - 1).getString("sortcode"));
        childNode.getHisList().get(childNode.getHisList().size() - 1).set("level", childNode.getAdminStructHisList().get(childNode.getAdminStructHisList().size() - 1).get("level"));
        childNode.getHisList().get(childNode.getHisList().size() - 1).set("structlongnumber", (Object)childNode.getAdminStructHisList().get(childNode.getAdminStructHisList().size() - 1).getString("structlongnumber"));
        childNode.getOtHisList().get(childNode.getOtHisList().size() - 1).set("sortcode", (Object)childNode.getAdminSortCodeHisList().get(childNode.getAdminSortCodeHisList().size() - 1).getString("sortcode"));
        childNode.getOtHisList().get(childNode.getOtHisList().size() - 1).set("level", childNode.getOrgTeamStructHisList().get(childNode.getOrgTeamStructHisList().size() - 1).get("level"));
        childNode.getOtHisList().get(childNode.getOtHisList().size() - 1).set("structlongnumber", (Object)childNode.getOrgTeamStructHisList().get(childNode.getOrgTeamStructHisList().size() - 1).getString("structlongnumber"));
    }

    private static void setResultMap(Map<String, List<DynamicObject>> resultMap, InitTreeNode childNode) {
        List adminorg = resultMap.computeIfAbsent("adminorg", k -> new ArrayList());
        adminorg.addAll(childNode.getHisList());
        List orgteam = resultMap.computeIfAbsent("orgteam", k -> new ArrayList());
        orgteam.addAll(childNode.getOtHisList());
        List adminorgstruct = resultMap.computeIfAbsent("adminorgstruct", k -> new ArrayList());
        adminorgstruct.addAll(childNode.getAdminStructHisList());
        List adminorgsortcode = resultMap.computeIfAbsent("adminorgsortcode", k -> new ArrayList());
        adminorgsortcode.addAll(childNode.getAdminSortCodeHisList());
        List orgteamstruct = resultMap.computeIfAbsent("orgteamstruct", k -> new ArrayList());
        orgteamstruct.addAll(childNode.getOrgTeamStructHisList());
    }

    private static void fillOrgTeamHisId(Map<Long, Long> boIdToFirstVid, InitTreeNode childNode) {
        List<DynamicObject> otHisList = childNode.getOtHisList();
        List<DynamicObject> orgTeamStructHis = childNode.getOrgTeamStructHisList();
        for (int i = 0; i < otHisList.size(); ++i) {
            for (int j = 0; j < orgTeamStructHis.size() - 1; ++j) {
                if (orgTeamStructHis.get(j).getLong("orgteamhisid") != 0L || otHisList.get(i).getDate("bsed").compareTo(orgTeamStructHis.get(j).getDate("bsed")) > 0 || otHisList.get(i).getDate("bsled").compareTo(orgTeamStructHis.get(j).getDate("bsled")) < 0) continue;
                orgTeamStructHis.get(j).set("orgteamhisid", (Object)otHisList.get(i).getLong("id"));
                if (i != otHisList.size() - 1) continue;
                orgTeamStructHis.get(j).set("orgteamhisid", (Object)boIdToFirstVid.get(otHisList.get(i).getLong("id")));
            }
        }
        orgTeamStructHis.get(orgTeamStructHis.size() - 1).set("orgteamhisid", (Object)childNode.getId());
    }

    private static void generateOrgTeamStructVersionList(IdCreator idCreator, HRBaseServiceHelper orgTeamStructServiceHelper, DynamicObject child, InitTreeNode childNode, List<DynamicObject> parentOrgTeamStructHisList) {
        for (int i = 0; i < parentOrgTeamStructHisList.size(); ++i) {
            DynamicObject orgTeamStruct;
            if (i == 0 && child.getDate("establishmentdate").before(parentOrgTeamStructHisList.get(i).getDate("bsed"))) {
                orgTeamStruct = orgTeamStructServiceHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)parentOrgTeamStructHisList.get(i), (DynamicObject)orgTeamStruct);
                Date newSled = HRDateTimeUtils.addDay((Date)parentOrgTeamStructHisList.get(i).getDate("bsed"), (long)-1L);
                orgTeamStruct.set("structproject", (Object)1010L);
                orgTeamStruct.set("bsed", (Object)child.getDate("establishmentdate"));
                orgTeamStruct.set("bsled", (Object)newSled);
                orgTeamStruct.set("id", (Object)idCreator.getId());
                orgTeamStruct.set("enable", (Object)child.getString("enable"));
                orgTeamStruct.set("disabledate", (Object)child.getDate("disabledate"));
                orgTeamStruct.set("orgteam", (Object)child);
                orgTeamStruct.set("parentorgteam", null);
                orgTeamStruct.set("orgteamhisid", (Object)0L);
                orgTeamStruct.set("otclassify", (Object)1010L);
                orgTeamStruct.set("structlongnumber", (Object)child.getString("structnumber"));
                orgTeamStruct.set("level", (Object)orgTeamStruct.getString("structlongnumber").split("!").length);
                childNode.getOrgTeamStructHisList().add(orgTeamStruct);
            }
            orgTeamStruct = orgTeamStructServiceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)parentOrgTeamStructHisList.get(i), (DynamicObject)orgTeamStruct);
            orgTeamStruct.set("id", (Object)idCreator.getId());
            orgTeamStruct.set("structproject", (Object)1010L);
            orgTeamStruct.set("enable", (Object)child.getString("enable"));
            orgTeamStruct.set("disabledate", (Object)child.getDate("disabledate"));
            orgTeamStruct.set("orgteam", (Object)child);
            orgTeamStruct.set("bsed", (Object)parentOrgTeamStructHisList.get(i).getDate("bsed"));
            orgTeamStruct.set("bsled", (Object)parentOrgTeamStructHisList.get(i).getDate("bsled"));
            orgTeamStruct.set("otclassify", (Object)1010L);
            orgTeamStruct.set("orgteamhisid", (Object)0L);
            orgTeamStruct.set("parentorgteam", parentOrgTeamStructHisList.get(i).get("orgteam"));
            orgTeamStruct.set("structlongnumber", (Object)(parentOrgTeamStructHisList.get(i).getString("structlongnumber") + "!" + child.getString("structnumber")));
            orgTeamStruct.set("level", (Object)orgTeamStruct.getString("structlongnumber").split("!").length);
            childNode.getOrgTeamStructHisList().add(orgTeamStruct);
        }
        DynamicObject effectingOrgTeam = childNode.getOrgTeamStructHisList().get(childNode.getOrgTeamStructHisList().size() - 1);
        for (int i = 0; i < childNode.getOrgTeamStructHisList().size() - 1; ++i) {
            childNode.getOrgTeamStructHisList().get(i).set("boid", (Object)effectingOrgTeam.getLong("id"));
        }
        effectingOrgTeam.set("boid", (Object)0L);
    }

    private static void generateAdminSortCodeVersionList(IdCreator idCreator, DynamicObject child, InitTreeNode childNode, List<DynamicObject> parentSortCodeHisList) {
        for (int i = 0; i < parentSortCodeHisList.size(); ++i) {
            DynamicObject dyn;
            if (i == 0 && child.getDate("establishmentdate").before(parentSortCodeHisList.get(i).getDate("bsed"))) {
                dyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey()));
                DynamicObjectUtils.copy((DynamicObject)parentSortCodeHisList.get(i), (DynamicObject)dyn, AdminOrgHisDynamicUtils.getInstance().getMultiLanguageIgnoreKey());
                dyn.set("id", (Object)idCreator.getId());
                dyn.set("adminorg", (Object)child);
                Date newSled = HRDateTimeUtils.addDay((Date)parentSortCodeHisList.get(i).getDate("bsed"), (long)-1L);
                dyn.set("bsed", (Object)child.getDate("establishmentdate"));
                dyn.set("bsled", (Object)newSled);
                dyn.set("enable", (Object)child.getString("enable"));
                dyn.set("disabledate", (Object)child.getDate("disabledate"));
                String sortCodeNumber = AdminOrgInitServiceHelper.fillIndexWithZero(child.getString("index"));
                dyn.set("sortcode", (Object)sortCodeNumber);
                dyn.set("index", (Object)child.getString("index"));
                childNode.getAdminSortCodeHisList().add(dyn);
            }
            dyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey()));
            DynamicObjectUtils.copy((DynamicObject)parentSortCodeHisList.get(i), (DynamicObject)dyn, AdminOrgHisDynamicUtils.getInstance().getMultiLanguageIgnoreKey());
            dyn.set("id", (Object)idCreator.getId());
            dyn.set("adminorg", (Object)child);
            dyn.set("bsed", (Object)parentSortCodeHisList.get(i).getDate("bsed"));
            dyn.set("bsled", (Object)parentSortCodeHisList.get(i).getDate("bsled"));
            dyn.set("enable", (Object)child.getString("enable"));
            dyn.set("disabledate", (Object)child.getDate("disabledate"));
            String sortCodeNumber = AdminOrgInitServiceHelper.fillIndexWithZero(child.getString("index"));
            dyn.set("sortcode", (Object)(parentSortCodeHisList.get(i).getString("sortcode") + "!" + sortCodeNumber));
            dyn.set("index", (Object)child.getString("index"));
            childNode.getAdminSortCodeHisList().add(dyn);
        }
        DynamicObject effectingAdminSort = childNode.getAdminSortCodeHisList().get(childNode.getAdminSortCodeHisList().size() - 1);
        for (int i = 0; i < childNode.getAdminSortCodeHisList().size() - 1; ++i) {
            childNode.getAdminSortCodeHisList().get(i).set("boid", (Object)effectingAdminSort.getLong("id"));
        }
        effectingAdminSort.set("boid", (Object)0L);
    }

    private static void generateAdminStructVersionList(IdCreator idCreator, HRBaseServiceHelper adminStructServiceHelper, DynamicObject child, InitTreeNode childNode, List<DynamicObject> parentStructHisList) {
        for (int i = 0; i < parentStructHisList.size(); ++i) {
            DynamicObject childStruct;
            if (i == 0 && child.getDate("establishmentdate").before(parentStructHisList.get(i).getDate("bsed"))) {
                childStruct = adminStructServiceHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)parentStructHisList.get(i), (DynamicObject)childStruct, AdminOrgHisDynamicUtils.getInstance().getMultiLanguageIgnoreKey());
                childStruct.set("adminorg", (Object)child);
                childStruct.set("parentorg", null);
                childStruct.set("id", (Object)idCreator.getId());
                childStruct.set("structproject", (Object)1010L);
                childStruct.set("enable", (Object)child.getString("enable"));
                childStruct.set("disabledate", (Object)child.getDate("disabledate"));
                childStruct.set("structlongnumber", (Object)child.getString("structnumber"));
                childStruct.set("level", (Object)childStruct.getString("structlongnumber").split("!").length);
                Date newSled = HRDateTimeUtils.addDay((Date)parentStructHisList.get(i).getDate("bsed"), (long)-1L);
                childStruct.set("bsed", (Object)child.getDate("establishmentdate"));
                childStruct.set("bsled", (Object)newSled);
                childNode.getAdminStructHisList().add(childStruct);
            }
            childStruct = adminStructServiceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)parentStructHisList.get(i), (DynamicObject)childStruct, AdminOrgHisDynamicUtils.getInstance().getMultiLanguageIgnoreKey());
            childStruct.set("adminorg", (Object)child);
            DynamicObject parentDynObj = child.getDynamicObject("parentorg");
            childStruct.set("parentorg", (Object)parentDynObj);
            childStruct.set("id", (Object)idCreator.getId());
            childStruct.set("enable", (Object)child.getString("enable"));
            childStruct.set("disabledate", (Object)child.getDate("disabledate"));
            childStruct.set("bsed", (Object)parentStructHisList.get(i).getDate("bsed"));
            childStruct.set("bsled", (Object)parentStructHisList.get(i).getDate("bsled"));
            childStruct.set("structproject", (Object)1010L);
            childStruct.set("structlongnumber", (Object)(parentStructHisList.get(i).getString("structlongnumber") + "!" + child.getString("structnumber")));
            childStruct.set("level", (Object)childStruct.getString("structlongnumber").split("!").length);
            childNode.getAdminStructHisList().add(childStruct);
        }
        DynamicObject effectingAdminStruct = childNode.getAdminStructHisList().get(childNode.getAdminStructHisList().size() - 1);
        for (int i = 0; i < childNode.getAdminStructHisList().size() - 1; ++i) {
            childNode.getAdminStructHisList().get(i).set("boid", (Object)effectingAdminStruct.getLong("id"));
        }
        effectingAdminStruct.set("boid", (Object)0L);
    }

    private static void generateChildrenOrgTeamVersionList(HRBaseServiceHelper orgServiceHelper, InitTreeNode childNode) {
        String orgTeamNumberPrefix = OrgTeamSynService.getNumberByPrefixId(1010L);
        for (int i = 0; i < childNode.getHisList().size(); ++i) {
            DynamicObject mainDyn = childNode.getHisList().get(i);
            DynamicObject adminOrgTeam = orgServiceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)mainDyn, (DynamicObject)adminOrgTeam);
            adminOrgTeam.set("id", (Object)mainDyn.getLong("id"));
            adminOrgTeam.set("boid", (Object)mainDyn.getLong("boid"));
            adminOrgTeam.set("number", (Object)(orgTeamNumberPrefix + "_" + mainDyn.getString("number")));
            adminOrgTeam.set("teamtype", (Object)1010L);
            adminOrgTeam.set("orgtype", (Object)1010L);
            adminOrgTeam.set("parent", mainDyn.get("parentorg"));
            adminOrgTeam.set("otclassify", (Object)1010L);
            adminOrgTeam.set("bsed", (Object)mainDyn.getDate("bsed"));
            adminOrgTeam.set("firstbsed", (Object)mainDyn.getDate("firstbsed"));
            adminOrgTeam.set("enable", (Object)mainDyn.getString("enable"));
            adminOrgTeam.set("status", (Object)"C");
            adminOrgTeam.set("initstatus", (Object)mainDyn.getString("initstatus"));
            adminOrgTeam.set("org", mainDyn.get("org"));
            childNode.getOtHisList().add(adminOrgTeam);
        }
    }

    private static void generateChildrenAdminOrgVerionList(IdCreator idCreator, HRBaseServiceHelper serviceHelper, Set<Long> set, DynamicObject child, InitTreeNode childNode, List<DynamicObject> suitableParentHisList) {
        for (int i = 0; i < suitableParentHisList.size(); ++i) {
            DynamicObject dynamicObject;
            DynamicObject parentHis = suitableParentHisList.get(i);
            if (i == 0 && child.getDate("establishmentdate").before(parentHis.getDate("bsed"))) {
                dynamicObject = serviceHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)child, (DynamicObject)dynamicObject);
                dynamicObject.set("parentorg", null);
                dynamicObject.set("belongcompany", (Object)(set.contains(child.getLong("adminorgtype.adminorgtypestd.id")) ? null : child));
                Date newSled = HRDateTimeUtils.addDay((Date)suitableParentHisList.get(i).getDate("bsed"), (long)-1L);
                dynamicObject.set("bsed", (Object)child.getDate("establishmentdate"));
                dynamicObject.set("bsled", (Object)newSled);
                dynamicObject.set("boid", (Object)childNode.getId());
                dynamicObject.set("id", (Object)idCreator.getId());
                childNode.getHisList().add(dynamicObject);
            }
            dynamicObject = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)child, (DynamicObject)dynamicObject);
            dynamicObject.set("bsed", (Object)suitableParentHisList.get(i).getDate("bsed"));
            dynamicObject.set("bsled", (Object)suitableParentHisList.get(i).getDate("bsled"));
            dynamicObject.set("belongcompany", set.contains(child.getLong("adminorgtype.adminorgtypestd.id")) ? child.getDynamicObject("parentorg").get("belongcompany") : child);
            dynamicObject.set("boid", (Object)childNode.getId());
            dynamicObject.set("id", (Object)idCreator.getId());
            if (i == suitableParentHisList.size() - 1) {
                dynamicObject.set("boid", null);
                dynamicObject.set("id", (Object)childNode.getId());
            }
            childNode.getHisList().add(dynamicObject);
        }
        AdminOrgInitServiceHelper.combineVersionIfNeed(childNode);
        childNode.getHisList().get(childNode.getHisList().size() - 1).set("id", (Object)childNode.getId());
        childNode.getHisList().get(childNode.getHisList().size() - 1).set("boid", null);
    }

    private static void setBsedOnylOne(DynamicObject child, InitTreeNode childNode) {
        if (childNode.getHisList().size() != 0) {
            childNode.getHisList().get(0).set("bsed", (Object)child.getDate("establishmentdate"));
        }
        if (childNode.getOtHisList().size() != 0) {
            childNode.getOtHisList().get(0).set("bsed", (Object)child.getDate("establishmentdate"));
        }
        if (childNode.getAdminStructHisList().size() != 0) {
            childNode.getAdminStructHisList().get(0).set("bsed", (Object)child.getDate("establishmentdate"));
        }
        if (childNode.getOrgTeamStructHisList().size() != 0) {
            childNode.getOrgTeamStructHisList().get(0).set("bsed", (Object)child.getDate("establishmentdate"));
        }
        if (childNode.getAdminSortCodeHisList().size() != 0) {
            childNode.getAdminSortCodeHisList().get(0).set("bsed", (Object)child.getDate("establishmentdate"));
        }
    }

    private static void combineVersionIfNeed(InitTreeNode childNode) {
        List<DynamicObject> hisList = childNode.getHisList();
        ArrayList<DynamicObject> tempList = new ArrayList<DynamicObject>(hisList.size());
        List hasParentHis = hisList.stream().filter(dyn -> dyn.getLong("parentorg.id") != 0L).collect(Collectors.toList());
        List noHasParentHis = hisList.stream().filter(dyn -> dyn.getLong("parentorg.id") == 0L).collect(Collectors.toList());
        tempList.add((DynamicObject)hasParentHis.get(0));
        for (int i = 1; i < hasParentHis.size(); ++i) {
            DynamicObject beforeVersion = (DynamicObject)tempList.get(tempList.size() - 1);
            DynamicObject afterVersion = (DynamicObject)hasParentHis.get(i);
            if (beforeVersion.getLong("belongcompany.id") == afterVersion.getLong("belongcompany.id") && beforeVersion.getLong("parentorg.id") == afterVersion.getLong("parentorg.id")) {
                beforeVersion.set("bsled", (Object)afterVersion.getDate("bsled"));
                if (i != hasParentHis.size() - 1) continue;
                beforeVersion.set("id", (Object)afterVersion.getLong("id"));
                beforeVersion.set("boid", (Object)afterVersion.getLong("boid"));
                continue;
            }
            tempList.add(afterVersion);
        }
        childNode.setHisList(tempList);
        childNode.getHisList().addAll(0, noHasParentHis);
    }

    private static void addGroupCompDepDynByOrgType(DynamicObject dynamicObject, List<DynamicObject> groupDynList, List<DynamicObject> companyDynList, List<DynamicObject> departmentDynList, Map<String, DynamicObject> allParentOrgMap) {
        long adminOrgTypeId = dynamicObject.getLong("adminorgtype.adminorgtypestd.id");
        switch (Objects.requireNonNull(AdminOrgType.getById((long)adminOrgTypeId))) {
            case GROUP: {
                DynamicObject groupDyn = AdminOrgHisServiceHelper.buildNewHisDynamicObject(dynamicObject, AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey());
                groupDynList.add(groupDyn);
                DynamicObject companyDyn = AdminOrgHisServiceHelper.buildNewHisDynamicObject(dynamicObject, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey());
                companyDynList.add(companyDyn);
                dynamicObject.set("belongcompany", (Object)dynamicObject);
                break;
            }
            case COMPANY: {
                DynamicObject company = AdminOrgHisServiceHelper.buildNewHisDynamicObject(dynamicObject, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey());
                companyDynList.add(company);
                dynamicObject.set("belongcompany", (Object)dynamicObject);
                break;
            }
            case DEPARTMENT: {
                DynamicObject departmentDyn = AdminOrgHisServiceHelper.buildNewHisDynamicObject(dynamicObject, AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey());
                departmentDynList.add(departmentDyn);
                dynamicObject.set("belongdept", (Object)dynamicObject);
                dynamicObject.set("belongcompany", (Object)AdminOrgInitServiceHelper.findBelongCompany(allParentOrgMap, dynamicObject));
                break;
            }
            case REGION: {
                dynamicObject.set("belongcompany", (Object)AdminOrgInitServiceHelper.findBelongCompany(allParentOrgMap, dynamicObject));
                break;
            }
        }
    }

    public static DynamicObject findBelongCompany(Map<String, DynamicObject> allParentOrgMap, DynamicObject currentOrg) {
        DynamicObject parentOrg = currentOrg.getDynamicObject("parentorg");
        if (Objects.isNull(parentOrg)) {
            return null;
        }
        DynamicObject parent = allParentOrgMap.get(parentOrg.getString("number"));
        long parentOrgTypeStdId = parent.getLong("adminorgtype.adminorgtypestd.id");
        if (parentOrgTypeStdId == AdminOrgType.COMPANY.getId() || parentOrgTypeStdId == AdminOrgType.GROUP.getId()) {
            return parent;
        }
        return AdminOrgInitServiceHelper.findBelongCompany(allParentOrgMap, parent);
    }

    public static List<HisVersionParamBo> constructOrgBasicInfoHisParam(DynamicObject[] dynArrays, List<DynamicObject> groupDynList, List<DynamicObject> companyDynList, List<DynamicObject> departmentDynList) {
        ArrayList<HisVersionParamBo> listHisVersionParamBo = new ArrayList<HisVersionParamBo>(16);
        LOGGER.info(String.format(Locale.ROOT, "kd.hr.haos.business.servicehelper.AdminOrgInitServiceHelper.constructOrgBasicInfoHisParam() dynArrays size = %s", dynArrays.length));
        if (dynArrays.length != 0) {
            HisVersionParamBo adminOrgHisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(dynArrays, AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), false);
            listHisVersionParamBo.add(adminOrgHisVersionParam);
        }
        if (!CollectionUtils.isEmpty(groupDynList)) {
            HisVersionParamBo groupHisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(groupDynList.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), false);
            listHisVersionParamBo.add(groupHisVersionParam);
        }
        if (!CollectionUtils.isEmpty(companyDynList)) {
            HisVersionParamBo companyHisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(companyDynList.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), false);
            listHisVersionParamBo.add(companyHisVersionParam);
        }
        if (!CollectionUtils.isEmpty(departmentDynList)) {
            HisVersionParamBo departmentHisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(departmentDynList.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), false);
            listHisVersionParamBo.add(departmentHisVersionParam);
        }
        return listHisVersionParamBo;
    }

    public static Map<String, DynamicObject> getBaseOrgInfoMap(Set<String> numberSet, boolean isValidate) {
        HashMap<String, DynamicObject> baseOrgInfoMap = new HashMap<String, DynamicObject>();
        Map<Object, Object> baseOrgInfoToList = new HashMap();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_adminorg_structure");
        ArrayList qFilters = Lists.newArrayListWithCapacity((int)3);
        QFilter numberFilters = new QFilter("org.number", "in", numberSet);
        qFilters.add(numberFilters);
        if (!isValidate) {
            QFilter viewFilters = new QFilter("view.number", "=", (Object)"01");
            qFilters.add(viewFilters);
        }
        QFilter freezsFilters = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        qFilters.add(freezsFilters);
        String selectFields = "id,org,parent,view";
        DynamicObject[] query = serviceHelper.query(selectFields, qFilters.toArray(new QFilter[0]));
        if (query != null && query.length > 0) {
            baseOrgInfoToList = Arrays.stream(query).collect(Collectors.groupingBy(dy -> dy.getString("org.number")));
            block0: for (Map.Entry<Object, Object> entry : baseOrgInfoToList.entrySet()) {
                for (DynamicObject dy2 : (List)entry.getValue()) {
                    if (!HRStringUtils.equals((String)"01", (String)dy2.getString("view.number"))) continue;
                    baseOrgInfoMap.put((String)entry.getKey(), dy2);
                    continue block0;
                }
            }
        }
        return baseOrgInfoMap;
    }

    public static Set<Long> getBaseOrgInfoMapById(Set<Long> orgIds) {
        HashSet<Long> baseOrgIds = new HashSet<Long>();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_adminorg_structure");
        String selectFields = "id,org,parent";
        QFilter idFilters = new QFilter("org.id", "in", orgIds);
        QFilter viewFilters = new QFilter("view.number", "=", (Object)"01");
        QFilter freezsFilters = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        DynamicObject[] query = serviceHelper.query(selectFields, new QFilter[]{idFilters, viewFilters, freezsFilters});
        if (query != null && query.length > 0) {
            Arrays.stream(query).forEach(dy -> baseOrgIds.add(dy.getLong("org.id")));
        }
        return baseOrgIds;
    }

    public static Map<String, List<DynamicObject>> getBaseOrgInfoMapByName(Set<String> nameSet) {
        Map<String, List<DynamicObject>> baseOrgInfoMap = new HashMap<String, List<DynamicObject>>();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_adminorg_structure");
        String selectFields = "id,org,parent,view";
        QFilter numberFilters = new QFilter("org.name", "in", nameSet);
        QFilter viewFilters = new QFilter("view.number", "=", (Object)"01");
        QFilter freezsFilters = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        DynamicObject[] query = serviceHelper.query(selectFields, new QFilter[]{numberFilters, viewFilters, freezsFilters});
        if (query != null && query.length > 0) {
            baseOrgInfoMap = Arrays.stream(query).collect(Collectors.groupingBy(dy -> dy.getString("org.name")));
        }
        return baseOrgInfoMap;
    }
}

