/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.servicehelper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.haos.business.servicehelper.AdminOrgInitServiceHelper;
import kd.hr.haos.business.util.NameSeparatorTipsUtil;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.haos.business.util.PatternUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class AdminOrgInitValidateServiceHelper {
    public static final String HRMP_HAOS_BUSINESS = "hrmp-haos-business";
    private static final Log LOG = LogFactory.getLog(AdminOrgInitValidateServiceHelper.class);
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("haos_adminorgdetail");
    private static final Long NUMBER_ORGTYPE_GROUP = 1010L;
    private static final Long NUMBER_ORGTYPE_COMPANY = 1020L;
    private static final Long NUMBER_ORGTYPE_AREA = 1030L;
    private static final Long NUMBER_ORGTYPE_DEPARTMENT = 1040L;

    public static void validateIsEmpty(Map<Long, DynamicObject> initParams, Map<Long, List<String>> result, List<Map<String, Object>> result2) {
        List<String> orgNumberList = AdminOrgInitValidateServiceHelper.getOrgNumber(initParams);
        Map<Long, Map> initParamsMap = result2.stream().collect(Collectors.toMap(key -> Long.parseLong(key.get("id").toString()), map -> map, (key1, key2) -> key1));
        initParams.forEach((key, dy) -> {
            boolean tobedisableFlag;
            String enable;
            List errors = result.getOrDefault(key, new ArrayList());
            if (HRObjectUtils.isEmpty((Object)dy.get("name"))) {
                errors.add(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u884c\u653f\u7ec4\u7ec7\u540d\u79f0\u201d\u3002", (String)"AdminOrgInitValidateServiceHelper_0", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)dy.get("number"))) {
                errors.add(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u201d\u3002", (String)"AdminOrgInitValidateServiceHelper_1", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)dy.get("adminorgtype")) && HRObjectUtils.isEmpty(((Map)initParamsMap.getOrDefault(key, new HashMap())).get("adminorgtype"))) {
                errors.add(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201d\u3002", (String)"AdminOrgInitValidateServiceHelper_2", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)dy.get("parentorg"))) {
                if (HRObjectUtils.isEmpty(((Map)initParamsMap.getOrDefault(key, new HashMap())).get("parentorg"))) {
                    errors.add(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u201d\u3002", (String)"AdminOrgInitValidateServiceHelper_3", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                } else {
                    errors.add(ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7684\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_5", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                }
            } else if (!HRStringUtils.equals((String)"1", (String)dy.getDynamicObject("parentorg").getString("datastatus"))) {
                errors.add(ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7684\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_5", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)dy.get("establishmentdate"))) {
                errors.add(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6210\u7acb\u65e5\u671f\u201d\u3002", (String)"AdminOrgInitValidateServiceHelper_4", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            if (HRStringUtils.isNotEmpty((String)(enable = dy.getString("enable"))) && HRStringUtils.equals((String)"0", (String)enable)) {
                if (HRObjectUtils.isEmpty((Object)dy.get("disabledate"))) {
                    errors.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c\u505c\u7528\u201d\u65f6\uff0c\u201c\u505c\u7528\u65e5\u671f\u201d\u5fc5\u586b\u3002", (String)"AdminOrgInitValidateServiceHelper_6", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                }
            } else if (!HRObjectUtils.isEmpty((Object)dy.get("disabledate"))) {
                errors.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c\u505c\u7528\u201d\u65f6\uff0c\u201c\u505c\u7528\u65e5\u671f\u201d\u624d\u5fc5\u586b\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_7", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            if (tobedisableFlag = dy.getBoolean("tobedisableflag")) {
                if (HRObjectUtils.isEmpty((Object)dy.get("tobedisabledate"))) {
                    errors.add(ResManager.loadKDString((String)"\u201c\u662f\u5426\u5f85\u505c\u7528\u201d\u4e3a\u201c\u662f\u201d\uff0c\u201c\u5f85\u505c\u7528\u65e5\u671f\u201d\u5fc5\u586b\uff0c\u82e5\u4e3a\u201c\u5426\u201d\u5219\u201c\u5f85\u505c\u7528\u65e5\u671f\u201d\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_8", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                }
            } else if (!HRObjectUtils.isEmpty((Object)dy.get("tobedisabledate"))) {
                errors.add(ResManager.loadKDString((String)"\u201c\u662f\u5426\u5f85\u505c\u7528\u201d\u4e3a\u201c\u662f\u201d\uff0c\u201c\u5f85\u505c\u7528\u65e5\u671f\u201d\u5fc5\u586b\uff0c\u82e5\u4e3a\u201c\u5426\u201d\u5219\u201c\u5f85\u505c\u7528\u65e5\u671f\u201d\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_8", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)dy.get("org"))) {
                errors.add(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u7f16\u7801\u201d\u3002", (String)"AdminOrgInitValidateServiceHelper_67", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            } else if (CollectionUtils.isEmpty((Collection)orgNumberList) || !orgNumberList.contains(dy.getString("org.number"))) {
                errors.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u7f16\u7801\u5728\u201cHR\u57fa\u7840\u670d\u52a1\u4e91>HR\u57fa\u7840\u670d\u52a1>HR\u4e1a\u52a1\u7ba1\u7406\u89c6\u56fe\u201d\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdminOrgInitValidateServiceHelper_68", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            if (errors != null && errors.size() > 0) {
                result.put((Long)key, errors);
            }
        });
    }

    public static List<String> getOrgNumber(Map<Long, DynamicObject> initParams) {
        QFilter orgFilter;
        QFilter enableFilter;
        QFilter viewFilter;
        HRBaseServiceHelper helper;
        DynamicObject[] dys;
        HashSet orgIdList = new HashSet();
        initParams.values().forEach(dy -> {
            DynamicObject org = dy.getDynamicObject("org");
            if (!HRObjectUtils.isEmpty((Object)org)) {
                orgIdList.add(org.getLong("id"));
            }
        });
        List<String> orgNumberList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(orgIdList) && (dys = (helper = new HRBaseServiceHelper("bos_org_structure")).query("id,org", new QFilter[]{viewFilter = new QFilter("view.number", "=", (Object)"21"), enableFilter = new QFilter("enable", "=", (Object)"1"), orgFilter = new QFilter("org.id", "in", orgIdList)})) != null && dys.length > 0) {
            orgNumberList = Arrays.stream(dys).map(dy -> dy.getString("org.number")).collect(Collectors.toList());
        }
        return orgNumberList;
    }

    public static void validateUniqueNumber(Map<Long, DynamicObject> initParams, Map<Long, List<String>> result, boolean isRoot) {
        HashMap<String, Integer> numberSizeMap = new HashMap<String, Integer>();
        HashSet<String> numberSet = new HashSet<String>();
        AdminOrgInitValidateServiceHelper.getNumberCollect(initParams, numberSizeMap, numberSet);
        QFilter numberFilter = new QFilter("number", "in", numberSet);
        QFilter statusFilter = new QFilter("status", "=", (Object)"A");
        QFilter statusNotAFilter = new QFilter("status", "!=", (Object)"A");
        DynamicObject[] masterDy = HELPER.query("number", new QFilter[]{numberFilter, statusNotAFilter});
        DynamicObject[] saveDy = HELPER.query("number", new QFilter[]{statusFilter, numberFilter});
        List<Object> saveCollect = new ArrayList();
        if (saveDy != null && saveDy.length > 0) {
            saveCollect = Arrays.stream(saveDy).map(dy -> dy.getString("number")).collect(Collectors.toList());
        }
        Set<Object> nameSet = new HashSet();
        if (masterDy != null && masterDy.length > 0) {
            nameSet = Arrays.stream(masterDy).map(dy -> dy.getString("number")).collect(Collectors.toSet());
        }
        Map<String, DynamicObject> baseOrgInfoMap = AdminOrgInitServiceHelper.getBaseOrgInfoMap(numberSet, true);
        List<Object> finalSaveCollect = saveCollect;
        HashSet finalNameSet = nameSet;
        initParams.forEach((key, dy) -> {
            String number = dy.getString("number");
            if (HRStringUtils.isNotEmpty((String)number)) {
                List errors = result.getOrDefault(key, new ArrayList());
                if (numberSizeMap.getOrDefault(number, 0) > 1) {
                    errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u5728\u5bfc\u5165\u6a21\u677f\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_9", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                }
                if (finalNameSet.size() > 0 && finalNameSet.contains(number)) {
                    errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_10", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                }
                if (finalSaveCollect.size() > 0 && finalSaveCollect.contains(number)) {
                    errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\u5728\u9014\u5355\u636e\u4e2d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_11", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                }
                AdminOrgInitValidateServiceHelper.checkBaseNumber(isRoot, baseOrgInfoMap, dy, number, errors);
                if (number.contains("!") || number.contains("\uff01")) {
                    errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\uff08!\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_71", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                }
                if (errors != null && errors.size() > 0) {
                    result.put((Long)key, errors);
                }
            }
        });
    }

    private static void checkBaseNumber(boolean isRoot, Map<String, DynamicObject> baseOrgInfoMap, DynamicObject dy, String number, List<String> errors) {
        if (!isRoot && baseOrgInfoMap.size() > 0) {
            String name = dy.getString("name");
            String parentOrgNumber = dy.getString("parentorg.number");
            DynamicObject baseOrgDy = baseOrgInfoMap.get(number);
            if (HRStringUtils.isNotEmpty((String)name) && HRStringUtils.isNotEmpty((String)parentOrgNumber) && baseOrgDy != null) {
                String baseName = baseOrgDy.getString("org.name");
                String baseParentOrgNumber = baseOrgDy.getString("parent.number");
                if (HRStringUtils.isNotEmpty((String)baseName) && HRStringUtils.isNotEmpty((String)baseParentOrgNumber) && (!HRStringUtils.equals((String)name, (String)baseName) || !HRStringUtils.equals((String)parentOrgNumber, (String)baseParentOrgNumber))) {
                    errors.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0\u548c\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u4e0e\u5e73\u53f0\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_47", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                }
            }
        }
    }

    public static boolean checkNumber(DynamicObject dy, DynamicObject baseOrgDy) {
        if (baseOrgDy == null || dy.get("parentorg") == null || baseOrgDy.get("parent") == null) {
            return false;
        }
        String parentOrgNumber = dy.getString("parentorg.number");
        String baseParentOrgNumber = baseOrgDy.getString("parent.number");
        String baseName = baseOrgDy.getString("org.name");
        String name = dy.getString("name");
        return !StringUtils.isEmpty((CharSequence)baseParentOrgNumber) && !StringUtils.isEmpty((CharSequence)baseName) && baseParentOrgNumber.equals(parentOrgNumber) && baseName.equals(name);
    }

    private static void getNumberCollect(Map<Long, DynamicObject> initParams, Map<String, Integer> numberSiseMap, Set<String> numberSet) {
        initParams.forEach((key, dy) -> {
            String number = dy.getString("number");
            if (HRStringUtils.isNotEmpty((String)number)) {
                numberSiseMap.put(number, numberSiseMap.getOrDefault(number, 0) + 1);
                numberSet.add(number);
            }
        });
    }

    public static void validateName(Map<Long, DynamicObject> initParams, Map<Long, List<String>> result) {
        HashMap<Long, Long> initBaseOrgIdMap = new HashMap<Long, Long>();
        HashMap<String, Integer> nameSizeMap = new HashMap<String, Integer>();
        HashSet<String> nameSet = new HashSet<String>();
        AdminOrgInitValidateServiceHelper.getNameCollection(initParams, nameSizeMap, nameSet);
        QFilter nameFilter = new QFilter("name", "in", nameSet);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter notCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        DynamicObject[] dys = HELPER.query("name,number,parentorg,bsed,bsled", new QFilter[]{nameFilter, enableFilter, notCurrentVersionFilter});
        DynamicObject[] currentDys = HELPER.query("name,number,parentorg", new QFilter[]{nameFilter, enableFilter, currentVersionFilter});
        Set currentNameSet = Arrays.stream(currentDys).map(dy -> dy.getString("name") + dy.getString("parentorg.number")).collect(Collectors.toSet());
        Map<String, List<DynamicObject>> baseOrgInfoMapByName = AdminOrgInitServiceHelper.getBaseOrgInfoMapByName(nameSet);
        HashMap<String, Set> parentOrgNumberAndChildOrgNamesMap = new HashMap<String, Set>(dys.length);
        for (DynamicObject dy2 : dys) {
            String parentOrgNumber = dy2.getString("parentorg.number");
            if (StringUtils.isEmpty((CharSequence)parentOrgNumber)) continue;
            Set childOrg = parentOrgNumberAndChildOrgNamesMap.getOrDefault(parentOrgNumber, new HashSet());
            childOrg.add(dy2);
            parentOrgNumberAndChildOrgNamesMap.put(parentOrgNumber, childOrg);
        }
        PatternUtil patternUtil = new PatternUtil();
        NameSeparatorTipsUtil nameSeparatorTipsUtil = new NameSeparatorTipsUtil();
        initParams.forEach((key, dy) -> {
            String name = dy.getString("name");
            String parentNumber = dy.getString("parentorg.number");
            if (HRStringUtils.isNotEmpty((String)name)) {
                List baseOrgInfoList;
                List errors = result.getOrDefault(key, new ArrayList());
                if (patternUtil.validName4Config(name)) {
                    errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\uff08%s\uff09,\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_12", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[]{nameSeparatorTipsUtil.getAllSeparator()}));
                }
                String enable = dy.getString("enable");
                if (HRStringUtils.isNotEmpty((String)parentNumber) && (HRStringUtils.isEmpty((String)enable) || HRStringUtils.equals((String)"1", (String)enable))) {
                    Set childOrg;
                    boolean isExist;
                    if (nameSizeMap.size() > 0 && nameSizeMap.getOrDefault(name + parentNumber, 0) > 1) {
                        errors.add(ResManager.loadKDString((String)"\u5728\u540c\u4e00\u4e0a\u7ea7\u90e8\u95e8\uff0c\u884c\u653f\u7ec4\u7ec7\u540d\u79f0\uff0c\u5bfc\u5165\u6a21\u677f\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_13", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                    }
                    if (!(isExist = AdminOrgInitValidateServiceHelper.checkHisName(childOrg = (Set)parentOrgNumberAndChildOrgNamesMap.getOrDefault(parentNumber, new HashSet()), dy, name, errors)) && currentNameSet.size() > 0 && currentNameSet.contains(name + parentNumber)) {
                        String parentName = dy.getString("parentorg.name");
                        String errorMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0b\u5df2\u5b58\u5728\u884c\u653f\u7ec4\u7ec7\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_14", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]), parentName, name);
                        errors.add(errorMessage);
                    }
                }
                if ((baseOrgInfoList = (List)baseOrgInfoMapByName.get(name)) != null && baseOrgInfoList.size() > 0) {
                    String parentOrgNumber = dy.getString("parentorg.number");
                    for (DynamicObject baseOrgInfo : baseOrgInfoList) {
                        String baseParentOrgNumber = baseOrgInfo.getString("parent.number");
                        if (!HRStringUtils.equals((String)parentOrgNumber, (String)baseParentOrgNumber) || !HRStringUtils.equals((String)"01", (String)baseOrgInfo.getString("view.number"))) continue;
                        long baseOrgId = baseOrgInfo.getLong("org.id");
                        initBaseOrgIdMap.put(baseOrgId, (Long)key);
                    }
                }
                if (errors != null && errors.size() > 0) {
                    result.put((Long)key, errors);
                }
            }
        });
        AdminOrgInitValidateServiceHelper.checkBaseOrgId(initParams, result, initBaseOrgIdMap);
    }

    private static void checkBaseOrgId(Map<Long, DynamicObject> initParams, Map<Long, List<String>> result, Map<Long, Long> initBaseOrgIdMap) {
        Long[] baseOrgIds;
        Object[] dynamicObjects;
        if (initBaseOrgIdMap.size() > 0 && !ArrayUtils.isEmpty((Object[])(dynamicObjects = AdminOrgInitValidateServiceHelper.getAdminOrgIds(baseOrgIds = initBaseOrgIdMap.keySet().toArray(new Long[0]))))) {
            Stream.of(dynamicObjects).forEach(dy -> {
                long orgId = dy.getLong("id");
                Long key = (Long)initBaseOrgIdMap.get(orgId);
                List errors = result.getOrDefault(key, new ArrayList());
                String errorMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0e\u201c%2$s%3$sID\u201d\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u7ec4\u7ec7\u7f16\u7801\u548c\u7ec4\u7ec7\u540d\u79f0\u3002", (String)"AdminOrgInitValidateServiceHelper_64", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]), ((DynamicObject)initParams.get(key)).getString("name"), dy.getString("number"), dy.getString("name"));
                errors.add(errorMessage);
            });
        }
    }

    private static boolean checkHisName(Set<DynamicObject> dys, DynamicObject dy, String name, List<String> errors) {
        Date date = dy.getDate("establishmentdate");
        if (dys != null && dys.size() > 0 && !HRObjectUtils.isEmpty((Object)date)) {
            for (DynamicObject dynamicObject : dys) {
                String hisName = dynamicObject.getString("name");
                Date bsledDate = dynamicObject.getDate("bsled");
                if (!HRStringUtils.equals((String)name, (String)hisName) || HRDateTimeUtils.dayAfter((Date)date, (Date)bsledDate)) continue;
                String parentName = dy.getString("parentorg.name");
                String errorMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0b\u5df2\u5b58\u5728\u884c\u653f\u7ec4\u7ec7\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_14", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]), parentName, name);
                errors.add(errorMessage);
                return true;
            }
        }
        return false;
    }

    private static void getNameCollection(Map<Long, DynamicObject> initParams, Map<String, Integer> nameSizeMap, Set<String> nameSet) {
        initParams.forEach((key, dy) -> {
            String name = dy.getString("name");
            String parentNumber = dy.getString("parentorg.number");
            if (HRStringUtils.isNotEmpty((String)name) && HRStringUtils.isNotEmpty((String)parentNumber)) {
                String nameAndNumber = name + parentNumber;
                nameSizeMap.put(nameAndNumber, nameSizeMap.getOrDefault(nameAndNumber, 0) + 1);
                nameSet.add(name);
            }
        });
    }

    public static void validateLength(Map<Long, DynamicObject> initParams, Map<Long, List<String>> result) {
        initParams.forEach((key, dy) -> {
            String number;
            String name;
            String description;
            String safedescription;
            String mainduty;
            String positioning;
            String groupmission;
            String groupvision;
            String detailAddress;
            List errors = result.getOrDefault(key, new ArrayList());
            String simpleName = dy.getString("simplename");
            if (HRStringUtils.isNotEmpty((String)simpleName) && simpleName.length() > 100) {
                errors.add(ResManager.loadKDString((String)"\u7b80\u79f0\u5185\u5bb9\u8d85\u957f\uff0c\u53ea\u652f\u6301\u586b\u5199100\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_15", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            if (HRStringUtils.isNotEmpty((String)(detailAddress = dy.getString("detailaddress"))) && detailAddress.length() > 255) {
                errors.add(ResManager.loadKDString((String)"\u8be6\u7ec6\u5730\u5740\u5185\u5bb9\u8d85\u957f\uff0c\u53ea\u652f\u6301\u586b\u5199255\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_16", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            if (HRStringUtils.isNotEmpty((String)(groupvision = dy.getString("groupvision"))) && groupvision.length() > 255) {
                errors.add(ResManager.loadKDString((String)"\u96c6\u56e2\u613f\u666f\u5185\u5bb9\u8d85\u957f\uff0c\u53ea\u652f\u6301\u586b\u5199255\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_17", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            if (HRStringUtils.isNotEmpty((String)(groupmission = dy.getString("groupmission"))) && groupmission.length() > 100) {
                errors.add(ResManager.loadKDString((String)"\u96c6\u56e2\u4f7f\u547d\u5185\u5bb9\u8d85\u957f\uff0c\u53ea\u652f\u6301\u586b\u5199100\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_18", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            if (HRStringUtils.isNotEmpty((String)(positioning = dy.getString("positioning"))) && positioning.length() > 2000) {
                errors.add(ResManager.loadKDString((String)"\u5b9a\u4f4d\u5185\u5bb9\u8d85\u957f\uff0c\u53ea\u652f\u6301\u586b\u51992000\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_19", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            if (HRStringUtils.isNotEmpty((String)(mainduty = dy.getString("mainduty"))) && mainduty.length() > 2000) {
                errors.add(ResManager.loadKDString((String)"\u4e3b\u8981\u804c\u8d23\u5185\u5bb9\u8d85\u957f\uff0c\u53ea\u652f\u6301\u586b\u51992000\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_20", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            if (HRStringUtils.isNotEmpty((String)(safedescription = dy.getString("safedescription"))) && safedescription.length() > 255) {
                errors.add(ResManager.loadKDString((String)"\u4fdd\u5bc6\u63cf\u8ff0\u5185\u5bb9\u8d85\u957f\uff0c\u53ea\u652f\u6301\u586b\u5199255\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_21", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            if (HRStringUtils.isNotEmpty((String)(description = dy.getString("description"))) && description.length() > 255) {
                errors.add(ResManager.loadKDString((String)"\u63cf\u8ff0\u5185\u5bb9\u8d85\u957f\uff0c\u53ea\u652f\u6301\u586b\u5199255\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_22", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            if (HRStringUtils.isNotEmpty((String)(name = dy.getString("name"))) && name.length() > 100) {
                errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u540d\u79f0\u8d85\u957f\uff0c\u53ea\u652f\u6301\u586b\u5199100\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_43", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            if (HRStringUtils.isNotEmpty((String)(number = dy.getString("number"))) && name.length() > 60) {
                errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u8d85\u957f\uff0c\u53ea\u652f\u6301\u586b\u519960\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_44", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            if (errors != null && errors.size() > 0) {
                result.put((Long)key, errors);
            }
        });
    }

    public static void validateParentOrg(Map<Long, DynamicObject> initParams, Map<Long, List<String>> result) {
        initParams.forEach((key, dy) -> {
            List errors = result.getOrDefault(key, new ArrayList());
            DynamicObject parentOrg = dy.getDynamicObject("parentorg");
            if (!HRObjectUtils.isEmpty((Object)parentOrg) && HRStringUtils.equals((String)"1", (String)dy.getDynamicObject("parentorg").getString("datastatus"))) {
                String number;
                String enable;
                String parentNumber = parentOrg.getString("number");
                String parentEnable = parentOrg.getString("enable");
                if (HRStringUtils.isNotEmpty((String)parentEnable) && HRStringUtils.equals((String)"0", (String)parentEnable) && (HRStringUtils.isEmpty((String)(enable = dy.getString("enable"))) || !HRStringUtils.equals((String)"0", (String)enable))) {
                    errors.add(ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_24", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                }
                if (HRStringUtils.isNotEmpty((String)(number = dy.getString("number"))) && HRStringUtils.isNotEmpty((String)parentNumber) && HRStringUtils.equals((String)number, (String)parentNumber)) {
                    errors.add(ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7684\u7f16\u7801\u4e0d\u80fd\u4e0e\u8be5\u884c\u653f\u7ec4\u7ec7\u7684\u7f16\u7801\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_42", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                }
                if ("true".equals(parentOrg.getString("isvirtualorg"))) {
                    errors.add(ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4e3a\u865a\u62df\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_72", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                }
                if (errors != null && errors.size() > 0) {
                    result.put((Long)key, errors);
                }
            }
        });
    }

    public static void validateDate(Map<Long, DynamicObject> initParams, Map<Long, List<String>> result) {
        initParams.forEach((key, dy) -> {
            List errors = result.getOrDefault(key, new ArrayList());
            Date establishmentdate = dy.getDate("establishmentdate");
            if (!HRObjectUtils.isEmpty((Object)establishmentdate) && HRDateTimeUtils.dayBefore((Date)new Date(), (Date)establishmentdate)) {
                errors.add(ResManager.loadKDString((String)"\u6210\u7acb\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_26", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            String enable = dy.getString("enable");
            Date disabledate = dy.getDate("disabledate");
            if (HRStringUtils.isNotEmpty((String)enable) && HRStringUtils.equals((String)"0", (String)enable)) {
                if (!HRObjectUtils.isEmpty((Object)disabledate) && HRDateTimeUtils.dayBefore((Date)new Date(), (Date)disabledate)) {
                    errors.add(ResManager.loadKDString((String)"\u505c\u7528\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_45", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                }
                if (!(HRObjectUtils.isEmpty((Object)disabledate) || HRObjectUtils.isEmpty((Object)establishmentdate) || HRDateTimeUtils.dayBefore((Date)establishmentdate, (Date)disabledate))) {
                    errors.add(ResManager.loadKDString((String)"\u505c\u7528\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u6210\u7acb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_46", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                }
            }
            if (errors != null && errors.size() > 0) {
                result.put((Long)key, errors);
            }
        });
    }

    public static void validateLevel4Model(Map<Long, DynamicObject> initParams, Map<Long, List<String>> result) {
        Map<Long, Long> parentOrgTypeMap = AdminOrgInitValidateServiceHelper.getParentOrgTypeMap(initParams);
        if (parentOrgTypeMap != null && parentOrgTypeMap.size() > 0) {
            initParams.forEach((key, dy) -> {
                List errors = result.getOrDefault(key, new ArrayList());
                DynamicObject adminorgtype = dy.getDynamicObject("adminorgtype");
                DynamicObject parentorg = dy.getDynamicObject("parentorg");
                if (!HRObjectUtils.isEmpty((Object)adminorgtype) && !HRObjectUtils.isEmpty((Object)parentorg) && HRStringUtils.equals((String)"1", (String)dy.getDynamicObject("parentorg").getString("datastatus"))) {
                    Long orgtypeStdNumber = adminorgtype.getLong("adminorgtypestd.id");
                    Long parentorgTypeNumber = (Long)parentOrgTypeMap.get(parentorg.getLong("adminorgtype.id"));
                    if (parentorgTypeNumber != null) {
                        if (NUMBER_ORGTYPE_GROUP.equals(orgtypeStdNumber) && !Arrays.asList(NUMBER_ORGTYPE_GROUP, NUMBER_ORGTYPE_AREA).contains(parentorgTypeNumber)) {
                            errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u201c\u96c6\u56e2\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c\u96c6\u56e2/\u533a\u57df\u201d\uff0c \u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_27", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                        } else if (NUMBER_ORGTYPE_COMPANY.equals(orgtypeStdNumber) && !Arrays.asList(NUMBER_ORGTYPE_GROUP, NUMBER_ORGTYPE_COMPANY, NUMBER_ORGTYPE_AREA).contains(parentorgTypeNumber)) {
                            errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u201c\u516c\u53f8\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c\u96c6\u56e2/\u533a\u57df/\u516c\u53f8\u201d\uff0c \u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_28", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                        }
                    }
                }
                if (errors != null && errors.size() > 0) {
                    result.put((Long)key, errors);
                }
            });
        }
    }

    public static void validateAdminorgType(Map<Long, DynamicObject> initParams, Map<Long, List<String>> result, boolean isRoot) {
        initParams.forEach((key, dy) -> {
            List errors = result.getOrDefault(key, new ArrayList());
            DynamicObject adminorgtype = dy.getDynamicObject("adminorgtype");
            if (!HRObjectUtils.isEmpty((Object)adminorgtype)) {
                Long orgtypeStdNumber = adminorgtype.getLong("adminorgtypestd.id");
                if (NUMBER_ORGTYPE_COMPANY.equals(orgtypeStdNumber)) {
                    if (HRStringUtils.isNotEmpty((String)dy.getString("groupvision"))) {
                        errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u201c\u516c\u53f8\u201d\u65f6\uff0c\u201c\u96c6\u56e2\u613f\u666f\u201d\u65e0\u9700\u586b\u5199\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_29", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                    }
                    if (HRStringUtils.isNotEmpty((String)dy.getString("groupmission"))) {
                        errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u201c\u516c\u53f8\u201d\u65f6\uff0c\u201c\u96c6\u56e2\u4f7f\u547d\u201d\u65e0\u9700\u586b\u5199\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_30", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                    }
                    if (!HRObjectUtils.isEmpty((Object)dy.get("departmenttype"))) {
                        errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u201c\u516c\u53f8\u201d\u65f6\uff0c\u201c\u90e8\u95e8\u7c7b\u578b\u201d\u65e0\u9700\u586b\u5199\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_61", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                    }
                } else if (NUMBER_ORGTYPE_AREA.equals(orgtypeStdNumber) && !isRoot) {
                    if (!HRObjectUtils.isEmpty((Object)dy.get("companytype"))) {
                        errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u201c\u533a\u57df\u201d\u65f6\uff0c\u201c\u516c\u53f8\u7c7b\u578b\u201d\u65e0\u9700\u586b\u5199\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_31", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                    }
                    if (!HRObjectUtils.isEmpty((Object)dy.get("industrytype"))) {
                        errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u201c\u533a\u57df\u201d\u65f6\uff0c\u201c\u884c\u4e1a\u7c7b\u522b\u201d\u65e0\u9700\u586b\u5199\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_32", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                    }
                    if (HRStringUtils.isNotEmpty((String)dy.getString("groupvision"))) {
                        errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u201c\u533a\u57df\u201d\u65f6\uff0c\u201c\u96c6\u56e2\u613f\u666f\u201d\u65e0\u9700\u586b\u5199\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_33", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                    }
                    if (HRStringUtils.isNotEmpty((String)dy.getString("groupmission"))) {
                        errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u201c\u533a\u57df\u201d\u65f6\uff0c\u201c\u96c6\u56e2\u4f7f\u547d\u201d\u65e0\u9700\u586b\u5199\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_34", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                    }
                    if (!HRObjectUtils.isEmpty((Object)dy.get("departmenttype"))) {
                        errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u201c\u533a\u57df\u201d\u65f6\uff0c\u201c\u90e8\u95e8\u7c7b\u578b\u201d\u65e0\u9700\u586b\u5199\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_62", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                    }
                } else if (NUMBER_ORGTYPE_DEPARTMENT.equals(orgtypeStdNumber) && !isRoot) {
                    if (!HRObjectUtils.isEmpty((Object)dy.get("companytype"))) {
                        errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u201c\u90e8\u95e8\u201d\u65f6\uff0c\u201c\u516c\u53f8\u7c7b\u578b\u201d\u65e0\u9700\u586b\u5199\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_35", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                    }
                    if (!HRObjectUtils.isEmpty((Object)dy.get("industrytype"))) {
                        errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u201c\u90e8\u95e8\u201d\u65f6\uff0c\u201c\u884c\u4e1a\u7c7b\u522b\u201d\u65e0\u9700\u586b\u5199\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_36", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                    }
                    if (HRStringUtils.isNotEmpty((String)dy.getString("groupvision"))) {
                        errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u201c\u90e8\u95e8\u201d\u65f6\uff0c\u201c\u96c6\u56e2\u613f\u666f\u201d\u65e0\u9700\u586b\u5199\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_37", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                    }
                    if (HRStringUtils.isNotEmpty((String)dy.getString("groupmission"))) {
                        errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u201c\u90e8\u95e8\u201d\u65f6\uff0c\u201c\u96c6\u56e2\u4f7f\u547d\u201d\u65e0\u9700\u586b\u5199\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_38", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                    }
                } else if (NUMBER_ORGTYPE_GROUP.equals(orgtypeStdNumber)) {
                    if (!HRObjectUtils.isEmpty((Object)dy.get("departmenttype"))) {
                        errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u201c\u96c6\u56e2\u201d\uff0c\u201c\u90e8\u95e8\u7c7b\u578b\u201d\u65e0\u9700\u586b\u5199\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_63", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                    }
                } else if (isRoot && (NUMBER_ORGTYPE_AREA.equals(orgtypeStdNumber) || NUMBER_ORGTYPE_DEPARTMENT.equals(orgtypeStdNumber))) {
                    errors.add(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u6839\u8282\u70b9\uff0c \u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u5fc5\u987b\u4e3a\u201c\u96c6\u56e2\u201d\u6216\u201c\u516c\u53f8\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_65", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                }
            }
            if (errors != null && errors.size() > 0) {
                result.put((Long)key, errors);
            }
        });
    }

    public static void validateDataEffective(Map<Long, DynamicObject> initParams, Map<Long, List<String>> result) {
        Map<String, String> countryNumberMap = AdminOrgInitValidateServiceHelper.getCountryNumber(initParams);
        Pattern pattern = Pattern.compile("[0-9]*");
        initParams.forEach((key, dy) -> {
            String index;
            List errors = result.getOrDefault(key, new ArrayList());
            String enable = dy.getString("enable");
            if (HRStringUtils.isNotEmpty((String)enable) && !Arrays.asList("0", "1").contains(enable)) {
                errors.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u53ea\u80fd\u586b\u201c\u5df2\u542f\u7528\u201d\u6216\u201c\u5df2\u505c\u7528\u201d\u3002", (String)"AdminOrgInitValidateServiceHelper_39", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            }
            if (HRStringUtils.isNotEmpty((String)(index = dy.getString("index")))) {
                if (index.length() > 5) {
                    errors.add(ResManager.loadKDString((String)"\u6392\u5e8f\u53f7\u53ea\u80fd\u586b\u51991-99999\u4e4b\u95f4\u7684\u6574\u6570\u3002", (String)"AdminOrgInitValidateServiceHelper_40", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                } else if (!pattern.matcher(index).matches()) {
                    errors.add(ResManager.loadKDString((String)"\u6392\u5e8f\u53f7\u53ea\u80fd\u586b\u51991-99999\u4e4b\u95f4\u7684\u6574\u6570\u3002", (String)"AdminOrgInitValidateServiceHelper_40", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                }
            }
            if (countryNumberMap.size() > 0) {
                DynamicObject companyarea = dy.getDynamicObject("companyarea");
                DynamicObject city = dy.getDynamicObject("city");
                if (!(HRObjectUtils.isEmpty((Object)companyarea) || HRObjectUtils.isEmpty((Object)city) || HRStringUtils.equals((String)companyarea.getString("number"), (String)((String)countryNumberMap.get(city.getString("number")))))) {
                    String errorMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6240\u5728\u57ce\u5e02\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u56fd\u5bb6/\u5730\u533a\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_41", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]), city.getString("name"), companyarea.getString("name"));
                    errors.add(errorMessage);
                }
            }
            if (errors != null && errors.size() > 0) {
                result.put((Long)key, errors);
            }
        });
    }

    public static void validateDatabaseEnable(Map<Long, DynamicObject> initParams, Map<Long, List<String>> result, List<Map<String, Object>> result2) {
        Map<Long, Map> initParamsMap = result2.stream().collect(Collectors.toMap(key -> Long.parseLong(key.get("id").toString()), map -> map, (key1, key2) -> key1));
        HashMap<String, Set<Long>> nameToIdMap = new HashMap<String, Set<Long>>();
        AdminOrgInitValidateServiceHelper.getDatabaseEnable(initParams, "adminorgtype", new HRBaseServiceHelper("haos_adminorgtype"), nameToIdMap);
        AdminOrgInitValidateServiceHelper.getDatabaseEnable(initParams, "corporateorg", new HRBaseServiceHelper("hbss_lawentity"), nameToIdMap);
        AdminOrgInitValidateServiceHelper.getDatabaseEnable(initParams, "adminorglayer", new HRBaseServiceHelper("haos_adminorglayer"), nameToIdMap);
        AdminOrgInitValidateServiceHelper.getDatabaseEnable(initParams, "adminorgfunction", new HRBaseServiceHelper("haos_adminorgfunction"), nameToIdMap);
        AdminOrgInitValidateServiceHelper.getDatabaseEnable(initParams, "companyarea", new HRBaseServiceHelper("bd_country"), nameToIdMap);
        AdminOrgInitValidateServiceHelper.getDatabaseEnable(initParams, "city", new HRBaseServiceHelper("bd_admindivision"), nameToIdMap);
        AdminOrgInitValidateServiceHelper.getDatabaseEnable(initParams, "workplace", new HRBaseServiceHelper("hbss_workplace"), nameToIdMap);
        AdminOrgInitValidateServiceHelper.getDatabaseEnable(initParams, "companytype", new HRBaseServiceHelper("haos_companytype"), nameToIdMap);
        AdminOrgInitValidateServiceHelper.getDatabaseEnable(initParams, "industrytype", new HRBaseServiceHelper("hbss_industrytype"), nameToIdMap);
        AdminOrgInitValidateServiceHelper.getDatabaseEnable(initParams, "departmenttype", new HRBaseServiceHelper("haos_departmenttype"), nameToIdMap);
        AdminOrgInitValidateServiceHelper.getDatabaseEnable(initParams, "safelevel", new HRBaseServiceHelper("haos_safelevel"), nameToIdMap);
        AdminOrgInitValidateServiceHelper.getDatabaseEnable(initParams, "safetype", new HRBaseServiceHelper("haos_safetype"), nameToIdMap);
        Map<String, String> databaseName = AdminOrgInitValidateServiceHelper.getDatabaseName("enable");
        initParams.forEach((key, dy) -> {
            List errors = result.getOrDefault(key, new ArrayList());
            databaseName.forEach((key1, value) -> {
                DynamicObject dynamicObject = dy.getDynamicObject(key1);
                Set idSet = (Set)nameToIdMap.get(key1);
                if (!HRObjectUtils.isEmpty((Object)dynamicObject) && !HRObjectUtils.isEmpty((Object)idSet) && idSet.contains(dynamicObject.getLong("id"))) {
                    String errorMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_60", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]), value);
                    errors.add(errorMessage);
                } else if (HRObjectUtils.isEmpty((Object)dynamicObject) && !HRObjectUtils.isEmpty(((Map)initParamsMap.getOrDefault(key, new HashMap())).get(key1))) {
                    String errorMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgInitValidateServiceHelper_60", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]), value);
                    errors.add(errorMessage);
                }
            });
            if (errors != null && errors.size() > 0) {
                result.put((Long)key, errors);
            }
        });
    }

    private static Map<String, String> getDatabaseName(String eventName) {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("adminorgtype", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b", (String)"AdminOrgInitValidateServiceHelper_48", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
        nameMap.put("corporateorg", ResManager.loadKDString((String)"\u6cd5\u5f8b\u5b9e\u4f53", (String)"AdminOrgInitValidateServiceHelper_49", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
        nameMap.put("adminorglayer", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u5c42\u7ea7", (String)"AdminOrgInitValidateServiceHelper_50", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
        nameMap.put("adminorgfunction", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u804c\u80fd", (String)"AdminOrgInitValidateServiceHelper_51", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
        nameMap.put("workplace", ResManager.loadKDString((String)"\u5de5\u4f5c\u5730", (String)"AdminOrgInitValidateServiceHelper_54", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
        nameMap.put("companytype", ResManager.loadKDString((String)"\u516c\u53f8\u7c7b\u578b", (String)"AdminOrgInitValidateServiceHelper_55", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
        nameMap.put("departmenttype", ResManager.loadKDString((String)"\u90e8\u95e8\u7c7b\u578b", (String)"AdminOrgInitValidateServiceHelper_57", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
        nameMap.put("safelevel", ResManager.loadKDString((String)"\u4fdd\u5bc6\u7b49\u7ea7", (String)"AdminOrgInitValidateServiceHelper_58", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
        nameMap.put("safetype", ResManager.loadKDString((String)"\u4fdd\u5bc6\u7c7b\u578b", (String)"AdminOrgInitValidateServiceHelper_59", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
        if (HRStringUtils.equals((String)"enable", (String)eventName)) {
            nameMap.put("companyarea", ResManager.loadKDString((String)"\u56fd\u5bb6\u5730\u533a", (String)"AdminOrgInitValidateServiceHelper_52", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            nameMap.put("city", ResManager.loadKDString((String)"\u6240\u5728\u57ce\u5e02", (String)"AdminOrgInitValidateServiceHelper_53", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
            nameMap.put("industrytype", ResManager.loadKDString((String)"\u884c\u4e1a\u7c7b\u522b", (String)"AdminOrgInitValidateServiceHelper_56", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
        }
        return nameMap;
    }

    private static void getDatabaseEnable(Map<Long, DynamicObject> initParams, String field, HRBaseServiceHelper helper, Map<String, Set<Long>> nameToIdMap) {
        HashSet<Long> enableSet = new HashSet<Long>();
        Set collect = initParams.values().stream().filter(dy -> !HRObjectUtils.isEmpty((Object)dy.getDynamicObject(field))).map(dy -> dy.getDynamicObject(field).getLong("id")).collect(Collectors.toSet());
        if (collect.size() > 0) {
            DynamicObject[] query;
            QFilter idFilter = new QFilter("id", "in", collect);
            QFilter enableFilter = new QFilter("enable", "=", (Object)"0");
            for (DynamicObject object : query = helper.query("id,number,enable", new QFilter[]{idFilter, enableFilter})) {
                enableSet.add(object.getLong("id"));
            }
        }
        nameToIdMap.put(field, enableSet);
    }

    private static Map<String, String> getCountryNumber(Map<Long, DynamicObject> initParams) {
        HashMap<String, String> countryNumber = new HashMap<String, String>();
        Set cityIds = initParams.values().stream().filter(dy -> !HRObjectUtils.isEmpty((Object)dy.getDynamicObject("city"))).map(dy -> dy.getLong("city.id")).collect(Collectors.toSet());
        if (cityIds.size() > 0) {
            DynamicObject[] cityDy;
            HRBaseServiceHelper helper = new HRBaseServiceHelper("bd_admindivision");
            QFilter idFilter = new QFilter("id", "in", cityIds);
            for (DynamicObject dy2 : cityDy = helper.query("id,number,country", new QFilter[]{idFilter})) {
                countryNumber.put(dy2.getString("number"), dy2.getString("country.number"));
            }
        }
        return countryNumber;
    }

    private static Map<Long, Long> getParentOrgTypeMap(Map<Long, DynamicObject> initParams) {
        QFilter idFilter;
        HRBaseServiceHelper serviceHelper;
        DynamicObject[] parentOrgTypeDy;
        HashSet parentOrgTypeIds = new HashSet(16);
        HashMap<Long, Long> parentOrgTypeMap = new HashMap<Long, Long>(16);
        initParams.forEach((key, dy) -> {
            DynamicObject parentorg = dy.getDynamicObject("parentorg");
            if (!HRObjectUtils.isEmpty((Object)parentorg)) {
                parentOrgTypeIds.add(parentorg.getLong("adminorgtype.id"));
            }
        });
        if (parentOrgTypeIds.size() > 0 && (parentOrgTypeDy = (serviceHelper = new HRBaseServiceHelper("haos_adminorgtype")).loadDynamicObjectArray(new QFilter[]{idFilter = new QFilter("id", "in", parentOrgTypeIds)})) != null && parentOrgTypeDy.length > 0) {
            for (DynamicObject dynamicObject : parentOrgTypeDy) {
                parentOrgTypeMap.put(dynamicObject.getLong("id"), dynamicObject.getLong("adminorgtypestd.id"));
            }
            return parentOrgTypeMap;
        }
        return null;
    }

    private static DynamicObject[] getAdminOrgIds(Long[] orgIds) {
        QFilter idFilter = new QFilter("id", "in", (Object)orgIds);
        return HELPER.query("id,name,number", new QFilter[]{idFilter});
    }

    public static void validateParentOrgInfo(Map<Long, DynamicObject> initKeyAdminOrgMap, Map<Long, List<String>> validateResult) {
        if (CollectionUtils.isEmpty(validateResult)) {
            return;
        }
        HashMap orgIdInitIdMap = new HashMap();
        initKeyAdminOrgMap.forEach((key, value) -> orgIdInitIdMap.put(value.getLong("id"), key));
        HashMap newValidateResult = new HashMap();
        initKeyAdminOrgMap.keySet().forEach(id -> AdminOrgInitValidateServiceHelper.processParentOrg(initKeyAdminOrgMap, validateResult, newValidateResult, id, id, orgIdInitIdMap));
        if (newValidateResult.size() > 0) {
            validateResult.putAll(newValidateResult);
        }
    }

    private static void processParentOrg(Map<Long, DynamicObject> initKeyAdminOrgMap, Map<Long, List<String>> validateResult, Map<Long, List<String>> newValidateResult, Long parentId, Long id, Map<Long, Long> orgIdInitIdMap) {
        DynamicObject parentorg = initKeyAdminOrgMap.get(parentId).getDynamicObject("parentorg");
        if (!HRObjectUtils.isEmpty((Object)parentorg)) {
            Long parentorgId = orgIdInitIdMap.getOrDefault(parentorg.getLong("id"), 0L);
            if (validateResult.containsKey(parentorgId)) {
                String number = initKeyAdminOrgMap.get(parentorgId).getString("number");
                String errorMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u6709\u9519\u8bef\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u3002", (String)"AdminOrgInitValidateServiceHelper_66", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]), number);
                if (validateResult.containsKey(id)) {
                    List<String> list = validateResult.get(id);
                    list.add(errorMessage);
                } else {
                    ArrayList<String> errors = new ArrayList<String>();
                    errors.add(errorMessage);
                    newValidateResult.put(id, errors);
                }
            } else if (initKeyAdminOrgMap.containsKey(parentorgId)) {
                AdminOrgInitValidateServiceHelper.processParentOrg(initKeyAdminOrgMap, validateResult, newValidateResult, parentorgId, id, orgIdInitIdMap);
            }
        }
    }

    public static void validateDatabaseUseRange(Map<Long, DynamicObject> initParams, Map<Long, List<String>> result) {
        Map<String, String> databaseName = AdminOrgInitValidateServiceHelper.getDatabaseName("range");
        LOG.info("validateDatabaseUseRange databaseName data: " + databaseName.toString());
        Map<String, Map<Long, List<Long>>> databaseToOrg = AdminOrgInitValidateServiceHelper.getDatabaseToOrg(initParams, databaseName);
        LOG.info("validateDatabaseUseRange databaseToCreateOrg data:" + databaseToOrg.toString());
        initParams.forEach((key, dy) -> {
            List errors = result.getOrDefault(key, new ArrayList());
            databaseName.forEach((key1, value) -> {
                DynamicObject dynamicObject = dy.getDynamicObject(key1);
                DynamicObject org = dy.getDynamicObject("org");
                if (!HRObjectUtils.isEmpty((Object)dynamicObject) && !HRObjectUtils.isEmpty((Object)org)) {
                    Map orgMap = (Map)databaseToOrg.get(key1);
                    if (!CollectionUtils.isEmpty((Map)orgMap)) {
                        LOG.info("validateDatabaseUseRange orgMap data:" + orgMap.toString());
                        List databaseIds = (List)orgMap.get(org.getLong("id"));
                        if (!databaseIds.contains(dynamicObject.getLong("id"))) {
                            String errorMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u201c%2$s\u201d\u4e0d\u5728\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201c%3$s\u201d\u7684\u4f7f\u7528\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdminOrgInitValidateServiceHelper_69", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]), value, dynamicObject.getString("name"), org.getString("name"));
                            errors.add(errorMessage);
                        }
                    } else {
                        String errorMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u201c%2$s\u201d\u4e0d\u5728\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201c%3$s\u201d\u7684\u4f7f\u7528\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AdminOrgInitValidateServiceHelper_69", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]), value, dynamicObject.getString("name"), org.getString("name"));
                        errors.add(errorMessage);
                    }
                }
            });
            if (errors != null && errors.size() > 0) {
                result.put((Long)key, errors);
            }
        });
    }

    private static Map<String, Map<Long, List<Long>>> getDatabaseToOrg(Map<Long, DynamicObject> initParams, Map<String, String> databaseName) {
        HashMap<String, Map<Long, List<Long>>> databaseToOrg = new HashMap<String, Map<Long, List<Long>>>();
        HashMap<String, String> helperMap = new HashMap<String, String>();
        helperMap.put("adminorgtype", "haos_adminorgtype");
        helperMap.put("corporateorg", "hbss_lawentity");
        helperMap.put("adminorglayer", "haos_adminorglayer");
        helperMap.put("adminorgfunction", "haos_adminorgfunction");
        helperMap.put("workplace", "hbss_workplace");
        helperMap.put("companytype", "haos_companytype");
        helperMap.put("departmenttype", "haos_departmenttype");
        helperMap.put("safelevel", "haos_safelevel");
        helperMap.put("safetype", "haos_safetype");
        databaseName.keySet().forEach(key -> {
            Set<Long> collect = initParams.values().stream().filter(dy -> !HRObjectUtils.isEmpty((Object)dy.getDynamicObject("org"))).map(dy -> dy.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
            if (collect.size() > 0) {
                HRBaseServiceHelper helper = new HRBaseServiceHelper((String)helperMap.get(key));
                HashMap orgIdToDatabaseIds = new HashMap();
                collect.forEach(org -> {
                    QFilter filter = new QFilter("enable", "=", (Object)"1");
                    QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)((String)helperMap.get(key)), (Long)org);
                    DynamicObject[] query = helper.query("id", new QFilter[]{filter, orgFilter});
                    if (query != null && query.length > 0) {
                        List databaseId = Arrays.stream(query).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                        orgIdToDatabaseIds.put(org, databaseId);
                    }
                });
                databaseToOrg.put((String)key, orgIdToDatabaseIds);
            }
        });
        return databaseToOrg;
    }

    public static void validateOrg(Map<Long, DynamicObject> initParams, Map<Long, List<String>> result) {
        HasPermOrgResult permOrg = OrgPermHelper.getHRPermOrg();
        if (!permOrg.hasAllOrgPerm()) {
            List<String> orgNumberList = AdminOrgInitServiceHelper.getPermOrgNumber(permOrg.getHasPermOrgs());
            initParams.forEach((key, dy) -> {
                List errors = result.getOrDefault(key, new ArrayList());
                if (!orgNumberList.contains(dy.getString("org.number"))) {
                    errors.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5728\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"AdminOrgInitValidateServiceHelper_70", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]));
                }
                if (!CollectionUtils.isEmpty((Collection)errors)) {
                    result.put((Long)key, errors);
                }
            });
        }
    }
}

