/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.servicehelper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.util.HisMainPeopleHelper;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.haos.common.util.HaosOrgUnitServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections4.trie.PatriciaTrie;

public class AdminOrgQueryServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(AdminOrgQueryServiceHelper.class);
    private static final HRBaseServiceHelper ADMINORGHELPER = new HRBaseServiceHelper("haos_adminorgdetail");
    private static final HRBaseServiceHelper COMPANYHELPER = new HRBaseServiceHelper("haos_adminorgcompany");
    private static final HRBaseServiceHelper DEPARTMENTHELPER = new HRBaseServiceHelper("haos_adminorgdepartment");
    private static final HRBaseServiceHelper GROUPHELPER = new HRBaseServiceHelper("haos_adminorggroup");
    private static final HRBaseServiceHelper STRUCTHELPER = new HRBaseServiceHelper("haos_adminorgstruct");

    public static Map<String, Map<String, Object>> batchQueryAdminOrgInfo(List<Long> orgIdList, Date date) {
        try {
            LOGGER.info(String.format(Locale.ROOT, "batchQueryAdminOrgInfo start : orgIdList %s, date : %s", orgIdList, date));
            HashMap<String, Map<String, Object>> adminOrgInfoMaps = new HashMap<String, Map<String, Object>>();
            if (CollectionUtils.isEmpty(orgIdList)) {
                AdminOrgQueryServiceHelper.bulidErrorMsg(adminOrgInfoMaps, "Input parameter number is null");
                return adminOrgInfoMaps;
            }
            if (orgIdList.size() > 2000) {
                AdminOrgQueryServiceHelper.bulidErrorMsg(adminOrgInfoMaps, "Input parameter number more than 2000");
                return adminOrgInfoMaps;
            }
            AdminOrgQueryServiceHelper.queryAdminOrgInfo(orgIdList, date, adminOrgInfoMaps);
            LOGGER.info("batchQueryAdminOrgInfo end");
            return adminOrgInfoMaps;
        }
        catch (Exception exception) {
            LOGGER.error("batchQueryAdminOrgInfo error", (Throwable)exception);
            return null;
        }
    }

    public static DynamicObject[] batchQueryAdminOrgHis(List<Long> orgIdList) {
        QFilter boidFilter = new QFilter("boid", "in", orgIdList);
        QFilter datastatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"});
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter qFilter = boidFilter.and(datastatusFilter).and(iscurrentVersionFilter).and(initStatusFilter);
        String field = "id, boid, name, number, bsed, bsled, isvirtualorg";
        return ADMINORGHELPER.queryOriginalArray(field, new QFilter[]{qFilter});
    }

    private static boolean emptyCheck(Object ... obj) {
        return Arrays.stream(obj).anyMatch(Objects::isNull);
    }

    private static Map<String, Object> getEmptyErrorMessage() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("msg", "must input error");
        return map;
    }

    private static <T> boolean maximumCheck(List<T> params, long max) {
        return (long)params.size() > max;
    }

    private static Map<String, Object> getMaxErrorMessage(int max) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("msg", String.format("exceed %s error", max));
        return map;
    }

    private static void bulidErrorMsg(Map<String, Map<String, Object>> adminOrgInfoMaps, String errorMsg) {
        String errorCode = "error";
        HashMap<String, String> infoMaps = new HashMap<String, String>();
        infoMaps.put(errorCode, errorMsg);
        adminOrgInfoMaps.put(errorCode, infoMaps);
    }

    private static void queryAdminOrgInfo(List<Long> idList, Date date, Map<String, Map<String, Object>> adminOrgInfoMaps) {
        try {
            String selectFiled = "id,boid,number,name,adminorgtype,belongcompany,belongdept,establishmentdate,parentorg,corporateorg,companyarea,city,workplace,enable,adminorglayer,adminorgfunction,positioning,mainduty,safelevel,safetype,iscurrentversion,org.id, isvirtualorg";
            DynamicObject[] dynamicObjects = AdminOrgQueryServiceHelper.getDynamicObjectList(idList, date, selectFiled);
            Map<Long, DynamicObject> companyMap = AdminOrgQueryServiceHelper.getBasicDataInfo(COMPANYHELPER, idList, date, "adminorg.id,companytype,industrytype,iscurrentversion");
            Map<Long, DynamicObject> depMap = AdminOrgQueryServiceHelper.getBasicDataInfo(DEPARTMENTHELPER, idList, date, "adminorg.id,departmenttype");
            Map<Long, DynamicObject> groupMap = AdminOrgQueryServiceHelper.getBasicDataInfo(GROUPHELPER, idList, date, "adminorg.id,groupvision,groupmission");
            Long id = null;
            for (DynamicObject dynamicObject : dynamicObjects) {
                HashMap<String, Object> infoMap = new HashMap<String, Object>(64);
                id = dynamicObject.getLong("boid");
                infoMap.put("id", id);
                infoMap.put("vid", dynamicObject.getPkValue());
                infoMap.put("number", dynamicObject.getString("number"));
                infoMap.put("org", dynamicObject.getLong("org.id"));
                infoMap.put("name", dynamicObject.getLocaleString("name").getLocaleValue());
                infoMap.put("adminorgtype", dynamicObject.getString("adminorgtype.id"));
                infoMap.put("adminorgtypename", dynamicObject.getString("adminorgtype.name"));
                infoMap.put("belongcompany", dynamicObject.getLong("belongcompany.id"));
                infoMap.put("companyname", dynamicObject.get("belongcompany.name"));
                infoMap.put("belongdept", dynamicObject.getLong("belongdept.id"));
                infoMap.put("establishmentdate", dynamicObject.getDate("establishmentdate"));
                infoMap.put("parentorg", dynamicObject.getLong("parentorg.id"));
                infoMap.put("corporateorg", dynamicObject.getLong("corporateorg.id"));
                infoMap.put("companyarea", dynamicObject.getLong("companyarea.id"));
                infoMap.put("city", dynamicObject.getLong("city.id"));
                infoMap.put("workplace", dynamicObject.getLong("workplace.id"));
                infoMap.put("enable", dynamicObject.getString("enable"));
                infoMap.put("adminorgclassify", 0);
                infoMap.put("adminorgclassifyname", "");
                infoMap.put("adminorglayer", dynamicObject.getLong("adminorglayer.id"));
                infoMap.put("adminorglayername", dynamicObject.getString("adminorglayer.name"));
                infoMap.put("adminorgfunction", dynamicObject.getLong("adminorgfunction.id"));
                infoMap.put("adminorgfunctionname", dynamicObject.getString("adminorgfunction.name"));
                infoMap.put("positioning", dynamicObject.getString("positioning"));
                infoMap.put("mainduty", dynamicObject.getString("mainduty"));
                infoMap.put("safelevel", dynamicObject.getLong("safelevel.id"));
                infoMap.put("safelevelname", dynamicObject.getString("safelevel.name"));
                infoMap.put("safetype", dynamicObject.getLong("safetype.id"));
                infoMap.put("safetypename", dynamicObject.getString("safetype.name"));
                infoMap.put("isvirtualorg", dynamicObject.getString("isvirtualorg"));
                AdminOrgQueryServiceHelper.getOtherInfo(infoMap, companyMap.get(id), depMap.get(id), groupMap.get(id));
                adminOrgInfoMaps.put(String.valueOf(id), infoMap);
            }
            LOGGER.info("queryAdminOrgInfo,size--" + dynamicObjects.length);
        }
        catch (Exception exception) {
            LOGGER.error("queryAdminOrgInfo error", (Throwable)exception);
            adminOrgInfoMaps.clear();
            AdminOrgQueryServiceHelper.bulidErrorMsg(adminOrgInfoMaps, "system error");
        }
    }

    private static DynamicObject[] getDynamicObjectList(List<Long> idList, Date date, String selectFiled) {
        QFilter idFilter = new QFilter("boid", "in", idList);
        return AdminOrgQueryServiceHelper.hisCommonQuery(date, selectFiled, idFilter);
    }

    private static DynamicObject[] hisCommonQuery(Date date, String selectFiled, QFilter filter) {
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        QFilter effectDateFilter = new QFilter("bsed", "<=", (Object)date);
        QFilter loseEffectDateFilter = new QFilter("bsled", ">=", (Object)date);
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        DynamicObject[] dynamicObjects = ADMINORGHELPER.query(selectFiled, new QFilter[]{filter, dataStatusFilter, effectDateFilter, loseEffectDateFilter, currentVersionFilter, initStatusFilter});
        return dynamicObjects;
    }

    private static Map<Long, DynamicObject> getBasicDataInfo(HRBaseServiceHelper helper, List<Long> idList, Date date, String selectFiled) {
        QFilter idFilter = new QFilter("adminorg", "in", idList);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        QFilter effectDateFilter = new QFilter("bsed", "<=", (Object)date);
        QFilter loseEffectDateFilter = new QFilter("bsled", ">=", (Object)date);
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        DynamicObject[] dys = helper.query(selectFiled, new QFilter[]{idFilter, dataStatusFilter, effectDateFilter, loseEffectDateFilter, currentVersionFilter});
        return Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong("adminorg.id"), dy -> dy, (key1, key2) -> key2));
    }

    private static void getOtherInfo(Map<String, Object> infoMap, DynamicObject companyDy, DynamicObject depDy, DynamicObject groupDy) {
        if (!HRObjectUtils.isEmpty((Object)companyDy)) {
            infoMap.put("companytype", companyDy.getLong("companytype.id"));
            infoMap.put("companytypename", companyDy.getString("companytype.name"));
            infoMap.put("industrytype", companyDy.getLong("industrytype.id"));
            infoMap.put("industrytypename", companyDy.getString("industrytype.name"));
        }
        if (!HRObjectUtils.isEmpty((Object)depDy)) {
            infoMap.put("departmenttype", depDy.getLong("departmenttype.id"));
            infoMap.put("departmenttypename", depDy.getString("departmenttype.name"));
        }
        infoMap.put("groupvision", "");
        infoMap.put("groupmission", "");
        if (!HRObjectUtils.isEmpty((Object)groupDy)) {
            infoMap.put("groupvision", groupDy.getLocaleString("groupvision").getLocaleValue());
            infoMap.put("groupmission", groupDy.getLocaleString("groupmission").getLocaleValue());
        }
    }

    public static Map<String, Map<String, Object>> batchQueryAdminOrgStruct(List<Long> idList, Date date, boolean needLongInfo) {
        LOGGER.info(String.format(Locale.ROOT, "batchQueryAdminOrgStruct start : idList: %s, date: %s, needLongInfo: %s", idList, date, needLongInfo));
        try {
            HashMap<String, Map<String, Object>> adminOrgStructMaps = new HashMap<String, Map<String, Object>>();
            if (AdminOrgQueryServiceHelper.emptyCheck(idList, date, needLongInfo)) {
                adminOrgStructMaps.put("error", AdminOrgQueryServiceHelper.getEmptyErrorMessage());
                return adminOrgStructMaps;
            }
            if (AdminOrgQueryServiceHelper.maximumCheck(idList, 2000L)) {
                adminOrgStructMaps.put("error", AdminOrgQueryServiceHelper.getMaxErrorMessage(2000));
                return adminOrgStructMaps;
            }
            LOGGER.info(String.format(Locale.ROOT, "batchQueryAdminOrgStruct end : %s", adminOrgStructMaps));
            return AdminOrgQueryServiceHelper.queryAdminOrgStruct(idList, date, needLongInfo);
        }
        catch (Exception ex) {
            LOGGER.error("getCompanyAndDepartmentInfo error", (Throwable)ex);
            return Collections.emptyMap();
        }
    }

    public static Map<String, Map<String, Object>> queryAdminOrgStruct(List<Long> idList, Date date, boolean needLongInfoFlag) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        List<Long> distinctIdList = idList.stream().distinct().collect(Collectors.toList());
        if (distinctIdList.size() == 0) {
            return result;
        }
        String infoSelectField = "id,boid,number,name,parentorg.id,structnumber";
        String structSelectField = "id,adminorg.id,structlongnumber";
        if (needLongInfoFlag) {
            DynamicObject[] adminOrgStructs = AdminOrgQueryServiceHelper.queryAdminOrgHisStruct(structSelectField, distinctIdList, date);
            DynamicObject[] adminOrgInfos = AdminOrgQueryServiceHelper.queryAdminHisInfo(infoSelectField, AdminOrgQueryServiceHelper.getStructNumberQFilter(adminOrgStructs), date);
            Map<String, String> structNumberVsName = Arrays.stream(adminOrgInfos).collect(Collectors.toMap(dy -> dy.getString("structnumber"), dy -> dy.getString("name")));
            Map<Long, DynamicObject> orgIdVsInfoDy = Arrays.stream(adminOrgInfos).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
            for (DynamicObject adminOrgStruct : adminOrgStructs) {
                HashMap<String, Object> infoMap = new HashMap<String, Object>();
                DynamicObject adminOrgInfo = orgIdVsInfoDy.get(adminOrgStruct.getLong("adminorg.id"));
                if (adminOrgInfo == null) continue;
                infoMap.put("id", adminOrgInfo.getLong("id"));
                infoMap.put("boid", adminOrgInfo.getLong("boid"));
                infoMap.put("number", adminOrgInfo.getString("number"));
                infoMap.put("name", adminOrgInfo.getString("name"));
                infoMap.put("parentorg", adminOrgInfo.getLong("parentorg.id"));
                infoMap.put("structnumber", adminOrgInfo.getString("structnumber"));
                infoMap.put("longnumber", adminOrgStruct.getString("structlongnumber"));
                infoMap.put("longname", AdminOrgQueryServiceHelper.convertLongName(adminOrgStruct.getString("structlongnumber"), structNumberVsName));
                infoMap.put("adminorgstructvid", adminOrgStruct.getLong("id"));
                result.put(adminOrgInfo.getString("boid"), infoMap);
            }
        } else {
            DynamicObject[] adminOrgInfos;
            QFilter boIdFilter = new QFilter("boid", "in", distinctIdList);
            for (DynamicObject dynamicObject : adminOrgInfos = AdminOrgQueryServiceHelper.queryAdminHisInfo(infoSelectField, boIdFilter, date)) {
                HashMap<String, Object> infoMap = new HashMap<String, Object>();
                infoMap.put("id", dynamicObject.getLong("id"));
                infoMap.put("boid", dynamicObject.getLong("boid"));
                infoMap.put("number", dynamicObject.getString("number"));
                infoMap.put("name", dynamicObject.getString("name"));
                infoMap.put("parentorg", dynamicObject.getLong("parentorg.id"));
                infoMap.put("structnumber", dynamicObject.getString("structnumber"));
                result.put(String.valueOf(dynamicObject.getLong("boid")), infoMap);
            }
        }
        return result;
    }

    private static QFilter getStructNumberQFilter(DynamicObject[] adminOrgStructs) {
        QFilter structNumberFilter = new QFilter("1", "!=", (Object)1);
        List structNumberList = Arrays.stream(adminOrgStructs).map(adminOrgStruct -> adminOrgStruct.getString("structlongnumber").split("!")).flatMap(Arrays::stream).distinct().collect(Collectors.toList());
        if (structNumberList.size() != 0) {
            structNumberFilter = new QFilter("structnumber", "in", structNumberList);
        }
        return structNumberFilter;
    }

    private static String convertLongName(String structLongNumber, Map<String, String> structNumberVsName) {
        String fullNameSep = HaosOrgUnitServiceHelper.getFullNameSep();
        return Arrays.stream(structLongNumber.split("!")).map(structNumberVsName::get).filter(HRStringUtils::isNotEmpty).collect(Collectors.joining(fullNameSep));
    }

    private static DynamicObject[] queryAdminOrgHisStruct(String selectField, List<Long> idList, Date date) {
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter effectDateFilter = new QFilter("bsed", "<=", (Object)date);
        QFilter loseEffectDateFilter = new QFilter("bsled", ">=", (Object)date);
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter idFilter = new QFilter("adminorg", "in", idList);
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        return STRUCTHELPER.queryOriginalArray(selectField, new QFilter[]{idFilter, dataStatusFilter, effectDateFilter, loseEffectDateFilter, currentVersionFilter, initStatusFilter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
    }

    private static DynamicObject[] queryAdminHisInfo(String selectFiled, QFilter dataFilter, Date date) {
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter effectDateFilter = new QFilter("bsed", "<=", (Object)date);
        QFilter loseEffectDateFilter = new QFilter("bsled", ">=", (Object)date);
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        return ADMINORGHELPER.queryOriginalArray(selectFiled, new QFilter[]{dataFilter, dataStatusFilter, effectDateFilter, loseEffectDateFilter, currentVersionFilter, initStatusFilter});
    }

    public static Map<Long, List<Map<String, Object>>> batchQueryOrgInfo(Date startDate, Date endDate, List<Long> boIdList) {
        if (CollectionUtils.isEmpty(boIdList) || Objects.isNull(startDate) || Objects.isNull(endDate)) {
            LOGGER.info(String.format(Locale.ROOT, "batchQueryOrgInfo() params are not valid, startDate: %s, endDate: %s, boIdList: %s, ", boIdList, startDate, endDate));
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        if (startDate.compareTo(endDate) > 0) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        if (boIdList.size() > 2000) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        long startTime = System.currentTimeMillis();
        LOGGER.info(String.format(Locale.ROOT, "batchQueryOrgInfo() params startDate: %s, endDate: %s, boIdList: %s, ", boIdList, startDate, endDate));
        Object[] adminOrgDyns = AdminOrgHisServiceHelper.batchGetOrgHisInfo(startDate, endDate, boIdList);
        if (ObjectUtils.isEmpty((Object[])adminOrgDyns)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)adminOrgDyns.length);
        for (Object dy : adminOrgDyns) {
            HashMap<String, Object> map2 = new HashMap<String, Object>(16);
            map2.put("boid", dy.getLong("boid"));
            map2.put("id", dy.getLong("id"));
            map2.put("number", dy.getString("number"));
            map2.put("name", dy.getString("name"));
            map2.put("adminorgtype", dy.getLong("adminorgtype.id"));
            map2.put("adminorgtypename", dy.getString("adminorgtype.name"));
            map2.put("belongcompany", dy.getLong("belongcompany.boid"));
            map2.put("establishmentdate", dy.getDate("establishmentdate"));
            map2.put("parentorg", dy.getLong("parentorg.id"));
            map2.put("corporateorg", dy.getLong("corporateorg.id"));
            map2.put("companyarea", dy.getLong("companyarea.id"));
            map2.put("city", dy.getLong("city.id"));
            map2.put("enable", dy.getString("enable"));
            map2.put("bsed", dy.getDate("bsed"));
            map2.put("bsled", dy.getDate("bsled"));
            map2.put("datastatus", dy.getString("datastatus"));
            map2.put("isvirtualorg", dy.getString("isvirtualorg"));
            list.add(map2);
        }
        Map<Long, List<Map<String, Object>>> result = list.stream().collect(Collectors.groupingBy(map -> (Long)map.get("boid")));
        LOGGER.info(String.format(Locale.ROOT, "batchQueryOrgInfo() cost: %s milliseconds", System.currentTimeMillis() - startTime));
        return result;
    }

    public static List<Map<String, Object>> batchQuerySubOrg(List<Long> orgIdList, Date date, Integer level) {
        LOGGER.info(String.format(Locale.ROOT, "batchQuerySubOrg() params orgIdList: %s, Date: %s", orgIdList, date));
        if (CollectionUtils.isEmpty(orgIdList)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        if (orgIdList.size() > 2000) {
            LOGGER.info("orgIdList more than 2000");
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey());
        QFilter orgQFilter = new QFilter("adminorg", "in", orgIdList);
        QFilter dateFilter = AdminOrgHisServiceHelper.hisDateQueryFilter(date == null ? new Date() : date);
        dateFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        DynamicObjectCollection structCol = serviceHelper.queryOriginalCollection("adminorg.id,level,structlongnumber", new QFilter[]{orgQFilter, dateFilter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
        if (ObjectUtils.isEmpty((Object)structCol)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        if (level != null && level == 0) {
            return AdminOrgQueryServiceHelper.queryOrg(structCol.stream().collect(Collectors.toMap(dy -> dy.getLong("adminorg.id"), dy -> dy.getString("structlongnumber"))), dateFilter);
        }
        List<String> structLongNumberList = structCol.stream().map(dy -> dy.getString("structlongnumber")).collect(Collectors.toList());
        LOGGER.info(String.format(Locale.ROOT, "Before filter structlongnumbers are: %s", structLongNumberList));
        List<String> filteredStructLongNumberList = AdminOrgHisServiceHelper.filterUnNecessaryStructLongNumber(structLongNumberList);
        LOGGER.info(String.format(Locale.ROOT, "After filter structlongnumbers are: %s", filteredStructLongNumberList));
        QFilter structLongNumberFilter = new QFilter("structlongnumber", "like", (Object)(filteredStructLongNumberList.get(0) + "%"));
        for (int i = 1; i < filteredStructLongNumberList.size(); ++i) {
            structLongNumberFilter.or("structlongnumber", "like", (Object)(filteredStructLongNumberList.get(i) + "%"));
        }
        DynamicObjectCollection subCol = serviceHelper.queryOriginalCollection("adminorg.id,level,structlongnumber", new QFilter[]{structLongNumberFilter, dateFilter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
        if (level == null) {
            return AdminOrgQueryServiceHelper.queryOrg(subCol.stream().collect(Collectors.toMap(dy -> dy.getLong("adminorg.id"), dy -> dy.getString("structlongnumber"))), dateFilter);
        }
        PatriciaTrie patriciaTrie = new PatriciaTrie();
        for (DynamicObject subStructDy : subCol) {
            patriciaTrie.put((Object)subStructDy.getString("structlongnumber"), (Object)subStructDy);
        }
        HashMap<Long, String> structMap = new HashMap<Long, String>(subCol.size());
        for (DynamicObject structDy : structCol) {
            patriciaTrie.prefixMap((Object)structDy.getString("structlongnumber")).values().stream().filter(dy -> structDy.getInt("level") + level >= dy.getInt("level")).forEach(subDy -> structMap.put(subDy.getLong("adminorg.id"), subDy.getString("structlongnumber")));
        }
        return AdminOrgQueryServiceHelper.queryOrg(structMap, dateFilter);
    }

    private static List<Map<String, Object>> queryOrg(Map<Long, String> structMap, QFilter dateFilter) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        DynamicObjectCollection col = serviceHelper.queryOriginalCollection("name, number,boid, parentorg.id, enable,id,corporateorg.id,belongcompany.id, isvirtualorg", new QFilter[]{new QFilter("boid", "in", structMap.keySet()), dateFilter});
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(col.size());
        for (DynamicObject dy : col) {
            result.add(AdminOrgQueryServiceHelper.getSubResultMap(dy, structMap));
        }
        return result;
    }

    private static Map<String, Object> getSubResultMap(DynamicObject dy, Map<Long, String> structMap) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        Long orgId = dy.getLong("boid");
        map.put("orgId", orgId);
        map.put("orgNumber", dy.getString("number"));
        map.put("orgName", dy.getString("name"));
        map.put("parentOrgId", dy.getLong("parentorg.id"));
        map.put("businessStatus", dy.getString("enable"));
        map.put("id", dy.getLong("id"));
        map.put("corporateOrgId", dy.getLong("corporateorg.id"));
        map.put("belongCompanyId", dy.getLong("belongcompany.id"));
        map.put("structLongNumber", structMap.get(orgId));
        map.put("isvirtualorg", dy.getString("isvirtualorg"));
        return map;
    }

    public static List<Map<String, Object>> batchQueryAllSubOrg(List<Long> orgIdList, Date date) {
        if (CollectionUtils.isEmpty(orgIdList) || Objects.isNull(date)) {
            LOGGER.error(String.format(Locale.ROOT, "batchQueryAllSubOrg() params are not valid, orgIdList: %s, Date: %s", orgIdList, date));
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        long startTime = System.currentTimeMillis();
        LOGGER.info(String.format(Locale.ROOT, "batchQueryAllSubOrg() params orgIdList: %s, Date: %s", orgIdList, date));
        Object[] dynamicObjects = AdminOrgHisServiceHelper.batchGetStructLongNumber(orgIdList, date, AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), "adminorg");
        if (ObjectUtils.isEmpty((Object[])dynamicObjects)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        List<String> structLongNumberList = Stream.of(dynamicObjects).map(dy -> dy.getString("structlongnumber")).collect(Collectors.toList());
        LOGGER.info(String.format(Locale.ROOT, "Before filter structlongnumbers are: %s", structLongNumberList));
        List<String> filteredStructLongNumberList = AdminOrgHisServiceHelper.filterUnNecessaryStructLongNumber(structLongNumberList);
        LOGGER.info(String.format(Locale.ROOT, "After filter structlongnumbers are: %s", filteredStructLongNumberList));
        QFilter structLongNumberFilter = new QFilter("structlongnumber", "like", (Object)(filteredStructLongNumberList.get(0) + "%"));
        for (int i = 1; i < filteredStructLongNumberList.size(); ++i) {
            structLongNumberFilter.or("structlongnumber", "like", (Object)(filteredStructLongNumberList.get(i) + "%"));
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey());
        QFilter dateFilter = AdminOrgHisServiceHelper.hisDateQueryFilter(date);
        dateFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        DynamicObject[] dynamicObjectArray = serviceHelper.queryOriginalArray("adminorg.id,structlongnumber", new QFilter[]{structLongNumberFilter, dateFilter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
        Map<Long, String> orgIdStructLongNumberMap = Stream.of(dynamicObjectArray).collect(Collectors.toMap(dy -> dy.getLong("adminorg.id"), dy -> dy.getString("structlongnumber")));
        serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        DynamicObject[] objects = serviceHelper.queryOriginalArray("name, number,boid, parentorg.id, enable,id,corporateorg.id,belongcompany.id, isvirtualorg", new QFilter[]{new QFilter("boid", "in", orgIdStructLongNumberMap.keySet()), dateFilter});
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(dynamicObjectArray.length);
        for (DynamicObject dynamicObject : objects) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("orgId", dynamicObject.getLong("boid"));
            map.put("orgNumber", dynamicObject.getString("number"));
            map.put("orgName", dynamicObject.getString("name"));
            map.put("parentOrgId", dynamicObject.getLong("parentorg.id"));
            map.put("businessStatus", dynamicObject.getString("enable"));
            map.put("structLongNumber", orgIdStructLongNumberMap.get(dynamicObject.getLong("boid")));
            map.put("id", dynamicObject.getLong("id"));
            map.put("corporateOrgId", dynamicObject.getLong("corporateorg.id"));
            map.put("belongCompanyId", dynamicObject.getLong("belongcompany.id"));
            map.put("isvirtualorg", dynamicObject.getString("isvirtualorg"));
            result.add(map);
        }
        LOGGER.info(String.format(Locale.ROOT, "batchQueryAllSubOrg() cost: %s milliseconds", System.currentTimeMillis() - startTime));
        return result;
    }

    public static Map<String, Map<String, Object>> getAdminOrgInfoByNumber(List<String> orgNumberList, Date date) {
        try {
            LOGGER.info(String.format(Locale.ROOT, "getAdminOrgInfoByNumber start : orgIdList %s, date : %s", orgNumberList, date));
            if (CollectionUtils.isEmpty(orgNumberList)) {
                return new HashMap<String, Map<String, Object>>();
            }
            if (orgNumberList.size() > 2000) {
                HashMap<String, Map<String, Object>> adminOrgInfoMaps = new HashMap<String, Map<String, Object>>();
                AdminOrgQueryServiceHelper.bulidErrorMsg(adminOrgInfoMaps, "Input parameter number more than 2000");
                return adminOrgInfoMaps;
            }
            return AdminOrgQueryServiceHelper.getAdminOrgInfo(orgNumberList, date);
        }
        catch (Exception exception) {
            LOGGER.error("getAdminOrgInfoByNumber error", (Throwable)exception);
            return new HashMap<String, Map<String, Object>>();
        }
    }

    private static Map<String, Map<String, Object>> getAdminOrgInfo(List<String> orgNumberList, Date date) {
        DynamicObject[] dynamicObjects;
        HashMap<String, Map<String, Object>> adminOrgInfoMaps = new HashMap<String, Map<String, Object>>(orgNumberList.size());
        String selectFiled = "id,boid,number,name,adminorgtype,belongcompany,parentorg,corporateorg,companyarea,city,workplace,adminorglayer,adminorgfunction,safelevel,safetype, isvirtualorg";
        QFilter numberFilter = new QFilter("number", "in", orgNumberList);
        for (DynamicObject dynamicObject : dynamicObjects = AdminOrgQueryServiceHelper.hisCommonQuery(date, selectFiled, numberFilter)) {
            HashMap<String, Object> infoMap = new HashMap<String, Object>(64);
            String number = dynamicObject.getString("number");
            infoMap.put("id", dynamicObject.getLong("id"));
            infoMap.put("boid", dynamicObject.getLong("boid"));
            infoMap.put("number", number);
            infoMap.put("adminorgtype", dynamicObject.getString("adminorgtype.id"));
            infoMap.put("belongcompany", dynamicObject.getLong("belongcompany.id"));
            infoMap.put("corporateorg", dynamicObject.getLong("corporateorg.id"));
            infoMap.put("parentorg", dynamicObject.getLong("parentorg.id"));
            infoMap.put("companyarea", dynamicObject.getLong("companyarea.id"));
            infoMap.put("city", dynamicObject.getLong("city.id"));
            infoMap.put("workplace", dynamicObject.getLong("workplace.id"));
            infoMap.put("adminorglayer", dynamicObject.getLong("adminorglayer.id"));
            infoMap.put("adminorgfunction", dynamicObject.getLong("adminorgfunction.id"));
            infoMap.put("safelevel", dynamicObject.getLong("safelevel.id"));
            infoMap.put("safetype", dynamicObject.getLong("safetype.id"));
            infoMap.put("isvirtualorg", dynamicObject.getString("isvirtualorg"));
            adminOrgInfoMaps.put(number, infoMap);
        }
        return adminOrgInfoMaps;
    }

    public static Map<String, Map<String, Object>> batchQueryOrgInfoByOrgNumberList(List<String> orgNumberList, Date date) {
        try {
            LOGGER.info(String.format(Locale.ROOT, "batchQueryOrgInfoByOrgNumberList start : orgNumberList %s, date : %s", orgNumberList, date));
            HashMap<String, Map<String, Object>> adminOrgInfoMap = new HashMap<String, Map<String, Object>>();
            if (CollectionUtils.isEmpty(orgNumberList)) {
                AdminOrgQueryServiceHelper.bulidErrorMsg(adminOrgInfoMap, "Input parameter number is null");
                return adminOrgInfoMap;
            }
            if (orgNumberList.size() > 5000) {
                AdminOrgQueryServiceHelper.bulidErrorMsg(adminOrgInfoMap, "Input parameter number more than 5000");
                return adminOrgInfoMap;
            }
            AdminOrgQueryServiceHelper.queryAdminOrgInfoByNumList(orgNumberList, date, adminOrgInfoMap);
            LOGGER.info("batchQueryAdminOrgInfo end");
            return adminOrgInfoMap;
        }
        catch (Exception exception) {
            LOGGER.error("batchQueryAdminOrgInfo error", (Throwable)exception);
            return null;
        }
    }

    private static void queryAdminOrgInfoByNumList(List<String> numberList, Date date, Map<String, Map<String, Object>> adminOrgInfoMaps) {
        try {
            DynamicObject[] adminOrgInfoArr;
            String selectFiled = "id, boid, number, enable, name, parentorg, belongcompany, establishmentdate, corporateorg, workplace,isvirtualorg";
            for (DynamicObject adminOrgInfo : adminOrgInfoArr = AdminOrgQueryServiceHelper.getOrgInfoArrByNumList(numberList, date, selectFiled)) {
                HashMap<String, Object> infoMap = new HashMap<String, Object>(50);
                infoMap.put("id", adminOrgInfo.getLong("boid"));
                infoMap.put("vid", adminOrgInfo.getPkValue());
                infoMap.put("number", adminOrgInfo.getString("number"));
                infoMap.put("enable", adminOrgInfo.getString("enable"));
                infoMap.put("name", adminOrgInfo.getLocaleString("name").getLocaleValue());
                infoMap.put("parentorg", adminOrgInfo.getLong("parentorg.id"));
                infoMap.put("belongcompany", adminOrgInfo.getLong("belongcompany.id"));
                infoMap.put("corporateorg", adminOrgInfo.getLong("corporateorg.id"));
                infoMap.put("workplace", adminOrgInfo.getLong("workplace.id"));
                infoMap.put("isvirtualorg", adminOrgInfo.getString("isvirtualorg"));
                adminOrgInfoMaps.put(adminOrgInfo.getString("number"), infoMap);
            }
            LOGGER.info("queryAdminOrgInfoByNumList,size--" + adminOrgInfoArr.length);
        }
        catch (Exception exception) {
            LOGGER.error("queryAdminOrgInfoByNumList error", (Throwable)exception);
            adminOrgInfoMaps.clear();
            AdminOrgQueryServiceHelper.bulidErrorMsg(adminOrgInfoMaps, "system error");
        }
    }

    private static DynamicObject[] getOrgInfoArrByNumList(List<String> numberList, Date date, String selectFiled) {
        QFilter idFilter = new QFilter("number", "in", numberList);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        QFilter effectDateFilter = new QFilter("bsed", "<=", (Object)date);
        QFilter loseEffectDateFilter = new QFilter("bsled", ">=", (Object)date);
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        DynamicObject[] dynamicObjects = ADMINORGHELPER.query(selectFiled, new QFilter[]{idFilter, dataStatusFilter, effectDateFilter, loseEffectDateFilter, currentVersionFilter, initStatusFilter});
        return dynamicObjects;
    }

    public static boolean checkClickView(String entityNumber, String fieldName) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entityType);
        FilterField filterField = FilterField.create((MainEntityType)entityType, (String)fieldName);
        String strategy = PrivacyCenterUtils.getDesensitizeStrategy((IDataEntityProperty)filterField.getFieldProp(), (String)"LIST", (DynamicObject)dynamicObject);
        return "CLICKVIEW".equals(strategy);
    }

    public static List<Map<String, Object>> getPersonInfo(String orgId) {
        List result = null;
        try {
            Map serviceResult = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIChargeService", (String)"queryPastChargeByOrgId", (Object[])new Object[]{Collections.singletonList(Long.parseLong(orgId)), new Date()});
            result = (List)serviceResult.get(Long.parseLong(orgId));
            if (result != null) {
                result.forEach(HisMainPeopleHelper::resetDateField);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
        }
        return result;
    }
}

