/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.servicehelper;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.AdOrgSortCodeRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.servicehelper.model.upgrade.sortcode.AdOrgCascadeBo;
import kd.hr.haos.business.servicehelper.model.upgrade.sortcode.SortCodePartBo;
import kd.hr.haos.business.util.IdCreator;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.business.util.OrgMetaDataServiceHelper;
import kd.hr.haos.business.util.TimeLogger;
import kd.hr.haos.business.util.cascade.MultiVersionCascadeHelper;
import kd.hr.haos.common.model.cascade.CascadeBo;
import kd.hr.haos.common.model.cascade.CascadeResult;
import kd.hr.haos.common.model.cascade.PartBo;
import kd.hr.haos.common.util.LocalDateRange;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class AdminOrgSortCodeUpgradeHelper {
    private static final Log LOGGER = LogFactory.getLog(AdminOrgSortCodeUpgradeHelper.class);

    public void upgrade() {
        LOGGER.info("start");
        boolean isMetaDataExist = OrgMetaDataServiceHelper.isMetaDataExist("haos_orgsortcode");
        LOGGER.info("metadata haos_orgsortcode exist:" + isMetaDataExist);
        if (isMetaDataExist) {
            this.getUpgradeTask().run();
        }
        LOGGER.info("end");
    }

    private Runnable getUpgradeTask() {
        return () -> {
            try (TXHandle txHandle = TX.required();){
                try {
                    TimeLogger timeLogger = TimeLogger.create();
                    timeLogger.start();
                    this.doUpgrade();
                    timeLogger.end();
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    LOGGER.error((Throwable)e);
                    throw e;
                }
            }
        };
    }

    private void doUpgrade() {
        CascadeResult cascadeResult = this.calculate();
        HisVersionParamBo hisVersionParamBo = this.createHisVersionParamBo(cascadeResult);
        this.logSortCodeChangedAdminorg(cascadeResult.getBoVsPartCascadeBo().keySet());
        HisResponse<VersionChangeRespData> response = this.saveHis(hisVersionParamBo);
        this.logHisResponse(response);
    }

    private List<Long> findOrgBo() {
        this.logIndexChangedAdminorg(Collections.emptySet());
        return null;
    }

    private CascadeResult calculate() {
        List<CascadeBo> cascadeBoList = this.getCascadeBoList();
        return MultiVersionCascadeHelper.getCascadeResult(cascadeBoList);
    }

    private HisVersionParamBo createHisVersionParamBo(CascadeResult cascadeResult) {
        Map boVsPartCascadeBo = cascadeResult.getBoVsPartCascadeBo();
        Set<Long> sortCodeVisSet = boVsPartCascadeBo.values().stream().flatMap(Collection::stream).map(PartBo::getVid).collect(Collectors.toSet());
        DynamicObject[] sortCodeHisDatas = AdOrgSortCodeRepository.getInstance().loadByIds(sortCodeVisSet);
        Map<Long, DynamicObject> idVsHisSortCode = Arrays.stream(sortCodeHisDatas).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        IdCreator idCreator = new IdCreator();
        Date now = new Date();
        DynamicObject administrator = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        administrator.set("id", (Object)1);
        DynamicObject[] hisDyns = (DynamicObject[])boVsPartCascadeBo.values().stream().flatMap(Collection::stream).map(partBo -> (SortCodePartBo)((Object)partBo)).map(sortCodePartBo -> {
            DynamicObject hisDy = (DynamicObject)idVsHisSortCode.get(sortCodePartBo.getVid());
            DynamicObject newDy = new DynamicObject(hisDy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)hisDy, (DynamicObject)newDy);
            String sortCode = sortCodePartBo.getSortCode();
            newDy.set("sortcode", (Object)sortCode);
            newDy.set("index", (Object)Integer.valueOf(sortCode.substring(sortCode.lastIndexOf("!") + 1)));
            LocalDateRangeUtils.setEffectRange(newDy, sortCodePartBo.getEffectRange());
            newDy.set("id", (Object)idCreator.getId());
            newDy.set("createtime", (Object)now);
            newDy.set("creator", (Object)administrator);
            return newDy;
        }).toArray(DynamicObject[]::new);
        return AdminOrgHisServiceHelper.getHisVersionParam(hisDyns, AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey(), false);
    }

    private HisResponse<VersionChangeRespData> saveHis(HisVersionParamBo hisVersionParamBo) {
        if (hisVersionParamBo.getHisDyns() != null && hisVersionParamBo.getHisDyns().length > 0) {
            return HisModelController.getInstance().hisVersionChange(hisVersionParamBo);
        }
        return new HisResponse();
    }

    private List<CascadeBo> getCascadeBoList() {
        DynamicObject[] adOrgDys = AdOrgRepository.getInstance().queryAllHisOriginalArrayByBo("id,boid,parentorg.id,index,bsed,bsled");
        DynamicObject[] sortCodeDys = AdOrgSortCodeRepository.getInstance().queryAllHisOriginalArrayByOrgId("id,adminorg.id, bsed,bsled,index,sortcode");
        return this.packageCascadeBoList(Arrays.asList(adOrgDys), Arrays.asList(sortCodeDys));
    }

    private List<CascadeBo> packageCascadeBoList(List<DynamicObject> hisMasterDyList, List<DynamicObject> hisSortCodeList) {
        Map<Long, List<DynamicObject>> boVsHisMasterDyList = hisMasterDyList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        Map<Long, List<DynamicObject>> adOrgBoVsHisSortCodeDyList = hisSortCodeList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("adminorg.id")));
        return boVsHisMasterDyList.entrySet().stream().map(boVsMasterDyListEntry -> {
            Long adminOrgBo = (Long)boVsMasterDyListEntry.getKey();
            List masterDyList = (List)boVsMasterDyListEntry.getValue();
            List<DynamicObject> sortCodeList = adOrgBoVsHisSortCodeDyList.getOrDefault(adminOrgBo, Collections.emptyList());
            return this.createCascadeBo(masterDyList, sortCodeList);
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<CascadeBo> createCascadeBo(List<DynamicObject> masterDyList, List<DynamicObject> sortCodeList) {
        return masterDyList.stream().map(masterDy -> {
            AdOrgCascadeBo adOrgCascadeBo = new AdOrgCascadeBo();
            adOrgCascadeBo.setBo(masterDy.getLong("boid"));
            LocalDateRange effectRange = LocalDateRangeUtils.getEffectRange(masterDy);
            adOrgCascadeBo.setEffectRange(effectRange);
            adOrgCascadeBo.setParentBo(masterDy.getLong("parentorg.id"));
            adOrgCascadeBo.setIndex(masterDy.getInt("index"));
            adOrgCascadeBo.setSortCodePartBoList(this.createCascadePartBo(effectRange, sortCodeList));
            return adOrgCascadeBo;
        }).collect(Collectors.toList());
    }

    private List<SortCodePartBo> createCascadePartBo(LocalDateRange effectRange, List<DynamicObject> sortCodeList) {
        return sortCodeList.stream().filter(dy -> LocalDateRangeUtils.getEffectRange(dy).overlaps(effectRange)).map(sortCodeDy -> {
            SortCodePartBo sortCodePartBo = new SortCodePartBo();
            sortCodePartBo.setSortCode(sortCodeDy.getString("sortcode"));
            sortCodePartBo.setVid(sortCodeDy.getLong("id"));
            sortCodePartBo.setEffectRange(LocalDateRangeUtils.getEffectRange(sortCodeDy));
            return sortCodePartBo;
        }).collect(Collectors.toList());
    }

    private void logIndexChangedAdminorg(Set<Long> idSet) {
        LOGGER.info(String.format("index changed adminorg boids: %s", idSet));
    }

    private void logSortCodeChangedAdminorg(Set<Long> idSet) {
        LOGGER.info(String.format("sortcode changed adminorg boid: %s", idSet));
    }

    private void logHisResponse(HisResponse<VersionChangeRespData> response) {
        LOGGER.info(String.format("response code: %s, response error message: %s", response.getCode(), response.getErrorMessage()));
    }
}

