/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.servicehelper;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.domain.repository.orgteam.OTStructRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.servicehelper.model.upgrade.AdminOrgCascadeBo;
import kd.hr.haos.business.servicehelper.model.upgrade.OTStructPartBo;
import kd.hr.haos.business.servicehelper.model.upgrade.StructPartBo;
import kd.hr.haos.business.util.IdCreator;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.business.util.cascade.MultiVersionCascadeHelper;
import kd.hr.haos.common.model.cascade.CascadeBo;
import kd.hr.haos.common.model.cascade.CascadeResult;
import kd.hr.haos.common.model.cascade.PartBo;
import kd.hr.haos.common.util.LocalDateRange;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class AdminOrgUpgradeHelper {
    private static final Log LOGGER = LogFactory.getLog(AdminOrgUpgradeHelper.class);
    private static final String PARENTORG_ESTABLISHMENTDATE = "parentorg.establishmentdate";
    private final Date now = new Date();
    private DynamicObject administratorDy = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");

    public AdminOrgUpgradeHelper() {
        this.administratorDy.set("id", (Object)1);
    }

    public void upgrade() {
        this.upgradeOrg();
        this.doUpgrade();
    }

    public void upgradeOrg() {
        QFilter qFilter = new QFilter("establishmentdate", "=", (Object)"bsed", true);
        qFilter.and(new QFilter(PARENTORG_ESTABLISHMENTDATE, ">", (Object)"bsed", true));
        qFilter.and(new QFilter(PARENTORG_ESTABLISHMENTDATE, "<", (Object)"bsled", true));
        qFilter.and("initdatasource", "=", (Object)"1");
        DynamicObject[] adOrgDys = AdOrgRepository.getInstance().load(qFilter);
        if (adOrgDys.length == 0) {
            return;
        }
        ArrayList<DynamicObject> newDyList = new ArrayList<DynamicObject>(adOrgDys.length);
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(adOrgDys.length);
        IdCreator idCreator = new IdCreator();
        for (DynamicObject adOrgDy : adOrgDys) {
            Date parentDate = HRDateTimeUtils.truncateDate((Date)adOrgDy.getDate(PARENTORG_ESTABLISHMENTDATE));
            if (parentDate.compareTo(adOrgDy.getDate("bsled")) >= 0 || parentDate.compareTo(adOrgDy.getDate("bsed")) <= 0) continue;
            DynamicObject newDy = new DynamicObject(adOrgDy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)adOrgDy, (DynamicObject)newDy);
            newDy.set("bsled", (Object)Date.from(parentDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().minusDays(1L).atStartOfDay(ZoneId.systemDefault()).toInstant()));
            newDy.set("parentorg", null);
            newDy.set("creator", (Object)this.administratorDy);
            newDy.set("modifier", (Object)this.administratorDy);
            newDy.set("createtime", (Object)this.now);
            newDy.set("modifytime", (Object)this.now);
            newDy.set("id", (Object)idCreator.getId());
            newDyList.add(newDy);
            map.put(newDy.getLong("boid"), newDy);
        }
        ArrayList<HisVersionParamBo> paramBoList = new ArrayList<HisVersionParamBo>(4);
        HisVersionParamBo paramBo = AdminOrgHisServiceHelper.getHisVersionParam(newDyList.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), false);
        paramBo.setNeedProcessAttachment(false);
        paramBoList.add(paramBo);
        this.addParam(map, paramBoList);
        HisResponse<BatchVersionChangeRespData> response = this.saveHis(paramBoList);
        this.logHisResponse(response);
    }

    private boolean overlaps(Date startDate, Date endDate, List<DynamicObject> list) {
        return this.overlapsDy(startDate, endDate, list) == null;
    }

    private DynamicObject overlapsDy(Date startDate, Date endDate, List<DynamicObject> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        Optional<DynamicObject> optional = list.stream().filter(dy -> startDate.compareTo(dy.getDate("bsled")) < 0 && dy.getDate("bsed").compareTo(endDate) < 0).findFirst();
        return optional.orElse(null);
    }

    private void fillAttribute(DynamicObject newDy, Date startDate, Date endDate) {
        newDy.set("createtime", (Object)this.now);
        newDy.set("creator", (Object)this.administratorDy);
        newDy.set("modifier", (Object)this.administratorDy);
        newDy.set("bsed", (Object)startDate);
        newDy.set("bsled", (Object)endDate);
    }

    private void addParam(Map<Long, DynamicObject> map, List<HisVersionParamBo> paramList) {
        HisVersionParamBo paramBo;
        Map<Long, List<DynamicObject>> hisStructMap = Arrays.stream(AdminOrgStructRepository.getInstance().loadByAdminOrg(map.keySet())).collect(Collectors.groupingBy(dy -> dy.getLong("adminorg.id")));
        Map<Long, List<DynamicObject>> hisTeamMap = Arrays.stream(OTQueryRepository.getInstance().loadByBoId(map.keySet())).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        Map<Long, List<DynamicObject>> hisTeamStructMap = Arrays.stream(OTStructRepository.getInstance().loadByOrgTeam(map.keySet())).collect(Collectors.groupingBy(dy -> dy.getLong("orgteam.id")));
        ArrayList<DynamicObject> structList = new ArrayList<DynamicObject>(map.size());
        ArrayList<DynamicObject> teamList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> teamStructList = new ArrayList<DynamicObject>();
        for (Map.Entry<Long, DynamicObject> entry : map.entrySet()) {
            DynamicObject newDy;
            DynamicObject oldDy;
            List<DynamicObject> list;
            Date endDate;
            Date startDate = entry.getValue().getDate("bsed");
            if (this.overlaps(startDate, endDate = entry.getValue().getDate("bsled"), list = hisStructMap.get(entry.getKey()))) {
                oldDy = list.get(0);
                newDy = new DynamicObject(oldDy.getDynamicObjectType());
                HRDynamicObjectUtils.copy((DynamicObject)oldDy, (DynamicObject)newDy);
                this.fillAttribute(newDy, startDate, endDate);
                newDy.set("structlongnumber", (Object)entry.getValue().getString("structnumber"));
                newDy.set("level", (Object)1);
                newDy.set("parentorg", null);
                structList.add(newDy);
            }
            if ((oldDy = this.overlapsDy(startDate, endDate, list = hisTeamMap.get(entry.getKey()))) != null) {
                newDy = new DynamicObject(oldDy.getDynamicObjectType());
                HRDynamicObjectUtils.copy((DynamicObject)oldDy, (DynamicObject)newDy);
                this.fillAttribute(newDy, startDate, endDate);
                newDy.set("parent", null);
                newDy.set("id", (Object)entry.getValue().getLong("id"));
                teamList.add(newDy);
            }
            if (!this.overlaps(startDate, endDate, list = hisTeamStructMap.get(entry.getKey()))) continue;
            oldDy = list.get(0);
            newDy = new DynamicObject(oldDy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)oldDy, (DynamicObject)newDy);
            this.fillAttribute(newDy, startDate, endDate);
            newDy.set("parentorgteam", null);
            newDy.set("orgteamhisid", (Object)entry.getValue().getLong("id"));
            newDy.set("structlongnumber", (Object)entry.getValue().getString("structnumber"));
            newDy.set("level", (Object)1);
            teamStructList.add(newDy);
        }
        if (!CollectionUtils.isEmpty(structList)) {
            paramBo = AdminOrgHisServiceHelper.getHisVersionParam(structList.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), false);
            paramBo.setNeedProcessAttachment(false);
            paramList.add(paramBo);
        }
        if (!CollectionUtils.isEmpty(teamList)) {
            paramBo = AdminOrgHisServiceHelper.getHisVersionParam(teamList.toArray(new DynamicObject[0]), "haos_orgteamquery", false);
            paramBo.setNeedProcessAttachment(false);
            paramList.add(paramBo);
        }
        if (!CollectionUtils.isEmpty(teamStructList)) {
            paramBo = AdminOrgHisServiceHelper.getHisVersionParam(teamStructList.toArray(new DynamicObject[0]), "haos_adminorgstructure", false);
            paramBo.setNeedProcessAttachment(false);
            paramList.add(paramBo);
        }
    }

    private void doUpgrade() {
        CascadeResult cascadeResult = this.calculate();
        List<HisVersionParamBo> hisBoList = this.createHisVersionParamBo(cascadeResult);
        this.changedAdminOrg(cascadeResult.getBoVsPartCascadeBo().keySet());
        HisResponse<BatchVersionChangeRespData> response = this.saveHis(hisBoList);
        this.logHisResponse(response);
    }

    private CascadeResult calculate() {
        List<CascadeBo> cascadeBoList = this.packageCascadeBoList();
        return MultiVersionCascadeHelper.getCascadeResult(cascadeBoList);
    }

    private HisVersionParamBo createStructParamBo(List<PartBo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        Set<Long> structVisSet = list.stream().map(PartBo::getVid).collect(Collectors.toSet());
        DynamicObject[] structHisDatas = AdminOrgStructRepository.getInstance().loadByIds(structVisSet);
        Map<Long, DynamicObject> idVsHisStruct = Arrays.stream(structHisDatas).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        IdCreator idCreator = new IdCreator();
        HRBaseServiceHelper orgHelp = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        DynamicObject[] hisDyns = (DynamicObject[])list.stream().map(partBo -> (StructPartBo)((Object)partBo)).map(structPartBo -> {
            DynamicObject hisDy = (DynamicObject)idVsHisStruct.get(structPartBo.getVid());
            DynamicObject newDy = new DynamicObject(hisDy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)hisDy, (DynamicObject)newDy);
            DynamicObject parentDy = orgHelp.generateEmptyDynamicObject();
            parentDy.set("id", (Object)structPartBo.getParentBoId());
            newDy.set("parentorg", (Object)parentDy);
            String structLongNumber = structPartBo.getStructLongNumber();
            newDy.set("structlongnumber", (Object)structLongNumber);
            newDy.set("level", (Object)structLongNumber.split("!").length);
            LocalDateRangeUtils.setEffectRange(newDy, structPartBo.getEffectRange());
            newDy.set("id", (Object)idCreator.getId());
            newDy.set("createtime", (Object)this.now);
            newDy.set("modifier", (Object)this.administratorDy);
            newDy.set("creator", (Object)this.administratorDy);
            return newDy;
        }).toArray(DynamicObject[]::new);
        return AdminOrgHisServiceHelper.getHisVersionParam(hisDyns, AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), false);
    }

    private HisVersionParamBo createOtStructParamBo(List<PartBo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        Set<Long> otVisSet = list.stream().map(PartBo::getVid).collect(Collectors.toSet());
        Map<Long, DynamicObject> idVsHisStruct = Arrays.stream(OTStructRepository.getInstance().loadByIds(otVisSet)).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        IdCreator idCreator = new IdCreator();
        HRBaseServiceHelper orgTeamHelp = new HRBaseServiceHelper("haos_adminorgteam");
        DynamicObject[] hisDyns = (DynamicObject[])list.stream().map(partBo -> (OTStructPartBo)((Object)partBo)).map(otStructPartBo -> {
            DynamicObject hisDy = (DynamicObject)idVsHisStruct.get(otStructPartBo.getVid());
            DynamicObject newDy = new DynamicObject(hisDy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)hisDy, (DynamicObject)newDy);
            String structLongNumber = otStructPartBo.getStructLongNumber();
            newDy.set("structlongnumber", (Object)structLongNumber);
            LocalDateRangeUtils.setEffectRange(newDy, otStructPartBo.getEffectRange());
            DynamicObject parentDy = orgTeamHelp.generateEmptyDynamicObject();
            parentDy.set("id", (Object)otStructPartBo.getParentBoId());
            newDy.set("parentorgteam", (Object)parentDy);
            newDy.set("id", (Object)idCreator.getId());
            newDy.set("createtime", (Object)this.now);
            newDy.set("modifier", (Object)this.administratorDy);
            newDy.set("creator", (Object)this.administratorDy);
            return newDy;
        }).toArray(DynamicObject[]::new);
        return AdminOrgHisServiceHelper.getHisVersionParam(hisDyns, "haos_adminorgstructure", false);
    }

    private List<HisVersionParamBo> createHisVersionParamBo(CascadeResult cascadeResult) {
        Map<Class, List<PartBo>> map = cascadeResult.getBoVsPartCascadeBo().values().stream().flatMap(Collection::stream).collect(Collectors.groupingBy(Object::getClass));
        ArrayList<HisVersionParamBo> list = new ArrayList<HisVersionParamBo>(3);
        HisVersionParamBo paramBo = this.createStructParamBo(map.get(StructPartBo.class));
        if (paramBo != null) {
            paramBo.setNeedProcessAttachment(false);
            list.add(paramBo);
        }
        if ((paramBo = this.createOtStructParamBo(map.get(OTStructPartBo.class))) != null) {
            paramBo.setNeedProcessAttachment(false);
            list.add(paramBo);
        }
        return list;
    }

    private HisResponse<BatchVersionChangeRespData> saveHis(List<HisVersionParamBo> hisBoList) {
        if (CollectionUtils.isEmpty(hisBoList)) {
            return new HisResponse();
        }
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setAtomicTrans(false);
        hisVersionParamListBo.setListHisVersionParamBo(hisBoList);
        return HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
    }

    private List<CascadeBo> packageCascadeBoList() {
        DynamicObject[] adOrgDys = AdOrgRepository.getInstance().queryAllHisOriginalArrayByBo("id,boid,parentorg.id,structnumber,bsed,bsled");
        Map<Long, List<DynamicObject>> boVsHisMasterDyMap = Arrays.stream(adOrgDys).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        Map<Long, List<DynamicObject>> adOrgBoVsHisStructDyMap = AdminOrgStructRepository.getInstance().queryHisColByBoId("id,adminorg.id,bsed,bsled,structlongnumber", boVsHisMasterDyMap.keySet()).stream().collect(Collectors.groupingBy(dy -> dy.getLong("adminorg.id")));
        Map<Long, List<DynamicObject>> adOrgBoVsHisOtStructMap = OTStructRepository.getInstance().queryHisColByBoId("id,orgteam.id,bsed,bsled,structlongnumber", boVsHisMasterDyMap.keySet()).stream().collect(Collectors.groupingBy(dy -> dy.getLong("orgteam.id")));
        return boVsHisMasterDyMap.entrySet().stream().map(boVsMasterDyListEntry -> {
            Long adminOrgBo = (Long)boVsMasterDyListEntry.getKey();
            List masterDyList = (List)boVsMasterDyListEntry.getValue();
            List<DynamicObject> structList = adOrgBoVsHisStructDyMap.getOrDefault(adminOrgBo, Collections.emptyList());
            return this.createCascadeBo(masterDyList, structList, adOrgBoVsHisOtStructMap.getOrDefault(adminOrgBo, Collections.emptyList()));
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<CascadeBo> createCascadeBo(List<DynamicObject> masterDyList, List<DynamicObject> structList, List<DynamicObject> otStructList) {
        return masterDyList.stream().map(masterDy -> {
            AdminOrgCascadeBo adOrgCascadeBo = new AdminOrgCascadeBo();
            adOrgCascadeBo.setBo(masterDy.getLong("boid"));
            LocalDateRange effectRange = LocalDateRangeUtils.getEffectRange(masterDy);
            adOrgCascadeBo.setEffectRange(effectRange);
            adOrgCascadeBo.setParentBo(masterDy.getLong("parentorg.id"));
            adOrgCascadeBo.setParam("structnumber", masterDy.getString("structnumber"));
            this.buildStructPartBo(adOrgCascadeBo, structList);
            this.buildOtStructPartBo(adOrgCascadeBo, otStructList);
            return adOrgCascadeBo;
        }).collect(Collectors.toList());
    }

    private void buildOtStructPartBo(AdminOrgCascadeBo adOrgCascadeBo, List<DynamicObject> otStructList) {
        LocalDateRange effectRange = adOrgCascadeBo.getEffectRange();
        otStructList.stream().filter(dy -> LocalDateRangeUtils.getEffectRange(dy).overlaps(effectRange)).forEach(structDy -> {
            OTStructPartBo structPartBo = new OTStructPartBo();
            structPartBo.setParentBoId(adOrgCascadeBo.getParentBo());
            structPartBo.setStructLongNumber(structDy.getString("structlongnumber"));
            structPartBo.setVid(structDy.getLong("id"));
            structPartBo.setEffectRange(LocalDateRangeUtils.getEffectRange(structDy));
            adOrgCascadeBo.addOtStructPartBo(structPartBo);
        });
    }

    private void buildStructPartBo(AdminOrgCascadeBo adOrgCascadeBo, List<DynamicObject> structList) {
        LocalDateRange effectRange = adOrgCascadeBo.getEffectRange();
        structList.stream().filter(dy -> LocalDateRangeUtils.getEffectRange(dy).overlaps(effectRange)).forEach(structDy -> {
            StructPartBo structPartBo = new StructPartBo();
            structPartBo.setParentBoId(adOrgCascadeBo.getParentBo());
            structPartBo.setStructLongNumber(structDy.getString("structlongnumber"));
            structPartBo.setVid(structDy.getLong("id"));
            structPartBo.setEffectRange(LocalDateRangeUtils.getEffectRange(structDy));
            adOrgCascadeBo.addStructPartBo(structPartBo);
        });
    }

    private void changedAdminOrg(Set<Long> idSet) {
        LOGGER.info(String.format("changed adminorg boid: %s", idSet));
    }

    private void logHisResponse(HisResponse<BatchVersionChangeRespData> response) {
        LOGGER.info(String.format("response code: %s, response error message: %s", response.getCode(), response.getErrorMessage()));
    }
}

