/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.servicehelper;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.util.HaosOrgUnitServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.HRBaseConstants;
import kd.hr.hbp.common.constants.HRHisBaseConstants;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OrgBatchBillHelper
implements HRHisBaseConstants,
HRBaseConstants,
HisFieldNameConstants {
    private static final Log log = LogFactory.getLog(OrgBatchBillHelper.class);
    static QFilter isNotCurrent = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
    static QFilter isCurrent = new QFilter("iscurrentversion", "=", (Object)"1");
    static QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
    static QFilter dataStatusCurrent = new QFilter("datastatus", "=", (Object)"-3");
    static QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
    static QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");

    public static String getOrgLongName(Long fId, Date modifyTime, String structType) {
        log.info("[\u83b7\u53d6\u884c\u653f\u7ec4\u7ec7\u957f\u540d\u79f0] orgId={}", (Object)fId);
        Set<Long> fIds = Stream.of(fId).collect(Collectors.toSet());
        return OrgBatchBillHelper.getOrgLongNameByFid(fIds, modifyTime, structType).values().stream().findFirst().orElse(" ");
    }

    public static Map<Long, String> getOrgLongName(Date modifyTime, String structType, Long ... boIds) {
        return OrgBatchBillHelper.getOrgLongName(Arrays.stream(boIds).collect(Collectors.toSet()), modifyTime, structType);
    }

    public static Map<Long, String> getOrgLongNameByFid(Set<Long> fIds, Date modifyTime, String structType) {
        HRBaseServiceHelper adminOrg = new HRBaseServiceHelper("haos_adminorgdetail");
        String select = StringUtils.joinWith((String)",", (Object[])new Object[]{"id", "name", "boid", "datastatus"});
        DynamicObjectCollection boIdObjects = adminOrg.queryOriginalCollection(select, new QFilter[]{new QFilter("id", "in", fIds)});
        if (CollectionUtils.isEmpty((Collection)boIdObjects)) {
            return new HashMap<Long, String>();
        }
        log.info("[\u6279\u91cf\u83b7\u53d6\u884c\u653f\u7ec4\u7ec7\u957f\u540d\u79f0] boIdObjects.size={}", (Object)boIdObjects.size());
        Set dynamicObjects = boIdObjects.stream().filter(OrgBatchBillHelper.distinctByKey1(s -> s.getLong("id"))).collect(Collectors.toSet());
        Map<Long, Long> fIdBoIdMap = dynamicObjects.stream().collect(Collectors.toMap(k -> Optional.of(k.getLong("id")).orElse(0L), v -> Optional.of(v.getLong("boid")).orElse(0L)));
        Map<Long, String> fIdNameMap = dynamicObjects.stream().collect(Collectors.toMap(k -> Optional.of(k.getLong("id")).orElse(0L), v -> Optional.of(v.getString("name")).orElse(" ")));
        Map<Long, String> boIdLongNameMap = OrgBatchBillHelper.getOrgLongName(new HashSet<Long>(fIdBoIdMap.values()), modifyTime, structType);
        HashMap<Long, String> orgLongNameMap = new HashMap<Long, String>();
        fIdBoIdMap.forEach((k, v) -> {
            String cfr_ignored_0 = (String)orgLongNameMap.put((Long)k, (String)boIdLongNameMap.get(v));
        });
        String separator = HaosOrgUnitServiceHelper.getFullNameSep();
        String separator4Regex = HaosOrgUnitServiceHelper.getFullNameSepSep4Regex();
        orgLongNameMap.forEach((k, v) -> {
            String[] split = String.join((CharSequence)separator, v, (CharSequence)fIdNameMap.get(k)).split(separator4Regex);
            split[split.length - 2] = "";
            String underLine = Arrays.stream(split).filter(s -> !s.isEmpty()).collect(Collectors.joining(separator));
            orgLongNameMap.put((Long)k, underLine);
        });
        return orgLongNameMap;
    }

    public static Map<Long, String> getBelongCompanyByAdId(Set<Long> idList, Date effDate) {
        DynamicObject[] adOrgDys = AdOrgRepository.getInstance().queryOriginalByPks("id, belongcompany.id", idList);
        Map<Long, Long> idVsCompanyBo = Arrays.stream(adOrgDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("belongcompany.id")));
        DynamicObject[] companyOrgDys = AdOrgRepository.getInstance().queryOriginalByBoAndEffDate("boid, belongcompany.name", idVsCompanyBo.values(), effDate);
        Map<Long, String> companyBoVsName = Arrays.stream(companyOrgDys).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getString("belongcompany.name")));
        return idList.stream().collect(Collectors.toMap(id -> id, id -> companyBoVsName.getOrDefault(idVsCompanyBo.get(id), ""), (v, v2) -> v));
    }

    public static Map<Long, String> getOrgLongName(Set<Long> boIds, Date modifyTime, String structType) {
        log.info("[\u6279\u91cf\u83b7\u53d6\u884c\u653f\u7ec4\u7ec7\u957f\u540d\u79f0] boIds={}", (Object)boIds.size());
        Map<Long, String> structLongNumberMap = OrgBatchBillHelper.getOrgStructObject(boIds, modifyTime, structType);
        Set<String> orgStructSet = structLongNumberMap.values().stream().map(s -> s.split("!")).flatMap(Arrays::stream).collect(Collectors.toSet());
        Map<String, String> structNameMap = OrgBatchBillHelper.getStructNumberMap(orgStructSet, modifyTime);
        String nameSeparator = HaosOrgUnitServiceHelper.getFullNameSep();
        HashMap<Long, String> structLongNameMap = new HashMap<Long, String>();
        structLongNumberMap.forEach((k, v) -> {
            Stream<String> structNumber = Arrays.stream(v.split("!"));
            String names = structNumber.map(x -> Optional.ofNullable(structNameMap.get(x)).orElse(" ")).collect(Collectors.joining(nameSeparator));
            structLongNameMap.put((Long)k, names);
        });
        return structLongNameMap;
    }

    static <T> Predicate<T> distinctByKey1(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private static Map<Long, String> getOrgStructObject(Set<Long> boIds, Date modifyTime, String structType) {
        HRBaseServiceHelper adminStruct = new HRBaseServiceHelper("haos_adminorgstruct");
        String selectStruct = StringUtils.joinWith((String)",", (Object[])new Object[]{"datastatus", "structlongnumber", "adminorg.id"});
        QFilter effDateFilter = new QFilter("bsed", "<=", (Object)modifyTime).and(new QFilter("bsled", ">=", (Object)modifyTime));
        Long structTypeId = AdminOrgConstants.ADMINORG_STRUCT;
        if (HRStringUtils.isNotEmpty((String)structType)) {
            structTypeId = Long.valueOf(structType);
        }
        QFilter structTypeQf = new QFilter("structproject", "=", (Object)structTypeId);
        QFilter structFilter = new QFilter("adminorg", "in", boIds);
        DynamicObjectCollection objects = adminStruct.queryOriginalCollection(selectStruct, new QFilter[]{structFilter, isNotCurrent, dataStatusFilter, effDateFilter, initStatusFilter, structTypeQf});
        HashSet orgStructObject = new HashSet(objects);
        HashMap<Long, String> structLongNumberMap = new HashMap<Long, String>(orgStructObject.stream().collect(Collectors.groupingBy(s -> s.getLong("adminorg.id"), Collectors.mapping(y -> y.getString("structlongnumber"), Collectors.joining()))));
        Set currentBoId = objects.stream().map(s -> s.getLong("adminorg.id")).collect(Collectors.toSet());
        boIds.removeAll(currentBoId);
        if (CollectionUtils.isEmpty(boIds)) {
            return structLongNumberMap;
        }
        structFilter = new QFilter("adminorg", "in", boIds);
        objects = adminStruct.queryOriginalCollection(selectStruct, new QFilter[]{structFilter, structTypeQf, isCurrent, dataStatusCurrent, effDateFilter, initStatusFilter});
        orgStructObject.addAll(new HashSet(objects));
        structLongNumberMap.putAll(orgStructObject.stream().collect(Collectors.groupingBy(s -> s.getLong("adminorg.id"), Collectors.mapping(y -> y.getString("structlongnumber"), Collectors.joining()))));
        return structLongNumberMap;
    }

    private static Map<String, String> getStructNumberMap(Set<String> structNumberSet, Date modifyTime) {
        HRBaseServiceHelper adminOrg = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter effDateFilter = new QFilter("bsed", "<=", (Object)modifyTime).and(new QFilter("bsled", ">=", (Object)modifyTime));
        QFilter structNumberFilter = new QFilter("structnumber", "in", structNumberSet);
        DynamicObject[] adminOrgNumber = adminOrg.query("id,structnumber,name", new QFilter[]{structNumberFilter, isNotCurrent, dataStatusFilter, effDateFilter, initStatusFilter});
        Stream<DynamicObject> dynamicObjectStream = Arrays.stream(adminOrgNumber).filter(OrgBatchBillHelper.distinctByKey1(s -> s.getString("structnumber")));
        Map<String, String> stringStringMap = dynamicObjectStream.collect(Collectors.toMap(dy -> Optional.ofNullable(dy.getString("structnumber")).orElse(""), dy -> Optional.ofNullable(dy.getString("name")).orElse("")));
        structNumberSet.removeAll(stringStringMap.keySet());
        if (structNumberSet.size() == 0) {
            return stringStringMap;
        }
        structNumberFilter = new QFilter("structnumber", "in", structNumberSet);
        DynamicObject[] adminOrgNumberNot = adminOrg.query("id,structnumber,name", new QFilter[]{structNumberFilter, isCurrent, dataStatusCurrent, enableFilter, effDateFilter, initStatusFilter});
        dynamicObjectStream = Arrays.stream(adminOrgNumberNot).filter(OrgBatchBillHelper.distinctByKey1(s -> s.getString("structnumber")));
        Map<String, String> stringStringMapNot = dynamicObjectStream.collect(Collectors.toMap(dy -> Optional.ofNullable(dy.getString("structnumber")).orElse(""), dy -> Optional.ofNullable(dy.getString("name")).orElse("")));
        stringStringMap.putAll(stringStringMapNot);
        return stringStringMap;
    }
}

