/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.servicehelper;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class OrgTeamStructUpgradeService {
    private final Map<Long, Long> teamAndOrgProjectIdMatchMap;
    private static final String ORG_TEAM_HIS_ID = "orgteamhisid";
    private static final String PARENT = "parent";
    private static final String PARENT_ID = "parent.id";
    private final HRBaseServiceHelper orgTeamStructHelp = new HRBaseServiceHelper("haos_adminorgstructure");
    private final HRBaseServiceHelper orgTeamBaseHelp = new HRBaseServiceHelper("haos_adminorgteam");
    private final HRBaseServiceHelper tempHelper = new HRBaseServiceHelper("haos_orgteamsreltemp");
    private Set<String> ignoreKeys;

    public OrgTeamStructUpgradeService(Map<Long, Long> teamAndOrgProjectIdMatchMap) {
        this.teamAndOrgProjectIdMatchMap = teamAndOrgProjectIdMatchMap;
    }

    private void saveTemp(DynamicObjectCollection baseCol, Set<Long> orgHisIdSet) {
        QFilter qFilter = new QFilter("id", "in", orgHisIdSet);
        Map<Long, DynamicObject> map = Arrays.stream(this.tempHelper.loadDynamicObjectArray(qFilter.toArray())).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        for (DynamicObject baseDy : baseCol) {
            Long hisId = baseDy.getLong("id");
            if (!orgHisIdSet.contains(hisId)) continue;
            DynamicObject tempDy = map.computeIfAbsent(hisId, k -> this.tempHelper.generateEmptyDynamicObject());
            tempDy.set("orgteam", (Object)baseDy.getLong("boid"));
            tempDy.set("id", (Object)hisId);
            tempDy.set(PARENT, (Object)baseDy.getLong(PARENT_ID));
            tempDy.set("bsed", (Object)baseDy.getDate("bsed"));
            tempDy.set("bsled", (Object)baseDy.getDate("bsled"));
            tempDy.set("otclassify", (Object)baseDy.getLong("otclassify.id"));
            tempDy.set("adminorghis", (Object)this.teamAndOrgProjectIdMatchMap.get(hisId));
        }
        this.tempHelper.save(map.values().toArray(new DynamicObject[0]));
    }

    public void updateStruct() {
        QFilter qFilter = new QFilter("otclassify", "in", Arrays.asList(1010L, 1020L));
        QFilter baseQFilter = new QFilter("datastatus", "in", (Object)new String[]{EnumHisDataVersionStatus.INVALIDED.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.DISCARDED.getStatus(), EnumHisDataVersionStatus.DELETED.getStatus()});
        qFilter.and(baseQFilter);
        DynamicObjectCollection baseCol = this.orgTeamBaseHelp.queryOriginalCollection("id,otclassify.id,datastatus,bsed,bsled,boid,iscurrentversion,parent.id,hisversion", new QFilter[]{qFilter}, "boid,iscurrentversion,bsed");
        ArrayList<DynamicObject> deleteBaseList = new ArrayList<DynamicObject>(baseCol.size());
        ArrayList<DynamicObject> baseList = new ArrayList<DynamicObject>(baseCol.size());
        HashSet<Long> orgTeamIdSet = new HashSet<Long>(baseCol.size());
        HashSet<Long> orgHisIdSet = new HashSet<Long>(baseCol.size());
        for (DynamicObject baseDy : baseCol) {
            Long hisId = baseDy.getLong("id");
            if (baseDy.getBoolean("iscurrentversion") || !hisId.equals(this.teamAndOrgProjectIdMatchMap.get(hisId))) {
                orgHisIdSet.add(hisId);
            }
            orgTeamIdSet.add(baseDy.getLong("boid"));
            if (EnumHisDataVersionStatus.DELETED.getStatus().equals(baseDy.getString("datastatus")) || EnumHisDataVersionStatus.DISCARDED.getStatus().equals(baseDy.getString("datastatus"))) {
                deleteBaseList.add(baseDy);
                continue;
            }
            baseList.add(baseDy);
        }
        qFilter = new QFilter("orgteam", "in", orgTeamIdSet);
        qFilter.and(baseQFilter);
        DynamicObject[] structArray = this.orgTeamStructHelp.loadDynamicObjectArray(qFilter.toArray());
        ArrayList<DynamicObject> deleteStructList = new ArrayList<DynamicObject>(baseCol.size());
        ArrayList<DynamicObject> structList = new ArrayList<DynamicObject>(baseCol.size());
        for (DynamicObject structDy : structArray) {
            if (EnumHisDataVersionStatus.DELETED.getStatus().equals(structDy.getString("datastatus")) || EnumHisDataVersionStatus.DISCARDED.getStatus().equals(structDy.getString("datastatus"))) {
                structDy.set(ORG_TEAM_HIS_ID, (Object)0L);
                deleteStructList.add(structDy);
                continue;
            }
            structList.add(structDy);
        }
        ArrayList newStructList = new ArrayList(structList.size());
        Map<Long, List<DynamicObject>> structMap = this.getNewStruct(baseList, structList);
        this.handleDeleteData(baseList, deleteBaseList, structMap, deleteStructList);
        structMap.values().forEach(newStructList::addAll);
        this.orgTeamStructHelp.save(newStructList.toArray(new DynamicObject[0]));
        this.saveTemp(baseCol, orgHisIdSet);
    }

    private void handleDeleteData(List<DynamicObject> baseList, List<DynamicObject> deleteBaseList, Map<Long, List<DynamicObject>> structMap, List<DynamicObject> deleteStructList) {
        Long orgTeamId;
        int index;
        Map<Long, List<DynamicObject>> deleteStructMap = deleteStructList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("orgteam.id")));
        for (DynamicObject baseDy : deleteBaseList) {
            DynamicObject structDy;
            index = -1;
            orgTeamId = baseDy.getLong("boid");
            if (CollectionUtils.isEmpty((Collection)structMap.get(orgTeamId))) continue;
            List<DynamicObject> structList = deleteStructMap.get(orgTeamId);
            if (!CollectionUtils.isEmpty(structList)) {
                index = this.getListIndex(structList, baseDy, true);
            }
            if (index != -1) {
                structDy = structList.get(index);
                this.fillNewAttribute(baseDy, structDy);
                structList = structMap.get(orgTeamId);
                structList.add(structDy);
                continue;
            }
            structList = structMap.get(orgTeamId);
            index = this.getListIndex(structList, baseDy, false);
            if (index == -1) continue;
            structDy = structList.get(index);
            DynamicObject newStructDy = this.orgTeamStructHelp.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)structDy, (DynamicObject)newStructDy, this.getIgnoreKeys());
            this.fillData(baseDy, newStructDy);
            structList.add(newStructDy);
        }
        if (CollectionUtils.isEmpty(deleteStructList)) {
            return;
        }
        Map<Long, List<DynamicObject>> baseMap = baseList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        for (DynamicObject deleteStructDy : deleteStructList) {
            List<DynamicObject> baseDyList;
            if (deleteStructDy.getLong(ORG_TEAM_HIS_ID) != 0L || CollectionUtils.isEmpty((Collection)structMap.get(orgTeamId = Long.valueOf(deleteStructDy.getLong("orgteam.id")))) || (index = this.getListIndex(baseDyList = baseMap.get(orgTeamId), deleteStructDy, false)) == -1) continue;
            this.fillNewAttribute(baseDyList.get(index), deleteStructDy);
            structMap.get(orgTeamId).add(deleteStructDy);
        }
    }

    private int getListIndex(List<DynamicObject> list, DynamicObject dy, boolean isEqual) {
        Date effStartDate = dy.getDate("bsed");
        for (int index = 0; index < list.size(); ++index) {
            DynamicObject otherDy = list.get(index);
            Date otherEffStartDate = otherDy.getDate("bsed");
            if (isEqual && effStartDate.compareTo(otherEffStartDate) == 0 && otherDy.getLong(ORG_TEAM_HIS_ID) == 0L) {
                return index;
            }
            if (isEqual || otherEffStartDate.compareTo(effStartDate) > 0 || otherDy.getDate("bsled").compareTo(effStartDate) < 0 || otherDy.getBoolean("iscurrentversion")) continue;
            return index;
        }
        return -1;
    }

    private Map<Long, List<DynamicObject>> getNewStruct(List<DynamicObject> baseList, List<DynamicObject> structList) {
        Map<Long, List<DynamicObject>> structMap = structList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("orgteam.id")));
        long lastOrgTeamId = 0L;
        int lastIndex = 0;
        for (DynamicObject baseDy : baseList) {
            long orgTeamId = baseDy.getLong("boid");
            if (lastOrgTeamId != orgTeamId) {
                lastIndex = 0;
                this.sort(structMap.get(orgTeamId));
                lastOrgTeamId = orgTeamId;
            }
            lastIndex = this.handleStruct(baseDy, structMap.get(orgTeamId), lastIndex);
        }
        return structMap;
    }

    private void sort(List<DynamicObject> structList) {
        if (CollectionUtils.isEmpty(structList)) {
            return;
        }
        structList.sort(Comparator.comparing(o -> o.getString("iscurrentversion")).thenComparing(o -> o.getDate("bsed")));
    }

    private int handleStruct(DynamicObject baseDy, List<DynamicObject> structList, int lastIndex) {
        if (CollectionUtils.isEmpty(structList)) {
            return lastIndex;
        }
        if (baseDy.getBoolean("iscurrentversion")) {
            DynamicObject structDy = structList.get(structList.size() - 1);
            this.fillNewAttribute(baseDy, structDy);
            if (structList.size() < 2) {
                return structList.size();
            }
            structDy.set("bsed", structList.get(structList.size() - 2).get("bsed"));
            return structList.size();
        }
        for (int index = lastIndex; index < structList.size(); ++index) {
            DynamicObject structDy = structList.get(index);
            if (structDy.getBoolean("iscurrentversion")) {
                return structList.size();
            }
            int compare = baseDy.getDate("bsled").compareTo(structDy.getDate("bsled"));
            if (baseDy.getDate("bsled").compareTo(structDy.getDate("bsed")) < 0) {
                return lastIndex;
            }
            this.fillNewAttribute(baseDy, structDy);
            if (compare > 0) continue;
            lastIndex = index + 1;
            if (compare == 0) {
                return lastIndex;
            }
            DynamicObject newStructDy = this.orgTeamStructHelp.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)structDy, (DynamicObject)newStructDy, this.getIgnoreKeys());
            if (EnumHisDataVersionStatus.EFFECTING.getStatus().equals(newStructDy.getString("datastatus"))) {
                newStructDy.set("datastatus", (Object)EnumHisDataVersionStatus.INVALIDED.getStatus());
            }
            Date endDate = baseDy.getDate("bsled");
            newStructDy.set("bsled", (Object)endDate);
            endDate = Date.from(endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().plusDays(1L).atStartOfDay(ZoneId.systemDefault()).toInstant());
            structDy.set("bsed", (Object)endDate);
            structDy.set(ORG_TEAM_HIS_ID, null);
            structList.set(index, newStructDy);
            structList.add(lastIndex, structDy);
            return lastIndex;
        }
        return lastIndex;
    }

    private Set<String> getIgnoreKeys() {
        if (this.ignoreKeys == null) {
            this.ignoreKeys = new HashSet<String>(16);
            this.ignoreKeys.add("sourcevid");
            this.ignoreKeys.add("modifytime");
            this.ignoreKeys.add("modify");
            this.ignoreKeys.add("createtime");
            this.ignoreKeys.add("creator");
        }
        return this.ignoreKeys;
    }

    private void fillData(DynamicObject baseDy, DynamicObject structDy) {
        structDy.set("bsled", baseDy.get("bsled"));
        structDy.set("bsed", baseDy.get("bsed"));
        structDy.set("datastatus", baseDy.get("datastatus"));
        this.fillNewAttribute(baseDy, structDy);
    }

    private void fillNewAttribute(DynamicObject baseDy, DynamicObject structDy) {
        Long id = this.teamAndOrgProjectIdMatchMap.get(baseDy.getLong("id"));
        long classifyId = baseDy.getLong("otclassify.id");
        structDy.set(ORG_TEAM_HIS_ID, (Object)id);
        structDy.set("otclassify", (Object)classifyId);
        structDy.set("hisversion", baseDy.get("hisversion"));
    }
}

