/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.servicehelper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class OrgTeamUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(OrgTeamUpgradeService.class);
    private static final String SEMICOLON = ";;";
    private Map<String, Set<Long>> orgTeamMap;
    private Map<Long, Long> orgAndTeamMap;

    public OrgTeamUpgradeService(Map<Long, Long> orgAndTeamMap) {
        this.orgAndTeamMap = orgAndTeamMap;
    }

    public void upgrade() {
        this.initOrgTeamMap();
        if (CollectionUtils.isEmpty(this.orgAndTeamMap)) {
            LOGGER.info("not data");
            return;
        }
        this.updateOrgTeamId();
        this.updateField();
    }

    private void initOrgTeamMap() {
        this.orgTeamMap = new HashMap<String, Set<Long>>(16);
        String sql = "select ffieldname,ftablename,max(fobjecttypeid) fobjecttypeid from t_meta_objecttyperef where frefobjecttypeid in ('haos_adminorgteamnoperm','haos_adminorgteam')\n and ftablename !=' '\n and fobjecttypeid != frefobjecttypeid and fobjecttypeid like 'homs_orgfastchgparent%' group by ffieldname,ftablename";
        try (DataSet rs = HRDBUtil.queryDataSet((String)"meta_objecttyperef", (DBRoute)new DBRoute("sys.meta"), (String)sql, null);){
            rs.forEach(data -> {
                try {
                    String routeKey = MetadataServiceHelper.getDataEntityType((String)data.getString("fobjecttypeid")).getDBRouteKey();
                    this.initOrgTeamMap(routeKey, data.getString("ffieldname"), data.getString("ftablename"));
                }
                catch (KDException e) {
                    LOGGER.error(e.getMessage());
                }
            });
        }
    }

    private void initOrgTeamMap(String routeKey, String fieldName, String tableName) {
        String key = routeKey + SEMICOLON + fieldName + SEMICOLON + tableName;
        String sql = "select " + fieldName + " from " + tableName;
        try (DataSet rs = HRDBUtil.queryDataSet((String)key, (DBRoute)new DBRoute(routeKey), (String)sql, null);){
            rs.forEach(data -> {
                Set set = this.orgTeamMap.computeIfAbsent(key, k -> new HashSet(100));
                set.add(data.getLong(fieldName));
            });
        }
    }

    private void updateOrgTeamId() {
        HRBaseServiceHelper orgTeamHelper = new HRBaseServiceHelper("haos_adminorgteam");
        QFilter qFilter = new QFilter("id", "in", this.orgAndTeamMap.keySet());
        qFilter.and("otclassify", "in", Arrays.asList(1010L, 1020L));
        qFilter.and("iscurrentversion", "!=", (Object)"1");
        DynamicObject[] orgTeamArray = orgTeamHelper.loadDynamicObjectArray(qFilter.toArray());
        ArrayList<DynamicObject> newOrgTeamList = new ArrayList<DynamicObject>(orgTeamArray.length);
        HashSet<Long> orgTeamIdSet = new HashSet<Long>(orgTeamArray.length);
        HashSet<Long> teamBoIdSet = new HashSet<Long>(orgTeamArray.length);
        for (DynamicObject orgTeamDy : orgTeamArray) {
            Long orgTeamId = orgTeamDy.getLong("id");
            Long adminOrgId = this.orgAndTeamMap.get(orgTeamId);
            if (adminOrgId.equals(orgTeamId)) continue;
            DynamicObject newDy = orgTeamHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)orgTeamDy, (DynamicObject)newDy);
            newDy.set("id", (Object)adminOrgId);
            newDy.set("sourcevid", (Object)this.orgAndTeamMap.get(orgTeamDy.getLong("sourcevid")));
            newOrgTeamList.add(newDy);
            orgTeamIdSet.add(orgTeamId);
            teamBoIdSet.add(orgTeamDy.getLong("boid"));
        }
        if (orgTeamIdSet.size() > 0) {
            orgTeamHelper.delete((Object[])orgTeamIdSet.toArray(new Long[0]));
            orgTeamHelper.save(newOrgTeamList.toArray(new DynamicObject[0]));
            this.updateTeamSourceId(orgTeamHelper, teamBoIdSet);
        }
    }

    private void updateTeamSourceId(HRBaseServiceHelper orgTeamHelper, Set<Long> id) {
        DynamicObject[] orgTeamArray;
        QFilter qFilter = new QFilter("id", "in", id);
        qFilter.and("sourcevid", "!=", (Object)0);
        for (DynamicObject dy : orgTeamArray = orgTeamHelper.loadDynamicObjectArray(qFilter.toArray())) {
            Long adminOrgId = this.orgAndTeamMap.get(dy.getLong("sourcevid"));
            if (adminOrgId == null) continue;
            dy.set("sourcevid", (Object)adminOrgId);
        }
        orgTeamHelper.save(orgTeamArray);
    }

    private void updateField() {
        for (Map.Entry<String, Set<Long>> entry : this.orgTeamMap.entrySet()) {
            Set<Long> set = entry.getValue();
            set.forEach(id -> {
                Long adminOrgId = this.orgAndTeamMap.get(id);
                LOGGER.info("orgTeam.id=" + id + ",adminorg.id=" + adminOrgId);
                if (adminOrgId != null && !id.equals(adminOrgId)) {
                    String[] args = ((String)entry.getKey()).split(SEMICOLON);
                    String sql = "update " + args[2] + " set " + args[1] + "= ? where " + args[1] + "= ?";
                    HRDBUtil.update((DBRoute)new DBRoute(args[0]), (String)sql, (Object[])new Object[]{adminOrgId, id});
                }
            });
        }
    }
}

