/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.servicehelper;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.business.servicehelper.SystemParamHelper;
import kd.hr.haos.business.util.HAOSPermUtils;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRDBUtil;

public class VirtualOrgHelper {
    public static Set<Long> getSubOrgSet(Long orgId, Long structProjectId, Date effectDate) {
        Set<Long> orgSet = Collections.singleton(orgId);
        DynamicObjectCollection structLongNumberCol = AdminOrgStructRepository.getInstance().queryHisColByBoDate(orgSet, effectDate, OrgDateTimeUtil.BSLED, structProjectId);
        Set<String> likeSet = structLongNumberCol.stream().map(struct -> struct.getString("structlongnumber")).collect(Collectors.toSet());
        DynamicObjectCollection structCol = AdminOrgStructRepository.getInstance().queryHisColBySLN(likeSet, Collections.emptySet(), effectDate, OrgDateTimeUtil.BSLED, structProjectId);
        return structCol.stream().map(dy -> dy.getLong("adminorg.id")).collect(Collectors.toSet());
    }

    public static Set<Long> getStructOrgSet(Long structProjectId, QFilter qFilter) {
        QFilter newQFilter = qFilter.copy();
        String value = newQFilter.getValue().toString();
        value = value.replace("number", "adminorg.number");
        value = value.replace("name", "adminorg.name");
        newQFilter.__setValue((Object)value);
        DynamicObjectCollection col = AdminOrgStructRepository.getInstance().queryColByStructAndQFilter("adminorg.id", structProjectId, newQFilter);
        return col.stream().map(dy -> dy.getLong("adminorg.id")).collect(Collectors.toSet());
    }

    public static void setPermFilter(List<QFilter> filterList, Long structProjectId) {
        DynamicObject dy = StructProjectRepository.getInstance().queryOriginalOneByPk("id,creator,org,enable", structProjectId);
        if ("10".equals(dy.getString("enable"))) {
            return;
        }
        Long userId = RequestContext.get().getCurrUserId();
        if (RequestContext.get().getCurrUserId() == dy.getLong("creator") && SystemParamHelper.getCreatorHasPermission(dy.getLong("org"))) {
            return;
        }
        String permField = "boid";
        Map<String, Object> map = HAOSPermUtils.getStructProjectCustomInParam(permField, structProjectId);
        AuthorizedOrgResult permResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserAdminOrgs", (Object[])new Object[]{userId, "homs", "haos_structorgdetail", "47150e89000000ac", permField, map});
        if (permResult.isHasAllOrgPerm()) {
            return;
        }
        filterList.add(new QFilter("id", "in", (Object)permResult.getHasPermOrgs()));
    }

    public static Set<String> checkProcessNumber(Set<String> numberSet) {
        if (CollectionUtils.isEmpty(numberSet)) {
            return Collections.emptySet();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select fbillno from t_homs_orgchgbill bi,t_homs_orgchgbillentry en ").append("where bi.fid = en.fid  and bi.fbillstatus in ('B','D') ").append("and en.fnumber in (");
        numberSet.forEach(id -> sb.append('?').append(','));
        sb.deleteCharAt(sb.length() - 1);
        sb.append(')');
        HashSet set = Sets.newHashSetWithExpectedSize((int)numberSet.size());
        try (DataSet ds = HRDBUtil.queryDataSet((String)"queryProcessNumber", (DBRoute)new DBRoute("haos"), (String)sb.toString(), (Object[])numberSet.toArray());){
            for (Row data : ds) {
                set.add(data.getString("fbillno"));
            }
        }
        return set;
    }
}

