/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgUnitSyncService;
import kd.hr.haos.business.servicehelper.AdminOrgInitServiceHelper;
import kd.hr.haos.business.util.TimeLogger;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class AdminInitSyncOrgTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(AdminInitSyncOrgTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try (TXHandle required = TX.required();){
            try {
                logger.info("begin do execute");
                this.execute(map);
                logger.info("do execute success");
            }
            catch (Throwable ex) {
                required.markRollback();
                logger.error("do execute error", ex);
                logger.error(ex);
                throw ex;
            }
        }
    }

    private int getPageSize() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_odcconfigparam");
        DynamicObject dynamicObject = serviceHelper.queryOne("value", new QFilter[]{new QFilter("number", "=", (Object)"OrgInitPageSIze")});
        return Integer.parseInt(dynamicObject.getString("value"));
    }

    private void execute(Map<String, Object> map) {
        TimeLogger timeLogger = TimeLogger.create();
        timeLogger.start();
        ArrayList<Long> batchList = new ArrayList<Long>();
        QFilter initBatchQFilter = null;
        Object initBatchNumber = map.get("initBatchNumber");
        if (initBatchNumber instanceof String) {
            String[] split;
            String batchNumber = (String)initBatchNumber;
            for (String sp : split = batchNumber.split(";")) {
                batchList.add(Long.parseLong(sp.trim()));
            }
        }
        if (!batchList.isEmpty()) {
            initBatchQFilter = new QFilter("initbatch", "in", batchList);
        }
        QFilter[] filters = new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1"), new QFilter("initstatus", "=", (Object)"2")};
        List<QFilter> qFilters = Arrays.stream(filters).collect(Collectors.toList());
        if (initBatchQFilter != null) {
            qFilters.add(initBatchQFilter);
        }
        filters = qFilters.toArray(new QFilter[0]);
        logger.info("filters == {}", qFilters);
        int pageSize = this.getPageSize();
        timeLogger.check("pageSize ==== " + pageSize);
        HRBaseServiceHelper orgDetailServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        int count = orgDetailServiceHelper.count("haos_adminorgdetail", filters);
        if (count == 0) {
            timeLogger.check("totalCount ====  0");
            return;
        }
        int pageCount = (int)Math.ceil((double)count / (double)pageSize);
        DynamicObject[] dynamicObjects = null;
        timeLogger.check("pageCount === " + pageCount);
        for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
            timeLogger.check("pageIndex === " + pageIndex);
            dynamicObjects = BusinessDataServiceHelper.load((String)"haos_adminorgdetail", (String)"description,adminorgtype,parentorg,name,nameparentorg.id,boid,enable", (QFilter[])filters, (String)"id", (int)pageIndex, (int)pageSize);
            timeLogger.check("orgDetailServiceHelper.query");
            HashSet<Long> orgIds = new HashSet<Long>();
            Stream.of(dynamicObjects).forEach(dynamicObject -> {
                dynamicObject.set("id", (Object)dynamicObject.getLong("boid"));
                orgIds.add(dynamicObject.getLong("boid"));
            });
            timeLogger.check("orgIds size" + orgIds.size());
            Set<Long> baseOrgIds = AdminOrgInitServiceHelper.getBaseOrgInfoMapById(orgIds);
            timeLogger.check("baseOrgIds size" + baseOrgIds.size());
            timeLogger.check("AdminOrgInitServiceHelper.getBaseOrgInfoMapById");
            List<DynamicObject> afterFilterOrgs = Stream.of(dynamicObjects).filter(dy -> !baseOrgIds.contains(dy.getLong("boid"))).collect(Collectors.toList());
            timeLogger.check("afterFilterOrgs size" + afterFilterOrgs.size());
            AdminOrgUnitSyncService.getInstance().syncAddBaseOrgMultiThread(afterFilterOrgs.toArray(new DynamicObject[0]));
            timeLogger.check("AdminOrgUnitSyncService.getInstance().syncAddBaseOrgMultiThread");
        }
    }
}

