/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.task;

import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.hr.haos.business.domain.service.impl.position.StPositionTemplateServiceImpl;
import kd.hr.haos.business.domain.service.impl.staff.StaffRuleConfigServiceImpl;
import kd.hr.haos.business.domain.service.impl.staff.StaffUpgradeServiceImpl;
import kd.hr.haos.business.servicehelper.StaffSpecialRuleTranUpdateDataServiceHelper;
import kd.hr.haos.business.task.ProjectChangeSceneUTableUpgrade;

public class DataUpgradeTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(DataUpgradeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long startTime = System.currentTimeMillis();
        LOG.info("\u6570\u636e\u5347\u7ea7\u4efb\u52a1 \u5f00\u59cb\u6267\u884c:");
        this.executeUpgrade(map);
        this.disableTask();
        LOG.info("\u6570\u636e\u5347\u7ea7\u4efb\u52a1: \u6267\u884c\u5b8c\uff0c\u5171\u8017\u65f6 {} \u6beb\u79d2", (Object)(System.currentTimeMillis() - startTime));
    }

    private void executeUpgrade(Map<String, Object> map) {
        Throwable throwable;
        TXHandle required;
        try (TXHandle required2 = TX.required();){
            try {
                new StaffSpecialRuleTranUpdateDataServiceHelper().upgrade();
                new StaffRuleConfigServiceImpl().saveStaffRuleConfigForTask();
                new ProjectChangeSceneUTableUpgrade().afterExecuteSqlWithResult(null, null, null, null);
            }
            catch (Exception ex) {
                required2.markRollback();
                LOG.error("staff upgrade error", (Throwable)ex);
            }
        }
        Object staffHistoryUpgrade = map.get("staffHistoryUpgrade");
        if (Objects.nonNull(staffHistoryUpgrade) && "1".equals(staffHistoryUpgrade.toString())) {
            required = TX.required();
            throwable = null;
            try {
                try {
                    new StaffUpgradeServiceImpl().entryHisDataUpgrade();
                }
                catch (Exception ex) {
                    required.markRollback();
                    LOG.error("staffhis upgrade error", (Throwable)ex);
                }
            }
            catch (Throwable ex) {
                throwable = ex;
                throw ex;
            }
            finally {
                if (required != null) {
                    if (throwable != null) {
                        try {
                            required.close();
                        }
                        catch (Throwable ex) {
                            throwable.addSuppressed(ex);
                        }
                    } else {
                        required.close();
                    }
                }
            }
        }
        required = TX.required();
        throwable = null;
        try {
            try {
                new StPositionTemplateServiceImpl().addFieldIntoImportTemplate("bsed", "1", "1");
                new StPositionTemplateServiceImpl().addFieldIntoImportTemplate("index", "0", "1");
            }
            catch (Exception ex) {
                required.markRollback();
                LOG.error("addBsedIntoImportTemplate error", (Throwable)ex);
            }
        }
        catch (Throwable ex) {
            throwable = ex;
            throw ex;
        }
        finally {
            if (required != null) {
                if (throwable != null) {
                    try {
                        required.close();
                    }
                    catch (Throwable ex) {
                        throwable.addSuppressed(ex);
                    }
                } else {
                    required.close();
                }
            }
        }
        required = TX.required();
        throwable = null;
        try {
            try {
                new StPositionTemplateServiceImpl().addFieldIntoInitImportTemplate("bsed", ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"DataUpgradeTask_0", (String)"hrmp-haos-business", (Object[])new Object[0]), "1", "1");
                new StPositionTemplateServiceImpl().addFieldIntoInitImportTemplate("index", ResManager.loadKDString((String)"\u6392\u5e8f\u53f7", (String)"DataUpgradeTask_1", (String)"hrmp-haos-business", (Object[])new Object[0]), "0", "1");
            }
            catch (Exception ex) {
                required.markRollback();
                LOG.error("addBsedIntoInitImportTemplate error", (Throwable)ex);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (required != null) {
                if (throwable != null) {
                    try {
                        required.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    required.close();
                }
            }
        }
    }

    private void disableTask() {
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob("35YXRHX9CM3Q");
        scheduleManager.disableSchedule("35YYTT83K25Q");
    }
}

