/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class OrgTeamStructNotPreUpdateTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(OrgTeamStructNotPreUpdateTask.class);
    private static final HRBaseServiceHelper OT_CLASS_HELPER = new HRBaseServiceHelper("haos_otclassify");
    private static final HRBaseServiceHelper STRUCT_PROJECT = new HRBaseServiceHelper("haos_structproject");
    private static final HRBaseServiceHelper OT_STRUCT_HELPER = new HRBaseServiceHelper("haos_adminorgstructure");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try (TXHandle required = TX.required();){
            try {
                LOG.info("begin do OrgTeamStructNotPreUpdateTask execute");
                this.execute();
                this.disableTask();
                LOG.info("do execute OrgTeamStructNotPreUpdateTask success");
            }
            catch (Throwable ex) {
                required.markRollback();
                LOG.error("do execute OrgTeamStructNotPreUpdateTask error", ex);
                LOG.error(ex);
                throw ex;
            }
        }
    }

    private void execute() {
        DynamicObject[] dynamicObjects = OT_CLASS_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("issyspreset", "=", (Object)"0")});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            LOG.info("haos_otclassify issyspreset false size is zero");
            return;
        }
        List allOtClassifyIds = Arrays.stream(dynamicObjects).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        DynamicObject[] allOtStructArray = OT_STRUCT_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("otclassify", "in", allOtClassifyIds)});
        if (allOtStructArray == null || allOtStructArray.length <= 0) {
            LOG.info("allOtStructArray is null or 0");
            return;
        }
        List noStructProjectId = Arrays.stream(allOtStructArray).filter(struct -> struct.getDynamicObject("structproject") == null || struct.getLong("structproject.id") == 0L).collect(Collectors.toList());
        if (noStructProjectId.isEmpty()) {
            LOG.info("has no structproject is null or 0");
            return;
        }
        HashMap<Long, Long> idToOtClassifyId = new HashMap<Long, Long>(dynamicObjects.length);
        ArrayList<DynamicObject> structProjectList = new ArrayList<DynamicObject>(dynamicObjects.length);
        long[] ids = ORM.create().genLongIds("haos_structproject", dynamicObjects.length);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject structProject = STRUCT_PROJECT.generateEmptyDynamicObject();
            idToOtClassifyId.put(dynamicObjects[i].getLong("id"), ids[i]);
            structProject.set("id", (Object)ids[i]);
            structProject.set("org", (Object)OrgUnitServiceHelper.getRootOrgId());
            structProject.set("number", dynamicObjects[i].get("number"));
            structProject.set("name", dynamicObjects[i].get("name"));
            structProject.set("enable", dynamicObjects[i].get("enable"));
            structProject.set("otclassify", (Object)dynamicObjects[i]);
            structProject.set("status", (Object)"C");
            structProject.set("rootorg", (Object)0L);
            structProject.set("roottype", (Object)"0");
            structProjectList.add(structProject);
        }
        STRUCT_PROJECT.save(structProjectList.toArray(new DynamicObject[0]));
        Map<Long, DynamicObject> id2DynMap = structProjectList.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn, (v1, v2) -> v1));
        Arrays.stream(allOtStructArray).forEach(struct -> {
            Long structId = (Long)idToOtClassifyId.get(struct.getLong("otclassify.id"));
            if (structId != null) {
                DynamicObject dynamicObject = (DynamicObject)id2DynMap.get(structId);
                if (dynamicObject != null) {
                    struct.set("structproject", (Object)dynamicObject);
                } else {
                    LOG.info("can not fid struct dynamicobject {}", (Object)structId);
                }
            } else {
                LOG.info("can not find struct id {}", (Object)struct.getString("id"));
            }
        });
        OT_STRUCT_HELPER.update(allOtStructArray);
    }

    private void disableTask() {
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob("3I3JR6LRS9FA");
        scheduleManager.disableSchedule("3I3KOJEOQUQ0");
    }
}

