/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.history.OrgHistoryUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.util.TimeLogger;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class OrgUnitHisSyncTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(OrgUnitHisSyncTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try (TXHandle required = TX.required();){
            try {
                logger.info("begin do OrgUnitHisSyncTask execute");
                this.execute(map);
                logger.info("do execute OrgUnitHisSyncTask success");
            }
            catch (Throwable ex) {
                required.markRollback();
                logger.error("do execute OrgUnitHisSyncTask error", ex);
                logger.error(ex);
                throw ex;
            }
        }
    }

    private void execute(Map<String, Object> map) {
        TimeLogger timeLogger = TimeLogger.create();
        timeLogger.start();
        DynamicObject[] bosOrgHis = BusinessDataServiceHelper.load((String)"bos_org_history", (String)"org", (QFilter[])new QFilter[]{new QFilter("1", "=", (Object)1)});
        timeLogger.check("BusinessDataServiceHelper.load bos_org_history  , org");
        List bosOrgHisIds = Arrays.stream(bosOrgHis).map(his -> his.getLong("org")).collect(Collectors.toList());
        bosOrgHis = null;
        ArrayList<Long> batchList = new ArrayList<Long>();
        QFilter initBatchQFilter = null;
        Object initBatchNumber = map.get("initBatchNumber");
        if (initBatchNumber instanceof String) {
            String[] split;
            String batchNumber = (String)initBatchNumber;
            for (String sp : split = batchNumber.split(";")) {
                batchList.add(Long.parseLong(sp.trim()));
            }
        }
        if (!batchList.isEmpty()) {
            initBatchQFilter = new QFilter("initbatch", "in", batchList);
        }
        QFilter[] filters = new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1"), new QFilter("initstatus", "=", (Object)"2")};
        List<QFilter> qFilters = Arrays.stream(filters).collect(Collectors.toList());
        if (initBatchQFilter != null) {
            qFilters.add(initBatchQFilter);
        }
        filters = qFilters.toArray(new QFilter[0]);
        int pageSize = this.getPageSize();
        timeLogger.check("pageSize ==== " + pageSize);
        HRBaseServiceHelper orgDetailServiceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        int count = orgDetailServiceHelper.count("haos_adminorgdetail", filters);
        if (count == 0) {
            timeLogger.check("totalCount ====  0");
            return;
        }
        int pageCount = (int)Math.ceil((double)count / (double)pageSize);
        DynamicObject[] dynamicObjects = null;
        timeLogger.check("pageCount === " + pageCount);
        for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
            timeLogger.check("pageIndex === " + pageIndex);
            dynamicObjects = BusinessDataServiceHelper.load((String)"haos_adminorgdetail", (String)"description,parentorg,name,nameparentorg.id,boid,enable", (QFilter[])filters, (String)"id", (int)pageIndex, (int)pageSize);
            timeLogger.check("orgDetailServiceHelper.query");
            List afterFilterOrgIds = Stream.of(dynamicObjects).filter(dy -> !bosOrgHisIds.contains(dy.getLong("boid"))).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
            if (afterFilterOrgIds.size() == 0) {
                logger.info("afterFilterOrgIds.size() : 0");
                continue;
            }
            OrgHistoryUtils.save(afterFilterOrgIds);
            timeLogger.check("OrgHistoryUtils.save(afterFilterOrgIds)");
        }
    }

    private int getPageSize() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_odcconfigparam");
        DynamicObject dynamicObject = serviceHelper.queryOne("value", new QFilter[]{new QFilter("number", "=", (Object)"OrgInitPageSIze")});
        return Integer.parseInt(dynamicObject.getString("value"));
    }
}

