/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.task;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.hr.haos.business.domain.repository.adorg.ChangeTranDetailRepository;
import kd.hr.haos.business.servicehelper.ProjectTeamChangeBuHelper;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;

public class ProjectTeamChangeBuTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(ProjectTeamChangeBuTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("ProjectTeamChangeBuTask_start");
        try {
            List<Long> adminOrgBoList = this.findNeedChangeAdminOrg();
            LOGGER.info(String.format("ProjectTeamChangeBuTask_adminOrgBoList:%s", SerializationUtils.toJsonString(adminOrgBoList)));
            ProjectTeamChangeBuHelper projectTeamChangeBuHelper = new ProjectTeamChangeBuHelper();
            adminOrgBoList.forEach(projectTeamChangeBuHelper::update);
            LOGGER.info("ProjectTeamChangeBuTask_biz_end");
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            scheduleManager.disableJob("3MGQ8T2LK3K/");
            scheduleManager.disableSchedule("3MGR82ZX0HX9");
            LOGGER.info("ProjectTeamChangeBuTask_job_disable_end");
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
            throw ex;
        }
        LOGGER.info("ProjectTeamChangeBuTask_all_end");
    }

    private List<Long> findNeedChangeAdminOrg() {
        DynamicObject[] changeTranDetails = ChangeTranDetailRepository.getInstance().queryOriginalArrayBySubScene("targetorg.id", Collections.singleton(ChangeTransactionConstants.SCENE_SUB_ORG));
        return Arrays.stream(changeTranDetails).map(changeTranDetail -> changeTranDetail.getLong("targetorg.id")).distinct().collect(Collectors.toList());
    }
}

