/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.task;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.domain.repository.staff.StaffOrgEmpCountRepository;
import kd.hr.haos.business.service.staff.service.StaffCommonService;

public class SyncOrgEmpCountTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SyncOrgEmpCountTask.class);
    private AdminOrgStructRepository adminOrgStructRepository = AdminOrgStructRepository.getInstance();
    private StaffOrgEmpCountRepository staffOrgEmpCountRepository = StaffOrgEmpCountRepository.getInstance();
    private DynamicObject[] structInfoArr;
    private Map<Long, Integer> orgDirectPersonCount;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("SyncOrgEmpCountTask.param:{}", (Object)JSONObject.toJSONString(map));
        String enable = (String)map.get("enable");
        if ("0".equals(enable)) {
            return;
        }
        String selectFields = "id, parentorg, adminorg";
        this.structInfoArr = this.adminOrgStructRepository.queryEffStructInfo(selectFields);
        if (this.structInfoArr == null || this.structInfoArr.length == 0) {
            logger.info("org id list or admin org info arr is empty!");
            return;
        }
        List structInfoGroupList = Lists.partition(Arrays.asList(this.structInfoArr), (int)3000);
        for (List structInfoList : structInfoGroupList) {
            List<Long> orgIds = structInfoList.stream().filter(dyn -> dyn.getLong("adminorg.id") != 0L).map(dyn -> dyn.getLong("adminorg.id")).collect(Collectors.toList());
            this.orgDirectPersonCount = StaffCommonService.getOrgDirectPersonCount(orgIds, new Date());
            this.buildSaveData(requestContext, orgIds, structInfoList);
        }
    }

    private void buildSaveData(RequestContext requestContext, List<Long> orgIds, List<DynamicObject> structInfoList) {
        DynamicObject[] staffEmpCountInfoArr = this.staffOrgEmpCountRepository.queryStaffEmpCountByOrgId(orgIds);
        Map<Long, DynamicObject> orgIdEmpCountInfoMap = Arrays.stream(staffEmpCountInfoArr).collect(Collectors.toMap(dyn -> dyn.getLong("useorgbo.id"), dyn -> dyn, (v1, v2) -> v1));
        ArrayList saveData = Lists.newArrayListWithExpectedSize((int)structInfoList.size());
        long currUserId = requestContext.getCurrUserId();
        Date currentDate = new Date();
        for (DynamicObject structInfo : structInfoList) {
            long orgId = structInfo.getLong("adminorg.id");
            DynamicObject empCountDyn = orgIdEmpCountInfoMap.get(orgId);
            if (empCountDyn == null) {
                empCountDyn = this.staffOrgEmpCountRepository.generateEmptyDynamicObject();
                empCountDyn.set("id", (Object)ID.genLongId());
                empCountDyn.set("useorgbo", (Object)orgId);
                empCountDyn.set("creator", (Object)currUserId);
                empCountDyn.set("createtime", (Object)currentDate);
            }
            Integer directNum = this.orgDirectPersonCount.get(orgId);
            empCountDyn.set("count", (Object)directNum);
            empCountDyn.set("modifytime", (Object)currentDate);
            empCountDyn.set("modifier", (Object)currUserId);
            saveData.add(empCountDyn);
        }
        logger.info("staff org emp count save data size:{}", (Object)saveData.size());
        this.staffOrgEmpCountRepository.saveStaffEmpCount(saveData.toArray(new DynamicObject[0]));
    }
}

