/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.org.model.OrgTreeModel;

public class AdminOrgTreeListTemplateHelper {
    public static FormShowParameter showAdminOrgTreeFilterDialog(String formId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Floating);
        openStyle.setFloatingDirection(FloatingDirection.RightCenter);
        openStyle.setTargetKey("btntreefilter");
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("140px");
        cssValue.setHeight("50px");
        openStyle.setInlineStyleCss(cssValue);
        formShowParameter.setFormId(formId);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u663e\u793a\u7981\u7528", (String)"AdminOrgTreeListTemplateHelper_0", (String)"hrmp-haos-business", (Object[])new Object[0]));
        return formShowParameter;
    }

    public static List<QFilter> programmeSearchChangeFilter(List<QFilter> customQFilters) {
        QFilter idFilter;
        boolean isSelected = false;
        ArrayList<QFilter> afterChangeFilters = new ArrayList<QFilter>();
        Iterator<QFilter> iterator = customQFilters.iterator();
        List<String> groupProperties = Arrays.asList("groupvision", "groupleader", "groupmission");
        List<String> companyProperties = Arrays.asList("companytype.name", "companytype.id", "industrytype.name", "industrytype.id");
        List<String> departmentProperties = Arrays.asList("departmenttype.name", "departmenttype.id");
        HashSet<Long> adminOrgIdSet = new HashSet<Long>();
        while (iterator.hasNext()) {
            QFilter qFilter = iterator.next();
            if (qFilter == null) continue;
            String property = qFilter.getProperty();
            String formId = "";
            if (groupProperties.contains(property)) {
                formId = AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey();
            } else if (companyProperties.contains(property)) {
                formId = AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey();
            } else if (departmentProperties.contains(property)) {
                formId = AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey();
            }
            if (!StringUtils.isNotEmpty((CharSequence)formId)) continue;
            isSelected = true;
            Set<Long> adminOrgIds = AdminOrgTreeListTemplateHelper.getAdminOrgIds(qFilter, formId);
            if (adminOrgIdSet.isEmpty()) {
                adminOrgIdSet.addAll(adminOrgIds);
            } else {
                adminOrgIdSet.retainAll(adminOrgIds);
            }
            iterator.remove();
        }
        if (!CollectionUtils.isEmpty(adminOrgIdSet)) {
            idFilter = new QFilter("id", "in", adminOrgIdSet);
            afterChangeFilters.add(idFilter);
        }
        if (isSelected && CollectionUtils.isEmpty(afterChangeFilters)) {
            idFilter = new QFilter("id", "=", (Object)-1L);
            afterChangeFilters.add(idFilter);
        }
        return afterChangeFilters;
    }

    private static Set<Long> getAdminOrgIds(QFilter qFilter, String formId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(formId);
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        Object[] dynObjArr = helper.query("adminorg", new QFilter[]{qFilter, statusFilter});
        HashSet<Long> adminOrgIdSet = new HashSet<Long>();
        if (!ObjectUtils.isEmpty((Object[])dynObjArr)) {
            Stream.of(dynObjArr).forEach(dy -> {
                long adminOrgId = dy.getLong("adminorg.id");
                if (adminOrgId > 0L) {
                    adminOrgIdSet.add(adminOrgId);
                }
            });
        }
        return adminOrgIdSet;
    }

    public static void packageData(PackageDataEvent event, Map<Long, DynamicObject> orgGroupDataMap, Map<Long, DynamicObject> orgCompanyDataMap, Map<Long, DynamicObject> departmentDataMap, Map<Long, DynamicObject> structDataMap, Map<Long, DynamicObject> belongcompanyMap, Map<Long, DynamicObject> parentOrgMap, OrgTreeModel orgTreeModel) {
        Long parentOrgId;
        DynamicObject parentOrgDy;
        DynamicObject belongcompanyData;
        DynamicObject structData;
        DynamicObject departmentData;
        DynamicObject orgCompanyData;
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        DynamicObject rowData = event.getRowData();
        Long rowId = orgTreeModel != null && orgTreeModel.isHisTree() ? (Long)rowData.get("boid") : (Long)rowData.get("id");
        DynamicObject orgGroupData = orgGroupDataMap.get(rowId);
        if (null != orgGroupData) {
            String groupVision = orgGroupData.getString("groupvision");
            String groupLeader = orgGroupData.getString("groupleader");
            String groupmission = orgGroupData.getString("groupmission");
            if ("groupvision".equals(columnDesc.getFieldKey()) && !StringUtils.isEmpty((CharSequence)groupVision)) {
                event.setFormatValue((Object)groupVision);
            }
            if ("groupleader".equals(columnDesc.getFieldKey()) && !StringUtils.isEmpty((CharSequence)groupLeader)) {
                event.setFormatValue((Object)groupLeader);
            }
            if ("groupmission".equals(columnDesc.getFieldKey()) && !StringUtils.isEmpty((CharSequence)groupmission)) {
                event.setFormatValue((Object)groupmission);
            }
        }
        if (null != (orgCompanyData = orgCompanyDataMap.get(rowId))) {
            String companyType = orgCompanyData.getString("companytype.name");
            String industryType = orgCompanyData.getString("industrytype.name");
            if ("companytype.name".equals(columnDesc.getFieldKey()) && companyType != null) {
                event.setFormatValue((Object)companyType);
            }
            if ("industrytype.name".equals(columnDesc.getFieldKey()) && industryType != null) {
                event.setFormatValue((Object)industryType);
            }
        }
        if (null != (departmentData = departmentDataMap.get(rowId))) {
            String departmentType = departmentData.getString("departmenttype.name");
            if ("departmenttype.name".equals(columnDesc.getFieldKey()) && departmentType != null) {
                event.setFormatValue((Object)departmentType);
            }
        }
        if (null != (structData = structDataMap.get(rowId))) {
            String parentName;
            int level = structData.getInt("level");
            if ("level".equals(columnDesc.getFieldKey())) {
                event.setFormatValue((Object)level);
            }
            if ("struct_parent_org.name".equals(columnDesc.getFieldKey()) && StringUtils.isNotEmpty((CharSequence)(parentName = structData.getString("parentorg.name")))) {
                event.setFormatValue((Object)parentName);
            }
        }
        if (null != (belongcompanyData = belongcompanyMap.get(rowId))) {
            String belongcompanyName = belongcompanyData.getString("name");
            if ("belongcompany.name".equals(columnDesc.getFieldKey()) && belongcompanyName != null) {
                event.setFormatValue((Object)belongcompanyName);
            }
        }
        if (rowData.containsProperty("parentorg") && null != (parentOrgDy = parentOrgMap.get(parentOrgId = Long.valueOf(rowData.getDynamicObject("parentorg") != null ? rowData.getLong("parentorg.boid") : 0L)))) {
            String parentOrgName = parentOrgDy.getString("name");
            if ("parentorg.name".equals(columnDesc.getFieldKey()) && parentOrgName != null) {
                event.setFormatValue((Object)parentOrgName);
            }
        }
    }
}

