/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.util;

import java.util.List;
import java.util.Locale;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.haos.business.util.CycleDetector;
import kd.hr.haos.business.util.DirectedGraph;

public class DfsCycleCheckServiceHelper<T> {
    private static final Log logger = LogFactory.getLog(DfsCycleCheckServiceHelper.class);
    private DirectedGraph<T> directedGraph = new DirectedGraph();
    private CycleDetector<T> cycleDetector = new CycleDetector<T>(this.directedGraph);

    public void addLine(T startNode, T endNode) {
        this.directedGraph.addEdge(startNode, endNode);
    }

    public List<List<T>> find() {
        logger.info(String.format(Locale.ROOT, "DfsCycleCheckServiceHelper start find %s", System.currentTimeMillis()));
        this.cycleDetector.containsCycle();
        List<List<T>> verticesInCycles = this.cycleDetector.getVerticesInCycles();
        logger.info(String.format(Locale.ROOT, "DfsCycleCheckServiceHelper end find %s", System.currentTimeMillis()));
        return verticesInCycles;
    }

    public boolean containsCycle() {
        return this.cycleDetector.containsCycle();
    }
}

