/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.util.CollectionUtils;

public class DynamicObjectLogHelper {
    public static List<Map<String, String>> convertDynamicObject2Map(List<DynamicObject> dynamicObjectList, String ... fields) {
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return new ArrayList<Map<String, String>>();
        }
        List<DynamicProperty> dynamicProperties = DynamicObjectLogHelper.string2Property(dynamicObjectList.get(0).getDynamicObjectType(), fields);
        return dynamicObjectList.stream().map(dy -> DynamicObjectLogHelper.convertDynamicObject2Map(dy, dynamicProperties)).collect(Collectors.toList());
    }

    public static Map<String, String> convertDynamicObject2Map(DynamicObject dynamicObject, String ... fields) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (dynamicObject == null) {
            return result;
        }
        List<DynamicProperty> dynamicProperties = DynamicObjectLogHelper.string2Property(dynamicObject.getDynamicObjectType(), fields);
        return DynamicObjectLogHelper.convertDynamicObject2Map(dynamicObject, dynamicProperties);
    }

    private static Map<String, String> convertDynamicObject2Map(DynamicObject dynamicObject, List<DynamicProperty> dynamicProperties) {
        if (dynamicObject == null) {
            return Collections.emptyMap();
        }
        return dynamicProperties.stream().collect(Collectors.toMap(DynamicProperty::getName, property -> {
            Object value = DynamicObjectLogHelper.convertValue(dynamicObject, property);
            return value == null ? "" : value.toString();
        }));
    }

    private static Object convertValue(DynamicObject dynamicObject, DynamicProperty property) {
        if (property instanceof BasedataProp) {
            return DynamicObjectLogHelper.smartGetId(property.getValueFast((Object)dynamicObject));
        }
        if (property instanceof EntryProp) {
            return "not supported";
        }
        if (property instanceof MulBasedataProp) {
            return "not supported";
        }
        return property.getValueFast((Object)dynamicObject);
    }

    public static long smartGetId(Object obj) {
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getLong("id");
        }
        if (obj instanceof String) {
            return Long.parseLong((String)obj);
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return 0L;
    }

    private static List<DynamicProperty> string2Property(DynamicObjectType dynamicObjectType, String ... fields) {
        if (fields != null && fields.length != 0) {
            return Arrays.stream(fields).distinct().map(arg_0 -> ((DynamicObjectType)dynamicObjectType).getProperty(arg_0)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

