/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;
import kd.hr.haos.common.util.HaosOrgUnitServiceHelper;

public class PatternUtil {
    private Pattern dynamicSeparatorRegex;
    private static final char[] SPECIAL_SEPARATORS = new char[]{'!', '_', '\\'};
    private static final char[] PLATFORM_SPECIAL_SEPARATORS = new char[]{'\\'};
    private static final Pattern SPECIAL_SEPARATORS_REGEX;

    public PatternUtil() {
        this.createDynamicPattern();
    }

    private void createDynamicPattern() {
        String dynamicSeparator = HaosOrgUnitServiceHelper.getFullNameSep();
        if (dynamicSeparator != null && dynamicSeparator.length() != 0) {
            HashSet<Character> dynamicSeparatorSet = new HashSet<Character>(16);
            char platFormSeparator = dynamicSeparator.charAt(0);
            dynamicSeparatorSet.add(Character.valueOf(platFormSeparator));
            for (char specialSeparator : PLATFORM_SPECIAL_SEPARATORS) {
                dynamicSeparatorSet.add(Character.valueOf(specialSeparator));
            }
            ArrayList dynamicSeparatorList = new ArrayList(dynamicSeparatorSet);
            StringBuilder stringBuffer = new StringBuilder();
            for (int i = 0; i < dynamicSeparatorList.size(); ++i) {
                stringBuffer.append("\\").append(dynamicSeparatorList.get(i)).append("+");
                if (i >= dynamicSeparatorList.size() - 1) continue;
                stringBuffer.append("|");
            }
            this.dynamicSeparatorRegex = Pattern.compile(stringBuffer.toString());
        }
    }

    public static boolean valideName(String orgName) {
        Matcher matcher = SPECIAL_SEPARATORS_REGEX.matcher(orgName);
        return matcher.find();
    }

    public boolean validName4Config(String orgName) {
        if (orgName != null) {
            return this.dynamicSeparatorRegex.matcher(orgName).find();
        }
        return false;
    }

    public static boolean checkStringIsPositiveNum(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        return str.matches("^[0-9]*[1-9][0-9]*$");
    }

    static {
        StringBuilder stringBuffer = new StringBuilder();
        for (int i = 0; i < SPECIAL_SEPARATORS.length; ++i) {
            stringBuffer.append("\\").append(SPECIAL_SEPARATORS[i]).append("+");
            if (i >= SPECIAL_SEPARATORS.length - 1) continue;
            stringBuffer.append("|");
        }
        SPECIAL_SEPARATORS_REGEX = Pattern.compile(stringBuffer.toString());
    }
}

