/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.util;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterEvaluator;

public class QFilterEval
implements QFilterEvaluator {
    private Map<String, Object> defValMap;

    public QFilterEval(Map<String, Object> defValMap) {
        this.defValMap = defValMap;
    }

    public boolean eval(QFilter fs) {
        if (fs != null && this.defValMap.containsKey(fs.getProperty())) {
            boolean isTrue = this.getPrediction(fs, this.defValMap.get(fs.getProperty()));
            List nests = fs.getNests(false);
            for (QFilter.QFilterNest nest : nests) {
                QFilter nextFilter = nest.getFilter();
                boolean isAnd = nest.isAnd();
                if (isAnd) {
                    isTrue &= this.getPrediction(nextFilter, this.defValMap.get(nextFilter.getProperty()));
                    continue;
                }
                isTrue |= this.getPrediction(nextFilter, this.defValMap.get(nextFilter.getProperty()));
            }
            return isTrue;
        }
        return false;
    }

    private boolean getPrediction(QFilter fs, Object val) {
        String cp;
        switch (cp = fs.getCP().toLowerCase()) {
            case "is not null": {
                return val != null;
            }
            case "is null": {
                return val == null;
            }
        }
        if (val == null) {
            this.throwNotSupportException(fs, val);
        }
        switch (cp) {
            case "=": {
                return this.isEquals(fs, val);
            }
            case "!=": 
            case "<>": {
                return !this.isEquals(fs, val);
            }
            case "in": {
                return this.isIn(fs, val);
            }
            case "not in": {
                return !this.isIn(fs, val);
            }
            case ">=": {
                return !this.isLessThan(fs, val);
            }
            case ">": {
                return !this.isLessEquals(fs, val);
            }
            case "<=": {
                return this.isLessEquals(fs, val);
            }
            case "<": {
                return this.isLessThan(fs, val);
            }
            case "like": {
                return this.isLike(fs, val);
            }
            case "not like": {
                return !this.isLike(fs, val);
            }
            case "exists": {
                return this.isExists(fs, val);
            }
            case "not exists": {
                return this.isNotExists(fs, val);
            }
            case "ftlike": {
                return this.isFtlike(fs, val);
            }
            case "match": {
                return this.isMatch(fs, val);
            }
        }
        return this.throwNotSupportException(fs, val);
    }

    private boolean isLike(QFilter fs, Object val) {
        if (!(val instanceof String)) {
            return this.throwNotSupportException(fs, val);
        }
        return ((String)val).contains(fs.getValue().toString());
    }

    private boolean isLessThan(QFilter fs, Object val) {
        if (val instanceof Date) {
            return ((Date)val).getTime() < ((Date)fs.getValue()).getTime();
        }
        if (val instanceof Number) {
            return new BigDecimal(val.toString()).compareTo(new BigDecimal(fs.getValue().toString())) < 0;
        }
        return this.throwNotSupportException(fs, val);
    }

    private boolean isLessEquals(QFilter fs, Object val) {
        if (val instanceof Date) {
            return ((Date)val).getTime() <= ((Date)fs.getValue()).getTime();
        }
        if (val instanceof Number) {
            return new BigDecimal(val.toString()).compareTo(new BigDecimal(fs.getValue().toString())) <= 0;
        }
        return this.throwNotSupportException(fs, val);
    }

    private boolean throwNotSupportException(QFilter fs, Object val) {
        throw new KDBizException(" QFilter prediction is not supported: QFilter.cp=" + fs + ",val=" + val + ". ");
    }

    private boolean isMatch(QFilter fs, Object val) {
        return this.throwNotSupportException(fs, val);
    }

    private boolean isFtlike(QFilter fs, Object val) {
        return this.throwNotSupportException(fs, val);
    }

    private boolean isExists(QFilter fs, Object val) {
        this.throwNotSupportException(fs, val);
        return true;
    }

    private boolean isNotExists(QFilter fs, Object val) {
        this.throwNotSupportException(fs, val);
        return true;
    }

    private boolean isIn(QFilter fs, Object val) {
        Object vals = fs.getValue();
        if (vals.getClass().isArray()) {
            Object[] arr;
            for (Object obj : arr = (Object[])vals) {
                if (!this.isEquals(fs, val, obj)) continue;
                return true;
            }
            return false;
        }
        if (vals instanceof Iterable) {
            for (Object obj : (Iterable)vals) {
                if (!this.isEquals(fs, val, obj)) continue;
                return true;
            }
            return false;
        }
        return this.throwNotSupportException(fs, val);
    }

    private boolean isEquals(QFilter fs, Object srcObj, Object target) {
        if (srcObj instanceof Date) {
            return ((Date)srcObj).getTime() == ((Date)target).getTime();
        }
        if (srcObj instanceof Number) {
            return new BigDecimal(srcObj.toString()).compareTo(new BigDecimal(target.toString())) == 0;
        }
        if (srcObj instanceof String) {
            return srcObj.equals(target);
        }
        return this.throwNotSupportException(fs, srcObj);
    }

    private boolean isEquals(QFilter fs, Object val) {
        return this.isEquals(fs, val, fs.getValue());
    }
}

