/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class SynOrgChangeToOtherDomainUtil {
    private static final Log logger = LogFactory.getLog(SynOrgChangeToOtherDomainUtil.class);
    private static final String HAOS_SYNORGCHANGELOG = "haos_synorgchangelog";
    private static final HRBaseServiceHelper HAOS_SYNORGCHANGELOG_HELPER = new HRBaseServiceHelper("haos_synorgchangelog");
    private static final String SYNSTATUS = "synstatus";
    private static final String SYNTYPE = "syntype";
    private static final String ERRORINFO = "errorinfo";
    private static final String ADMINORGTEXT = "adminorgtext";
    private static final String COMPANY = "company";
    private static final String EFFECTDATE = "effectdate";
    private static final String CLOUDNUMBER = "cloudnumber";
    private static final String APPNUMBER = "appnumber";
    private static final String SERVICENAME = "servicename";
    private static final String METHODNAME = "methodname";
    private static final Log LOG = LogFactory.getLog(SynOrgChangeToOtherDomainUtil.class);
    private static ArrayList<Map<String, String>> classList = new ArrayList();

    public static void synOrgChange(List<DynamicObject> orgDyList) {
        if (orgDyList == null || orgDyList.size() == 0) {
            return;
        }
        DynamicObject firstDynObj = orgDyList.get(0);
        Date effectDate = firstDynObj.getDate("bsed");
        Map<Long, Long> orglistToMap = SynOrgChangeToOtherDomainUtil.orglistToMap(orgDyList);
        if (orglistToMap != null && orglistToMap.size() > 0) {
            List<Map<Long, Long>> groupList = SynOrgChangeToOtherDomainUtil.mapGroupByValue(orglistToMap);
            groupList.forEach(groupMap -> {
                Long companyId = SynOrgChangeToOtherDomainUtil.getFirstValue(groupMap);
                HashSet<Long> orgBoIdSet = new HashSet<Long>(groupMap.size());
                for (Long key : groupMap.keySet()) {
                    orgBoIdSet.add(key);
                }
                try (TXHandle required = TX.requiresNew();){
                    try {
                        SynOrgChangeToOtherDomainUtil.synOrgChangeToOtherDomain(classList.get(0), orgBoIdSet, companyId, effectDate);
                        required.commit();
                    }
                    catch (Exception ex) {
                        required.markRollback();
                        LOG.error("IHSPMCompanyChangeService.companyChangeSync()", (Throwable)ex);
                    }
                }
                required = TX.requiresNew();
                var5_5 = null;
                try {
                    try {
                        SynOrgChangeToOtherDomainUtil.synOrgChangeToOtherDomain(classList.get(1), orgBoIdSet, companyId, effectDate);
                        required.commit();
                    }
                    catch (Exception ex) {
                        required.markRollback();
                        LOG.error("IPersonAttFileService.modifyCompanyBoId()", (Throwable)ex);
                    }
                }
                catch (Throwable ex) {
                    var5_5 = ex;
                    throw ex;
                }
                finally {
                    if (required != null) {
                        if (var5_5 != null) {
                            try {
                                required.close();
                            }
                            catch (Throwable ex) {
                                var5_5.addSuppressed(ex);
                            }
                        } else {
                            required.close();
                        }
                    }
                }
                required = TX.requiresNew();
                var5_5 = null;
                try {
                    try {
                        SynOrgChangeToOtherDomainUtil.synOrgChangeToOtherDomain(classList.get(2), orgBoIdSet, companyId, effectDate);
                        required.commit();
                    }
                    catch (Exception ex) {
                        required.markRollback();
                        LOG.error("IPersonService.companyChangeSync()", (Throwable)ex);
                    }
                }
                catch (Throwable throwable) {
                    var5_5 = throwable;
                    throw throwable;
                }
                finally {
                    if (required != null) {
                        if (var5_5 != null) {
                            try {
                                required.close();
                            }
                            catch (Throwable throwable) {
                                var5_5.addSuppressed(throwable);
                            }
                        } else {
                            required.close();
                        }
                    }
                }
            });
        }
    }

    public static void synOrgChangeToOtherDomain(Map<String, String> classMap, HashSet<Long> orgBoIdSet, Long companyId, Date effectDate) {
        try {
            Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)classMap.get("cloud"), (String)classMap.get("app"), (String)classMap.get("serviceName"), (String)classMap.get("methodName"), (Object[])new Object[]{orgBoIdSet, companyId, effectDate});
            String errorMsg = "";
            if (resultMap.get("isSuccess") != null && resultMap.get("isSuccess").toString().equals("false")) {
                if (resultMap.get("errorMsg") != null && !resultMap.get("errorMsg").equals("")) {
                    errorMsg = (String)resultMap.get("errorMsg");
                }
                SynOrgChangeToOtherDomainUtil.addSynInfoLog(false, classMap, orgBoIdSet, companyId, effectDate, errorMsg);
            } else {
                SynOrgChangeToOtherDomainUtil.addSynInfoLog(true, classMap, orgBoIdSet, companyId, effectDate, errorMsg);
            }
        }
        catch (Exception exp) {
            logger.error((Throwable)exp);
            logger.error("SynOrgChangeToOtherDomain error ,{}", (Object)exp.getMessage());
            String errorMsg = "traceId:" + TraceIdUtil.getCurrentTraceIdString() + ";";
            if (exp != null && (errorMsg = errorMsg + exp.getMessage()).length() > 1000) {
                errorMsg = errorMsg.substring(0, 1000);
            }
            SynOrgChangeToOtherDomainUtil.addSynInfoLog(false, classMap, orgBoIdSet, companyId, effectDate, errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSynInfoLog(boolean isSuccess, Map<String, String> classMap, HashSet<Long> orgBoIdSet, Long companyId, Date effectDate, String errorMsg) {
        try (TXHandle txHandle = TX.requiresNew();){
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)HAOS_SYNORGCHANGELOG);
            DynamicObject dynObj = new DynamicObject((DynamicObjectType)dataEntityType);
            dynObj.set(SYNTYPE, (Object)Character.valueOf('1'));
            dynObj.set(ADMINORGTEXT, (Object)SynOrgChangeToOtherDomainUtil.setToString(orgBoIdSet));
            DynamicObject[] companyDynObjs = SynOrgChangeToOtherDomainUtil.queryOrgInfoByBoId("id,boid,name,number", Collections.singletonList(companyId));
            if (companyDynObjs.length > 0) {
                dynObj.set(COMPANY, (Object)companyDynObjs[0]);
            }
            dynObj.set(EFFECTDATE, (Object)effectDate);
            dynObj.set(ERRORINFO, (Object)errorMsg);
            dynObj.set(CLOUDNUMBER, (Object)classMap.get("cloud"));
            dynObj.set(APPNUMBER, (Object)classMap.get("app"));
            dynObj.set(SERVICENAME, (Object)classMap.get("serviceName"));
            dynObj.set(METHODNAME, (Object)classMap.get("methodName"));
            if (isSuccess) {
                dynObj.set(SYNSTATUS, (Object)Character.valueOf('1'));
            } else {
                dynObj.set(SYNSTATUS, (Object)Character.valueOf('2'));
            }
            HAOS_SYNORGCHANGELOG_HELPER.saveOne(dynObj);
        }
    }

    private static void updateSynInfoLog(DynamicObject synOrgLogObj, boolean isSuccess, String errorMsg) {
        if (isSuccess) {
            synOrgLogObj.set(SYNSTATUS, (Object)"1");
            synOrgLogObj.set(ERRORINFO, (Object)"");
        } else {
            synOrgLogObj.set(SYNSTATUS, (Object)"2");
            synOrgLogObj.set(ERRORINFO, (Object)errorMsg);
        }
        HAOS_SYNORGCHANGELOG_HELPER.saveOne(synOrgLogObj);
    }

    public static boolean retryByLog(DynamicObject synOrgLogObj) {
        boolean isSuccess = true;
        String cloudId = (String)synOrgLogObj.get(CLOUDNUMBER);
        String appId = (String)synOrgLogObj.get(APPNUMBER);
        String serviceName = (String)synOrgLogObj.get(SERVICENAME);
        String methodName = (String)synOrgLogObj.get(METHODNAME);
        Date effectdate = (Date)synOrgLogObj.get(EFFECTDATE);
        Long companyId = (Long)synOrgLogObj.get("company.id");
        String adminorgtext = (String)synOrgLogObj.get(ADMINORGTEXT);
        try {
            Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{SynOrgChangeToOtherDomainUtil.stringToSet(adminorgtext), companyId, effectdate});
            String errorMsg = "";
            if (resultMap.get("isSuccess") != null && resultMap.get("isSuccess").toString().equals("false")) {
                if (resultMap.get("errorMsg") != null && !resultMap.get("errorMsg").equals("")) {
                    errorMsg = (String)resultMap.get("errorMsg");
                }
                SynOrgChangeToOtherDomainUtil.updateSynInfoLog(synOrgLogObj, false, errorMsg);
                isSuccess = false;
            } else {
                SynOrgChangeToOtherDomainUtil.updateSynInfoLog(synOrgLogObj, true, errorMsg);
            }
        }
        catch (Exception exp) {
            logger.error((Throwable)exp);
            logger.error("SynOrgChangeToOtherDomain error ,{}", (Object)exp.getMessage());
            String errorMsg = "traceId:" + TraceIdUtil.getCurrentTraceIdString() + ";";
            if (exp != null && (errorMsg = errorMsg + exp.getMessage()).length() > 1000) {
                errorMsg = errorMsg.substring(0, 1000);
            }
            SynOrgChangeToOtherDomainUtil.updateSynInfoLog(synOrgLogObj, false, errorMsg);
            isSuccess = false;
        }
        return isSuccess;
    }

    public static DynamicObject querySynOrgChangeLog(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(HAOS_SYNORGCHANGELOG);
        QFilter filter = new QFilter("id", "in", (Object)id);
        return serviceHelper.loadDynamicObject(new QFilter[]{filter});
    }

    private static DynamicObject[] queryOrgInfoByBoId(String selectFields, List<Long> boIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
        filter.and("boid", "in", boIds);
        return serviceHelper.query(selectFields, new QFilter[]{filter});
    }

    private static DynamicObject[] queryOrgBoIdInfoById(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter filter = new QFilter("id", "in", ids);
        return serviceHelper.query("id, boid", new QFilter[]{filter});
    }

    private static HashSet<Long> stringToSet(String stringParam) {
        if (stringParam.equals("")) {
            return null;
        }
        String[] arrOfStr = stringParam.split(",");
        HashSet<Long> set = new HashSet<Long>(arrOfStr.length);
        for (String str : arrOfStr) {
            set.add(Long.parseLong(str));
        }
        return set;
    }

    private static String setToString(HashSet<Long> setParam) {
        if (setParam.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Long id : setParam) {
            sb.append(String.valueOf(id)).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private static Map<Long, Long> orglistToMap(List<DynamicObject> orgDyList) {
        HashMap<Long, Long> orgToCompanyMap = new HashMap<Long, Long>();
        for (int i = 0; i < orgDyList.size(); ++i) {
            DynamicObject orgDynObj = orgDyList.get(i);
            if (HRStringUtils.isEmpty((String)orgDynObj.getString("companychangetype")) || HRStringUtils.equals((String)orgDynObj.getString("companychangetype"), (String)AdminOrgConstants.CompanyChangeType.NO_CHANGE.code()) || orgDynObj.get("adminorgboid") == null || (Long)orgDynObj.get("adminorgboid") == 0L || orgToCompanyMap.containsKey(orgDynObj.get("adminorgboid")) || orgDynObj.get("belongcompany.id") == null || (Long)orgDynObj.get("belongcompany.id") == 0L) continue;
            orgToCompanyMap.put((Long)orgDynObj.get("adminorgboid"), (Long)orgDynObj.get("belongcompany.id"));
        }
        if (orgToCompanyMap.size() > 0) {
            ArrayList<Long> companyIdList = new ArrayList<Long>(orgToCompanyMap.values());
            DynamicObject[] companyDyns = SynOrgChangeToOtherDomainUtil.queryOrgBoIdInfoById(companyIdList);
            Map<Long, Long> companyIdToBoIdMap = Arrays.stream(companyDyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("boid")));
            orgToCompanyMap.forEach((adminorgboid, companyid) -> orgToCompanyMap.put((Long)adminorgboid, (Long)companyIdToBoIdMap.get(companyid)));
        }
        return orgToCompanyMap;
    }

    private static List<Map<Long, Long>> mapGroupByValue(Map<Long, Long> map) {
        Collection<Long> values = map.values();
        HashSet<Long> set = new HashSet<Long>(map.size());
        set.addAll(values);
        ArrayList<Map<Long, Long>> resultList = new ArrayList<Map<Long, Long>>(map.size());
        for (Long value : set) {
            HashMap<Long, Long> tempMap = new HashMap<Long, Long>(map.size());
            for (Map.Entry<Long, Long> entry : map.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null || !value.equals(entry.getValue())) continue;
                tempMap.put(entry.getKey(), entry.getValue());
            }
            resultList.add(tempMap);
        }
        return resultList;
    }

    private static Long getFirstValue(Map<Long, Long> map) {
        Set<Long> keys = map.keySet();
        ArrayList<Long> keyList = new ArrayList<Long>(keys);
        Long firstKey = (Long)keyList.get(0);
        return map.get(firstKey);
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("cloud", "hr");
        map.put("app", "hspm");
        map.put("serviceName", "IHSPMCompanyChangeService");
        map.put("methodName", "companyChangeSync");
        classList.add(map);
        map = new HashMap();
        map.put("cloud", "wtc");
        map.put("app", "wtp");
        map.put("serviceName", "IPersonAttFileService");
        map.put("methodName", "modifyCompanyBoId");
        classList.add(map);
        map = new HashMap();
        map.put("cloud", "swc");
        map.put("app", "hsas");
        map.put("serviceName", "IPersonService");
        map.put("methodName", "companyChangeSync");
        classList.add(map);
    }
}

