/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.util.cascade;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.hr.haos.common.model.cascade.CycleCheckBo;
import kd.hr.haos.common.model.cascade.CycleCheckResult;
import kd.hr.haos.common.util.LocalDateRange;

public class CycleCheckTree {
    private DateRangeNode virtualRoot;
    Map<Long, List<DateRangeNode>> boVsNodeList;
    private CycleCheckResult cycleCheckResult;
    private List<Long> startBoLis;
    private Map<CycleCheckBo, Boolean> boVsUnvisited;

    public static CycleCheckTree create(List<? extends CycleCheckBo> CycleCheckBoList) {
        return new CycleCheckTree(CycleCheckBoList);
    }

    public void traverse() {
        this.virtualRoot.childList.forEach(this::dfs);
    }

    public void traverse(List<Long> startBoList) {
        this.startBoLis = startBoList;
        startBoList.stream().map(bo -> this.boVsNodeList.getOrDefault(bo, Collections.emptyList())).flatMap(Collection::stream).forEach(this::dfs);
    }

    private void dfs(DateRangeNode dateRangeNode) {
        ArrayDeque<List<Object>> stack = new ArrayDeque<List<Object>>();
        ArrayDeque<DateRangeNode> checkStack = new ArrayDeque<DateRangeNode>();
        DateRangeNode start = new DateRangeNode(dateRangeNode.val, dateRangeNode.childList, dateRangeNode.effectRange);
        ArrayList<DateRangeNode> startList = new ArrayList<DateRangeNode>();
        startList.add(start);
        stack.push(startList);
        while (!stack.isEmpty()) {
            List<DateRangeNode> nextRelList;
            DateRangeNode pop = (DateRangeNode)((List)stack.peek()).remove(0);
            checkStack.push(pop);
            this.boVsUnvisited.computeIfPresent(pop.val, (node, val) -> false);
            if (((List)stack.peek()).size() == 0) {
                stack.pop();
            }
            if ((nextRelList = this.getNextAndFilteredAndIntersected(pop)).size() != 0) {
                stack.push(nextRelList);
                if (this.check(checkStack)) continue;
                break;
            }
            checkStack.pop();
        }
    }

    private boolean check(ArrayDeque<DateRangeNode> checkStack) {
        Map<Long, List<DateRangeNode>> boVsCount = checkStack.stream().collect(Collectors.groupingBy(DateRangeNode::getBo));
        Optional<List> fail = boVsCount.values().stream().filter(nodeList -> nodeList.size() > 1).findAny();
        if (fail.isPresent()) {
            List dateRangeNodes = fail.get();
            this.cycleCheckResult.setCycled(true);
            this.cycleCheckResult.setStartBo(((DateRangeNode)dateRangeNodes.get(0)).getBo());
            Optional<LocalDateRange> min = dateRangeNodes.stream().map(node -> ((DateRangeNode)node).effectRange).min((dRange, dRange2) -> dRange.isBefore(dRange2) ? -1 : 1);
            this.cycleCheckResult.setEffectRange(min.get());
            return false;
        }
        return true;
    }

    private List<DateRangeNode> getNextAndFilteredAndIntersected(DateRangeNode pop) {
        LocalDateRange curDRange = pop.effectRange;
        return pop.childList.stream().filter(node -> ((DateRangeNode)node).effectRange.overlaps(curDRange)).map(node -> new DateRangeNode(((DateRangeNode)node).val, ((DateRangeNode)node).childList, ((DateRangeNode)node).effectRange.intersection(curDRange))).collect(Collectors.toList());
    }

    public CycleCheckResult getResult() {
        if (!this.cycleCheckResult.isCycled()) {
            HashSet<Long> startBoSet = new HashSet<Long>(this.startBoLis);
            Optional<Long> curBatchCheck = this.boVsUnvisited.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).map(CycleCheckBo::getBo).filter(startBoSet::contains).findAny();
            if (curBatchCheck.isPresent()) {
                Optional<CycleCheckBo> any = this.boVsUnvisited.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).findAny();
                any.ifPresent(cycleCheckBo -> {
                    this.cycleCheckResult = new CycleCheckResult(true);
                    this.cycleCheckResult.setStartBo(cycleCheckBo.getBo());
                    this.cycleCheckResult.setEffectRange(cycleCheckBo.getEffectRange());
                });
            }
        }
        return this.cycleCheckResult;
    }

    private void setResult(long bo, LocalDateRange newSearchDateRange) {
        this.cycleCheckResult = new CycleCheckResult(true);
        this.cycleCheckResult.setStartBo(bo);
        this.cycleCheckResult.setEffectRange(newSearchDateRange);
    }

    private CycleCheckTree(List<? extends CycleCheckBo> CycleCheckBoList) {
        this.init(CycleCheckBoList);
        this.buildTree();
    }

    private void init(List<? extends CycleCheckBo> CycleCheckBoList) {
        this.virtualRoot = CycleCheckTree.getVirtualRoot();
        this.boVsNodeList = CycleCheckBoList.stream().collect(Collectors.groupingBy(CycleCheckBo::getBo, Collectors.mapping(cycleCheckBo -> new DateRangeNode((CycleCheckBo)cycleCheckBo, cycleCheckBo.getEffectRange()), Collectors.toList())));
        this.cycleCheckResult = new CycleCheckResult(false);
        this.boVsUnvisited = this.boVsNodeList.values().stream().flatMap(Collection::stream).collect(Collectors.toMap(node -> ((DateRangeNode)node).val, node -> true));
    }

    private void buildTree() {
        List<DateRangeNode> defaultParentList = Collections.singletonList(this.virtualRoot);
        this.boVsNodeList.values().forEach(nodeList -> nodeList.forEach(node -> {
            List<DateRangeNode> parentNodeList = this.boVsNodeList.getOrDefault(node.getParentBo(), defaultParentList);
            AtomicBoolean noRealRoot = new AtomicBoolean(true);
            parentNodeList.forEach(parentNode -> {
                if (((DateRangeNode)parentNode).effectRange.overlaps(((DateRangeNode)node).effectRange)) {
                    ((DateRangeNode)parentNode).childList.add(node);
                    noRealRoot.set(false);
                }
            });
            if (noRealRoot.get()) {
                this.virtualRoot.childList.add(node);
            }
        }));
    }

    private static DateRangeNode getVirtualRoot() {
        return new DateRangeNode(new CycleCheckBo(){

            public long getBo() {
                return -1L;
            }

            public long getParentBo() {
                return 0L;
            }
        }, LocalDateRange.ALL);
    }

    private static class DateRangeNode {
        private CycleCheckBo val;
        private List<DateRangeNode> childList;
        private LocalDateRange effectRange;

        public DateRangeNode(CycleCheckBo val, LocalDateRange effectRange) {
            this.val = val;
            this.effectRange = effectRange;
            this.childList = new ArrayList<DateRangeNode>();
        }

        public DateRangeNode(CycleCheckBo val, List<DateRangeNode> childList, LocalDateRange effectRange) {
            this.val = val;
            this.childList = childList;
            this.effectRange = effectRange;
        }

        public long getBo() {
            return this.val.getBo();
        }

        public long getParentBo() {
            return this.val.getParentBo();
        }

        public String toString() {
            return "DateRangeNode{bo=" + this.getBo() + ", parentBo=" + this.getParentBo() + ", effectRange=" + this.effectRange + '}';
        }
    }
}

