/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.util.cascade;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.hr.haos.common.model.cascade.CascadeBo;
import kd.hr.haos.common.model.cascade.CascadeResult;
import kd.hr.haos.common.model.cascade.FollowModel;
import kd.hr.haos.common.model.cascade.PartBo;
import kd.hr.haos.common.util.LocalDateRange;

public class MultiVersionTree {
    private DateRangeNode virtualRoot;
    Map<Long, List<DateRangeNode>> boVsNodeList;
    private CascadeResult cascadeResult = new CascadeResult();

    public static MultiVersionTree create(List<? extends CascadeBo> cascadeBoList) {
        return new MultiVersionTree(cascadeBoList);
    }

    public void traverse() {
        ArrayDeque<SearchNode> queue = new ArrayDeque<SearchNode>();
        this.virtualRoot.childList.stream().map(node -> new SearchNode((DateRangeNode)node, ((DateRangeNode)node).effectRange)).forEach(queue::offer);
        while (!queue.isEmpty()) {
            SearchNode parentSearchNode = (SearchNode)queue.poll();
            for (DateRangeNode childNode : parentSearchNode.getChildList()) {
                if (!childNode.effectRange.overlaps(parentSearchNode.searchRange)) continue;
                LocalDateRange newSearchDateRange = childNode.effectRange.intersection(parentSearchNode.searchRange);
                CascadeBo clone = this.followParent(parentSearchNode.node.val, childNode.val, newSearchDateRange);
                SearchNode searchNode = new SearchNode(new DateRangeNode(clone, childNode.childList), newSearchDateRange);
                queue.offer(searchNode);
            }
        }
    }

    public CascadeResult getResult() {
        this.combineVersion();
        return this.cascadeResult;
    }

    private MultiVersionTree(List<? extends CascadeBo> cascadeBoList) {
        this.init(cascadeBoList);
        this.buildTree();
    }

    private void init(List<? extends CascadeBo> cascadeBoList) {
        this.virtualRoot = MultiVersionTree.getVirtualRoot();
        this.boVsNodeList = cascadeBoList.stream().collect(Collectors.groupingBy(CascadeBo::getBo, Collectors.mapping(DateRangeNode::new, Collectors.toList())));
    }

    private void buildTree() {
        List<DateRangeNode> defaultParentList = Collections.singletonList(this.virtualRoot);
        this.boVsNodeList.values().forEach(nodeList -> nodeList.forEach(node -> {
            List<DateRangeNode> parentNodeList = this.boVsNodeList.getOrDefault(node.getParentBo(), defaultParentList);
            AtomicBoolean noRealRoot = new AtomicBoolean(true);
            parentNodeList.forEach(parentNode -> {
                if (((DateRangeNode)parentNode).effectRange.overlaps(((DateRangeNode)node).effectRange)) {
                    ((DateRangeNode)parentNode).childList.add(node);
                    noRealRoot.set(false);
                }
            });
            if (noRealRoot.get()) {
                this.virtualRoot.childList.add(node);
            }
        }));
    }

    private CascadeBo followParent(CascadeBo parent, CascadeBo child, LocalDateRange newSearchDateRange) {
        CascadeBo cloneChild = null;
        try {
            cloneChild = child.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("cascadeBo must override clone method", e);
        }
        Map paramMap = child.getParamMap();
        List partCascadeBoFunctionList = parent.getPartCascadeBoFunctionList();
        CascadeBo finalCloneChild = cloneChild;
        partCascadeBoFunctionList.forEach(getPartCascadeFunction -> {
            Map<Long, PartBo> vidVsOldPartBo = ((List)getPartCascadeFunction.apply(child)).stream().collect(Collectors.toMap(PartBo::getVid, partBo -> partBo));
            List childPartList = (List)getPartCascadeFunction.apply(finalCloneChild);
            List parentPartList = (List)getPartCascadeFunction.apply(parent);
            parentPartList.stream().filter(partBo -> partBo.getEffectRange().overlaps(newSearchDateRange)).forEach(parentPartBo -> childPartList.stream().filter(partBo -> partBo.getEffectRange().overlaps(newSearchDateRange)).forEach(childPartBo -> {
                if (childPartBo.getEffectRange().overlaps(parentPartBo.getEffectRange())) {
                    childPartBo.followParent(new FollowModel(parentPartBo, childPartBo, paramMap));
                    LocalDateRange intersectionEffectRange = parentPartBo.getEffectRange().intersection(childPartBo.getEffectRange().intersection(newSearchDateRange));
                    childPartBo.setEffectRange(intersectionEffectRange);
                    this.collectChanged((PartBo)vidVsOldPartBo.get(childPartBo.getVid()), (PartBo)childPartBo, child.getBo());
                }
            }));
        });
        return cloneChild;
    }

    private void combineVersion() {
        this.cascadeResult.foreach((bo, allPartBoList) -> {
            Map<Class, List<PartBo>> clzVsPartBoList = allPartBoList.stream().collect(Collectors.groupingBy(Object::getClass));
            List afterCombineList = clzVsPartBoList.values().stream().peek(aPartBoList -> {
                aPartBoList.sort(Comparator.comparing(partBo -> partBo.getEffectRange().getStart()));
                this.combinePartVersion((List<PartBo>)aPartBoList);
            }).flatMap(Collection::stream).collect(Collectors.toList());
            allPartBoList.clear();
            allPartBoList.addAll(afterCombineList);
        });
    }

    private void combinePartVersion(List<PartBo> aPartBoList) {
        ArrayList<PartBo> tempList = new ArrayList<PartBo>(aPartBoList.size());
        tempList.add(aPartBoList.get(0));
        for (int i = 1; i < aPartBoList.size(); ++i) {
            PartBo beforeVersion = (PartBo)tempList.get(tempList.size() - 1);
            PartBo afterVersion = aPartBoList.get(i);
            if (beforeVersion.getVid() == afterVersion.getVid() && beforeVersion.getEffectRange().abuts(afterVersion.getEffectRange()) && beforeVersion.canCombine(afterVersion)) {
                beforeVersion.setEffectRange(afterVersion.getEffectRange().union(beforeVersion.getEffectRange()));
                continue;
            }
            tempList.add(afterVersion);
        }
        aPartBoList.clear();
        aPartBoList.addAll(tempList);
    }

    private void collectChanged(PartBo oldPartBo, PartBo newPartBo, long bo) {
        boolean changed = oldPartBo.isChanged(newPartBo);
        if (changed) {
            this.cascadeResult.add(bo, newPartBo);
        }
    }

    private static DateRangeNode getVirtualRoot() {
        return new DateRangeNode(new CascadeBo(){

            public long getBo() {
                return -1L;
            }

            public long getParentBo() {
                return 0L;
            }

            public LocalDateRange getEffectRange() {
                return LocalDateRange.ALL;
            }

            public List<Function<CascadeBo, List<? extends PartBo>>> getPartCascadeBoFunctionList() {
                return null;
            }

            public CascadeBo clone() {
                throw new RuntimeException("unsupported operation");
            }
        });
    }

    private static class SearchNode {
        private DateRangeNode node;
        private LocalDateRange searchRange;

        public SearchNode(DateRangeNode dateRangeNode, LocalDateRange searchDateRange) {
            this.node = dateRangeNode;
            this.searchRange = searchDateRange;
        }

        public List<DateRangeNode> getChildList() {
            return this.node.childList;
        }
    }

    private static class DateRangeNode {
        private CascadeBo val;
        private List<DateRangeNode> childList;
        private LocalDateRange effectRange;

        public DateRangeNode(CascadeBo val) {
            this.val = val;
            this.effectRange = val.getEffectRange();
            this.childList = new ArrayList<DateRangeNode>();
        }

        public DateRangeNode(CascadeBo val, List<DateRangeNode> childList) {
            this.val = val;
            this.childList = childList;
            this.effectRange = val.getEffectRange();
        }

        public long getBo() {
            return this.val.getBo();
        }

        public long getParentBo() {
            return this.val.getParentBo();
        }
    }
}

