/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.common.constants;

import java.util.function.Supplier;
import kd.bos.dataentity.resource.ResManager;

public enum PosTypeEnum {
    FULL_TIME(1010L, PosTypeEnum::getFullTimeLocaleName),
    PART_TIME(1020L, PosTypeEnum::getPartTimeLocaleName),
    SECONDMENT(1030L, PosTypeEnum::getSecondmentLocaleName),
    EXPATRIATE(1040L, PosTypeEnum::getExpatriateLocaleName),
    OTHER(1050L, PosTypeEnum::getOtherLocaleName);

    private final long id;
    private final Supplier<String> localeNameSupplier;

    private PosTypeEnum(long id, Supplier<String> localeNameSupplier) {
        this.id = id;
        this.localeNameSupplier = localeNameSupplier;
    }

    public long getId() {
        return this.id;
    }

    public String getLocaleName() {
        return this.localeNameSupplier.get();
    }

    private static String getFullTimeLocaleName() {
        return ResManager.loadKDString((String)"\u5168\u804c", (String)"PosTypeEnum_0", (String)"hrmp-haos-common", (Object[])new Object[0]);
    }

    private static String getPartTimeLocaleName() {
        return ResManager.loadKDString((String)"\u517c\u804c", (String)"PosTypeEnum_1", (String)"hrmp-haos-common", (Object[])new Object[0]);
    }

    private static String getSecondmentLocaleName() {
        return ResManager.loadKDString((String)"\u501f\u8c03", (String)"PosTypeEnum_2", (String)"hrmp-haos-common", (Object[])new Object[0]);
    }

    private static String getExpatriateLocaleName() {
        return ResManager.loadKDString((String)"\u5916\u6d3e", (String)"PosTypeEnum_3", (String)"hrmp-haos-common", (Object[])new Object[0]);
    }

    private static String getOtherLocaleName() {
        return ResManager.loadKDString((String)"\u5176\u4ed6", (String)"PosTypeEnum_4", (String)"hrmp-haos-common", (Object[])new Object[0]);
    }
}

