/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import kd.bos.dataentity.entity.DynamicObject;

public class DyCollectors {
    static final Set<Collector.Characteristics> CH_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    static final Set<Collector.Characteristics> CH_UNORDERED_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH));

    public static Function<DynamicObject, Long> getIdMapper() {
        return dy -> dy.getLong("id");
    }

    public static Function<DynamicObject, Long> getBoIdMapper() {
        return dy -> dy.getLong("boid");
    }

    public static <R> Collector<DynamicObject, ?, List<R>> toList(Function<DynamicObject, R> mapper) {
        return new CollectorImpl(ArrayList::new, (list, dy) -> list.add(mapper.apply((DynamicObject)dy)), (left, right) -> {
            left.addAll(right);
            return left;
        }, CH_ID);
    }

    public static <R> Collector<DynamicObject, ?, Set<R>> toSet(Function<DynamicObject, R> mapper) {
        return new CollectorImpl(HashSet::new, (set, dy) -> set.add(mapper.apply((DynamicObject)dy)), (left, right) -> {
            left.addAll(right);
            return left;
        }, CH_UNORDERED_ID);
    }

    public static Collector<DynamicObject, ?, List<Long>> toIdList() {
        return DyCollectors.toList(DyCollectors.getIdMapper());
    }

    public static Collector<DynamicObject, ?, List<Long>> toBoIdList() {
        return DyCollectors.toList(DyCollectors.getBoIdMapper());
    }

    public static Collector<DynamicObject, ?, Set<Long>> toIdSet() {
        return DyCollectors.toSet(DyCollectors.getIdMapper());
    }

    public static Collector<DynamicObject, ?, Set<Long>> toBoIdSet() {
        return DyCollectors.toSet(DyCollectors.getBoIdMapper());
    }

    public static Collector<DynamicObject, ?, Map<Long, DynamicObject>> toIdVsDy() {
        return DyCollectors.toMap(DyCollectors.getIdMapper(), dy -> dy);
    }

    public static Collector<DynamicObject, ?, Map<Long, DynamicObject>> toBoIdVsDy() {
        return DyCollectors.toMap(DyCollectors.getBoIdMapper(), dy -> dy);
    }

    public static Collector<DynamicObject, ?, Map<Long, DynamicObject>> toIdVsDyWithMergeFunction() {
        return DyCollectors.toMap(DyCollectors.getIdMapper(), dy -> dy, (v, v2) -> v);
    }

    public static Collector<DynamicObject, ?, Map<Long, DynamicObject>> toBoIdVsDyWithMergeFunction() {
        return DyCollectors.toMap(DyCollectors.getBoIdMapper(), dy -> dy, (v, v2) -> v);
    }

    private static <I, R> Function<I, R> castingIdentity() {
        return i -> i;
    }

    private static <K, V, M extends Map<K, V>> BinaryOperator<M> mapMerger(BinaryOperator<V> mergeFunction) {
        return (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                m1.merge(e.getKey(), e.getValue(), mergeFunction);
            }
            return m1;
        };
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    private static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return DyCollectors.toMap(keyMapper, valueMapper, DyCollectors.throwingMerger(), HashMap::new);
    }

    private static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return DyCollectors.toMap(keyMapper, valueMapper, mergeFunction, HashMap::new);
    }

    private static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapSupplier) {
        BiConsumer<Map, Object> accumulator = (map, element) -> map.merge(keyMapper.apply(element), valueMapper.apply(element), mergeFunction);
        return new CollectorImpl(mapSupplier, accumulator, DyCollectors.mapMerger(mergeFunction), CH_ID);
    }

    static class CollectorImpl<T, A, R>
    implements Collector<T, A, R> {
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;
        private final Function<A, R> finisher;
        private final Set<Collector.Characteristics> characteristics;

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = finisher;
            this.characteristics = characteristics;
        }

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Set<Collector.Characteristics> characteristics) {
            this(supplier, accumulator, combiner, DyCollectors.castingIdentity(), characteristics);
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }
    }
}

