/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.common.util;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.property.BasedataProp;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class HRDyObjectUtils {
    public static boolean compareDyValue(DynamicObject first, DynamicObject second, Collection<String> compareField) {
        if (Objects.isNull(first) && Objects.isNull(second)) {
            return true;
        }
        if (Objects.isNull(first) || Objects.isNull(second)) {
            return false;
        }
        DataEntityPropertyCollection firstPros = first.getDataEntityType().getProperties();
        DataEntityPropertyCollection sencodPros = second.getDataEntityType().getProperties();
        if (CollectionUtils.isEmpty((Collection)firstPros) || CollectionUtils.isEmpty((Collection)sencodPros)) {
            return false;
        }
        Map<String, Class<?>> firstProMap = firstPros.stream().filter(pro -> Objects.nonNull(pro.getPropertyType())).collect(Collectors.toMap(pro -> StringUtils.lowerCase((String)pro.getName()), IDataEntityProperty::getPropertyType));
        Map<String, Class<?>> secondProMap = sencodPros.stream().filter(pro -> Objects.nonNull(pro.getPropertyType())).collect(Collectors.toMap(pro -> StringUtils.lowerCase((String)pro.getName()), IDataEntityProperty::getPropertyType));
        Set shareProSet = Sets.intersection(secondProMap.keySet(), firstProMap.keySet()).copyInto((Set)Sets.newHashSet());
        Optional.ofNullable(first.getDataEntityType().getPrimaryKey()).ifPresent(pk -> shareProSet.remove(StringUtils.lowerCase((String)pk.getName())));
        return !HRDyObjectUtils.isShareProSet(first, second, compareField, firstProMap, secondProMap, shareProSet);
    }

    private static boolean isShareProSet(DynamicObject first, DynamicObject second, Collection<String> compareField, Map<String, Class<?>> firstProMap, Map<String, Class<?>> secondProMap, Set<String> shareProSet) {
        for (String pro : shareProSet) {
            if (CollectionUtils.isNotEmpty(compareField) && !compareField.contains(pro)) continue;
            if (secondProMap.get(pro) != firstProMap.get(pro)) {
                return true;
            }
            if (firstProMap.get(pro) == DynamicObject.class) {
                boolean result = HRDyObjectUtils.compareDyValue(first.getDynamicObject(pro), second.getDynamicObject(pro), null);
                if (result) continue;
                return true;
            }
            if (firstProMap.get(pro) == DynamicObjectCollection.class) {
                boolean result = HRDyObjectUtils.compareDynamicObjectCollection((DynamicObjectCollection)first.get(pro), (DynamicObjectCollection)second.get(pro));
                if (result) continue;
                return true;
            }
            if (firstProMap.get(pro) == LocaleDynamicObjectCollection.class) {
                boolean result = HRDyObjectUtils.compareDynamicObjectCollection((DynamicObjectCollection)first.get(pro), (DynamicObjectCollection)second.get(pro));
                if (result) continue;
                return true;
            }
            Boolean isBothObject = HRDyObjectUtils.compareBothObject(first, second, firstProMap, pro);
            if (isBothObject == null) continue;
            return isBothObject;
        }
        return false;
    }

    private static Boolean compareBothObject(DynamicObject first, DynamicObject second, Map<String, Class<?>> firstProMap, String pro) {
        Object firstObj = first.get(pro);
        Object secondObj = second.get(pro);
        if (Objects.isNull(firstObj) && Objects.isNull(secondObj)) {
            return null;
        }
        if (Objects.isNull(firstObj) || Objects.isNull(secondObj)) {
            return true;
        }
        if (ILocaleString.class.isAssignableFrom(firstProMap.get(pro))) {
            if (!Objects.equals(first.getLocaleString(pro).getLocaleValue(), second.getLocaleString(pro).getLocaleValue())) {
                return true;
            }
            return null;
        }
        if (Date.class.isAssignableFrom(firstProMap.get(pro))) {
            if (first.getDate(pro).getTime() != second.getDate(pro).getTime()) {
                return true;
            }
            return null;
        }
        if (!firstObj.equals(secondObj)) {
            return true;
        }
        return null;
    }

    public static boolean compareDynamicObjectCollection(DynamicObjectCollection firstObjColl, DynamicObjectCollection secondObjColl) {
        if (CollectionUtils.isEmpty((Collection)firstObjColl) && CollectionUtils.isEmpty((Collection)secondObjColl)) {
            return true;
        }
        if (CollectionUtils.isEmpty((Collection)firstObjColl) || CollectionUtils.isEmpty((Collection)secondObjColl)) {
            return false;
        }
        if (firstObjColl.size() != secondObjColl.size()) {
            return false;
        }
        Map firstPKDyMap = firstObjColl.stream().filter(Objects::nonNull).filter(dy -> null != dy.getDataEntityType().getPrimaryKey()).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (oldVal, newVal) -> oldVal));
        Map secondPKDyMap = firstObjColl.stream().filter(Objects::nonNull).filter(dy -> null != dy.getDataEntityType().getPrimaryKey()).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (oldVal, newVal) -> oldVal));
        boolean compreResult = true;
        for (Map.Entry entry : firstPKDyMap.entrySet()) {
            compreResult = HRDyObjectUtils.compareDyValue((DynamicObject)entry.getValue(), (DynamicObject)secondPKDyMap.get(entry.getKey()), null);
            if (compreResult) continue;
            return false;
        }
        return compreResult;
    }

    public static DynamicObjectType createDyTypeFromTargetType(DynamicObjectType dynamicObjectType, String targetName) {
        DynamicProperty targetProp = dynamicObjectType.getProperty(targetName);
        return ((BasedataProp)targetProp).getDynamicComplexPropertyType();
    }
}

