/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devenv.bos.BosMserviceInit;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class OrgDateTimeUtil {
    public static final Log LOGGER = LogFactory.getLog(BosMserviceInit.class);
    public static final String SYSTEM_TYPE = "hrmp-haos-common";
    public static Date BSLED;

    public static Map<String, Integer> calculatePreciseDuration(Date startDate, Date endDate) {
        if (startDate != null && endDate != null && !"2999-12-31".equals(HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd"))) {
            Instant startInstant = startDate.toInstant();
            Instant endInstant = endDate.toInstant();
            ZoneId zone = ZoneId.systemDefault();
            LocalDate startLocalDate = LocalDateTime.ofInstant(startInstant, zone).toLocalDate();
            LocalDate endLocalDate = LocalDateTime.ofInstant(endInstant, zone).toLocalDate();
            if (endLocalDate.compareTo(startLocalDate) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f", (String)"OrgDateTimeUtil_1", (String)"hrmp-hbp-common", (Object[])new Object[0]));
            }
            Period period = Period.between(startLocalDate, endLocalDate.plusDays(1L));
            HashMap<String, Integer> preciseDurationMap = new HashMap<String, Integer>();
            int years = period.getYears();
            int months = period.getMonths();
            int days = period.getDays();
            preciseDurationMap.put("years", years);
            preciseDurationMap.put("months", months);
            preciseDurationMap.put("days", days);
            return preciseDurationMap;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"OrgDateTimeUtil_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
    }

    public static String setYmd(int years, int months, int day) {
        String ymd = null;
        ymd = years != 0 ? String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708%3$s\u5929 ", (String)"NewAdminorgDetailEditPlugin_15", (String)SYSTEM_TYPE, (Object[])new Object[0]), years, months, day) : (months != 0 ? String.format(ResManager.loadKDString((String)"%1$s\u6708%2$s\u5929 ", (String)"NewAdminorgDetailEditPlugin_11", (String)SYSTEM_TYPE, (Object[])new Object[0]), months, day) : String.format(ResManager.loadKDString((String)"%s\u5929 ", (String)"NewAdminorgDetailEditPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]), day));
        return ymd;
    }

    public static Date getSearchDate(FormShowParameter formShowParameter) {
        Map customvariables = (Map)formShowParameter.getCustomParam("customvariables");
        if (customvariables == null) {
            return OrgDateTimeUtil.getStartOfDay(new Date());
        }
        if (customvariables.containsKey("searchdate")) {
            String searchdateStr = (String)customvariables.get("searchdate");
            Date searchdate = null;
            try {
                if (!StringUtils.isEmpty((CharSequence)searchdateStr)) {
                    searchdate = HRDateTimeUtils.parseDate((String)searchdateStr);
                }
            }
            catch (ParseException e) {
                LOGGER.error((Throwable)e);
            }
            return searchdate;
        }
        return new Date();
    }

    public static Date getStartOfDay(Date date) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime startOfDay = localDateTime.with(LocalTime.MIN);
        return Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getFirstDateOfYear(Date date) {
        int year = HRDateTimeUtils.getYear((Date)date);
        Date start = OrgDateTimeUtil.getDateByYear(year, "-01-01");
        return start;
    }

    private static Date getDateByYear(int year, String syc) {
        Date start = null;
        try {
            start = HRDateTimeUtils.parseDate((String)(year + syc));
        }
        catch (Exception ex) {
            throw new KDBizException("parse date error");
        }
        return start;
    }

    public static Date getLastDateOfYear(Date date) {
        int year = HRDateTimeUtils.getYear((Date)date);
        Date dateTime = OrgDateTimeUtil.getDateByYear(year, "-12-31");
        return dateTime;
    }

    public static Date getFirstDayOfCurYear() {
        return OrgDateTimeUtil.getFirstDateOfYear(new Date());
    }

    public static Date getLastDayOfCurYear() {
        return OrgDateTimeUtil.getLastDateOfYear(new Date());
    }

    public static Date getLastDayOfMonth(Date date) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        return Date.from(ZonedDateTime.of(LocalDate.of(zonedDateTime.getYear(), zonedDateTime.getMonth(), 1), LocalTime.MIN, ZoneId.systemDefault()).plusMonths(1L).minusDays(1L).toInstant());
    }

    public static Date str2DateIfNullToday(String dateString, boolean truncateDate) {
        Date customDate = null;
        if (StringUtils.isNotEmpty((CharSequence)dateString)) {
            try {
                customDate = HRDateTimeUtils.parseDate((String)dateString);
            }
            catch (ParseException e) {
                LOGGER.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        } else {
            customDate = new Date();
        }
        if (truncateDate) {
            customDate = HRDateTimeUtils.truncateDate((Date)customDate);
        }
        return customDate;
    }

    public static Date selDay(Date date, int day) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, day);
        return calendar.getTime();
    }

    public static Date getDate2999(SimpleDateFormat sdf) {
        if (sdf == null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd");
        }
        Date date2999 = null;
        try {
            date2999 = sdf.parse("2999-12-31");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date2999;
    }

    public static Date getDate1907(SimpleDateFormat sdf) {
        if (sdf == null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd");
        }
        Date getDate1907 = null;
        try {
            getDate1907 = sdf.parse("1907-01-01");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return getDate1907;
    }

    static {
        try {
            BSLED = HRDateTimeUtils.parseDate((String)"2999-12-31");
        }
        catch (ParseException exception) {
            LOGGER.error((Throwable)exception);
        }
    }
}

