/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.collections4.CollectionUtils;

public class StructLongNumberUtil {
    private static final Log logger = LogFactory.getLog(StructLongNumberUtil.class);

    public static List<String> getPrefixStructLongNumber(List<String> structLongNumbers) {
        if (CollectionUtils.isEmpty(structLongNumbers)) {
            return Collections.emptyList();
        }
        long startTime = System.currentTimeMillis();
        structLongNumbers.sort(Comparator.comparingInt(o -> o.length()));
        logger.info("StructLongNumberUtil.structLongNumbers.sort,size={} cost:{}ms", (Object)structLongNumbers.size(), (Object)(System.currentTimeMillis() - startTime));
        HashSet<String> result = new HashSet<String>();
        result.add(structLongNumbers.get(0));
        for (int i = 1; i < structLongNumbers.size(); ++i) {
            boolean flag = true;
            for (String checkedLongNumber : result) {
                if (!structLongNumbers.get(i).startsWith(checkedLongNumber)) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            result.add(structLongNumbers.get(i));
        }
        logger.info("StructLongNumberUtil.structLongNumbers,cost={}ms", (Object)(System.currentTimeMillis() - startTime));
        return new ArrayList<String>(result);
    }
}

