/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.customorgteam.validator;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class CustomOrgTeamEnableValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        HashSet enabledOrgTeamIds = new HashSet(dataEntities.length);
        List<ExtendedDataEntity> collect = Arrays.stream(dataEntities).sorted(Comparator.comparingInt(o -> o.getDataEntity().getInt("level"))).collect(Collectors.toList());
        collect.forEach(dataEntity -> {
            DynamicObject orgTeam = dataEntity.getDataEntity();
            DynamicObject parentOrgTeam = orgTeam.getDynamicObject("parent");
            if (HRObjectUtils.isEmpty((Object)parentOrgTeam)) {
                return;
            }
            String parentEnable = parentOrgTeam.getString("enable");
            long parentOrgTeamId = parentOrgTeam.getLong("id");
            if (!enabledOrgTeamIds.contains(parentOrgTeamId) && !HRStringUtils.equals((String)parentEnable, (String)"1")) {
                this.addErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u5c06\u4e0a\u7ea7\u7ec4\u7ec7\u542f\u7528\u3002", (String)"CustomOrgTeamEnableValidator_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
            } else {
                enabledOrgTeamIds.add(orgTeam.getLong("id"));
            }
        });
    }
}

