/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.custroleemp;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.haos.business.domain.repository.CommonRepository;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.opplugin.web.custroleemp.util.CustRoleEmpHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class CustRoleEmpRelValid
extends HRDataBaseValidator {
    private static Log LOGGER = LogFactory.getLog(CustRoleEmpRelValid.class);

    public void validate() {
        Map variables;
        String operateKey;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (Objects.isNull(dataEntities) || dataEntities.length == 0) {
            return;
        }
        switch (operateKey = this.getOperateKey()) {
            case "btnsave": 
            case "his_rolemodify": {
                this.checkSameData(dataEntities, operateKey);
                this.checkDateValue(dataEntities);
            }
        }
        if ("btnsave".equals(operateKey) && (variables = this.getOption().getVariables()) != null && !"new".equals(variables.get("importtype")) && !PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"homs", (String)this.getEntityKey(), (String)"47156aff000000ac")) {
            String message = ResManager.loadKDString((String)"\u65e0\u65b0\u589e\u201c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CustomRoleNameValid_7", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                this.addFatalErrorMessage(dataEntity, message);
            }
        }
    }

    private void checkDateValue(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObjectCollection dys = dynamicObject.getDynamicObjectCollection("entryentity");
            if (dys == null) continue;
            for (DynamicObject dy : dys) {
                Date startDate = dy.getDate("enstartdate");
                Date endDate = dy.getDate("ensysenddate");
                if (startDate == null || endDate == null || !startDate.after(endDate)) continue;
                String errorMsg = ResManager.loadKDString((String)"\u4efb\u804c\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u4efb\u804c\u5f00\u59cb\u65e5\u671f\u3002", (String)"CustRoleEmpRelValid_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMsg);
            }
        }
    }

    private void checkSameData(ExtendedDataEntity[] dataEntities, String opKey) {
        if (!dataEntities[0].getDataEntity().getBoolean("datasource")) {
            this.checkOutPersonSameData(dataEntities, opKey);
            return;
        }
        HashSet<String> ids = new HashSet<String>(dataEntities.length);
        HashSet<Long> employIds = new HashSet<Long>(dataEntities.length);
        HashSet<Long> orgTeamIds = new HashSet<Long>(dataEntities.length);
        HashSet<Long> roleIds = new HashSet<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            QFilter filter;
            DynamicObject empRoleDy;
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObjectCollection collection = data.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)collection)) {
                return;
            }
            Long employId = data.getLong("depemp.employee.id");
            for (DynamicObject dy : collection) {
                Long orgTeamId = dy.getLong("enorgteam.id");
                Long roleId = dy.getLong("encustomorole.id");
                String id = employId + "-" + orgTeamId + "-" + roleId;
                if (ids.contains(id)) {
                    String errorMsg = ResManager.loadKDString((String)"\u5206\u5f55\u5b58\u5728\u76f8\u540c\u7684\u7ec4\u7ec7\u548c\u89d2\u8272\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CustomRoleNameValid_2", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, errorMsg);
                    break;
                }
                ids.add(id);
                this.addId(employIds, employId);
                this.addId(orgTeamIds, orgTeamId);
                this.addId(roleIds, roleId);
            }
            if (CollectionUtils.isEmpty(employIds) || "his_rolemodify".equals(opKey) || !data.getBoolean("datasource") || (empRoleDy = CommonRepository.queryDynamicObject((String)"haos_cusempposorgrel", (String)"customorole,depemp", (QFilter[])new QFilter[]{filter = new QFilter("customorole.id", "in", roleIds).and("orgteam.id", "in", orgTeamIds).and("depemp.employee.id", "in", employIds).and(QFilterHelper.createValidHisCurrentDataFilter())})) == null) continue;
            String roleName = empRoleDy.getString("customorole.name");
            String as = ResManager.loadKDString((String)"\u62c5\u4efb", (String)"CustomRoleNameValid_6", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CustomRoleNameValid_3", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), empRoleDy.get("depemp.person.name") + as + roleName);
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }

    private void addId(Set<Long> idSet, Long id) {
        if (id != null && id != 0L) {
            idSet.add(id);
        }
    }

    private void checkOutPersonSameData(ExtendedDataEntity[] dataEntities, String opKey) {
        HashSet<String> uniqStrs = new HashSet<String>(dataEntities.length);
        HashSet<Long> orgTeamIds = new HashSet<Long>(dataEntities.length);
        HashSet<Long> roleIds = new HashSet<Long>(dataEntities.length);
        HashSet<String> numbers = new HashSet<String>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObjectCollection collection = data.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)collection)) {
                return;
            }
            String number = data.getString("outpernumber");
            for (DynamicObject dy : collection) {
                Long orgTeamId = dy.getLong("enorgteam.id");
                Long roleId = dy.getLong("encustomorole.id");
                String id = number + "-" + orgTeamId + "-" + roleId;
                if (!uniqStrs.add(id)) {
                    String errorMsg = ResManager.loadKDString((String)"\u5206\u5f55\u5b58\u5728\u76f8\u540c\u7684\u7ec4\u7ec7\u548c\u89d2\u8272\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CustomRoleNameValid_2", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, errorMsg);
                    break;
                }
                this.addId(orgTeamIds, orgTeamId);
                this.addId(roleIds, roleId);
            }
            numbers.add(number);
            if ("his_rolemodify".equals(opKey)) continue;
            DynamicObject[] outPersonDys = CustRoleEmpHelper.findOutPerson(numbers);
            if (outPersonDys == null || outPersonDys.length == 0) {
                return;
            }
            Set ids = Arrays.stream(outPersonDys).map(val -> val.getLong("id")).collect(Collectors.toSet());
            QFilter filter = new QFilter("customorole.id", "in", roleIds).and("orgteam.id", "in", orgTeamIds).and("outperson.id", "in", ids).and(QFilterHelper.createValidHisCurrentDataFilter());
            DynamicObject empRoleDy = CommonRepository.queryDynamicObject((String)"haos_cusempposorgrel", (String)"customorole,outperson", (QFilter[])new QFilter[]{filter});
            if (empRoleDy == null) continue;
            String roleName = empRoleDy.getString("customorole.name");
            String as = ResManager.loadKDString((String)"\u62c5\u4efb", (String)"CustomRoleNameValid_6", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CustomRoleNameValid_3", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), empRoleDy.get("outperson.name") + as + roleName);
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }
}

