/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.custroleemp;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.CommonRepository;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.domain.repository.custroleemp.CustRoleEmpRepository;
import kd.hr.haos.opplugin.web.custroleemp.ImportPersonValid;
import kd.hr.haos.opplugin.web.custroleemp.util.CustRoleEmpHelper;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

public class ImportPersonOp
extends HRDataBaseOp {
    private static final HRBaseServiceHelper OUTPER_HELPER = new HRBaseServiceHelper("haos_outperson");
    private static final HRBaseServiceHelper CUSEMPPOSORGREL_HELPER = new HRBaseServiceHelper("haos_cusempposorgrel");

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator((AbstractValidator)new ImportPersonValid());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        HashSet<String> numbers = new HashSet<String>(dataEntities.length);
        for (DynamicObject dy : dataEntities) {
            if (dy.getBoolean("datasource")) continue;
            numbers.add(dy.getString("outpernumber"));
        }
        HashMap<String, DynamicObject> outPersonMap = numbers.size() > 0 ? CustRoleEmpHelper.findOutPersonMap(numbers) : new HashMap<String, DynamicObject>(numbers.size());
        ArrayList<DynamicObject> outPerList = new ArrayList<DynamicObject>(dataEntities.length);
        ArrayList<DynamicObject> outPerUpdateList = new ArrayList<DynamicObject>(dataEntities.length);
        ArrayList<DynamicObject> synUpdateNameList = new ArrayList<DynamicObject>(dataEntities.length);
        long[] ids = ORM.create().genLongIds("haos_outperson", dataEntities.length);
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dy = dataEntities[i];
            dy.set("businessstatus", (Object)"1");
            if (!dy.getBoolean("datasource")) {
                String number = dy.getString("outpernumber");
                DynamicObject outPerDy = (DynamicObject)outPersonMap.get(number);
                if (outPerDy == null) {
                    outPerDy = OUTPER_HELPER.generateEmptyDynamicObject();
                    outPerDy.set("id", (Object)ids[i]);
                    outPerDy.set("masterid", (Object)ids[i]);
                    outPerDy.set("number", dy.get("outpernumber"));
                    outPerDy.set("name", dy.get("name"));
                    outPerDy.set("gender", dy.get("gender"));
                    outPerDy.set("phone", dy.get("phone"));
                    outPerDy.set("enable", (Object)"1");
                    outPerDy.set("status", (Object)"C");
                    outPerDy.set("description", dy.get("perdesc"));
                    outPerDy.set("creator", (Object)RequestContext.get().getCurrUserId());
                    outPerList.add(outPerDy);
                    outPersonMap.put(number, outPerDy);
                } else {
                    String name = dy.getString("name");
                    if (HRStringUtils.isNotEmpty((String)name) && !name.equals(outPerDy.getString("name"))) {
                        outPerDy.set("name", dy.get("name"));
                        synUpdateNameList.add(outPerDy);
                    }
                    outPerDy.set("gender", dy.get("gender"));
                    outPerDy.set("phone", dy.get("phone"));
                    outPerDy.set("description", dy.get("perdesc"));
                    outPerUpdateList.add(outPerDy);
                }
                dy.set("outperson", (Object)outPerDy);
            }
            if (dy.getInt("index") <= 0) {
                dy.set("index", (Object)1);
            }
            if (dy.getDate("sysenddate") != null) continue;
            dy.set("sysenddate", (Object)HisEffDateCommonService.getInstance().getDate2999(null));
        }
        if (!CollectionUtils.isEmpty(outPerList)) {
            CommonRepository.saveDynamicObjects((String)"haos_outperson", (DynamicObject[])outPerList.toArray(new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty(outPerUpdateList)) {
            Map<Long, String> outPerMap;
            QFilter outPerFilter;
            DynamicObject[] cusempposorgrelDys;
            CommonRepository.updateDynamicObjects((String)"haos_outperson", (DynamicObject[])outPerUpdateList.toArray(new DynamicObject[0]));
            if (!CollectionUtils.isEmpty(synUpdateNameList) && (cusempposorgrelDys = CommonRepository.queryDynamicObjects((String)"haos_cusempposorgrel", (String)"", (String)"index", (QFilter[])new QFilter[]{outPerFilter = new QFilter("outperson.id", "in", (outPerMap = synUpdateNameList.stream().collect(Collectors.toMap(val -> val.getLong("id"), val -> val.getString("name"), (K1, K2) -> K1))).keySet()).and(QFilterHelper.createValidHisCurrentDataFilter())})) != null && cusempposorgrelDys.length > 0) {
                ArrayList<DynamicObject> hisNeedEditDys = new ArrayList<DynamicObject>(cusempposorgrelDys.length);
                for (DynamicObject cusempposorgrelDy : cusempposorgrelDys) {
                    DynamicObject newDy = CUSEMPPOSORGREL_HELPER.generateEmptyDynamicObject();
                    HRDynamicObjectUtils.copy((DynamicObject)cusempposorgrelDy, (DynamicObject)newDy);
                    newDy.set("name", (Object)outPerMap.get(cusempposorgrelDy.getLong("outperson.id")));
                    newDy.set("bsed", (Object)new Date());
                    hisNeedEditDys.add(newDy);
                }
                CustRoleEmpRepository.getInstance().saveOrEditHisData(hisNeedEditDys.toArray(new DynamicObject[0]), "haos_cusempposorgrel");
            }
        }
        CustRoleEmpRepository.getInstance().saveOrEditHisData(dataEntities, "haos_cusempposorgrel");
    }
}

