/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.custroleemp;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.CommonRepository;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.opplugin.web.custroleemp.CustRoleEmpRelValid;
import kd.hr.haos.opplugin.web.custroleemp.util.CustRoleEmpHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class ImportPersonValid
extends HRDataBaseValidator {
    private static Log LOGGER = LogFactory.getLog(CustRoleEmpRelValid.class);
    private static final String SELPROP = "depemp.id,orgteam.id,customorole.id,name";

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        this.checkDateValue(dataEntities);
        if (dataEntities[0].getDataEntity().getBoolean("datasource")) {
            Map<Long, Long> roleOrgMap = this.findRoleOrgMap(dataEntities);
            HashSet<Long> employIds = new HashSet<Long>(dataEntities.length);
            HashSet<Long> orgTeamIds = new HashSet<Long>(dataEntities.length);
            HashSet<Long> roleIds = new HashSet<Long>(dataEntities.length);
            Set<Long> effectDepempSet = null;
            for (ExtendedDataEntity dataEntity : dataEntities) {
                boolean isHasBusinessStatus;
                DynamicObject dy2 = dataEntity.getDataEntity();
                Long orgTeamId = dy2.getLong("orgteam.id");
                Long roleId = dy2.getLong("customorole.id");
                Long orgT = roleOrgMap.get(roleId);
                if (orgT == null || !orgT.equals(orgTeamId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u89d2\u8272\u4e0d\u5728\u8be5\u7ec4\u7ec7\u4e0b\u3002", (String)"ImportPersonValid_2", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                }
                if (!(isHasBusinessStatus = dy2.getDynamicObject("depemp").getDynamicObjectType().getProperties().containsKey((Object)"businessstatus"))) {
                    if (effectDepempSet == null) {
                        effectDepempSet = this.getEffectDepemp(dataEntities);
                    }
                    if (!effectDepempSet.contains(dy2.getLong("depemp.id"))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u4e1a\u52a1\u72b6\u6001\u5df2\u7ecf\u5931\u6548\u3002", (String)"ImportPersonValid_3", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                    }
                } else if (!"1".equals(dy2.getString("depemp.businessstatus"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u4e1a\u52a1\u72b6\u6001\u5df2\u7ecf\u5931\u6548\u3002", (String)"ImportPersonValid_3", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                }
                Long employId = dy2.getLong("depemp.id");
                this.addId(employIds, employId);
                this.addId(orgTeamIds, orgTeamId);
                this.addId(roleIds, roleId);
            }
            if (!CollectionUtils.isEmpty(employIds)) {
                QFilter filter = new QFilter("customorole.id", "in", roleIds).and("orgteam.id", "in", orgTeamIds).and("depemp.id", "in", employIds).and(QFilterHelper.createValidHisCurrentDataFilter());
                DynamicObject[] empRoleDys = CommonRepository.queryDynamicObjects((String)"haos_cusempposorgrel", (String)SELPROP, (QFilter[])new QFilter[]{filter});
                if (empRoleDys == null || empRoleDys.length == 0) {
                    return;
                }
                Map<String, DynamicObject> empDyMap = Arrays.stream(empRoleDys).collect(Collectors.toMap(dy -> dy.getString("depemp.employee.id") + dy.getString("orgteam.id") + dy.getString("customorole.id"), dy -> dy, (oldVal, newVal) -> newVal));
                this.checkSameData(dataEntities, empDyMap);
            }
        } else {
            this.checkOutPerson(dataEntities);
        }
    }

    private Set<Long> getEffectDepemp(ExtendedDataEntity[] dataEntities) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_depemp");
        Set depempIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("depemp.id")).collect(Collectors.toSet());
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", depempIds), new QFilter("businessstatus", "=", (Object)"1")};
        DynamicObject[] dys = serviceHelper.loadDynamicObjectArray(filters);
        if (dys == null || dys.length == 0) {
            return new HashSet<Long>(0);
        }
        return Arrays.stream(dys).map(val -> val.getLong("id")).collect(Collectors.toSet());
    }

    private Map<Long, String> getEmployee(ExtendedDataEntity[] dataEntities) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_depemp");
        Set depempIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("depemp.id")).collect(Collectors.toSet());
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", depempIds), new QFilter("businessstatus", "=", (Object)"1")};
        DynamicObject[] dys = serviceHelper.loadDynamicObjectArray(filters);
        if (dys == null || dys.length == 0) {
            return new HashMap<Long, String>(0);
        }
        return Arrays.stream(dys).collect(Collectors.toMap(val -> val.getLong("id"), val -> val.getString("employee.id")));
    }

    private void checkDateValue(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dy = dataEntity.getDataEntity();
            Date startDate = dy.getDate("startdate");
            Date endDate = dy.getDate("sysenddate");
            if (startDate == null || endDate == null || !startDate.after(endDate)) continue;
            String errorMsg = ResManager.loadKDString((String)"\u4efb\u804c\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u4efb\u804c\u5f00\u59cb\u65e5\u671f\u3002", (String)"CustRoleEmpRelValid_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }

    private void checkOutPerson(ExtendedDataEntity[] dataEntities) {
        QFilter filter;
        DynamicObject[] empRoleDys;
        HashSet<String> numbers = new HashSet<String>(dataEntities.length);
        HashSet<Long> orgTeamIds = new HashSet<Long>(dataEntities.length);
        HashSet<Long> roleIds = new HashSet<Long>(dataEntities.length);
        Map<Long, Long> roleOrgMap = this.findRoleOrgMap(dataEntities);
        Set<Long> outPersonIds = new HashSet<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dy2 = dataEntity.getDataEntity();
            if ("import_updperson".equals(this.getOperateKey())) {
                outPersonIds.add(dy2.getLong("outperson.id"));
            } else {
                String number = dy2.getString("outpernumber");
                if (HRStringUtils.isEmpty((String)number)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportPersonValid_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                    continue;
                }
                numbers.add(number);
            }
            Long orgTeamId = dy2.getLong("orgteam.id");
            Long roleId = dy2.getLong("customorole.id");
            Long orgT = roleOrgMap.get(roleId);
            if (orgT == null || !orgT.equals(orgTeamId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u89d2\u8272\u4e0d\u5728\u8be5\u7ec4\u7ec7\u4e0b\u3002", (String)"ImportPersonValid_2", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                continue;
            }
            this.addId(orgTeamIds, orgTeamId);
            this.addId(roleIds, roleId);
        }
        if (!CollectionUtils.isEmpty(numbers)) {
            QFilter outFilter = new QFilter("number", "in", numbers).and("enable", "=", (Object)"1").and("status", "=", (Object)"C");
            DynamicObject[] outPersonDys = CommonRepository.queryDynamicObjects((String)"haos_outperson", (String)"name,phone", (QFilter[])new QFilter[]{outFilter});
            if (outPersonDys == null || outPersonDys.length == 0) {
                return;
            }
            outPersonIds = Arrays.stream(outPersonDys).map(val -> val.getLong("id")).collect(Collectors.toSet());
        }
        if ((empRoleDys = CommonRepository.queryDynamicObjects((String)"haos_cusempposorgrel", (String)"outperson,customorole,orgteam", (QFilter[])new QFilter[]{filter = new QFilter("customorole.id", "in", roleIds).and("orgteam.id", "in", orgTeamIds).and("outperson.id", "in", outPersonIds).and(QFilterHelper.createValidHisCurrentDataFilter())})) == null || empRoleDys.length == 0) {
            return;
        }
        Map<String, DynamicObject> empDyMap = Arrays.stream(empRoleDys).collect(Collectors.toMap(dy -> dy.getString("outperson.number") + dy.getString("orgteam.id") + dy.getString("customorole.id"), dy -> dy, (oldVal, newVal) -> newVal));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dy3 = dataEntity.getDataEntity();
            String number = dy3.getString("outpernumber");
            String key = dy3.getString("outpernumber") + dy3.getString("orgteam.id") + dy3.getString("customorole.id");
            if (empDyMap.get(key) == null || empDyMap.get(key).getLong("id") == dy3.getLong("id")) continue;
            String roleName = dy3.getString("customorole.name");
            String as = ResManager.loadKDString((String)"\u62c5\u4efb", (String)"CustomRoleNameValid_6", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CustomRoleNameValid_3", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), number + as + roleName);
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }

    private void checkSameData(ExtendedDataEntity[] dataEntities, Map<String, DynamicObject> empDyMap) {
        Map<Long, String> employeeMap = null;
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String employeeId;
            DynamicObject dy = dataEntity.getDataEntity();
            boolean isHasEmployee = dy.getDynamicObject("depemp").getDynamicObjectType().getProperties().containsKey((Object)"employee");
            if (!isHasEmployee) {
                if (employeeMap == null) {
                    employeeMap = this.getEmployee(dataEntities);
                }
                employeeId = employeeMap.get(dy.getLong("depemp.id"));
            } else {
                employeeId = dy.getString("depemp.employee.id");
            }
            String key = employeeId + dy.getString("orgteam.id") + dy.getString("customorole.id");
            if (empDyMap.get(key) == null || empDyMap.get(key).getLong("id") == dy.getLong("id")) continue;
            String roleName = dy.getString("customorole.name");
            String as = ResManager.loadKDString((String)"\u62c5\u4efb", (String)"CustomRoleNameValid_6", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CustomRoleNameValid_3", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), dy.get("depemp.person.name") + as + roleName);
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }

    private Map<Long, Long> findRoleOrgMap(ExtendedDataEntity[] dataEntities) {
        HashSet<Long> roleIds = new HashSet<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dy = dataEntity.getDataEntity();
            roleIds.add(dy.getLong("customorole.id"));
        }
        return CustRoleEmpHelper.findRoleOrgMap(roleIds);
    }

    private void addId(Set<Long> idSet, Long id) {
        if (id != null && id != 0L) {
            idSet.add(id);
        }
    }
}

