/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.custroleemp;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.CommonRepository;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.domain.repository.custroleemp.CustRoleEmpRepository;
import kd.hr.haos.opplugin.web.custroleemp.ImportPersonValid;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

public class ImportUpdPersonOp
extends HRDataBaseOp {
    private static final HRBaseServiceHelper OUTPERSON_Helper = new HRBaseServiceHelper("haos_outperson");
    private static final HRBaseServiceHelper CUSEMPPOSORGREL_HELPER = new HRBaseServiceHelper("haos_cusempposorgrel");

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator((AbstractValidator)new ImportPersonValid());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        ArrayList<DynamicObject> hisNeedEditDys = new ArrayList<DynamicObject>(dataEntities.length);
        ArrayList<DynamicObject> outPersonList = new ArrayList<DynamicObject>(dataEntities.length);
        HashSet<Long> outPersonIds = new HashSet<Long>(dataEntities.length);
        for (DynamicObject dynamicObject : dataEntities) {
            if (!dynamicObject.getBoolean("datasource")) {
                outPersonIds.add(dynamicObject.getLong("outperson.id"));
                outPersonList.add(dynamicObject);
            }
            DynamicObject newDy = CUSEMPPOSORGREL_HELPER.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)newDy);
            hisNeedEditDys.add(newDy);
        }
        if (!CollectionUtils.isEmpty(hisNeedEditDys)) {
            CustRoleEmpRepository.getInstance().saveOrEditHisData(hisNeedEditDys.toArray(new DynamicObject[0]), "haos_cusempposorgrel");
        }
        if (outPersonIds.size() > 0) {
            ArrayList<DynamicObject> synUpdateNameList = new ArrayList<DynamicObject>(dataEntities.length);
            Map<Long, DynamicObject> perIdPerMap = outPersonList.stream().collect(Collectors.toMap(dy -> dy.getLong("outperson.id"), dy -> dy, (oldVal, newVal) -> newVal));
            DynamicObject[] outPersons = OUTPERSON_Helper.loadDynamicObjectArray(outPersonIds.toArray());
            if (outPersons != null && outPersons.length > 0) {
                Map<Long, String> map;
                QFilter outPerFilter;
                DynamicObject[] cusempposorgrelDys;
                for (DynamicObject outNewPer : outPersons) {
                    String newName;
                    DynamicObject imDy = perIdPerMap.get(outNewPer.getLong("id"));
                    if (imDy.get("gender") != null) {
                        outNewPer.set("gender", imDy.get("gender"));
                    }
                    if (HRStringUtils.isNotEmpty((String)imDy.getString("perdesc"))) {
                        outNewPer.set("description", imDy.get("perdesc"));
                    }
                    if (HRStringUtils.isNotEmpty((String)(newName = imDy.getString("name"))) && !newName.equals(outNewPer.getString("name"))) {
                        outNewPer.set("name", (Object)newName);
                        synUpdateNameList.add(outNewPer);
                    }
                    if (!HRStringUtils.isNotEmpty((String)imDy.getString("phone"))) continue;
                    outNewPer.set("phone", imDy.get("phone"));
                }
                CommonRepository.saveDynamicObjects((String)"haos_outperson", (DynamicObject[])outPersons);
                if (!CollectionUtils.isEmpty(synUpdateNameList) && (cusempposorgrelDys = CommonRepository.queryDynamicObjects((String)"haos_cusempposorgrel", (String)"", (String)"index", (QFilter[])new QFilter[]{outPerFilter = new QFilter("outperson.id", "in", (map = synUpdateNameList.stream().collect(Collectors.toMap(val -> val.getLong("id"), val -> val.getString("name"), (K1, K2) -> K1))).keySet()).and(QFilterHelper.createValidHisCurrentDataFilter())})) != null && cusempposorgrelDys.length > 0) {
                    ArrayList<DynamicObject> cusempposorgrelDyDys = new ArrayList<DynamicObject>(cusempposorgrelDys.length);
                    for (DynamicObject cusempposorgrelDy : cusempposorgrelDys) {
                        DynamicObject newDy = CUSEMPPOSORGREL_HELPER.generateEmptyDynamicObject();
                        HRDynamicObjectUtils.copy((DynamicObject)cusempposorgrelDy, (DynamicObject)newDy);
                        newDy.set("name", (Object)map.get(cusempposorgrelDy.getLong("outperson.id")));
                        newDy.set("bsed", (Object)new Date());
                        cusempposorgrelDyDys.add(newDy);
                    }
                    CustRoleEmpRepository.getInstance().saveOrEditHisData(cusempposorgrelDyDys.toArray(new DynamicObject[0]), "haos_cusempposorgrel");
                }
            }
        }
    }
}

