/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.projectgroup;

import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.service.projectgroup.service.ProjChangeEventService;
import kd.hr.haos.business.service.projectgroup.service.ProjStrategyService;
import kd.hr.haos.business.service.projectgroup.service.ProjectGroupBaseService;
import kd.hr.haos.business.servicehelper.ProjectGroupServiceHelper;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.opplugin.web.projectgroup.validate.ProjTeamDisableValidator;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;

public class ProjTeamDisableOp
extends HRCoreBaseBillOp
implements ProjectGroupMDConstants {
    private List<Long> idList;

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ProjTeamDisableValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Set selectIdSet = Arrays.stream(dataEntities).map(s -> s.getLong("id")).collect(Collectors.toSet());
        HRBaseServiceHelper projectInfoDAO = new HRBaseServiceHelper("haos_projteambaseinfo");
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", selectIdSet)};
        DynamicObject[] projectSelectedDynArr = projectInfoDAO.loadDynamicObjectArray(filters);
        HashSet<Long> idSet = new HashSet<Long>(16);
        HashSet<Long> enableIdSet = new HashSet<Long>(16);
        for (DynamicObject dyn2 : projectSelectedDynArr) {
            Long proTeamId = dyn2.getLong("id");
            idSet.add(proTeamId);
            if (!"1".equals(dyn2.getString("enable"))) continue;
            enableIdSet.add(proTeamId);
        }
        DynamicObject[] projectBaseList = ProjectGroupServiceHelper.getSubProjectArray(idSet);
        if (projectBaseList == null) {
            return;
        }
        DynamicObject[] projectRoles = ProjectGroupServiceHelper.queryProjectRoleByProjectTeamId(new ArrayList(enableIdSet));
        List subProTeamDynList = Arrays.stream(projectBaseList).filter(dyn -> !enableIdSet.contains(dyn.getLong("id"))).collect(Collectors.toList());
        String msg = String.format(ResManager.loadKDString((String)"\u7981\u7528\u9009\u4e2d\u7684\u9879\u76ee\u56e2\u961f\uff0c\u4e1a\u52a1\u72b6\u6001\u53d8\u4e3a\u201c\u5df2\u7981\u7528\u201d\uff1b\u540c\u65f6\u7981\u7528\u4e0b\u7ea7\u9879\u76ee\u56e2\u961f\uff08\u7981\u7528\u4e2a\u6570\uff1a%1$s\uff09\u548c\u9879\u76ee\u89d2\u8272\uff08\u7981\u7528\u4e2a\u6570\uff1a%2$s\uff09\u3002", (String)"ProjectGroupDisableEdit_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), subProTeamDynList.size(), projectRoles.length);
        boolean continueFlag = ProjectGroupServiceHelper.alterConfigWindow((OperateOption)this.getOption(), (boolean)true, (String)msg);
        if (!continueFlag) {
            e.setCancelOperation(true);
            return;
        }
        this.idList = Arrays.stream(projectBaseList).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        Date nowDate = HRDateTimeUtils.localDate2Date((LocalDate)LocalDate.now());
        for (DynamicObject dyn3 : projectBaseList) {
            dyn3.set("disabledate", (Object)nowDate);
            dyn3.set("createtime", (Object)nowDate);
        }
        this.setDisableInfo(projectBaseList);
        HisResponse hisResponse = ProjectGroupBaseService.getInstance().disable(projectBaseList, Long.valueOf(0L), null);
        ProjChangeEventService.handleChangeEventHis((HisResponse)hisResponse, (String)"haos_projteambaseinfo", null);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (this.operationResult.isSuccess()) {
            ProjStrategyService.INSTANCE.disableStrategy(new ArrayList<Long>(this.idList));
        }
    }

    private void setDisableInfo(DynamicObject[] projectBaseList) {
        Map variables = this.getOption().getVariables();
        String effDtStr = variables.getOrDefault("bsed", "");
        Date effDt = "".equals(effDtStr) ? new Date() : Date.from(Instant.ofEpochMilli(Long.parseLong(effDtStr)));
        HRBaseServiceHelper changeSceneHelper = new HRBaseServiceHelper("haos_projchangescene");
        HRBaseServiceHelper changeReasonHelper = new HRBaseServiceHelper("haos_projchangereason");
        HRBaseServiceHelper changeOperateHelper = new HRBaseServiceHelper("haos_projchangeoperate");
        Date now = new Date();
        Arrays.stream(projectBaseList).forEach(s -> {
            s.set("bsed", (Object)effDt);
            DynamicObject projChangeSceneDy = changeSceneHelper.generateEmptyDynamicObject();
            projChangeSceneDy.set("id", (Object)variables.getOrDefault("changescene", ""));
            DynamicObject changeReasonDy = changeReasonHelper.generateEmptyDynamicObject();
            changeReasonDy.set("id", (Object)variables.getOrDefault("changereason", ""));
            DynamicObject changeOperateDy = changeOperateHelper.generateEmptyDynamicObject();
            changeOperateDy.set("id", (Object)variables.getOrDefault("changeoperate", ""));
            s.set("changescene", (Object)projChangeSceneDy);
            s.set("changereason", (Object)changeReasonDy);
            s.set("changeoperate", (Object)changeOperateDy);
            s.set("createtime", (Object)now);
        });
    }
}

