/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.projectgroup;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.service.projectgroup.service.ProTeamMsgService;
import kd.hr.haos.business.service.projectgroup.service.ProjStrategyService;
import kd.hr.haos.business.service.projectgroup.service.ProjectGroupEnableService;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.opplugin.web.projectgroup.validate.ProjTeamEnableValidator;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;

public class ProjTeamEnableOp
extends HRCoreBaseBillOp
implements ProjectGroupMDConstants {
    HisResponse<BatchVersionChangeRespData> hisResponse;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("enable");
        e.getFieldKeys().add("boid");
        e.getFieldKeys().add("parentorg");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ProjTeamEnableValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Set selectIdSet = Arrays.stream(dataEntities).map(s -> s.getLong("id")).collect(Collectors.toSet());
        HRBaseServiceHelper projectInfoDAO = new HRBaseServiceHelper("haos_projteambaseinfo");
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", selectIdSet)};
        DynamicObject[] projectSelectedDynArr = projectInfoDAO.loadDynamicObjectArray(filters);
        Date nowDate = HRDateTimeUtils.getNowDate();
        DynamicObject changeInfoOperateDy = BusinessDataServiceHelper.loadSingle((Object)ProjectGroupMDConstants.CHANGE_OPERATE_ENABLE, (String)"haos_projchangeoperate");
        DynamicObject changeInfoTypeDy = BusinessDataServiceHelper.loadSingle((Object)ProjectGroupMDConstants.CHANGETYPE_ENABLE, (String)"haos_projchangetype");
        DynamicObject changeInfoSceneDy = BusinessDataServiceHelper.loadSingle((Object)1030L, (String)"haos_projchangescene");
        Arrays.stream(projectSelectedDynArr).forEach(pjt -> {
            pjt.set("enable", (Object)"1");
            pjt.set("bsed", (Object)nowDate);
            pjt.set("changeoperate", (Object)changeInfoOperateDy);
            pjt.set("changetype", (Object)changeInfoTypeDy);
            pjt.set("changescene", (Object)changeInfoSceneDy);
        });
        ProjectGroupEnableService projectGroupEnableService = new ProjectGroupEnableService();
        projectGroupEnableService.setPjtList(Arrays.asList(projectSelectedDynArr));
        this.hisResponse = projectGroupEnableService.enable();
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ProTeamMsgService.getInstance().sendProTeamChgMsg(this.hisResponse);
        List idList = Arrays.stream(e.getDataEntities()).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        ProjStrategyService.INSTANCE.enableStrategy(idList);
    }
}

