/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.projectgroup;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.haos.business.service.projectgroup.service.IProjectInfoService;
import kd.hr.haos.business.service.projectgroup.service.ProjChangeEventService;
import kd.hr.haos.business.service.projectgroup.service.ProjStrategyService;
import kd.hr.haos.business.service.projectgroup.service.ProjectGroupBaseService;
import kd.hr.haos.business.service.projectgroup.service.ProjectInfoService;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.opplugin.web.projectgroup.validate.ProjectGroupSaveValidator;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;

public class ProjectGroupSaveOp
extends HRCoreBaseBillOp
implements ProjectGroupMDConstants {
    private static final Log log = LogFactory.getLog(ProjectGroupSaveOp.class);
    private long eventId;
    private IProjectInfoService projectInfoService = new ProjectInfoService();

    public void onAddValidators(AddValidatorsEventArgs event) {
        event.addValidator((AbstractValidator)new ProjectGroupSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs event) {
        DynamicObject[] dataEntities = event.getDataEntities();
        this.setProjectIdentity(dataEntities);
        log.info("\u9879\u76ee\u56e2\u961f\u65b0\u589e dataEntities={}", (Object)dataEntities[0]);
        HisResponse hisResponse = ProjectGroupBaseService.getInstance().saveNew(dataEntities, Long.valueOf(0L));
        this.eventId = ((BatchVersionChangeRespData)hisResponse.getData()).getEventId();
        ProjChangeEventService.handleChangeEventHis((HisResponse)hisResponse, (String)"haos_projteambaseinfo", null);
    }

    private void setProjectIdentity(DynamicObject[] dataEntities) {
        String[] ids = ORM.create().genStringIds("haos_projteambaseinfo", dataEntities.length);
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dataEntity = dataEntities[i];
            if (!this.projectInfoService.isRootProjectTeam(dataEntity)) continue;
            dataEntity.set("projectidentify", (Object)ids[i]);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        List newOrgIdList = Stream.of(dataEntities).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        ProjStrategyService.INSTANCE.addStrategy(newOrgIdList);
    }
}

