/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.staff;

import java.util.Arrays;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.haos.business.application.impl.staff.StaffInfoApplicationImpl;
import kd.hr.haos.business.domain.service.impl.staff.StaffReportService;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.opplugin.web.staff.validate.OrgStaffPermissionValidator;
import kd.hr.haos.opplugin.web.staff.validate.OrgStaffSaveValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

public class OrgStaffSaveOp
extends HRDataBaseOp
implements OrgStaffConstants {
    public void onAddValidators(AddValidatorsEventArgs event) {
        event.addValidator((AbstractValidator)new OrgStaffPermissionValidator());
        event.addValidator((AbstractValidator)new OrgStaffSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs event) {
        event.setCancelOperation(true);
        OperateOption option = this.getOption();
        String sourceType = option.getVariableValue("callType", "");
        if (HRStringUtils.equals((String)sourceType, (String)"onlyValidate")) {
            return;
        }
        DynamicObject[] dataEntities = event.getDataEntities();
        StaffInfoApplicationImpl staffInfoApplication = new StaffInfoApplicationImpl();
        staffInfoApplication.saveStaffInfo(dataEntities);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        StaffReportService staffReportSaveService = new StaffReportService();
        staffReportSaveService.saveReportData(Arrays.stream(e.getDataEntities()).map(dyn -> dyn.getLong("id")).collect(Collectors.toList()));
    }
}

