/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.staff.validate;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class OrgStaffPermissionValidator
extends HRDataBaseValidator
implements OrgStaffConstants {
    public void validate() {
        OperateOption option = this.getOption();
        String sourceType = option.getVariableValue("sourceType", "");
        if (HRStringUtils.equals((String)sourceType, (String)"interface")) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        long userId = RequestContext.get().getCurrUserId();
        boolean hasModifyPerm = PermissionServiceHelper.hasSpecificPerm((long)userId, (String)"11", (String)"homs", (String)"haos_staff", (String)"4730fc9f000029ae");
        boolean hasNewPerm = PermissionServiceHelper.hasSpecificPerm((long)userId, (String)"11", (String)"homs", (String)"haos_staff", (String)"47156aff000000ac");
        HashSet ids = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dyn2 = dataEntity.getDataEntity();
            ids.add(dyn2.getLong("id"));
        }
        HRBaseServiceHelper staffServiceHelper = new HRBaseServiceHelper("haos_staff");
        QFilter filter = new QFilter("id", "in", (Object)ids);
        DynamicObject[] staffInfos = staffServiceHelper.queryOriginalArray("id", new QFilter[]{filter});
        Map<Long, DynamicObject> idDynMap = Arrays.stream(staffInfos).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dyn3 = dataEntity.getDataEntity();
            DynamicObject dynFromDB = idDynMap.get(dyn3.getLong("id"));
            if (dynFromDB != null) {
                if (hasModifyPerm) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u7f16\u5236\u4fe1\u606f\u7ef4\u62a4\u7684\u201c\u53d8\u66f4\u201d\u6743\u9650,\u65e0\u6cd5\u4fdd\u5b58,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OrgStaffPermissionValidator_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (hasNewPerm) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u7f16\u5236\u4fe1\u606f\u7ef4\u62a4\u7684\u201c\u65b0\u589e\u201d\u6743\u9650,\u65e0\u6cd5\u4fdd\u5b58,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OrgStaffPermissionValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
        }
    }
}

