/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.staff.validate;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.domain.repository.staff.StaffRuleConfigRepository;
import kd.hr.haos.business.service.ext.StaffRuleConfigExtend;
import kd.hr.haos.business.service.staff.bean.StaffRuleConfigEntryBO;
import kd.hr.haos.business.service.staff.service.StaffRuleConfigHelper;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.common.constants.staff.OrgStaffRuleConfigConstants;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class OrgStaffRuleConfigValidator
extends HRDataBaseValidator
implements OrgStaffConstants,
OrgStaffRuleConfigConstants {
    private static final Log logger = LogFactory.getLog(OrgStaffRuleConfigValidator.class);
    List<StaffRuleConfigEntryBO> existRuleConfigBoList = Lists.newArrayListWithExpectedSize((int)16);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject[] staffRuleInfoArr = this.queryEnableStaffRuleConfig(dataEntities);
        Set<Long> idSetFromDB = Arrays.stream(staffRuleInfoArr).map(staffRuleInfo -> staffRuleInfo.getLong("id")).collect(Collectors.toSet());
        Map<Long, List<DynamicObject>> orgIdVsRuleConfigDynMap = Arrays.stream(staffRuleInfoArr).collect(Collectors.groupingBy(staffRuleInfo -> staffRuleInfo.getLong("org.id")));
        Map<Long, List<StaffRuleConfigEntryBO>> ruleConfigIdVsBoList = this.getRuleConfigIdVsBoListMap(dataEntities);
        Boolean hasCodeRule = StaffRuleConfigHelper.codeRuleExistFlag((String)"haos_staff", null);
        boolean skipBURepeatConfigValidator = StaffRuleConfigExtend.getInstance().skipBURepeatConfigValidator();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.validateNumberRule(dataEntity, hasCodeRule);
            if (!skipBURepeatConfigValidator) {
                this.validateEnableConfig(dataEntity, idSetFromDB, orgIdVsRuleConfigDynMap);
            }
            long ruleConfigId = dataEntity.getDataEntity().getLong("id");
            List<StaffRuleConfigEntryBO> staffRuleConfigEntryBOList = ruleConfigIdVsBoList.get(ruleConfigId);
            this.validateOrgRangeCoincidance(staffRuleConfigEntryBOList);
        }
    }

    private Map<Long, List<StaffRuleConfigEntryBO>> getRuleConfigIdVsBoListMap(ExtendedDataEntity[] dataEntities) {
        Map<Long, String> orgBoIdVsStructLongNumberMap = this.getOrgBoIdVsStructLongNumMap(dataEntities);
        ArrayList staffRuleConfigBOList = Lists.newArrayListWithExpectedSize((int)16);
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            DynamicObject ruleConfigDyn = dataEntity.getDataEntity();
            DynamicObjectCollection ruleConfigDynEntryCol = ruleConfigDyn.getDynamicObjectCollection("entryentity");
            ruleConfigDynEntryCol.stream().filter(entry -> {
                DynamicObject refStaff = entry.getDynamicObject("refstaff");
                if (Objects.nonNull(refStaff)) {
                    return !HRStringUtils.equals((String)entry.getString("refstaff.enable"), (String)"0");
                }
                return true;
            }).forEach(entry -> staffRuleConfigBOList.addAll(this.buildRuleConfigEntryBO((ExtendedDataEntity)dataEntity, (DynamicObject)entry, orgBoIdVsStructLongNumberMap)));
        });
        return staffRuleConfigBOList.stream().collect(Collectors.groupingBy(bo -> bo.getRuleConfigId()));
    }

    private Map<Long, String> getOrgBoIdVsStructLongNumMap(ExtendedDataEntity[] dataEntities) {
        HashSet ruleOrgIdSet = Sets.newHashSetWithExpectedSize((int)16);
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            DynamicObjectCollection ruleConfigDynEntryCol = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            ruleConfigDynEntryCol.stream().forEach(entry -> {
                Set staffRuleOrgIdSet = entry.getDynamicObjectCollection("staffruleorg").stream().map(staffRuleOrg -> staffRuleOrg.getLong("fbasedataid.id")).collect(Collectors.toSet());
                ruleOrgIdSet.addAll(staffRuleOrgIdSet);
            });
        });
        DynamicObject[] orgStructDyns = AdminOrgStructRepository.getInstance().queryEffStructInfoByOrgId("id, adminorg, structlongnumber", (Collection)ruleOrgIdSet);
        return Arrays.stream(orgStructDyns).collect(Collectors.toMap(dyn -> dyn.getLong("adminorg.id"), dyn -> dyn.getString("structlongnumber")));
    }

    private DynamicObject[] queryEnableStaffRuleConfig(ExtendedDataEntity[] dataEntities) {
        Set orgIdSet = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("org.id")).collect(Collectors.toSet());
        QFilter filter = new QFilter("org", "in", orgIdSet);
        filter.and("enable", "=", (Object)"1");
        return StaffRuleConfigRepository.getInstance().queryOriginalArray("id, org.name, org.id, year", new QFilter[]{filter});
    }

    private void validateNumberRule(ExtendedDataEntity dataEntity, Boolean hasCodeRule) {
        DynamicObjectCollection ruleConfigEntryCol = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
        for (DynamicObject ruleConfigEntry : ruleConfigEntryCol) {
            if (!Objects.isNull(ruleConfigEntry.getDynamicObject("refstaff")) || hasCodeRule.booleanValue()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u7f16\u5236\u4fe1\u606f\u7684\u7f16\u7801\u89c4\u5219\u3002", (String)"OrgStaffRuleConfigValidator_03", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void validateEnableConfig(ExtendedDataEntity dataEntity, Set<Long> idSetFromDB, Map<Long, List<DynamicObject>> orgIdVsRuleConfigDynMap) {
        boolean changeSaveValid;
        if (CollectionUtils.isEmpty(orgIdVsRuleConfigDynMap)) {
            return;
        }
        DynamicObject ruleConfigDyn = dataEntity.getDataEntity();
        long ruleConfigId = ruleConfigDyn.getLong("id");
        long orgId = ruleConfigDyn.getLong("org.id");
        int year = HRDateTimeUtils.getYear((Date)ruleConfigDyn.getDate("year"));
        Map<Integer, List<DynamicObject>> yearVsRuleConfigDynListMap = orgIdVsRuleConfigDynMap.get(orgId).stream().collect(Collectors.groupingBy(dyn -> HRDateTimeUtils.getYear((Date)dyn.getDate("year"))));
        List<DynamicObject> ruleVsRuleConfigDynList = yearVsRuleConfigDynListMap.get(year);
        boolean newSaveValid = !idSetFromDB.contains(ruleConfigId) && !CollectionUtils.isEmpty(ruleVsRuleConfigDynList);
        boolean bl = changeSaveValid = idSetFromDB.contains(ruleConfigId) && !CollectionUtils.isEmpty(ruleVsRuleConfigDynList) && ruleVsRuleConfigDynList.size() > 1;
        if (newSaveValid || changeSaveValid) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5728\u201c%2$s\u201d\u5185\u5df2\u914d\u7f6e\u7f16\u5236\u89c4\u5219\uff0c\u4e0d\u53ef\u91cd\u590d\u914d\u7f6e\u3002", (String)"OrgStaffRuleConfigValidator_00", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), ruleConfigDyn.getString("org.name"), year));
        }
    }

    private void validateOrgRangeCoincidance(List<StaffRuleConfigEntryBO> staffRuleConfigBOList) {
        if (CollectionUtils.isEmpty(staffRuleConfigBOList)) {
            return;
        }
        List<StaffRuleConfigEntryBO> newRuleConfigEntryBoList = staffRuleConfigBOList.stream().filter(bo -> bo.getStaffId() == 0L).collect(Collectors.toList());
        List<StaffRuleConfigEntryBO> newAndIncludeSubBoList = newRuleConfigEntryBoList.stream().filter(bo -> bo.getIncludeSub()).collect(Collectors.toList());
        this.validateIncludeSub(newAndIncludeSubBoList, newRuleConfigEntryBoList, (a, b) -> true);
        this.existRuleConfigBoList = staffRuleConfigBOList.stream().filter(bo -> bo.getStaffId() != 0L).collect(Collectors.toList());
        List<StaffRuleConfigEntryBO> existAndIncludeSubBoList = this.existRuleConfigBoList.stream().filter(bo -> bo.getIncludeSub()).collect(Collectors.toList());
        this.validateIncludeSub(existAndIncludeSubBoList, newRuleConfigEntryBoList, this::getNearParentOrgIsIncludeSub);
        this.validateIncludeSub(newAndIncludeSubBoList, this.existRuleConfigBoList, (a, b) -> true);
    }

    private void validateIncludeSub(List<StaffRuleConfigEntryBO> newAndIncludeSubBoList, List<StaffRuleConfigEntryBO> newRuleConfigEntryBoList, BiFunction<List<StaffRuleConfigEntryBO>, StaffRuleConfigEntryBO, Boolean> getNearParentOrgIsIncludeSubMethod) {
        for (StaffRuleConfigEntryBO newAndIncludeSubBo : newAndIncludeSubBoList) {
            for (StaffRuleConfigEntryBO newRuleConfigEntryBo : newRuleConfigEntryBoList) {
                if (newAndIncludeSubBo.getAdminOrgId().equals(newRuleConfigEntryBo.getAdminOrgId())) continue;
                String structNumber = newAndIncludeSubBo.getStructNumber();
                String structLongNumber = newRuleConfigEntryBo.getStructLongNumber();
                boolean validateFlag = structLongNumber.contains(structNumber) && getNearParentOrgIsIncludeSubMethod.apply(this.existRuleConfigBoList, newRuleConfigEntryBo) != false;
                logger.info("OrgStaffRuleConfigValidator#validateIncludeSub ruleConfigId={}, boid={}, structLongNumber={}, boid={}, structNumber={}, validateFlag={}", new Object[]{newAndIncludeSubBo.getRuleConfigId(), newRuleConfigEntryBo.getAdminOrgId(), structLongNumber, newAndIncludeSubBo.getAdminOrgId(), structNumber, validateFlag});
                if (!validateFlag) continue;
                this.addErrorMessage(newRuleConfigEntryBo.getRuleConfigDataEntity(), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8303\u56f4\u91cd\u5408\uff0c\u201c%1$s\u201d\u4e3a\u201c%2$s\u201d\u7684\u4e0b\u7ea7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgStaffRuleConfigValidator_02", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), newRuleConfigEntryBo.getAdminOrgName(), newAndIncludeSubBo.getAdminOrgName()));
            }
        }
    }

    private List<StaffRuleConfigEntryBO> buildRuleConfigEntryBO(ExtendedDataEntity ruleConfigDataEntity, DynamicObject entryDyn, Map<Long, String> orgBoIdVsStructLongNumberMap) {
        boolean includeSub = entryDyn.getBoolean("includesub");
        Long refStaffId = Objects.isNull(entryDyn.getDynamicObject("refstaff")) ? 0L : entryDyn.getLong("refstaff.id");
        List staffRuleOrgDynList = entryDyn.getDynamicObjectCollection("staffruleorg").stream().map(staffRuleOrgDyn -> staffRuleOrgDyn.getDynamicObject("fbasedataid")).collect(Collectors.toList());
        return staffRuleOrgDynList.stream().map(dyn -> new StaffRuleConfigEntryBO(ruleConfigDataEntity, dyn, includeSub, (String)orgBoIdVsStructLongNumberMap.get(dyn.getLong("id")), refStaffId)).collect(Collectors.toList());
    }

    private Boolean getNearParentOrgIsIncludeSub(List<StaffRuleConfigEntryBO> existAndIncludeSubBoList, StaffRuleConfigEntryBO ruleConfigEntryBO) {
        String structLongNumber = ruleConfigEntryBO.getStructLongNumber();
        StaffRuleConfigEntryBO nearParentOrg = new StaffRuleConfigEntryBO(false, "");
        for (StaffRuleConfigEntryBO existAndIncludeSubBo : existAndIncludeSubBoList) {
            String structNumber = existAndIncludeSubBo.getStructNumber();
            logger.info("OrgStaffRuleConfigValidator#getNearParentOrgIsIncludeSub ruleConfigId={}, boid={}, structLongNumber={}, boid={}, structNumber={}", new Object[]{ruleConfigEntryBO.getRuleConfigId(), ruleConfigEntryBO.getAdminOrgId(), structLongNumber, existAndIncludeSubBo.getAdminOrgId(), structNumber});
            if (!structLongNumber.contains(structNumber) || existAndIncludeSubBo.getStructLongNumber().length() <= nearParentOrg.getStructLongNumber().length()) continue;
            nearParentOrg = existAndIncludeSubBo;
        }
        return nearParentOrg.getIncludeSub();
    }
}

