/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.staff.validate;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.haos.business.domain.repository.staff.StaffCaseRepository;
import kd.hr.haos.business.util.IdAndDateRangeBo;
import kd.hr.haos.business.util.StaffCaseDateRangeHelper;
import kd.hr.haos.common.constants.staff.StaffCaseConstants;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class StaffCaseEnableValidator
extends HRDataBaseValidator
implements StaffCaseConstants {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        List personIdList = Arrays.stream(extendedDataEntities).map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("person.id")).collect(Collectors.toList());
        DynamicObject[] staffCaseDyns = StaffCaseRepository.getInstance().queryEnableAndAuditDyns(personIdList);
        Map personIdVsStaffCaseListMap = Arrays.stream(staffCaseDyns).collect(Collectors.groupingBy(dyn -> dyn.getLong("person.id"), Collectors.mapping(dyn -> StaffCaseDateRangeHelper.buildBo((DynamicObject)dyn), Collectors.toList())));
        Map personIdVsBoList = Arrays.stream(extendedDataEntities).collect(Collectors.groupingBy(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("person.id"), Collectors.mapping(extendedDataEntity -> StaffCaseDateRangeHelper.buildBo((DynamicObject)extendedDataEntity.getDataEntity()), Collectors.toList())));
        for (ExtendedDataEntity extendedDataEntity2 : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity2.getDataEntity();
            long personId = dataEntity.getLong("person.id");
            IdAndDateRangeBo needToValidateBo = StaffCaseDateRangeHelper.buildBo((DynamicObject)dataEntity);
            boolean isDateIntervalForMemory = StaffCaseDateRangeHelper.isDateInterval((IdAndDateRangeBo)needToValidateBo, personIdVsBoList.get(personId));
            if (isDateIntervalForMemory) {
                this.addErrorMessage(extendedDataEntity2, String.format(ResManager.loadKDString((String)"\u6240\u9009\u7f16\u5236\u4e2a\u4f8b\u751f\u6548\u65e5\u671f\u8303\u56f4\u4e0e\u5176\u4ed6\u7f16\u5236\u4e2a\u4f8b\u91cd\u590d\uff0c\u4e0d\u53ef\u542f\u7528\u3002", (String)"StaffCaseEnableValidator_00", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), new Object[0]));
                continue;
            }
            boolean isDateIntervalForDB = StaffCaseDateRangeHelper.isDateInterval((IdAndDateRangeBo)needToValidateBo, personIdVsStaffCaseListMap.get(personId));
            if (!isDateIntervalForDB) continue;
            this.addErrorMessage(extendedDataEntity2, String.format(ResManager.loadKDString((String)"\u6240\u9009\u7f16\u5236\u4e2a\u4f8b\u751f\u6548\u65e5\u671f\u8303\u56f4\u4e0e\u5176\u4ed6\u7f16\u5236\u4e2a\u4f8b\u91cd\u590d\uff0c\u4e0d\u53ef\u542f\u7528\u3002", (String)"StaffCaseEnableValidator_00", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }
}

